<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="robots" content="noindex, nofollow">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    @if (env('SYSTEM_INSTALLED'))
        <title>@yield('title') {{ config('seotools.meta.defaults.separator') }} {{ getSetting('site_name') }} </title>
        <link rel="icon" type="image/png" href="{{ asset(getSetting('favicon')) }}">
    @else
        <title>@yield('title') {{ config('seotools.meta.defaults.separator') }} {{ config('lobage.script_name') }}
        </title>
        <link rel="icon" type="image/png" href="{{ asset('assets/img/favicon.ico') }}">
    @endif
    <link rel="stylesheet" href="{{ asset('assets/css/vendor/fontawesome.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/vendor/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/error_style.css?v=' . env('SITE_VERSION')) }}" />
    @if (env('SYSTEM_INSTALLED'))
        @if (getCurrentLangDirection())
            <link rel="preload" href="{{ asset('assets/css/vendor/bootstrap.rtl.min.css') }}" as="style">
            <link rel="stylesheet" href="{{ asset('assets/themes/basic/css/rtl.css?v=' . env('SITE_VERSION')) }}"
                type="text/css">
        @endif
    @endif
</head>

<body>
    <!-- Error Page -->
    <div class="error-page">
        <div class="error-page-img">
            @php
                $code = trim($__env->yieldContent('code'));
            @endphp

            @switch($code)
                @case('maintenance')
                    <svg id="svg-color" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 750 500">
                        <g id="freepik--background-complete--inject-84">
                            <path
                                d="M366.6,163.49a7.15,7.15,0,0,1-2.37-.4L352,158.85a7.29,7.29,0,0,1-4.75-5.49l-2.45-12.73a7.26,7.26,0,0,1,2.38-6.86l9.79-8.48a7.3,7.3,0,0,1,7.14-1.38l12.24,4.25a7.27,7.27,0,0,1,4.76,5.49l2.44,12.72a7.31,7.31,0,0,1-2.37,6.87l-9.8,8.48A7.28,7.28,0,0,1,366.6,163.49ZM355,151.43l11.44,4,9.16-7.92-2.29-11.89-11.44-4-9.15,7.93Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M509.44,126.54a7.15,7.15,0,0,1-2.37-.4l-6.2-2.15a7.27,7.27,0,0,1-4.75-5.49l-1.24-6.44a7.28,7.28,0,0,1,2.37-6.86l5-4.3a7.27,7.27,0,0,1,7.13-1.37l6.19,2.15a7.27,7.27,0,0,1,4.76,5.49l1.24,6.44a7.26,7.26,0,0,1-2.38,6.86l-5,4.3A7.33,7.33,0,0,1,509.44,126.54Zm-5.55-10,5.4,1.87,4.31-3.74-1.08-5.6-5.39-1.87L502.81,111Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M680.68,220.77a5.3,5.3,0,0,1-4.11-2l-3.49-4.36a5.28,5.28,0,0,1-.8-5.2l2-5.2a5.26,5.26,0,0,1,4.1-3.29l5.52-.85a5.29,5.29,0,0,1,4.91,1.91l3.49,4.36a5.28,5.28,0,0,1,.8,5.2l-2,5.2a5.25,5.25,0,0,1-4.11,3.29l-5.52.85A5.16,5.16,0,0,1,680.68,220.77Zm4.05-16.93h-.19l-5.52.85a1.28,1.28,0,0,0-1,.79l-2,5.2a1.26,1.26,0,0,0,.19,1.25l3.49,4.36a1.3,1.3,0,0,0,1.18.46l5.52-.85a1.26,1.26,0,0,0,1-.79l2-5.2a1.28,1.28,0,0,0-.19-1.25h0l-3.49-4.36A1.29,1.29,0,0,0,684.73,203.84Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M57.7,264.23a6.82,6.82,0,0,1-5.29-2.53l-8.2-10.24a6.78,6.78,0,0,1-1-6.68L48,232.55a6.78,6.78,0,0,1,5.27-4.23l13-2a6.79,6.79,0,0,1,6.3,2.46L80.7,239a6.79,6.79,0,0,1,1,6.69L77,257.93a6.78,6.78,0,0,1-5.28,4.24l-13,2A5.84,5.84,0,0,1,57.7,264.23Zm-7.94-17,8,10,12.7-1.94,4.66-12-8-10-12.7,1.95Zm25.48-3.79Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M90.88,174.6H83.15A5.27,5.27,0,0,1,78.59,172l-3.87-6.69a5.33,5.33,0,0,1,0-5.27l3.87-6.69a5.26,5.26,0,0,1,4.56-2.63h7.73a5.26,5.26,0,0,1,4.56,2.63L99.31,160a5.33,5.33,0,0,1,0,5.27L95.44,172A5.28,5.28,0,0,1,90.88,174.6Zm-7.73-19.92a1.28,1.28,0,0,0-1.1.63L78.19,162a1.26,1.26,0,0,0,0,1.27L82.05,170a1.29,1.29,0,0,0,1.1.64h7.73A1.29,1.29,0,0,0,92,170l3.86-6.69a1.26,1.26,0,0,0,0-1.27L92,155.31a1.28,1.28,0,0,0-1.1-.63Z"
                                style="fill:#ebebeb"></path>
                            <polygon
                                points="222.78 98.95 207.7 89.46 189.19 58.22 163.44 42.46 158.46 47.85 161.07 51.37 169.2 62.27 201.47 105.59 214.63 112.83 222.78 98.95"
                                style="fill:#ebebeb"></polygon>
                            <polygon
                                points="203.83 121.41 199.51 107.03 152.09 52.85 145.77 56.59 155.78 85.08 183.31 112.12 189.48 129 203.83 121.41"
                                style="fill:#ebebeb"></polygon>
                            <path
                                d="M229.52,101.63s53.55,29.39,64.34,39.31,36,51.23,33.44,56.51-4.52,6-10.33.88-24.59-33.42-29.63-38S219.56,119,219.56,119Z"
                                style="fill:#e0e0e0"></path>
                            <circle cx="193.21" cy="97.26" r="16.96" style="fill:#ebebeb"></circle>
                            <path
                                d="M189,113.67a25.24,25.24,0,0,0,4.14.43,16.2,16.2,0,0,0,4.8-.71,16.79,16.79,0,0,0,12-17.69A15.9,15.9,0,0,0,208.7,91a18.28,18.28,0,0,0-1.08-2.23,17.29,17.29,0,0,0-1.47-2.07,16.62,16.62,0,0,0-19.11-5,19.9,19.9,0,0,0-2.28,1.09,18.59,18.59,0,0,0-2,1.43,15.55,15.55,0,0,0-3.27,3.52,16.81,16.81,0,0,0-2.93,8.32,16.92,16.92,0,0,0,4.75,12.95,16.3,16.3,0,0,0,3.85,3,26,26,0,0,0,3.83,1.64,1.07,1.07,0,0,1-.27,0l-.78-.22a7.71,7.71,0,0,1-1.24-.43,12.11,12.11,0,0,1-1.63-.76,16,16,0,0,1-4-2.93,17.13,17.13,0,0,1-5-13.19,17.22,17.22,0,0,1,3-8.56,16.28,16.28,0,0,1,3.36-3.64,15.9,15.9,0,0,1,4.45-2.61,17.13,17.13,0,0,1,19.69,5.12,19.19,19.19,0,0,1,1.5,2.14,18.09,18.09,0,0,1,1.11,2.31,15.81,15.81,0,0,1,1.16,4.8,17,17,0,0,1-6.53,15.08,16.82,16.82,0,0,1-5.82,2.94,15.8,15.8,0,0,1-4.88.63,11.86,11.86,0,0,1-1.8-.13A8.13,8.13,0,0,1,190,114l-.79-.19A.91.91,0,0,1,189,113.67Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M190.81,106.53a9.58,9.58,0,1,1,11.67-6.86A9.58,9.58,0,0,1,190.81,106.53Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M190.81,106.53c0-.07.83.2,2.33.2a9.53,9.53,0,0,0,8.54-5.48,9.43,9.43,0,0,0,.82-4.86,9.35,9.35,0,0,0-2.07-5,9.27,9.27,0,0,0-10.66-2.77A8.53,8.53,0,0,0,187.36,90a8.69,8.69,0,0,0-1.83,2,9.46,9.46,0,0,0-1.65,4.64,9.31,9.31,0,0,0,.68,4.26,9.52,9.52,0,0,0,4.11,4.68,20.27,20.27,0,0,0,2.14,1,7.22,7.22,0,0,1-2.24-.79,9.53,9.53,0,0,1-4.35-4.71,9.63,9.63,0,0,1-.77-4.44,9.83,9.83,0,0,1,1.68-4.89A9.33,9.33,0,0,1,187,89.63a9.23,9.23,0,0,1,2.54-1.49,9.75,9.75,0,0,1,11.25,2.92A9.83,9.83,0,0,1,203,96.34a9.83,9.83,0,0,1-.91,5.09,9.69,9.69,0,0,1-2.83,3.5,9.57,9.57,0,0,1-6.1,2A7.14,7.14,0,0,1,190.81,106.53Z"
                                style="fill:#e0e0e0"></path>
                            <rect x="208" y="100.53" width="28.67" height="15.51" rx="7.38"
                                transform="translate(17.68 247.11) rotate(-60.12)" style="fill:#ebebeb"></rect>
                            <path
                                d="M212.14,110.45a9.92,9.92,0,0,0-.83,2.81,7.69,7.69,0,0,0,.45,3.37,7.87,7.87,0,0,0,1,1.86,7.29,7.29,0,0,0,1.74,1.61,10.72,10.72,0,0,0,2.34,1.19,7.14,7.14,0,0,0,8.07-2.57c2.3-3.83,4.73-8.22,7.35-12.73a7.16,7.16,0,0,0,0-7A7,7,0,0,0,230,96.43a8.64,8.64,0,0,0-3.07-1.36,7.17,7.17,0,0,0-5.87,1.4c-1.57,1.19-2.26,3-3.18,4.46l-4.12,7-1.14,1.89a3.78,3.78,0,0,1-.43.64,6.56,6.56,0,0,1,.34-.7c.27-.48.62-1.13,1.06-1.93,1-1.72,2.31-4.12,4-7.07l1.32-2.34a7.91,7.91,0,0,1,1.91-2.28A7.59,7.59,0,0,1,227,94.6,9.06,9.06,0,0,1,230.22,96a7.41,7.41,0,0,1,2.55,2.69,7.62,7.62,0,0,1,0,7.54c-2.63,4.53-5,8.85-7.41,12.76a7.69,7.69,0,0,1-5.64,3.07,7.79,7.79,0,0,1-2.95-.4,11.23,11.23,0,0,1-2.41-1.28,7.6,7.6,0,0,1-1.81-1.71,8.27,8.27,0,0,1-1-2,7.22,7.22,0,0,1,.26-5.62A4.08,4.08,0,0,1,212.14,110.45Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M191.47,137.54s20.29,57.62,28.33,69.88,44.69,43.84,50.31,42.18,6.61-3.49,2.55-10-29-29.69-32.68-35.42-29.81-73.6-29.81-73.6Z"
                                style="fill:#e0e0e0"></path>
                            <rect x="184.87" y="123.77" width="28.67" height="15.51" rx="7.38"
                                transform="translate(-33.47 78.19) rotate(-20.52)" style="fill:#ebebeb"></rect>
                            <path
                                d="M203,121.83a3.52,3.52,0,0,1,.72-.28,7.37,7.37,0,0,1,2.21-.28,7.52,7.52,0,0,1,3.38.93,8.35,8.35,0,0,1,1.76,1.35,8,8,0,0,1,1.4,2.06,10.8,10.8,0,0,1,.86,2.59,7.51,7.51,0,0,1-.08,3,7.66,7.66,0,0,1-4,5.06c-4.24,1.71-8.89,3.38-13.79,5.24a7.69,7.69,0,0,1-7.45-1.2,7.6,7.6,0,0,1-2.24-3,9,9,0,0,1-.86-3.44,7.58,7.58,0,0,1,2.52-5.9,7.9,7.9,0,0,1,2.56-1.51l2.52-.93,7.62-2.76,2.08-.73a4.2,4.2,0,0,1,.74-.22,3.33,3.33,0,0,1-.7.32l-2,.82-7.56,2.92c-1.57.67-3.49,1.06-4.92,2.41a7.21,7.21,0,0,0-2.34,5.57,8.81,8.81,0,0,0,.85,3.25,7,7,0,0,0,2.1,2.76,7.16,7.16,0,0,0,6.95,1.11c4.87-1.85,9.6-3.54,13.76-5.18a7.19,7.19,0,0,0,3.85-7.54,10.69,10.69,0,0,0-.81-2.51,7.47,7.47,0,0,0-1.3-2,7.7,7.7,0,0,0-1.66-1.32,7.45,7.45,0,0,0-3.25-1A9.69,9.69,0,0,0,203,121.83Z"
                                style="fill:#e0e0e0"></path>
                        </g>
                        <g id="freepik--Floor--inject-84">
                            <path
                                d="M714.76,453.47c0,.14-152.44.26-340.44.26s-340.47-.12-340.47-.26,152.41-.26,340.47-.26S714.76,453.33,714.76,453.47Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Screwdriver--inject-84">
                            <path
                                d="M87,339.07c.27-.84,31.43-102.7,31.43-102.7l-.78-12.65,8.15-13.42,10.12,3.35-1.38,15-7.2,10.94L96,342Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M87,339.07l.6.17,1.73.54L96,341.87l-.11.06c5.07-16.61,16.79-55.05,31.23-102.38v0l0,0,7.19-10.93,0,.11c.44-4.79.91-9.88,1.38-15l.18.27-.84-.27-9.28-3.07.3-.11-8.15,13.42,0-.15q.39,6.47.77,12.65v.09c-9.11,29.59-17,55.22-22.61,73.46-2.82,9.13-5.08,16.4-6.63,21.41-.77,2.5-1.38,4.43-1.79,5.75l-.47,1.49-.17.51a4.43,4.43,0,0,1,.13-.49c.1-.35.24-.84.43-1.47.4-1.32,1-3.24,1.72-5.72,1.51-5,3.71-12.28,6.47-21.4,5.58-18.3,13.4-44,22.44-73.69v.09q-.39-6.18-.79-12.65v-.08l0-.07,8.15-13.42.1-.18.2.07,9.29,3.06.83.28.2.06,0,.21c-.47,5.15-.94,10.24-1.39,15v.07l0,.05-7.19,10.94,0-.07C113,287,101.18,325.39,96.06,342l0,.09-.09,0-6.68-2.21-1.69-.57Z"
                                style="fill:#263238"></path>
                            <path
                                d="M79.49,344l-14,18.92-19.57,71s-2.81,14.48,13.18,18.59c18,4.62,22.1-9.14,22.1-9.14l19-69.33L100,350l4.69-5.29a2,2,0,0,0-.85-3.19l-22.48-7.42a2,2,0,0,0-2.59,2.07Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M100.12,350.83c-.05.14-4.76-1.23-10.52-3.06s-10.41-3.43-10.36-3.57,4.75,1.24,10.52,3.07S100.16,350.69,100.12,350.83Z"
                                style="fill:#263238"></path>
                            <path
                                d="M100.24,374.05a6.67,6.67,0,0,1-1.4-.24c-.9-.19-2.18-.5-3.77-.9-3.18-.79-7.54-2-12.29-3.52s-9-3.06-12.07-4.25c-1.52-.6-2.75-1.1-3.59-1.46a7.13,7.13,0,0,1-1.28-.61,7.28,7.28,0,0,1,1.36.42l3.64,1.3c3.08,1.1,7.34,2.59,12.09,4.1s9.09,2.78,12.23,3.67l3.73,1.05A7.75,7.75,0,0,1,100.24,374.05Z"
                                style="fill:#263238"></path>
                            <g style="opacity:0.30000000000000004">
                                <rect x="58.9" y="368.79" width="7.11" height="68.49" rx="3.3"
                                    transform="matrix(0.96, 0.28, -0.28, 0.96, 116.98, -1.15)"></rect>
                            </g>
                            <g style="opacity:0.30000000000000004">
                                <rect x="68.88" y="372.07" width="7.11" height="68.49" rx="3.3"
                                    transform="matrix(0.96, 0.28, -0.28, 0.96, 118.35, -3.84)"></rect>
                            </g>
                            <g style="opacity:0.30000000000000004">
                                <rect x="79.46" y="375.21" width="7.11" height="68.49" rx="3.3"
                                    transform="translate(119.66 -6.72) rotate(16.49)"></rect>
                            </g>
                            <path
                                d="M127.27,239.6a20.88,20.88,0,0,1-4.46-1.27,20,20,0,0,1-4.28-1.76,21.62,21.62,0,0,1,4.45,1.27A20.26,20.26,0,0,1,127.27,239.6Z"
                                style="fill:#263238"></path>
                            <path
                                d="M135.94,213.65a8.12,8.12,0,0,1-.35,1.4c-.29,1-.67,2.26-1.14,3.82l-4,13-.08.25-.25-.08-4.61-1.61-4.74-1.66-.23-.08.07-.23c1.44-5.14,2.71-9.65,3.65-13,.46-1.55.83-2.83,1.12-3.79a9.16,9.16,0,0,1,.46-1.36,8.12,8.12,0,0,1-.29,1.41l-1,3.83c-.89,3.33-2.09,7.85-3.47,13l-.16-.31,4.75,1.66,4.6,1.61-.33.17,4.2-12.91c.52-1.55,1-2.81,1.28-3.77A8.57,8.57,0,0,1,135.94,213.65Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Gears--inject-84">
                            <path
                                d="M430.9,111.92a7.15,7.15,0,0,1-2.37-.4l-12.25-4.24a7.29,7.29,0,0,1-4.75-5.49l-2.45-12.73a7.26,7.26,0,0,1,2.38-6.86l9.8-8.48a7.28,7.28,0,0,1,7.13-1.37l12.24,4.24a7.29,7.29,0,0,1,4.76,5.49l2.45,12.73a7.31,7.31,0,0,1-2.38,6.86l-9.8,8.48A7.28,7.28,0,0,1,430.9,111.92ZM419.3,99.86l11.45,4,9.15-7.92L437.61,84l-11.44-4L417,88Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M430.9,111.92a7.15,7.15,0,0,1-2.37-.4l-12.25-4.24a7.29,7.29,0,0,1-4.75-5.49l-2.45-12.73a7.26,7.26,0,0,1,2.38-6.86l9.8-8.48a7.28,7.28,0,0,1,7.13-1.37l12.24,4.24a7.29,7.29,0,0,1,4.76,5.49l2.45,12.73a7.31,7.31,0,0,1-2.38,6.86l-9.8,8.48A7.28,7.28,0,0,1,430.9,111.92ZM419.3,99.86l11.45,4,9.15-7.92L437.61,84l-11.44-4L417,88Z"
                                style="fill:none"></path>
                            <path
                                d="M419.3,99.86a6.36,6.36,0,0,1-.2-.79l-.5-2.35c-.43-2.11-1-5.08-1.77-8.71a.2.2,0,0,1,.06-.19l9.12-8a.26.26,0,0,1,.24,0l11.44,4,.18.2h0v.17l0,.2.08.39.15.78c.1.51.19,1,.29,1.54.2,1,.39,2,.58,3,.38,2,.75,3.92,1.1,5.77a.24.24,0,0,1-.08.23L430.87,104a.19.19,0,0,1-.19,0l-8.37-3-2.25-.84a5.66,5.66,0,0,1-.76-.31,6.07,6.07,0,0,1,.84.24l2.31.74,8.36,2.8-.19,0,9.12-8-.08.24c-.36-1.86-.74-3.78-1.12-5.77-.19-1-.39-2-.59-3-.1-.51-.19-1-.29-1.54l-.15-.78-.08-.39,0-.2,0-.1v-.07h0s.32.37.16.19l-11.43-4,.24,0-9.19,7.89.07-.19c.65,3.62,1.19,6.57,1.57,8.68.17,1,.31,1.79.41,2.39A4.79,4.79,0,0,1,419.3,99.86Z"
                                style="fill:#263238"></path>
                            <path
                                d="M430.9,111.92s.43,0,1.24-.16a7.28,7.28,0,0,0,3.19-1.47l9.95-8.71A7.1,7.1,0,0,0,447.51,98a7.34,7.34,0,0,0,.24-2.25,21,21,0,0,0-.4-2.35c-.63-3.23-1.3-6.67-2-10.29a10.15,10.15,0,0,0-.73-2.63,7,7,0,0,0-4-3.67l-2.82-1-5.79-2-3-1a8.06,8.06,0,0,0-3-.63,7.11,7.11,0,0,0-3,.66,9.88,9.88,0,0,0-2.48,1.77l-4.63,4-4.47,3.87a7.06,7.06,0,0,0-2.28,4.82,10.37,10.37,0,0,0,.3,2.65c.17.89.33,1.76.5,2.62.32,1.72.64,3.38.94,5s.59,3.18.9,4.64a7.15,7.15,0,0,0,2.24,3.56,7.28,7.28,0,0,0,1.67,1.07c.59.26,1.22.45,1.8.67l3.35,1.18,5.36,1.9a28.56,28.56,0,0,0,3.4,1.13c.8.15,1.24.14,1.24.16a5.23,5.23,0,0,1-1.26,0,25.7,25.7,0,0,1-3.44-1.05L420.81,109l-3.36-1.14c-.6-.21-1.21-.39-1.84-.66a7.7,7.7,0,0,1-1.77-1.11,7.51,7.51,0,0,1-2.39-3.73c-.34-1.52-.61-3.06-.93-4.67s-.64-3.28-1-5q-.26-1.27-.51-2.61a10.76,10.76,0,0,1-.32-2.76,7.57,7.57,0,0,1,2.43-5.17l4.46-3.88,4.63-4c.4-.34.77-.68,1.2-1a8.24,8.24,0,0,1,1.4-.84,7.53,7.53,0,0,1,3.18-.7,8.59,8.59,0,0,1,3.17.66l3,1,5.79,2,2.82,1a7.56,7.56,0,0,1,2.57,1.55,7.42,7.42,0,0,1,1.73,2.38,10.47,10.47,0,0,1,.76,2.75q1,5.45,1.95,10.3a19.51,19.51,0,0,1,.39,2.41,7.51,7.51,0,0,1-2.64,6.1l-10.06,8.59a7.37,7.37,0,0,1-3.31,1.42A5.14,5.14,0,0,1,430.9,111.92Z"
                                style="fill:#263238"></path>
                            <path
                                d="M345.67,91.1a5.27,5.27,0,0,1-4.12-2l-3.49-4.35a5.3,5.3,0,0,1-.8-5.21l2-5.2a5.27,5.27,0,0,1,4.11-3.29l5.51-.85a5.29,5.29,0,0,1,4.91,1.91l3.49,4.36a5.28,5.28,0,0,1,.8,5.2l-2,5.21A5.29,5.29,0,0,1,352,90.2l-5.52.84A5.35,5.35,0,0,1,345.67,91.1Zm4-16.93-.19,0L344,75a1.28,1.28,0,0,0-1,.79L341,81a1.28,1.28,0,0,0,.19,1.25l3.49,4.35a1.28,1.28,0,0,0,1.18.46l5.52-.85a1.27,1.27,0,0,0,1-.79l2-5.2a1.26,1.26,0,0,0-.19-1.25l-3.49-4.35A1.28,1.28,0,0,0,349.71,74.17Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M345.67,91.1a5.27,5.27,0,0,1-4.12-2l-3.49-4.35a5.3,5.3,0,0,1-.8-5.21l2-5.2a5.27,5.27,0,0,1,4.11-3.29l5.51-.85a5.29,5.29,0,0,1,4.91,1.91l3.49,4.36a5.28,5.28,0,0,1,.8,5.2l-2,5.21A5.29,5.29,0,0,1,352,90.2l-5.52.84A5.35,5.35,0,0,1,345.67,91.1Zm4-16.93-.19,0L344,75a1.28,1.28,0,0,0-1,.79L341,81a1.28,1.28,0,0,0,.19,1.25l3.49,4.35a1.28,1.28,0,0,0,1.18.46l5.52-.85a1.27,1.27,0,0,0,1-.79l2-5.2a1.26,1.26,0,0,0-.19-1.25l-3.49-4.35A1.28,1.28,0,0,0,349.71,74.17Z"
                                style="fill:none"></path>
                            <path
                                d="M349.71,74.17a.72.72,0,0,1,.43,0,1.2,1.2,0,0,1,.47.25,6.51,6.51,0,0,1,.48.53l2.84,3.41.46.57a1.44,1.44,0,0,1,.28.81,2,2,0,0,1-.2.83c-.09.25-.19.5-.28.76-.4,1-.82,2.13-1.26,3.29-.11.29-.22.58-.34.88a1.5,1.5,0,0,1-.74.83,3.94,3.94,0,0,1-1,.23l-1,.16c-1.35.2-2.67.43-4.17.62a1.52,1.52,0,0,1-1.14-.51l-.66-.83-1.29-1.6-1.23-1.56-.31-.38a1.67,1.67,0,0,1-.28-.47,1.54,1.54,0,0,1,0-1.1l1.3-3.27.59-1.48a3.55,3.55,0,0,1,.34-.72,1.42,1.42,0,0,1,.64-.5c1.92-.35,3.38-.49,4.43-.63a7.61,7.61,0,0,1,1.63-.14,1.82,1.82,0,0,1-.41.1l-1.18.24c-1,.2-2.58.42-4.33.77a1.15,1.15,0,0,0-.47.38,4.07,4.07,0,0,0-.28.65l-.56,1.49-1.26,3.29a1.07,1.07,0,0,0,0,.75,3.42,3.42,0,0,0,.51.71L343,84.1l1.29,1.6.65.81a1,1,0,0,0,.75.33l4.09-.61,1-.15a3.32,3.32,0,0,0,.89-.18,1,1,0,0,0,.51-.56c.11-.3.23-.59.34-.88.46-1.14.89-2.24,1.3-3.27q.17-.37.3-.75a1.71,1.71,0,0,0,.19-.67,1.22,1.22,0,0,0-.19-.6l-.44-.56-2.71-3.51A1.69,1.69,0,0,0,349.71,74.17Z"
                                style="fill:#263238"></path>
                            <path
                                d="M345.67,91.1a4.58,4.58,0,0,1,.66-.1l1.91-.33,3-.51a7.31,7.31,0,0,0,1.82-.44,5,5,0,0,0,1.7-1.16A5.29,5.29,0,0,0,356,86.62c.29-.76.6-1.56.91-2.39.55-1.67,1.67-3.38,1.26-5.29a5.31,5.31,0,0,0-1.28-2.6l-2-2.48-1-1.28a5.76,5.76,0,0,0-1.12-1.14,5,5,0,0,0-3-1,10.83,10.83,0,0,0-1.66.19l-1.67.25-3.25.51a5,5,0,0,0-2.6,1.48,5.19,5.19,0,0,0-.84,1.2c-.21.43-.38.93-.56,1.38l-1.07,2.71a14.24,14.24,0,0,0-.88,2.54,5.27,5.27,0,0,0,1.37,4.39l2.51,3.2c.38.46.69.92,1.05,1.27a5.18,5.18,0,0,0,1.09.82,6.35,6.35,0,0,0,2.47.72s-.06,0-.18,0-.28,0-.5,0a5.07,5.07,0,0,1-1.88-.55,5.82,5.82,0,0,1-1.17-.82,16,16,0,0,1-1.11-1.27l-2.57-3.15a5.62,5.62,0,0,1-1.5-4.68,13.93,13.93,0,0,1,.87-2.65l1.05-2.71c.19-.47.34-.93.57-1.42a5.71,5.71,0,0,1,.91-1.33A5.6,5.6,0,0,1,343,70.89c1.1-.19,2.17-.34,3.28-.52l1.67-.25a10.51,10.51,0,0,1,1.74-.2A5.46,5.46,0,0,1,353,71a6.12,6.12,0,0,1,1.21,1.23l1,1.28c.68.84,1.34,1.68,2,2.49a5.69,5.69,0,0,1,1.37,2.83,5.46,5.46,0,0,1-.32,3c-.34.87-.68,1.72-1,2.55s-.64,1.61-.94,2.38a5.55,5.55,0,0,1-1.29,2,5.87,5.87,0,0,1-3.75,1.63l-3,.42c-.83.11-1.48.2-1.92.23A2.92,2.92,0,0,1,345.67,91.1Z"
                                style="fill:#263238"></path>
                            <path
                                d="M443.09,78.05a15.17,15.17,0,0,1-2.58,3.29,12.46,12.46,0,0,1-3.15,2.77A27.3,27.3,0,0,1,440.13,81,18.49,18.49,0,0,1,443.09,78.05Z"
                                style="fill:#263238"></path>
                            <path
                                d="M424.34,72.3a11.93,11.93,0,0,1,1.33,3.78,11.78,11.78,0,0,1,.53,4,22.26,22.26,0,0,1-1-3.86A21.83,21.83,0,0,1,424.34,72.3Z"
                                style="fill:#263238"></path>
                            <path
                                d="M416.88,87.77a23.61,23.61,0,0,1-3.84-1.1,25.2,25.2,0,0,1-3.8-1.26,18.4,18.4,0,0,1,7.64,2.36Z"
                                style="fill:#263238"></path>
                            <path
                                d="M414.75,105.12a12,12,0,0,1,2-2.86,12.26,12.26,0,0,1,2.44-2.52,11.48,11.48,0,0,1-2,2.86A12.26,12.26,0,0,1,414.75,105.12Z"
                                style="fill:#263238"></path>
                            <path
                                d="M431.59,110.59a10.4,10.4,0,0,1-.7-3.22,10.29,10.29,0,0,1-.19-3.3,10.72,10.72,0,0,1,.7,3.23A10.58,10.58,0,0,1,431.59,110.59Z"
                                style="fill:#263238"></path>
                            <path d="M445.82,97.78a9.22,9.22,0,0,1-2.95-.86,9,9,0,0,1-2.77-1.34,18.44,18.44,0,0,1,5.72,2.2Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Character--inject-84">
                            <path
                                d="M644.34,174.46c6.77-8.16,13.54-16.4,18.82-25.6s9-19.48,9.27-30.08c0-1.61-.65-12.76-2.2-13.21-1.1-.32-1.86,9.53-2.76,10.24-8.64,6.76-14.25,16.79-17.48,27.27a143.85,143.85,0,0,0-5.65,31.38"
                                style="fill:#263238"></path>
                            <path
                                d="M556.15,236.48c2.7-7,16-42,15.93-42s-22.91-11.92-15-36.2c3.8-11.73,13.59-35.24,22.69-56.42a47.55,47.55,0,0,1,58.89-26.25l2.33.79c24.66,10,30,36.47,19.33,60.84l-49,113.5-42.94-13.27Z"
                                style="fill:#ffbf9d"></path>
                            <path d="M572.09,194.5s14.93,6,34.61,1.32c0,0-13.62,15.39-37,5.07Z" style="fill:#ff9a6c"></path>
                            <path
                                d="M579.73,125.23a3.65,3.65,0,0,0,2.15,4.61,3.49,3.49,0,0,0,4.61-1.91,3.64,3.64,0,0,0-2.15-4.61A3.48,3.48,0,0,0,579.73,125.23Z"
                                style="fill:#263238"></path>
                            <path
                                d="M581.51,113.66c.28.6,3.55-.46,7.26.81s5.81,4,6.36,3.72c.27-.13.11-1.09-.79-2.36a9.94,9.94,0,0,0-4.9-3.53,9.56,9.56,0,0,0-6-.08C582,112.71,581.37,113.39,581.51,113.66Z"
                                style="fill:#263238"></path>
                            <path
                                d="M612.32,138.34a3.63,3.63,0,0,0,2.15,4.6,3.48,3.48,0,0,0,4.61-1.91,3.65,3.65,0,0,0-2.15-4.61A3.49,3.49,0,0,0,612.32,138.34Z"
                                style="fill:#263238"></path>
                            <path
                                d="M617.4,127.45c.27.6,3.55-.45,7.26.81s5.8,4,6.36,3.73c.26-.14.11-1.1-.79-2.36a10,10,0,0,0-4.91-3.54,9.53,9.53,0,0,0-6-.08C617.92,126.5,617.26,127.18,617.4,127.45Z"
                                style="fill:#263238"></path>
                            <path
                                d="M594.43,151.5c.09-.2-2.09-1.38-5.67-3.12-.91-.42-1.75-.91-1.69-1.62s.75-1.65,1.58-2.59l5.25-6.28c7.37-9,13.05-16.47,12.68-16.77s-6.63,6.74-14,15.71c-1.79,2.22-3.51,4.33-5.14,6.36-.72,1-1.75,2-1.75,3.56a2.53,2.53,0,0,0,1.09,1.91,7.11,7.11,0,0,0,1.54.77C592,150.9,594.34,151.71,594.43,151.5Z"
                                style="fill:#263238"></path>
                            <path
                                d="M604.5,157.76c-.6-.23-2,3.8-6.38,5.49s-8.57-.19-8.79.36c-.14.23.7,1.1,2.49,1.77a10.67,10.67,0,0,0,7.26-.07,9.25,9.25,0,0,0,5.09-4.69C604.89,159,604.78,157.83,604.5,157.76Z"
                                style="fill:#263238"></path>
                            <path
                                d="M622.69,112.45c0,1.13,3.9,1.91,8.08,3.9s7.31,4.38,8.19,3.67c.4-.35.11-1.51-1-3a15.55,15.55,0,0,0-12.39-5.77C623.77,111.39,622.7,111.92,622.69,112.45Z"
                                style="fill:#263238"></path>
                            <path
                                d="M587.22,101.83c.37,1.07,3.22,1,6.31,2s5.5,2.49,6.39,1.81c.41-.34.29-1.32-.58-2.51a9.63,9.63,0,0,0-10.24-3.11C587.72,100.57,587.07,101.32,587.22,101.83Z"
                                style="fill:#263238"></path>
                            <path d="M652.26,154.5c.48,0,18.27.69,12.17,17s-21.27,6.85-21.12,6.37S652.26,154.5,652.26,154.5Z"
                                style="fill:#ffbf9d"></path>
                            <path
                                d="M650.62,173.58c.09,0,.21.31.61.71a3,3,0,0,0,2.11.84c2,0,4.44-2.19,5.62-5.11a10,10,0,0,0,.73-4.38,3.48,3.48,0,0,0-1.33-3,1.54,1.54,0,0,0-2,.15c-.39.38-.41.74-.5.74s-.25-.41.13-1a2,2,0,0,1,1-.79,2.31,2.31,0,0,1,1.73.17,4.29,4.29,0,0,1,2,3.65,10.43,10.43,0,0,1-.72,4.93c-1.34,3.25-4.17,5.71-6.79,5.51a3.3,3.3,0,0,1-2.45-1.41C650.5,174,650.55,173.59,650.62,173.58Z"
                                style="fill:#ff9a6c"></path>
                            <path
                                d="M600.64,78.93c-2.08-2.46,9.11-8,16.72-8.42,11.5-.68,27.51,2.32,35.55,8.35,9.7,7.25,16.65,16.13,18.31,28.12s-.71,24.31-5.36,35.49c-1.42,3.41-3.16,6.86-6.12,9.07-3.65,2.73-8.89,3.32-10.61,8.37a7.3,7.3,0,0,1-3.6,4.32c-4.2,2-6.7-2.35-7.23-6-1.13-7.76,1.39-15.53,3.88-23,1.77-5.28,3.6-10.67,7-15.1,1.84-2.41,4.1-4.48,5.81-7s2.82-5.67,2-8.58a10.31,10.31,0,0,0-.81-1.85,18.21,18.21,0,0,0-15.62-9.68c-10.43-.27-28-1.44-30.85-6.12-4.17-6.74-4.46-10.2-4.46-10.2Z"
                                style="fill:#263238"></path>
                            <path
                                d="M655,68.88c1.05.53,25.62,15.71,25.46,37.85s-4.21,27.56-4.21,27.56a13.62,13.62,0,0,1,2,3.35c.66,1.68-3.11,7.38-6.34,5.48-22.06-20.47-52.46-32.23-87.14-43l-26.16-9.37c-7.66-1.67-9.57-4.52-5.83-5.29,2.87-.6,26.63-1.8,26.63-1.8l5.13-1.58,16-11.31s-.62-2.56,2.63-3.39S634.34,58.38,655,68.88Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M584.52,82.12s.35.14,1,.36l3,.94c2.58.77,6.25,2.07,10.77,3.73A215.13,215.13,0,0,1,633,103.63a329.88,329.88,0,0,1,31,21.26c3.84,2.91,6.89,5.33,9,7l2.45,1.91c.56.43.87.64.87.64s-.27-.26-.82-.72l-2.39-2c-2.09-1.7-5.12-4.16-8.93-7.1a307.34,307.34,0,0,0-31-21.4,205.4,205.4,0,0,0-33.88-16.39A154.54,154.54,0,0,0,584.52,82.12Z"
                                style="fill:#263238"></path>
                            <g style="opacity:0.30000000000000004">
                                <path
                                    d="M675.34,89s-27.12-14.52-42.1-12.76L635,76l-14,1.16c-2.37.2-5.08.27-6.7-1.46,0,0,8.49-3.6,21.9-3.53S669.29,77,675.34,89Z">
                                </path>
                            </g>
                            <path
                                d="M675.7,89.24a21.84,21.84,0,0,0-2-2.57,37.91,37.91,0,0,0-6.58-5.94,44.73,44.73,0,0,0-11.69-6,37.67,37.67,0,0,0-15.91-2.21,66.18,66.18,0,0,0-8.24,1.36c-2.62.59-5.17,1-7.58,1.7a40.67,40.67,0,0,1-6.78,1.62,13.1,13.1,0,0,1-5.94-.79c-7.09-2.33-10.92-5.28-10.44-5.61a1.16,1.16,0,0,0,.37.75A9.49,9.49,0,0,0,602.83,73a41.17,41.17,0,0,0,8.06,3.71,13.56,13.56,0,0,0,6.08.86A40.91,40.91,0,0,0,623.83,76c2.36-.65,4.94-1.09,7.56-1.68A70.14,70.14,0,0,1,639.57,73a37.91,37.91,0,0,1,15.73,2.15A45.76,45.76,0,0,1,666.94,81a40.15,40.15,0,0,1,6.63,5.79c.71.77,1.24,1.39,1.58,1.82S675.7,89.24,675.7,89.24Z"
                                style="fill:#263238"></path>
                            <g style="opacity:0.30000000000000004">
                                <path
                                    d="M680.14,115.88c-5.14-1.81-8.58-4.48-13.31-7.36-5-3.06-10.11-5.86-15-9.16-3.71-2.5-8.2-5.14-9.85-9a6.29,6.29,0,0,0-.09,6.19c1.05,2,5.5,5.57,7.4,6.86,10.81,7.35,18.32,12.37,30.4,17.48a37.75,37.75,0,0,0,.44-5">
                                </path>
                            </g>
                            <path
                                d="M680.4,104.28c2.78,2.53,4.45,4.17,3.59,7-.71,2.34-2.15,5-4.57,4.63a5.9,5.9,0,0,1-2-.88L644.3,95.64A5.49,5.49,0,0,1,641.56,93c-.66-1.88,1-3.94,2.91-4.46s3.95,0,5.85.66c10.78,3.49,20.61,8.85,30.08,15.07"
                                style="fill:currentColor"></path>
                            <path
                                d="M641.92,93.72a3.67,3.67,0,0,1-.42-1.88,4.71,4.71,0,0,1,3-4c2.12-.72,4.93-.24,7.69.88s5.87,2.39,9,3.84a100,100,0,0,1,15.57,8.64c1.88,1.29,3.33,2.43,4.34,3.22l1.14.93a2.42,2.42,0,0,0,.42.3s-.11-.14-.36-.37l-1.09-1c-1-.83-2.39-2-4.26-3.35a91.47,91.47,0,0,0-15.57-8.79c-3.18-1.46-6.25-2.72-9.07-3.83s-5.71-1.59-8-.78a4.87,4.87,0,0,0-3.06,4.29,3.16,3.16,0,0,0,.31,1.45A1.66,1.66,0,0,0,641.92,93.72Z"
                                style="fill:#263238"></path>
                            <polygon points="595.52 74.36 618.03 81.57 613.98 87.22 589.85 78.36 595.52 74.36"
                                style="fill:#fff"></polygon>
                            <path
                                d="M622.52,105.81c.05-.12-9.42-5-21.17-10.82S580,84.46,580,84.58s9.42,5,21.17,10.82S622.46,105.92,622.52,105.81Z"
                                style="fill:#263238"></path>
                            <path
                                d="M628.19,227.13l.3-14.78-50.58,18.79s-9.35-30.37-9.35-31.8l-11.21,7-18.63-8-18.63-9.2-37.68,66L442.88,371.68,536,433.8l69.06-74,42-64,23.08-40.52Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M573.41,230.92a10.13,10.13,0,0,1-.07-1.48c0-1,0-2.42-.06-4.14l.23.14a63.37,63.37,0,0,0-15.23,10.43l-.4.38,0-.55c0-.66-.08-1.36-.12-2.07-.41-7.25-.75-13.81-1-18.57-.1-2.32-.18-4.22-.24-5.63q0-.92,0-1.53a.27.27,0,1,1,.1,0c0,.4.08.91.14,1.52.1,1.41.23,3.31.39,5.62.32,4.75.71,11.31,1.12,18.56,0,.71.08,1.41.11,2.07l-.43-.18a59.76,59.76,0,0,1,15.44-10.34l.24-.1v.25c0,1.72-.07,3.11-.09,4.14A10.08,10.08,0,0,1,573.41,230.92Z"
                                style="fill:#263238"></path>
                            <path
                                d="M623.53,227.84a2.83,2.83,0,0,1-.58.31l-1.69.81L615,231.83l-20.76,9.28-9.86,4.36-.42.18.08-.45A77.72,77.72,0,0,0,585.18,231l.23.14-4.67,2.27-1.25.58c-.28.13-.43.19-.44.17a1.89,1.89,0,0,1,.4-.25l1.21-.66,4.61-2.4.22-.12V231a72.66,72.66,0,0,1-1,14.33l-.34-.27,9.85-4.38,20.82-9.15,6.34-2.72,1.73-.71A2.82,2.82,0,0,1,623.53,227.84Z"
                                style="fill:#263238"></path>
                            <rect x="139.63" y="153.88" width="410.04" height="292.88" rx="14.57" style="fill:#455a64">
                            </rect>
                            <path
                                d="M123.6,427.84H567.85a0,0,0,0,1,0,0v7.83a17.8,17.8,0,0,1-17.8,17.8H141.4a17.8,17.8,0,0,1-17.8-17.8v-7.83a0,0,0,0,1,0,0Z"
                                style="fill:#455a64"></path>
                            <rect x="150.64" y="165.52" width="386.88" height="247.33" style="fill:#263238"></rect>
                            <polygon points="304.23 425.1 309.74 434.57 387.31 434.57 392.43 425.1 304.23 425.1"
                                style="fill:#263238"></polygon>
                            <rect x="158.6" y="173.89" width="371.74" height="238.16" rx="3.27" style="fill:#ebebeb">
                            </rect>
                            <polygon points="529.95 412.4 158.21 412.4 158.6 191.69 529.95 191.69 529.95 412.4"
                                style="fill:#fafafa"></polygon>
                            <path d="M189.84,183.09a3.06,3.06,0,1,1-3.06-3.21A3.14,3.14,0,0,1,189.84,183.09Z"
                                style="fill:#263238"></path>
                            <path d="M171.28,183.09a3.06,3.06,0,1,1-3.06-3.21A3.14,3.14,0,0,1,171.28,183.09Z"
                                style="fill:#263238"></path>
                            <path d="M180.82,183.09a3.06,3.06,0,1,1-3.06-3.21A3.14,3.14,0,0,1,180.82,183.09Z"
                                style="fill:#263238"></path>
                            <path
                                d="M546.15,425.1c0,.16-91,.28-203.25.28s-203.27-.12-203.27-.28,91-.29,203.27-.29S546.15,424.94,546.15,425.1Z"
                                style="fill:#263238"></path>
                            <path
                                d="M304.54,234a79.31,79.31,0,0,1,19.34-8.4l4-19.15,32.34-.57,4.66,19a79.63,79.63,0,0,1,19.62,7.72l16.35-10.71,23.27,22.47L414,261.09a79.21,79.21,0,0,1,8.4,19.35l19.14,4,.57,32.34-19,4.66A79.24,79.24,0,0,1,415.38,341l10.72,16.35-22.47,23.27-16.71-10.13a79.21,79.21,0,0,1-19.35,8.4l-4,19.15-32.35.56-4.65-19A79.09,79.09,0,0,1,307,371.93l-16.35,10.72-23.27-22.47,10.13-16.71a79.24,79.24,0,0,1-8.41-19.35l-19.14-4-.57-32.34,19-4.66a79.47,79.47,0,0,1,7.72-19.62l-10.71-16.35,22.47-23.27L304.54,234Zm17.24,43.09a34.7,34.7,0,1,0,49.07-.86A34.7,34.7,0,0,0,321.78,277.12Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M433.75,246.37a27.69,27.69,0,0,1,2.25-6.91l-4-5.4,7.24-8.48,6,3.14a27.37,27.37,0,0,1,6.47-3.29l1-6.67,11.11-.87,2,6.43a27.31,27.31,0,0,1,6.91,2.26l5.4-4,8.48,7.25-3.14,6a27.28,27.28,0,0,1,3.3,6.48l6.66,1,.87,11.12-6.43,2a27.05,27.05,0,0,1-2.26,6.91l4,5.41-7.24,8.47-6-3.14a27.28,27.28,0,0,1-6.48,3.3l-1,6.67-11.11.87-2-6.44a27.29,27.29,0,0,1-6.91-2.25l-5.41,4L435,272.9l3.14-6a27.47,27.47,0,0,1-3.3-6.48l-6.66-1-.87-11.12,6.43-2Zm15.07,3.37a12,12,0,1,0,9.84-10.68A12,12,0,0,0,448.82,249.74Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M190.22,358a32,32,0,0,1,1.39-8.47L185.94,344l6.94-11.18,7.52,2.6a32.34,32.34,0,0,1,7-5l-.06-7.95,12.82-3,3.47,7.15a31.93,31.93,0,0,1,8.47,1.39l5.59-5.67,11.18,6.94-2.6,7.52a32.34,32.34,0,0,1,5,7l7.95-.06,3,12.81L255.06,360a32.42,32.42,0,0,1-1.4,8.47l5.67,5.58-6.94,11.19-7.52-2.6a32.1,32.1,0,0,1-7,5l.06,7.95-12.81,3-3.48-7.15A32,32,0,0,1,213.2,390l-5.58,5.67-11.19-6.94,2.6-7.52a32.34,32.34,0,0,1-5-7l-8,.06-3-12.81,7.15-3.48Zm18.53,3.6a14.12,14.12,0,1,0,10.53-17A14.12,14.12,0,0,0,208.75,361.63Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M213.23,251.18a20.14,20.14,0,0,1,1.7-5.21l-3-4.08,5.46-6.39,4.5,2.37a20.79,20.79,0,0,1,4.88-2.49l.74-5,8.38-.66,1.5,4.85a20.93,20.93,0,0,1,5.21,1.7l4.08-3,6.38,5.46-2.36,4.5a20.38,20.38,0,0,1,2.48,4.88l5,.73.66,8.38L254,258.68a20.77,20.77,0,0,1-1.69,5.21l3,4.07-5.46,6.39-4.5-2.37a20.41,20.41,0,0,1-4.88,2.49l-.73,5-8.38.65-1.51-4.85a20.27,20.27,0,0,1-5.21-1.7l-4.07,3-6.39-5.46,2.36-4.5a20.38,20.38,0,0,1-2.48-4.88l-5-.74-.65-8.38,4.85-1.5Zm11.35,4.07a9,9,0,1,0,8.29-9.69A9,9,0,0,0,224.58,255.25Z"
                                style="fill:#ebebeb"></path>
                            <path
                                d="M434.17,341.43a18.09,18.09,0,0,1,1.46-4.48l-2.61-3.5,4.69-5.49,3.87,2a17.62,17.62,0,0,1,4.19-2.14l.63-4.32,7.2-.56,1.29,4.17a17.68,17.68,0,0,1,4.48,1.46l3.5-2.61,5.49,4.69-2,3.86a17.69,17.69,0,0,1,2.14,4.2l4.32.63.56,7.2-4.17,1.29a17.68,17.68,0,0,1-1.46,4.48l2.61,3.5-4.69,5.48-3.86-2a18.07,18.07,0,0,1-4.2,2.14l-.63,4.31-7.2.56-1.29-4.16a18.09,18.09,0,0,1-4.48-1.46l-3.5,2.61L435,358.6l2-3.86a17.62,17.62,0,0,1-2.14-4.19l-4.31-.63-.57-7.2,4.17-1.29Zm9.75,3.49A7.75,7.75,0,1,0,451,336.6,7.74,7.74,0,0,0,443.92,344.92Z"
                                style="fill:#ebebeb"></path>
                            <path
                                d="M345.73,352.28H296a16.7,16.7,0,0,1-14.45-25l24.88-43.09,24.87-43.09a16.7,16.7,0,0,1,28.91,0l24.88,43.09,24.88,43.09a16.7,16.7,0,0,1-14.46,25Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M399.29,332.22s.13.25.38.77a6.84,6.84,0,0,1-.66,6.42,6.75,6.75,0,0,1-1.87,1.86,6.1,6.1,0,0,1-2.86.94c-8.48.09-20.72.07-35.86.11l-53.18.06h-7.6a6.55,6.55,0,0,1-6.13-4.44,7.14,7.14,0,0,1-.25-4c.08-.33.19-.66.3-1s.29-.63.44-.93l1-1.75c1.28-2.35,2.58-4.71,3.88-7.1L313,293.57,329.22,264q3.91-7.17,7.7-14.07c.64-1.14,1.23-2.29,1.91-3.42a7.69,7.69,0,0,1,2.8-2.78,8.23,8.23,0,0,1,7.52-.34,7.87,7.87,0,0,1,3,2.38A30,30,0,0,1,354,249c1.17,2.14,2.33,4.25,3.46,6.33q3.42,6.24,6.61,12.11c4.27,7.81,8.24,15.09,11.86,21.73,7.24,13.29,13.09,24.05,17.14,31.5l4.64,8.57c.52,1,.92,1.72,1.19,2.24s.4.77.4.77-.16-.25-.44-.75l-1.24-2.21-4.73-8.53c-4.08-7.43-10-18.15-17.28-31.41l-11.91-21.71-6.64-12.09c-1.14-2.08-2.29-4.19-3.47-6.33a32.22,32.22,0,0,0-1.83-3.14,7.44,7.44,0,0,0-2.8-2.23,7.74,7.74,0,0,0-7.08.32,7.31,7.31,0,0,0-2.62,2.62c-.66,1.09-1.26,2.26-1.89,3.4l-7.7,14.07c-5.22,9.56-10.64,19.45-16.18,29.59l-16.19,29.57c-1.31,2.39-2.6,4.76-3.89,7.1a14.9,14.9,0,0,0-1.65,3.54,6.65,6.65,0,0,0,.23,3.75,6,6,0,0,0,5.66,4.11h7.6l53.18.05,35.85.05a5.89,5.89,0,0,0,2.77-.88,6.63,6.63,0,0,0,1.85-1.8,6.82,6.82,0,0,0,1.18-3.84A7.53,7.53,0,0,0,399.29,332.22Z"
                                style="fill:#263238"></path>
                            <path
                                d="M337.67,323c0-4.41,3.52-7.7,8.53-7.7s8.45,3.29,8.45,7.7-3.44,7.85-8.45,7.85S337.67,327.35,337.67,323Zm.08-45.17h16.9l-2.84,33.28H340.52Z"
                                style="fill:#fff"></path>
                            <path
                                d="M348.11,236.12a13.5,13.5,0,0,0-3.16-.66,11.26,11.26,0,0,0-7.22,2.42A17.9,17.9,0,0,0,333,244c-.91,1.8-1.34,3-1.42,2.95a3,3,0,0,1,.21-.86,21,21,0,0,1,.88-2.25,16.85,16.85,0,0,1,4.77-6.38A11,11,0,0,1,345,235.1a7.41,7.41,0,0,1,2.37.58C347.86,235.91,348.13,236.09,348.11,236.12Z"
                                style="fill:#fff"></path>
                            <path
                                d="M327.31,254.4A6.89,6.89,0,0,1,328.4,252c.73-1.23,1.42-2.17,1.55-2.1a6.8,6.8,0,0,1-1.1,2.36A6.89,6.89,0,0,1,327.31,254.4Z"
                                style="fill:#fff"></path>
                            <g style="opacity:0.30000000000000004">
                                <polygon points="370.69 259.26 293.2 307 283.14 324.44 376.16 268.73 370.69 259.26"
                                    style="fill:#fff"></polygon>
                            </g>
                            <g style="opacity:0.30000000000000004">
                                <path d="M382.89,280.42,280.18,341a11,11,0,0,0,2.23,4.32L384.7,283.56Z" style="fill:#fff">
                                </path>
                            </g>
                            <path
                                d="M636.72,393.4a30.26,30.26,0,0,0-31.65-8.48l-9.57-10.5-1.33-1.49-75.73-83.09a30.25,30.25,0,0,0-32-41.94l-3.7,1.47L495.61,258l-.69,14.05-10.41,9.45-14.05-.69-9.18-10.12-3.79,1.49c-1.09,8.47,4.59,19.15,10.78,26a30.24,30.24,0,0,0,31.6,8.49l77,84.48,2.36,2.63,7.3,8A30.22,30.22,0,0,0,591.92,434c6.16,6.8,14.34,11.34,22.85,11.11l3.8-1.48-9.19-10.13.69-14,10.41-9.45,14,.68,5.38,11.61,3.8-1.49A30.23,30.23,0,0,0,636.72,393.4Z"
                                style="fill:#e0e0e0"></path>
                            <g style="opacity:0.30000000000000004">
                                <path
                                    d="M636.72,393.4a30.26,30.26,0,0,0-31.65-8.48l-9.57-10.5-1.33-1.49-75.73-83.09a30.25,30.25,0,0,0-32-41.94l-3.7,1.47L495.61,258l-.69,14.05-10.41,9.45-14.05-.69-9.18-10.12-3.79,1.49c-1.09,8.47,4.59,19.15,10.78,26a30.24,30.24,0,0,0,31.6,8.49l77,84.48,2.36,2.63,7.3,8A30.22,30.22,0,0,0,591.92,434c6.16,6.8,14.34,11.34,22.85,11.11l3.8-1.48-9.19-10.13.69-14,10.41-9.45,14,.68,5.38,11.61,3.8-1.49A30.23,30.23,0,0,0,636.72,393.4Z">
                                </path>
                            </g>
                            <path
                                d="M632.92,394.88a30.23,30.23,0,0,0-31.64-8.47L591.7,375.9l-1.33-1.49-75.73-83.09a30.24,30.24,0,0,0-32-41.93l9.18,10.12-.68,14L480.71,283l-14-.68-9.18-10.12a30.23,30.23,0,0,0,38.58,35.94l77,84.48,2.37,2.63,7.3,8a30.24,30.24,0,0,0,32,41.89L605.59,435l.68-14,10.42-9.45,14,.69,9.18,10.12A30.19,30.19,0,0,0,632.92,394.88Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M632.92,394.88s.44.48,1.27,1.45a31.63,31.63,0,0,1,3.13,4.72,30.26,30.26,0,0,1,2.7,21.31l0,.2-.14-.15-9.19-10.11.08.05-14-.67.1,0-10.4,9.46,0-.11c-.2,4.36-.43,9.11-.67,14.05l0-.13L614.91,445l.24.26-.35.05A30.35,30.35,0,0,1,587.37,435a30.09,30.09,0,0,1-6.9-14.82,30.63,30.63,0,0,1,2.06-17l0,.24-86.69-95.09.27.07a30.84,30.84,0,0,1-16.9.48,30.5,30.5,0,0,1-22-36.73l.12-.48.33.36,9.18,10.12-.18-.08,14.05.68-.19.07L491,273.36l-.09.18c.23-4.74.46-9.41.69-14.05l.06.18-9.18-10.12-.31-.35.46-.06a30.49,30.49,0,0,1,29.1,12.5,30.32,30.32,0,0,1,5.51,14.73,31,31,0,0,1-2.35,15l0-.24,86.55,95.16-.12,0a30.32,30.32,0,0,1,24.9,2.93,31.78,31.78,0,0,1,5.24,4c1,1.07,1.54,1.62,1.54,1.62l-1.58-1.58a33.46,33.46,0,0,0-5.26-4,30.28,30.28,0,0,0-24.77-2.82l-.07,0,0-.06-86.71-95-.1-.11.06-.13a30.63,30.63,0,0,0,2.3-14.82,29.72,29.72,0,0,0-5.44-14.5,30,30,0,0,0-28.64-12.29l.15-.41L492,259.34l.07.07v.11q-.33,6.94-.68,14v.11l-.08.07-10.41,9.45-.08.07h-.11l-14-.69h-.11l-.07-.08-9.19-10.12.45-.11A30,30,0,0,0,496,307.9l.15,0,.12.12c31.48,34.58,61,66.95,86.63,95.13l.1.11-.06.14a30.3,30.3,0,0,0-2.05,16.72,30.19,30.19,0,0,0,19.4,23.39,30.12,30.12,0,0,0,14.46,1.5l-.12.31-9.17-10.12-.05-.06V435c.24-4.93.47-9.68.69-14v-.07l0-.05,10.43-9.43,0,0h.06l14,.7h0l0,0c3.36,3.72,6.45,7.13,9.16,10.14l-.18,0a30.21,30.21,0,0,0-2.59-21.21,33.33,33.33,0,0,0-3.07-4.74C633.33,395.39,632.92,394.88,632.92,394.88Z"
                                style="fill:#263238"></path>
                            <path
                                d="M511.19,296.17a2.64,2.64,0,0,1-.33.75,17.63,17.63,0,0,1-1.17,1.88,24.25,24.25,0,0,1-11.46,8.81,16.55,16.55,0,0,1-2.12.64,2.51,2.51,0,0,1-.8.13c0-.09,1.09-.39,2.79-1.11a27.64,27.64,0,0,0,11.3-8.68C510.53,297.12,511.11,296.13,511.19,296.17Z"
                                style="fill:#263238"></path>
                            <path
                                d="M595.76,332.26,567,318.86l-25.71-3.21,9.44,8s-33.24,11.59-33.82,14.2,2.62,9.63,8.48,8.33c0,0-3.29,4-1.92,8.41s4.4,5.24,10,4.21c0,0-3.8,5.69-.82,8.59s7.62,2.17,7.62,2.17.06,6.93,3.72,7.53,13.86-.11,17.67-1.28l19.35-6L593.55,367Z"
                                style="fill:#ffbf9d"></path>
                            <path
                                d="M542.82,341.06c.11.38-3.72,1.82-8.54,3.23s-8.84,2.23-8.95,1.85,3.72-1.83,8.54-3.23S542.71,340.68,542.82,341.06Z"
                                style="fill:#ff9a6c"></path>
                            <path
                                d="M547.71,354.73c.11.38-2.92,1.63-6.78,2.8s-7.09,1.79-7.21,1.41,2.93-1.63,6.79-2.79S547.6,354.36,547.71,354.73Z"
                                style="fill:#ff9a6c"></path>
                            <path
                                d="M552.1,366.1c.07.43-2.69,1-5.93,1.82s-5.77,2-6,1.59,2.15-2.06,5.6-3S552.05,365.75,552.1,366.1Z"
                                style="fill:#ff9a6c"></path>
                            <path
                                d="M555.73,322.5c.11.39-3.66,1.76-8.33,3.37s-8.48,2.84-8.64,2.47,3.46-2.21,8.18-3.83S555.63,322.12,555.73,322.5Z"
                                style="fill:#ff9a6c"></path>
                            <polygon points="590.34 329.74 652.63 352.3 648.99 395.05 580.41 367.4 590.34 329.74"
                                style="fill:#ffbf9d"></polygon>
                            <path
                                d="M670.26,254.93s8.12,8.39,12.85,23.48,27,79.06,26.46,99.41c-.59,21.05-14.76,36.07-45.9,27.75-18.58-5-40.72-13-40.72-13l15.74-51.74L651,344l-19.88-37.32Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M656,279.38c.12.09-8.5,12.36-19.24,27.41S617.23,334,617.11,333.9s8.5-12.36,19.24-27.41S655.89,279.3,656,279.38Z"
                                style="fill:#263238"></path>
                            <path
                                d="M679.84,351s-.54-.26-1.51-.71a28.35,28.35,0,0,0-4.27-1.51c-1.85-.51-4.09-1-6.58-1.53l-8.08-1.78c-5.73-1.28-10.92-2.47-14.66-3.36l-4.43-1.08a9.38,9.38,0,0,1-1.61-.46,10.46,10.46,0,0,1,1.65.27l4.47.91c3.77.8,9,1.93,14.7,3.21l8.07,1.83c2.48.56,4.72,1.08,6.57,1.64a24.54,24.54,0,0,1,4.26,1.68,10.18,10.18,0,0,1,1.07.63A1.67,1.67,0,0,1,679.84,351Z"
                                style="fill:#263238"></path>
                            <g style="opacity:0.30000000000000004">
                                <path
                                    d="M695.76,353.28a7.71,7.71,0,0,0-4.28-5.72,20.73,20.73,0,0,0-7.16-1.92c-11.19-1.54-22.51-2-33.8-2.39l1,.45a210.73,210.73,0,0,1,40.75,11.88,3.14,3.14,0,0,0,2.36.28A2.47,2.47,0,0,0,695.76,353.28Z">
                                </path>
                            </g>
                            <g style="opacity:0.30000000000000004">
                                <path
                                    d="M439.14,154.92c-10.5-1.79-23.06,1.26-33.56-.53-1.56-.26-3.28-.51-4.66.29-1.66.95-2.23,3.07-2.31,5a19,19,0,0,0,6,14.16,26.89,26.89,0,0,0,14.11,6.74c4.19.71,8.7.57,12.43-1.45C437.71,175.57,440.86,162.13,439.14,154.92Z">
                                </path>
                            </g>
                            <path
                                d="M398.39,174.13s-6.37-7.47-7.29-10.91c-.61-2.28-.31-8.67,0-12.72a7,7,0,0,1,4.55-6.2,2.31,2.31,0,0,1,2.37.19,23.81,23.81,0,0,1,2.9-3.26c2.5-2.56,3.69-4.29,9.19-2.7,0,0,4.05-4.27,6.38-3.95a36,36,0,0,1,4.63,1s8.87-.38,10.69,2.44a8.13,8.13,0,0,0,4,2.67,11,11,0,0,1,6.33,5.77,22.91,22.91,0,0,1,1.77,7.73l-9,.36s.64,20.71-1.63,22.38-3.13,1.07-3.13,1.07-1.73,4.86-8.48,1.27c0,0-5.6,1.69-8-.62s-11.18-24.5-11.18-24.5l.25,11s4.63,7.13,2.36,8.8S398.39,174.13,398.39,174.13Z"
                                style="fill:#ffbf9d"></path>
                            <path
                                d="M409.63,146.06a7,7,0,0,1,.51,1.3l1.22,3.6c1,3,2.37,7.28,3.83,11.95s2.68,9,4.06,11.84a25.44,25.44,0,0,0,1.84,3.3c.49.75.8,1.13.77,1.16s-.11-.07-.27-.25a9.22,9.22,0,0,1-.66-.79,20.16,20.16,0,0,1-2-3.26c-1.49-2.89-2.74-7.18-4.22-11.84s-2.77-8.92-3.69-12c-.42-1.47-.78-2.69-1.06-3.65A7.6,7.6,0,0,1,409.63,146.06Z"
                                style="fill:#ff9a6c"></path>
                            <path
                                d="M420.7,143.5a6.67,6.67,0,0,1,.46,1.34l1.07,3.71c.87,3.13,2,7.47,3.32,12.27s2.39,9.16,3.17,12.32c.37,1.5.67,2.76.91,3.74a6.94,6.94,0,0,1,.26,1.4,8.77,8.77,0,0,1-.46-1.34c-.28-1-.63-2.22-1.06-3.71-.88-3.13-2.06-7.47-3.32-12.27s-2.39-9.16-3.18-12.32c-.36-1.51-.67-2.76-.9-3.75A7.43,7.43,0,0,1,420.7,143.5Z"
                                style="fill:#ff9a6c"></path>
                        </g>
                    </svg>
                @break

                @case('401')
                    <svg id="svg-color" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 500">
                        <g id="freepik--background-complete--inject-4">
                            <circle cx="425.75" cy="143.5" r="44.03" style="fill:#fff"></circle>
                            <path
                                d="M425.75,188a44.54,44.54,0,1,1,44.53-44.53A44.59,44.59,0,0,1,425.75,188Zm0-88.07a43.54,43.54,0,1,0,43.53,43.54A43.59,43.59,0,0,0,425.75,100Z"
                                style="fill:#ebebeb"></path>
                            <path
                                d="M446.59,140.35a3.09,3.09,0,0,0-4.93-.71,10.91,10.91,0,0,0-1.63,2.89c-1.1,2.57-2.11,5.19-3.2,7.77-.11.28-.47.46-.72.68-.15-.29-.43-.58-.44-.88-.07-1.54-.1-3.08-.1-4.62,0-3,0-6,.05-9.07,0-5.09,0-10.17,0-15.26a3.05,3.05,0,0,0-.52-1.62,3,3,0,0,0-3.35-.92,2.79,2.79,0,0,0-1.77,2.7q0,8.1,0,16.18a2.06,2.06,0,0,1,0,.75.77.77,0,0,1-.53.44c-.18,0-.43-.24-.52-.43a2.07,2.07,0,0,1,0-.75V118.71a11.55,11.55,0,0,0,0-1.18,2.19,2.19,0,0,0-1.8-2.06,2.88,2.88,0,0,0-3.91,3c0,6.18,0,12.36,0,18.54a4.41,4.41,0,0,1-.05,1.09.67.67,0,0,1-.47.44.72.72,0,0,1-.53-.4,3.69,3.69,0,0,1-.06-1c0-4.95,0-9.89,0-14.84a2.84,2.84,0,0,0-5.67,0c0,5.26,0,10.51,0,15.76a3.13,3.13,0,0,1,0,.92,2.66,2.66,0,0,1-.53.74c-.2-.25-.57-.5-.58-.75,0-1.91,0-3.82,0-5.73s0-4,0-6.07a2.66,2.66,0,0,0-2.92-2.6,2.46,2.46,0,0,0-2.52,2.57q-.17,5.94-.34,11.87h0c0,2.42,0,4.83-.13,7.24a36.4,36.4,0,0,0,1.87,14.17,13,13,0,0,0,9,8.53A18.74,18.74,0,0,0,434,167.49a12.53,12.53,0,0,0,6.45-6.93c2.16-5.92,4.2-11.88,6.21-17.86A3.51,3.51,0,0,0,446.59,140.35Z"
                                style="fill:#ebebeb"></path>
                            <path
                                d="M89.23,82.76l-1.27-6A20.12,20.12,0,0,0,48.71,85.6L50,91.71a11.25,11.25,0,0,0-6.91,13l8,35.27a11.26,11.26,0,0,0,13.47,8.5l36.62-8.28a11.26,11.26,0,0,0,8.5-13.46l-8-35.28A11.24,11.24,0,0,0,89.23,82.76Zm-5.84,40.66-9.58,2.16-.07-7.25a6,6,0,1,1,6.31-1.55C81.33,119.31,83.39,123.42,83.39,123.42ZM85,83.66l-30.78,7-1.26-6a15.78,15.78,0,0,1,30.78-7Z"
                                style="fill:#ebebeb"></path>
                            <path
                                d="M150.79,44.63,152,40.9a12.89,12.89,0,0,0-24.58-7.8l-1.27,3.8a7.21,7.21,0,0,0-8,4.94l-7,22.1A7.22,7.22,0,0,0,115.88,73l22.94,7.26a7.22,7.22,0,0,0,9.06-4.7l7-22.1A7.22,7.22,0,0,0,150.79,44.63ZM134.41,65.24l-6-1.9,2.31-4a3.84,3.84,0,1,1,4,1.18C134.59,62.31,134.41,65.24,134.41,65.24Zm13.74-21.48-19.29-6.1,1.23-3.7A10.12,10.12,0,0,1,149.39,40Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M425.91,408.05a12,12,0,0,1,2,9.2A21.2,21.2,0,0,1,424,426c-3.63,5.09-9.76,8.86-15.49,11.36-2.35-6.53.46-14.08,2.13-17.82,2.63-5.91,11-15,15.26-11.51"
                                style="fill:#ebebeb"></path>
                            <path
                                d="M408.86,449.29a10.29,10.29,0,0,1,7.64-6.92,13.58,13.58,0,0,1,10.32,2.13c1.4.92,2.73,2.22,2.9,3.88a4.39,4.39,0,0,1-2.1,3.92,9,9,0,0,1-4.46,1.24c-5.34.29-10.56-.42-14.3-4.25"
                                style="fill:#ebebeb"></path>
                            <path
                                d="M396.48,458.85a23.28,23.28,0,0,1,6-6.16,42.72,42.72,0,0,1,4.69-2.89,20.55,20.55,0,0,1,9.7-2.37,14.62,14.62,0,0,1,3,.41,3.34,3.34,0,0,1,1.05.38c0,.12-1.56-.33-4.07-.29a21.94,21.94,0,0,0-9.39,2.5,50.81,50.81,0,0,0-4.64,2.8,20.77,20.77,0,0,0-3.44,2.75A30.23,30.23,0,0,1,396.48,458.85Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M420.16,415.52a11.2,11.2,0,0,1-.83,1.92c-.57,1.22-1.43,3-2.5,5.12-2.15,4.3-5.18,10.2-8.69,16.64s-6.86,12.19-9.37,16.29c-1.25,2.05-2.28,3.7-3,4.82a11,11,0,0,1-1.2,1.71,13,13,0,0,1,1-1.85l2.83-4.93c2.39-4.17,5.66-9.94,9.17-16.37l8.87-16.54,2.7-5A12.67,12.67,0,0,1,420.16,415.52Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M400.8,447.55a24,24,0,0,0-5.89-21.14c-1.32-1.41-3.26-2.75-5.06-2.05s-2.36,3-2.35,4.93a20.52,20.52,0,0,0,13,18.69"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M394.07,432s.3.26.73.82,1,1.39,1.72,2.45a26.84,26.84,0,0,1,3.89,9.08,17,17,0,0,1,.18,5.48,16.6,16.6,0,0,1-1.25,4.31,15.91,15.91,0,0,1-1.45,2.62c-.41.59-.65.89-.69.87s.77-1.38,1.69-3.68a17.76,17.76,0,0,0,1.05-4.2,17.26,17.26,0,0,0-.22-5.27,30.64,30.64,0,0,0-3.62-9A36.08,36.08,0,0,1,394.07,432Z"
                                style="fill:#e0e0e0"></path>
                        </g>
                        <g id="freepik--Plant--inject-4">
                            <path
                                d="M61,446.2c.59-2.29-.91-4.58-2.59-6.24s-3.69-3.15-4.56-5.34c-1.42-3.55.49-8.15-1.93-11.11-1.42-1.75-4-2.33-5.23-4.19A9.61,9.61,0,0,1,45.53,416a33.66,33.66,0,0,0-8.41-15.73,29.47,29.47,0,0,0,3.3,15.16c1,1.86,2.18,3.68,2.51,5.76.52,3.38-1.36,6.85-.53,10.17,1,3.79,5.21,6.33,5.41,10.23.17,3.3-2.71,6.2-2.49,9.5A8.81,8.81,0,0,0,46.79,455c2.55,4.24,6.3,7.16,12,7.07l7,.24Z"
                                style="fill:currentColor"></path>
                            <g style="opacity:0.30000000000000004">
                                <path
                                    d="M61,446.2c.59-2.29-.91-4.58-2.59-6.24s-3.69-3.15-4.56-5.34c-1.42-3.55.49-8.15-1.93-11.11-1.42-1.75-4-2.33-5.23-4.19A9.61,9.61,0,0,1,45.53,416a33.66,33.66,0,0,0-8.41-15.73,29.47,29.47,0,0,0,3.3,15.16c1,1.86,2.18,3.68,2.51,5.76.52,3.38-1.36,6.85-.53,10.17,1,3.79,5.21,6.33,5.41,10.23.17,3.3-2.71,6.2-2.49,9.5A8.81,8.81,0,0,0,46.79,455c2.55,4.24,6.3,7.16,12,7.07l7,.24Z">
                                </path>
                            </g>
                            <path
                                d="M67.14,462.49a5.56,5.56,0,0,0,1.91-.05,11.53,11.53,0,0,0,2.26-.56,9.78,9.78,0,0,0,2.8-1.53,3.91,3.91,0,0,0,1.14-1.54,7,7,0,0,0,.33-2.07,22.24,22.24,0,0,1,.16-2.26,6.3,6.3,0,0,1,.85-2.23c.83-1.44,2.19-2.81,2.63-4.77a16,16,0,0,0-.19-6.1,12.93,12.93,0,0,1,.16-6.53c.75-2.18,2.27-4.15,3-6.6s.4-5.14.56-7.77a10.38,10.38,0,0,1,.91-3.86c.56-1.24,1.34-2.4,2-3.69,1.24-2.63,1.46-5.6,1.79-8.51.17-1.47.34-2.95.5-4.45a21.73,21.73,0,0,1,.78-4.45,39.66,39.66,0,0,1,1.66-4.3,15,15,0,0,0,.81-2.25,21.84,21.84,0,0,0,.22-2.4,27.69,27.69,0,0,0-.18-4.81c-.19-1.61-.48-3.2-.65-4.81l0-.28,0-.32-.29.14a10.73,10.73,0,0,0-3.74,3.17,16.78,16.78,0,0,0-2.3,4.24A51.91,51.91,0,0,0,82,393a24.83,24.83,0,0,1-2.86,8.42c-.76,1.24-1.68,2.37-2.49,3.58a9.76,9.76,0,0,0-1.73,4c-.41,2.95,1.21,5.53.87,8.14a9,9,0,0,1-1.27,3.61c-.63,1.11-1.37,2.14-2.08,3.18a20.72,20.72,0,0,0-1.86,3.21,10.11,10.11,0,0,0-.86,3.49c-.17,2.35.17,4.57,0,6.67A15.4,15.4,0,0,1,68,443c-.85,1.71-1.78,3.26-2.57,4.76-.39.75-.75,1.49-1,2.22a10.53,10.53,0,0,0-.61,2.2,13.63,13.63,0,0,0-.05,4,10,10,0,0,0,2,5.07,4.26,4.26,0,0,0,.56.61,3.55,3.55,0,0,0,.46.39l.4.28a8.94,8.94,0,0,1-1.35-1.34,10,10,0,0,1-1.89-5,13.66,13.66,0,0,1,.09-3.91,10.38,10.38,0,0,1,.61-2.15c.3-.72.67-1.45,1.06-2.19.79-1.49,1.74-3,2.6-4.75A15.8,15.8,0,0,0,70,437.3c.18-2.15-.14-4.38,0-6.67a9.87,9.87,0,0,1,.83-3.38,21.49,21.49,0,0,1,1.85-3.14c.71-1,1.46-2.07,2.11-3.2a9.39,9.39,0,0,0,1.32-3.76c.34-2.78-1.27-5.38-.85-8.12A9.37,9.37,0,0,1,77,405.24c.79-1.19,1.72-2.32,2.5-3.59a25,25,0,0,0,2.93-8.56,52.2,52.2,0,0,1,2.15-9,16.7,16.7,0,0,1,2.24-4.13,10.3,10.3,0,0,1,3.59-3l-.32-.18,0,.28c.18,1.63.47,3.22.65,4.81a26.94,26.94,0,0,1,.19,4.74c0,.78-.09,1.59-.21,2.32A13.45,13.45,0,0,1,90,391a39.11,39.11,0,0,0-1.67,4.36,22.32,22.32,0,0,0-.79,4.52c-.16,1.5-.33,3-.49,4.45-.33,2.93-.55,5.85-1.74,8.38-.59,1.26-1.37,2.43-2,3.7a10.66,10.66,0,0,0-.93,4c-.15,2.69.2,5.32-.53,7.69s-2.24,4.35-3,6.59a13.06,13.06,0,0,0-.15,6.7,15.67,15.67,0,0,1,.22,6c-.4,1.87-1.72,3.22-2.56,4.7a6.28,6.28,0,0,0-.86,2.33,18.17,18.17,0,0,0-.15,2.28,7.19,7.19,0,0,1-.3,2A3.7,3.7,0,0,1,74,460.21a9.48,9.48,0,0,1-2.72,1.54,13,13,0,0,1-2.23.61,9.15,9.15,0,0,1-1.42.13Z"
                                style="fill:#263238"></path>
                            <path
                                d="M89.12,380.5a1.26,1.26,0,0,0-.06.21c0,.17-.1.38-.16.63-.13.55-.3,1.38-.56,2.41s-.9,2.2-1.44,3.63a49,49,0,0,0-1.66,4.94c-.53,1.86-1,3.92-1.49,6.12a26,26,0,0,1-2.23,6.8c-.57,1.13-1.21,2.28-1.72,3.53a16.21,16.21,0,0,0-1,4,82,82,0,0,1-1.5,8.42c-1.4,5.7-2.73,11.13-3.94,16.08l-3.3,13.11c-.91,3.71-1.66,6.73-2.18,8.86-.24,1-.44,1.82-.57,2.41-.06.25-.11.46-.14.63a.6.6,0,0,0,0,.22,2,2,0,0,0,.07-.21l.18-.62.66-2.39c.55-2.12,1.35-5.12,2.32-8.82s2.12-8.17,3.39-13.09,2.56-10.38,4-16.08a80.53,80.53,0,0,0,1.5-8.46,15.94,15.94,0,0,1,1-3.89c.5-1.22,1.13-2.36,1.7-3.5a26.22,26.22,0,0,0,2.22-6.9c.48-2.22.93-4.27,1.44-6.12s1-3.51,1.58-4.94,1.12-2.61,1.38-3.67.37-1.88.48-2.44c.05-.26.08-.47.11-.64A.72.72,0,0,0,89.12,380.5Z"
                                style="fill:#263238"></path>
                            <path
                                d="M68.36,462.51c4.55-2.7,5.85-10.91,4-15.84S67.1,437.22,66.59,432c-.39-4,.93-8.2,0-12.15-1.27-5.34-6.48-9.47-6.42-15,0-3.08,1.78-6,1.64-9.05-.17-3.77-3.06-6.76-4.86-10.08-2.74-5.09-2.92-11.1-3.86-16.8S50,357.11,44.92,354.31c-.75,4.84-2,8.15-1.62,14.71.14,2.36,2.88,6.86,3.25,12,.22,3.08.38,6.17.56,9.26a29.8,29.8,0,0,0,1.46,8.87c.82,2.16,2.15,4.11,2.76,6.34,1.16,4.18-.36,8.71.57,13,.79,3.59,3.28,6.68,3.78,10.33.72,5.11-2.59,10.43-.9,15.31.84,2.42,2.83,4.36,3.4,6.87.44,1.94,0,4,.36,5.94.64,3.14,6.63,5.58,9.82,5.38"
                                style="fill:currentColor"></path>
                            <path
                                d="M46.17,359.11a1.1,1.1,0,0,0,0,.27c0,.21.06.47.1.8.11.7.22,1.73.46,3.05s.94,2.84,1.49,4.65,1.16,3.89,1.67,6.23,1,4.91,1.41,7.69a32.21,32.21,0,0,0,2.33,8.7c.63,1.45,1.35,2.9,1.89,4.45a19.87,19.87,0,0,1,1,4.91,100.86,100.86,0,0,0,1.34,10.59c1.39,7.18,2.72,14,3.92,20.23s2.42,11.77,3.39,16.47l2.31,11.1.66,3q.11.48.18.78a2.18,2.18,0,0,0,.07.26.93.93,0,0,0,0-.27c0-.2-.08-.46-.13-.79-.14-.72-.33-1.74-.57-3-.53-2.66-1.27-6.45-2.18-11.12s-2.06-10.29-3.29-16.5-2.51-13-3.89-20.21a100,100,0,0,1-1.34-10.56,20.51,20.51,0,0,0-1-5c-.55-1.58-1.28-3-1.92-4.48a32.14,32.14,0,0,1-2.34-8.59c-.47-2.78-.92-5.36-1.46-7.7s-1.14-4.43-1.74-6.23-1.29-3.31-1.56-4.61-.41-2.34-.54-3c-.06-.33-.11-.59-.15-.79A1,1,0,0,0,46.17,359.11Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Device--inject-4">
                            <rect x="140.19" y="80.02" width="266.62" height="382.62" rx="11.55" style="fill:#263238">
                            </rect>
                            <rect x="148.6" y="106.2" width="249.81" height="319.54" style="fill:#fff"></rect>
                            <circle cx="273.5" cy="443.42" r="10.23"
                                transform="translate(-221.06 607.21) rotate(-76.66)" style="fill:#455a64"></circle>
                            <rect x="233.35" y="91.04" width="80.3" height="4.23" rx="1.22" style="fill:#455a64">
                            </rect>
                            <path
                                d="M304.8,400H242.21a13.43,13.43,0,0,1-13.43-13.43h0a13.43,13.43,0,0,1,13.43-13.43H304.8a13.43,13.43,0,0,1,13.43,13.43h0A13.43,13.43,0,0,1,304.8,400Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M256.6,388.21l.24-.48a2.71,2.71,0,0,0,1.86.72c1.06,0,1.53-.45,1.53-1,0-1.62-3.48-.64-3.47-2.83,0-.87.65-1.62,2.09-1.61a3.07,3.07,0,0,1,1.75.53l-.2.5a2.76,2.76,0,0,0-1.55-.5c-1,0-1.5.47-1.5,1.07,0,1.62,3.48.65,3.47,2.8,0,.87-.67,1.61-2.12,1.61A3,3,0,0,1,256.6,388.21Z"
                                style="fill:#fafafa"></path>
                            <path d="M262.14,383h.59l0,5.91h-.6Z" style="fill:#fafafa"></path>
                            <path d="M269.3,383.08l0,5.91h-.49l-3.62-4.81,0,4.8h-.6l0-5.91h.49l3.62,4.81,0-4.8Z"
                                style="fill:#fafafa"></path>
                            <path
                                d="M275.12,386.06h.57v2.25a3,3,0,0,1-2.08.75,3,3,0,0,1,0-6,2.7,2.7,0,0,1,2.09.86l-.37.39a2.29,2.29,0,0,0-1.7-.7,2.45,2.45,0,1,0,1.45,4.45Z"
                                style="fill:#fafafa"></path>
                            <path
                                d="M279.45,386.51v-3.39h.6l0,3.36c0,1.4.63,2,1.73,2.05s1.74-.64,1.74-2l0-3.36h.58l0,3.38c0,1.7-.88,2.57-2.33,2.56S279.44,388.21,279.45,386.51Z"
                                style="fill:#fafafa"></path>
                            <path
                                d="M290.33,385.2c0,1.26-.88,2-2.32,2h-1.52v1.87h-.6l0-5.91H288C289.46,383.17,290.33,383.93,290.33,385.2Zm-.6,0c0-.95-.59-1.49-1.72-1.5H286.5v2.95H288C289.13,386.66,289.73,386.13,289.73,385.2Z"
                                style="fill:#fafafa"></path>
                            <rect x="202.56" y="253.06" width="35.64" height="6.54"
                                transform="matrix(1, 0, 0, 1, 1.19, -1.01)" style="fill:#e0e0e0"></rect>
                            <path
                                d="M342.06,293.26a5.67,5.67,0,0,0,.82-.15,2.89,2.89,0,0,0,1.75-1.57,3.75,3.75,0,0,0,.24-1.76c0-.67,0-1.41,0-2.2,0-1.6,0-3.43,0-5.5v-8.8a3,3,0,0,0-.4-1.83,2.81,2.81,0,0,0-1.51-1.17,8.82,8.82,0,0,0-2.09-.12l-20,0-115.5-.42a2.55,2.55,0,0,0-2.53,2.23c0,1.31,0,2.77,0,4.15,0,2.78,0,5.55,0,8.29,0,1.38,0,2.74,0,4.11a8,8,0,0,0,.09,1.93,2.51,2.51,0,0,0,1,1.42,2.78,2.78,0,0,0,1.72.45h2l4,0,30.67.16,51.92.32,35,.27,9.52.11,2.47.05.85,0s-.29,0-.85,0l-2.47,0-9.52,0-35,0-51.93-.17L211.62,293h-6a3.54,3.54,0,0,1-2.13-.57,3.28,3.28,0,0,1-1.29-1.82,8.73,8.73,0,0,1-.12-2.13c0-1.36,0-2.73,0-4.1,0-2.75,0-5.51,0-8.3,0-1.41,0-2.75,0-4.23A3.26,3.26,0,0,1,205.4,269l115.5.63,20,.15a8.75,8.75,0,0,1,2.21.15,3.14,3.14,0,0,1,1.71,1.34,3.45,3.45,0,0,1,.44,2c0,.66,0,1.3,0,1.93,0,2.51,0,4.81-.06,6.88s0,3.89-.05,5.49c0,.79,0,1.53,0,2.2a3.93,3.93,0,0,1-.29,1.82,2.91,2.91,0,0,1-1.86,1.58A2.33,2.33,0,0,1,342.06,293.26Z"
                                style="fill:#e0e0e0"></path>
                            <rect x="202.29" y="315.3" width="35.64" height="6.54"
                                transform="translate(1.47 -1.01) rotate(0.26)" style="fill:#e0e0e0"></rect>
                            <path
                                d="M341.79,355.5a5.42,5.42,0,0,0,.82-.15,2.9,2.9,0,0,0,1.76-1.58,3.84,3.84,0,0,0,.24-1.75c0-.68,0-1.41,0-2.2,0-1.6,0-3.43,0-5.5v-8.8a3,3,0,0,0-.41-1.83,2.71,2.71,0,0,0-1.5-1.17,8.87,8.87,0,0,0-2.1-.12l-19.94,0-115.5-.43a2.54,2.54,0,0,0-2.53,2.23c-.05,1.32,0,2.78,0,4.15,0,2.79,0,5.55,0,8.3,0,1.37,0,2.74,0,4.1a8.66,8.66,0,0,0,.08,1.94,2.59,2.59,0,0,0,1,1.42,2.74,2.74,0,0,0,1.73.44h2l4,0,30.66.17L294,355l35,.28,9.51.11,2.48,0c.56,0,.84,0,.84,0l-.84,0-2.48,0-9.52,0-35-.05L242,355.37l-30.67-.12-4,0h-2a3.43,3.43,0,0,1-2.12-.56,3.28,3.28,0,0,1-1.3-1.82,9.23,9.23,0,0,1-.11-2.13c0-1.36,0-2.73,0-4.1q0-4.12,0-8.3c0-1.41,0-2.75,0-4.23a3.27,3.27,0,0,1,3.25-2.87l115.5.64,19.95.15a8.68,8.68,0,0,1,2.2.15,3.07,3.07,0,0,1,1.71,1.34,3.38,3.38,0,0,1,.45,2c0,.65,0,1.3,0,1.92,0,2.52,0,4.82-.06,6.88s0,3.9-.06,5.5c0,.79,0,1.52,0,2.2a3.88,3.88,0,0,1-.29,1.81,2.94,2.94,0,0,1-1.87,1.59A2.33,2.33,0,0,1,341.79,355.5Z"
                                style="fill:#e0e0e0"></path>
                            <rect x="212.12" y="278.28" width="65.19" height="6.11"
                                transform="translate(1.3 -1.13) rotate(0.26)" style="fill:#e0e0e0"></rect>
                            <path d="M218.06,344.19a2.86,2.86,0,1,1-2.84-3.06A2.94,2.94,0,0,1,218.06,344.19Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M226.89,344.23a2.86,2.86,0,1,1-2.84-3.05A2.94,2.94,0,0,1,226.89,344.23Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M235.72,344.27a2.86,2.86,0,1,1-2.84-3A2.94,2.94,0,0,1,235.72,344.27Z"
                                style="fill:#e0e0e0">
                            </path>
                            <path d="M244.55,344.31a2.86,2.86,0,1,1-2.84-3.05A3,3,0,0,1,244.55,344.31Z" style="fill:#e0e0e0">
                            </path>
                            <path d="M253.38,344.35a2.86,2.86,0,1,1-2.84-3.05A3,3,0,0,1,253.38,344.35Z" style="fill:#e0e0e0">
                            </path>
                            <path d="M262.21,344.39a2.86,2.86,0,1,1-2.84-3.05A3,3,0,0,1,262.21,344.39Z" style="fill:#e0e0e0">
                            </path>
                            <path d="M271,344.43a2.86,2.86,0,1,1-2.84-3.05A3,3,0,0,1,271,344.43Z" style="fill:#e0e0e0"></path>
                            <path d="M279.87,344.47a2.86,2.86,0,1,1-2.83-3.05A2.94,2.94,0,0,1,279.87,344.47Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M288.7,344.51a2.86,2.86,0,1,1-2.83-3.05A2.94,2.94,0,0,1,288.7,344.51Z"
                                style="fill:#e0e0e0"></path>
                            <circle cx="279.8" cy="181.75" r="48.88" transform="translate(-46.57 251.08) rotate(-45)"
                                style="fill:#e0e0e0"></circle>
                            <path
                                d="M283.58,182.44a10.7,10.7,0,0,0,6.37-9.9c0-5.91-4.45-10.72-10-10.74s-10,4.74-10.07,10.65a10.69,10.69,0,0,0,6.39,10c-15.44,2.32-14.74,19.1-14.74,19.1l36.51.17S298.88,184.75,283.58,182.44Z"
                                style="fill:#fff"></path>
                        </g>
                        <g id="freepik--Sign--inject-4">
                            <rect x="103.83" y="229.31" width="12.88" height="233.26" style="fill:#263238"></rect>
                            <rect x="100.25" y="229.31" width="12.88" height="233.26" style="fill:#455a64"></rect>
                            <path
                                d="M173.77,206.92c0-8.77,0-17.54,0-26.3a3.4,3.4,0,0,0-.78-2.18Q154.3,159.69,135.53,141a4.19,4.19,0,0,0-2.7-1.08c-17.32-.06-34.63,0-51.94-.08a4.2,4.2,0,0,0-3.27,1.42q-18.37,18.45-36.79,36.87a4,4,0,0,0-1,2.55q-.09,26.22,0,52.44a4,4,0,0,0,1.07,2.53q18.36,18.48,36.79,36.89A4.15,4.15,0,0,0,80.92,274q25.8-.06,51.61,0a4.25,4.25,0,0,0,3.3-1.35c12.24-12.31,24.55-24.56,36.78-36.88a4.25,4.25,0,0,0,1.11-2.69C173.8,224.34,173.77,215.63,173.77,206.92Z"
                                style="fill:currentColor"></path>
                            <g id="freepik--4mamg4tif--inject-4">
                                <path
                                    d="M30.14,206.76c0-10,0-20.06,0-30.08a3.82,3.82,0,0,1,1-2.42q16.72-16.83,33.55-33.59c3.06-3.06,6.07-6.16,9.19-9.15a4.07,4.07,0,0,1,2.52-1.1c20.06-.06,40.11,0,60.17-.07a4.05,4.05,0,0,1,3.15,1.32q21.21,21.3,42.49,42.55a3.72,3.72,0,0,1,1,2.39c.05,20.17,0,40.33.05,60.5a3.47,3.47,0,0,1-1.13,2.72Q165.47,256.4,148.89,273c-3.17,3.17-6.35,6.34-9.6,9.44a3.62,3.62,0,0,1-2.24.95q-30.42.07-60.83,0a3.29,3.29,0,0,1-2.11-.86q-17.78-17.65-35.47-35.39c-2.48-2.47-5-4.91-7.39-7.47a4.13,4.13,0,0,1-1.06-2.54C30.12,227,30.14,216.9,30.14,206.76Zm76.64-71.91c-9.53,0-19.07,0-28.6,0a3.12,3.12,0,0,0-2,.72q-20.32,20.21-40.53,40.53a3.8,3.8,0,0,0-1,2.42q-.08,28.35,0,56.71a3.94,3.94,0,0,0,1,2.54q20,20.14,40.2,40.17a3.77,3.77,0,0,0,2.41,1c18.84.05,37.69,0,56.54.07a3.68,3.68,0,0,0,2.87-1.19q19.89-19.95,39.85-39.85a3.86,3.86,0,0,0,1.2-3c0-18.85,0-37.7-.06-56.55a3.67,3.67,0,0,0-.94-2.26c-3.5-3.62-7.09-7.15-10.65-10.72q-14.52-14.53-29-29.09a4.77,4.77,0,0,0-3.73-1.53C125.19,134.89,116,134.85,106.78,134.85Z"
                                    style="fill:currentColor"></path>
                                <path
                                    d="M106.78,134.85c9.21,0,18.41,0,27.62,0a4.77,4.77,0,0,1,3.73,1.53q14.48,14.58,29,29.09c3.56,3.57,7.15,7.1,10.65,10.72a3.67,3.67,0,0,1,.94,2.26c.05,18.85,0,37.7.06,56.55a3.86,3.86,0,0,1-1.2,3q-20,19.89-39.85,39.85a3.68,3.68,0,0,1-2.87,1.19c-18.85,0-37.7,0-56.54-.07a3.77,3.77,0,0,1-2.41-1q-20.16-20-40.2-40.17a3.94,3.94,0,0,1-1-2.54q-.09-28.37,0-56.71a3.8,3.8,0,0,1,1-2.42q20.2-20.32,40.53-40.53a3.12,3.12,0,0,1,2-.72C87.71,134.83,97.25,134.85,106.78,134.85Zm66.93,72.07c0-8.77,0-17.54,0-26.3a3.4,3.4,0,0,0-.78-2.18q-18.65-18.75-37.43-37.4a4.19,4.19,0,0,0-2.7-1.08c-17.31-.06-34.63,0-51.94-.08a4.19,4.19,0,0,0-3.26,1.42q-18.39,18.45-36.8,36.87a4,4,0,0,0-1,2.55q-.09,26.22,0,52.44a4,4,0,0,0,1.07,2.53q18.36,18.48,36.79,36.89A4.16,4.16,0,0,0,80.86,274q25.81-.06,51.61,0a4.24,4.24,0,0,0,3.3-1.35c12.25-12.31,24.55-24.56,36.79-36.88a4.24,4.24,0,0,0,1.1-2.69C173.74,224.34,173.71,215.63,173.71,206.92Z"
                                    style="fill:#fff"></path>
                            </g>
                            <path
                                d="M95.21,214.16H89.55v7.3H81.71v-7.3H63v-5.41l16.38-22h8.43l-15.18,20.9H82v-6.5h7.59v6.5h5.66Z"
                                style="fill:#fff"></path>
                            <path
                                d="M97.59,204.09c0-11.47,6.35-18,14.89-18s14.89,6.5,14.89,18-6.3,18-14.89,18S97.59,215.55,97.59,204.09Zm21.69,0c0-7.89-2.78-11.17-6.8-11.17s-6.75,3.28-6.75,11.17,2.78,11.17,6.75,11.17S119.28,212,119.28,204.09Z"
                                style="fill:#fff"></path>
                            <path d="M144.39,186.71v34.75h-8V193.17H129.4v-6.46Z" style="fill:#fff"></path>
                            <path d="M98,176v1.5H89.28v-12h8.48v1.49H91v3.69h6v1.46H91V176Z" style="fill:#fff"></path>
                            <path
                                d="M105.44,168.27v1.6a2.55,2.55,0,0,0-.38,0c-1.76,0-2.86,1.08-2.86,3.07v4.54h-1.65v-9.1h1.58v1.52A3.47,3.47,0,0,1,105.44,168.27Z"
                                style="fill:#fff"></path>
                            <path
                                d="M112.37,168.27v1.6a2.55,2.55,0,0,0-.38,0c-1.77,0-2.87,1.08-2.87,3.07v4.54h-1.65v-9.1h1.58v1.52A3.48,3.48,0,0,1,112.37,168.27Z"
                                style="fill:#fff"></path>
                            <path
                                d="M113.47,172.91a4.73,4.73,0,1,1,4.74,4.65A4.53,4.53,0,0,1,113.47,172.91Zm7.79,0a3.07,3.07,0,1,0-6.13,0,3.07,3.07,0,1,0,6.13,0Z"
                                style="fill:#fff"></path>
                            <path
                                d="M130.11,168.27v1.6a2.42,2.42,0,0,0-.37,0c-1.77,0-2.87,1.08-2.87,3.07v4.54h-1.65v-9.1h1.58v1.52A3.48,3.48,0,0,1,130.11,168.27Z"
                                style="fill:#fff"></path>
                            <path
                                d="M62.24,235.59v-5.34h1.34v5.28c0,2.08,1,3,2.64,3s2.66-.94,2.66-3v-5.28h1.3v5.34c0,2.72-1.49,4.16-4,4.16S62.24,238.31,62.24,235.59Z"
                                style="fill:#fff"></path>
                            <path
                                d="M79.49,235.55v4.09H78.2v-3.95c0-1.39-.7-2.07-1.92-2.07A2.1,2.1,0,0,0,74,236v3.66H72.74v-7.11H74v1.07a3.08,3.08,0,0,1,2.57-1.14A2.75,2.75,0,0,1,79.49,235.55Z"
                                style="fill:#fff"></path>
                            <path
                                d="M87.51,235.35v4.29H86.29v-.94a2.65,2.65,0,0,1-2.34,1c-1.61,0-2.63-.86-2.63-2.09s.74-2.08,2.86-2.08h2v-.26c0-1.08-.63-1.72-1.91-1.72a3.6,3.6,0,0,0-2.25.77l-.54-1a4.75,4.75,0,0,1,2.94-.91C86.41,232.46,87.51,233.4,87.51,235.35Zm-1.29,2.12v-1h-2c-1.27,0-1.63.5-1.63,1.1s.59,1.16,1.57,1.16A2.07,2.07,0,0,0,86.22,237.47Z"
                                style="fill:#fff"></path>
                            <path
                                d="M96.52,232.53v7.11H95.3v-1.07a2.92,2.92,0,0,1-2.42,1.15,2.8,2.8,0,0,1-3.06-3.1v-4.09h1.29v3.94c0,1.4.7,2.1,1.92,2.1a2.1,2.1,0,0,0,2.2-2.37v-3.67Z"
                                style="fill:#fff"></path>
                            <path
                                d="M103,239.22a2.41,2.41,0,0,1-1.56.5,2,2,0,0,1-2.25-2.23v-3.9H98v-1.06h1.21V231h1.29v1.56h2v1.06h-2v3.85a1,1,0,0,0,1.11,1.19,1.62,1.62,0,0,0,1-.33Z"
                                style="fill:#fff"></path>
                            <path
                                d="M111.27,235.55v4.09H110v-3.95c0-1.39-.7-2.07-1.92-2.07a2.1,2.1,0,0,0-2.25,2.36v3.66h-1.29v-10h1.29v3.85a3.1,3.1,0,0,1,2.51-1.07A2.75,2.75,0,0,1,111.27,235.55Z"
                                style="fill:#fff"></path>
                            <path
                                d="M113,236.08a3.7,3.7,0,1,1,3.7,3.64A3.54,3.54,0,0,1,113,236.08Zm6.09,0a2.4,2.4,0,1,0-2.39,2.51A2.33,2.33,0,0,0,119.13,236.08Z"
                                style="fill:#fff"></path>
                            <path
                                d="M126,232.46v1.25h-.29a2.12,2.12,0,0,0-2.24,2.4v3.54h-1.29v-7.11h1.23v1.19A2.72,2.72,0,0,1,126,232.46Z"
                                style="fill:#fff"></path>
                            <path d="M127.39,230.33a.87.87,0,1,1,.87.83A.83.83,0,0,1,127.39,230.33Zm.22,2.2h1.29v7.11h-1.29Z"
                                style="fill:#fff"></path>
                            <path d="M136.63,238.58v1.06h-6v-.83l4.2-5.22h-4.12v-1.06h5.77v.84l-4.2,5.21Z" style="fill:#fff">
                            </path>
                            <path
                                d="M144.63,236.51h-5.77a2.42,2.42,0,0,0,2.58,2.08,2.64,2.64,0,0,0,2.05-.86l.71.84a3.87,3.87,0,0,1-6.62-2.49,3.48,3.48,0,0,1,3.57-3.62,3.43,3.43,0,0,1,3.51,3.66A2.66,2.66,0,0,1,144.63,236.51Zm-5.77-.92h4.57a2.3,2.3,0,0,0-4.57,0Z"
                                style="fill:#fff"></path>
                            <path
                                d="M153.15,229.68v10h-1.23v-1.13a3,3,0,0,1-2.54,1.21,3.63,3.63,0,0,1,0-7.26,3,3,0,0,1,2.48,1.14v-3.92Zm-1.28,6.4a2.39,2.39,0,1,0-2.38,2.51A2.34,2.34,0,0,0,151.87,236.08Z"
                                style="fill:#fff"></path>
                        </g>
                        <g id="freepik--Padlock--inject-4">
                            <path
                                d="M325.32,238.6a13.51,13.51,0,0,0-18.15-6l-18.34,9.24a13.51,13.51,0,0,0-6,18.14h0A13.51,13.51,0,0,0,301,266l18.34-9.24A13.52,13.52,0,0,0,325.32,238.6Zm-8.75,12.48-18.2,9.17a7.2,7.2,0,1,1-6.48-12.87l18.2-9.17a7.2,7.2,0,1,1,6.48,12.87Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M317.8,239l6-2.79a12.63,12.63,0,0,0-1.48-1.56L316.15,238S317.64,238.54,317.8,239Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M320.33,246.5l6.34-.11a27.45,27.45,0,0,0-.06-3.75l-6.13,2.87Z" style="fill:#e0e0e0">
                            </path>
                            <path
                                d="M325.32,238.6a13.51,13.51,0,0,0-18.15-6l-18.34,9.24a13.51,13.51,0,0,0-6,18.14h0A13.51,13.51,0,0,0,301,266l18.34-9.24A13.52,13.52,0,0,0,325.32,238.6Zm-8.75,12.48-18.2,9.17a7.2,7.2,0,1,1-6.48-12.87l18.2-9.17a7.2,7.2,0,1,1,6.48,12.87Z"
                                style="fill:none"></path>
                            <path
                                d="M316.57,251.08a8.5,8.5,0,0,0,2.48-2.23,7.19,7.19,0,0,0,1.31-3.61,7,7,0,0,0-10.06-6.88l-3.35,1.7L292,247.61a7,7,0,0,0-3.79,6.89,7.06,7.06,0,0,0,1.46,3.64,6.94,6.94,0,0,0,3.06,2.21,7.1,7.1,0,0,0,3.58.34,11.51,11.51,0,0,0,3.22-1.27l5.7-2.84,8.27-4.07,2.26-1.08a4.49,4.49,0,0,1,.8-.35,5.65,5.65,0,0,1-.75.44l-2.22,1.17-8.2,4.22-5.67,2.89a11.62,11.62,0,0,1-3.33,1.34,7.52,7.52,0,0,1-3.83-.35,7.45,7.45,0,0,1-4-10.51,7.52,7.52,0,0,1,3.21-3.13l15-7.52L310.1,238a7.36,7.36,0,0,1,9.13,2.25,7.3,7.3,0,0,1,1.42,5,7.17,7.17,0,0,1-1.44,3.71,7,7,0,0,1-1.86,1.71,5.16,5.16,0,0,1-.57.31Q316.58,251.1,316.57,251.08Z"
                                style="fill:#263238"></path>
                            <path
                                d="M325.32,238.6a1.71,1.71,0,0,1,.15.29c.11.22.24.51.41.87s.33.88.51,1.47a14.24,14.24,0,0,1,.39,2.09,13.73,13.73,0,0,1-.61,5.78,14.68,14.68,0,0,1-1.62,3.28,14.48,14.48,0,0,1-2.77,3,22.39,22.39,0,0,1-3.88,2.29l-4.32,2.2L304,264.72a35.15,35.15,0,0,1-5.3,2.41,13.38,13.38,0,0,1-6.08.36,13.66,13.66,0,0,1-5.83-2.43,13.66,13.66,0,0,1-5.68-11.27,13.69,13.69,0,0,1,1.52-6.13,13.26,13.26,0,0,1,3.91-4.67,35.22,35.22,0,0,1,5.09-2.83l9.56-4.79,4.34-2.17a22,22,0,0,1,4.14-1.75,15,15,0,0,1,4.08-.43,14.76,14.76,0,0,1,3.6.66,13.6,13.6,0,0,1,5,2.94,14.28,14.28,0,0,1,1.45,1.56c.36.5.66.93.88,1.29l.45.84a1.56,1.56,0,0,1,.14.29,15.83,15.83,0,0,0-3.05-3.83,13.51,13.51,0,0,0-5-2.82,14.22,14.22,0,0,0-3.52-.6,14.54,14.54,0,0,0-4,.45,21.51,21.51,0,0,0-4.06,1.76l-4.33,2.19-9.54,4.84a34.68,34.68,0,0,0-5,2.79,12.87,12.87,0,0,0-3.75,4.51,13.1,13.1,0,0,0-1.46,5.9,13.19,13.19,0,0,0,5.47,10.86,13.19,13.19,0,0,0,5.61,2.34,13,13,0,0,0,5.86-.33,34.67,34.67,0,0,0,5.22-2.36l9.57-4.79,4.33-2.17a21.38,21.38,0,0,0,3.83-2.22,13.36,13.36,0,0,0,4.34-6.11,13.53,13.53,0,0,0,.69-5.67A15.63,15.63,0,0,0,325.32,238.6Z"
                                style="fill:#263238"></path>
                            <path
                                d="M383.92,209.64a13.5,13.5,0,0,0-18.14-6l-18.34,9.24a13.51,13.51,0,0,0-6,18.15h0a13.51,13.51,0,0,0,18.14,6l18.35-9.24A13.5,13.5,0,0,0,383.92,209.64Zm-8.74,12.47L357,231.28a7.21,7.21,0,1,1-6.49-12.87l18.2-9.17a7.21,7.21,0,0,1,6.49,12.87Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M376.4,210l6-2.8a13.33,13.33,0,0,0-1.47-1.55l-6.14,3.37S376.24,209.57,376.4,210Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M378.93,217.54l6.34-.11a27.18,27.18,0,0,0,0-3.76l-6.13,2.87Z" style="fill:#e0e0e0"></path>
                            <path
                                d="M383.92,209.64a13.5,13.5,0,0,0-18.14-6l-18.34,9.24a13.51,13.51,0,0,0-6,18.15h0a13.51,13.51,0,0,0,18.14,6l18.35-9.24A13.5,13.5,0,0,0,383.92,209.64Zm-8.74,12.47L357,231.28a7.21,7.21,0,1,1-6.49-12.87l18.2-9.17a7.21,7.21,0,0,1,6.49,12.87Z"
                                style="fill:none"></path>
                            <path
                                d="M375.18,222.11a8.59,8.59,0,0,0,2.47-2.22,7,7,0,0,0-8.75-10.49l-3.35,1.69-14.94,7.55a7,7,0,0,0-3.79,6.89,7.1,7.1,0,0,0,1.47,3.65,7,7,0,0,0,3,2.2,6.89,6.89,0,0,0,3.58.34,11,11,0,0,0,3.23-1.27l5.7-2.83,8.26-4.08,2.26-1.08a7.33,7.33,0,0,1,.81-.35,4.43,4.43,0,0,1-.76.44l-2.22,1.17L364,227.94l-5.67,2.89a11.57,11.57,0,0,1-3.34,1.34,7.48,7.48,0,0,1-3.82-.34,7.45,7.45,0,0,1-.8-13.65l15-7.51,3.37-1.68a7.51,7.51,0,0,1,3.54-.72,7.39,7.39,0,0,1,5.59,3,7.31,7.31,0,0,1,1.41,5.06,7.24,7.24,0,0,1-1.44,3.71,7,7,0,0,1-1.85,1.7,5.11,5.11,0,0,1-.58.31C375.25,222.09,375.18,222.12,375.18,222.11Z"
                                style="fill:#263238"></path>
                            <path
                                d="M383.92,209.64s.06.09.16.28l.41.87q.22.59.51,1.47a14.14,14.14,0,0,1,.39,2.1,13.55,13.55,0,0,1-.62,5.77,14.21,14.21,0,0,1-1.61,3.28,14.54,14.54,0,0,1-2.78,3,21.34,21.34,0,0,1-3.87,2.29l-4.32,2.2-9.55,4.83a33.76,33.76,0,0,1-5.3,2.41,13.38,13.38,0,0,1-6.08.36,13.55,13.55,0,0,1-5.82-2.42,14.07,14.07,0,0,1-4.22-4.95,13.92,13.92,0,0,1-1.46-6.33,13.6,13.6,0,0,1,1.51-6.12,13.42,13.42,0,0,1,3.91-4.68,34.72,34.72,0,0,1,5.09-2.82l9.57-4.8,4.33-2.16a21.73,21.73,0,0,1,4.15-1.75,14.55,14.55,0,0,1,4.08-.43,14.22,14.22,0,0,1,3.59.65,13.65,13.65,0,0,1,5,2.94,15.06,15.06,0,0,1,1.44,1.56c.37.5.66.93.89,1.29l.45.84a.94.94,0,0,1,.13.3,15.11,15.11,0,0,0-3.05-3.84,13.68,13.68,0,0,0-5-2.82,14.3,14.3,0,0,0-3.52-.6,14.68,14.68,0,0,0-4,.46,21.09,21.09,0,0,0-4.06,1.75L360,206.78l-9.55,4.84a34.58,34.58,0,0,0-5,2.79,13,13,0,0,0-3.76,4.51,13.16,13.16,0,0,0-1.45,5.91,13.19,13.19,0,0,0,5.47,10.85,13,13,0,0,0,5.61,2.34,12.85,12.85,0,0,0,5.86-.33,34.58,34.58,0,0,0,5.22-2.36l9.56-4.79,4.34-2.17a21.73,21.73,0,0,0,3.83-2.22,14.93,14.93,0,0,0,2.73-2.92A14.49,14.49,0,0,0,384.5,220a13.5,13.5,0,0,0,.69-5.66A15.53,15.53,0,0,0,383.92,209.64Z"
                                style="fill:#263238"></path>
                            <path
                                d="M408.5,202.77l-31.32,14.66a3.51,3.51,0,0,1-4.68-1.69h0a3.52,3.52,0,0,1,1.7-4.68l31.31-14.67a3.52,3.52,0,0,1,4.68,1.7h0A3.51,3.51,0,0,1,408.5,202.77Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M408.5,202.77s.29-.15.74-.54a3.44,3.44,0,0,0-.65-5.63,3.38,3.38,0,0,0-2.44-.26,8.18,8.18,0,0,0-1.29.55l-1.36.65-29.19,13.75a3.27,3.27,0,0,0,1.09,6.21,3.51,3.51,0,0,0,2-.44l2-.92,3.8-1.77,13.16-6.1,8.89-4.07,2.43-1.09.63-.27a.9.9,0,0,1,.23-.07l-.2.12-.62.32-2.39,1.17-8.82,4.22-13.11,6.2-3.79,1.79-2,.92a4,4,0,0,1-2.26.49,3.77,3.77,0,0,1-1.26-7.17l29.25-13.62,1.37-.63a8.1,8.1,0,0,1,1.36-.56,3.67,3.67,0,0,1,2.65.33A3.61,3.61,0,0,1,410.6,200a3.55,3.55,0,0,1-1.29,2.32A2.78,2.78,0,0,1,408.5,202.77Z"
                                style="fill:#263238"></path>
                            <path
                                d="M349.89,231.73,318.58,246.4a3.51,3.51,0,0,1-4.68-1.69h0a3.51,3.51,0,0,1,1.69-4.68l31.32-14.67a3.52,3.52,0,0,1,4.68,1.69h0A3.52,3.52,0,0,1,349.89,231.73Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M349.89,231.73a6.42,6.42,0,0,0,.75-.54,3.44,3.44,0,0,0,1.15-2.26,3.38,3.38,0,0,0-1.81-3.36,3.43,3.43,0,0,0-2.44-.27,8.27,8.27,0,0,0-1.29.56l-1.36.65L315.7,240.26a3.27,3.27,0,0,0,1.09,6.21,3.56,3.56,0,0,0,2-.44l2-.92,3.8-1.77,13.16-6.1,8.89-4.08,2.43-1.08.64-.27.22-.08s-.06.05-.2.13l-.62.31-2.38,1.18-8.82,4.22-13.12,6.2L321,245.56l-2,.92a4,4,0,0,1-2.25.49,3.76,3.76,0,0,1-3.37-3,3.81,3.81,0,0,1,2.1-4.15l29.26-13.61,1.37-.64a8.88,8.88,0,0,1,1.35-.55,3.64,3.64,0,0,1,4.53,4,3.48,3.48,0,0,1-1.29,2.31A2.5,2.5,0,0,1,349.89,231.73Z"
                                style="fill:#263238"></path>
                            <path
                                d="M209.36,294.1a13.53,13.53,0,0,0-18.15-6l-18.34,9.24a13.51,13.51,0,0,0-6,18.15h0a13.51,13.51,0,0,0,18.15,6l18.34-9.24A13.53,13.53,0,0,0,209.36,294.1Zm-8.75,12.48-18.2,9.17a7.2,7.2,0,1,1-6.48-12.87l18.2-9.17a7.2,7.2,0,0,1,6.48,12.87Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M201.83,294.49l6-2.79a13.55,13.55,0,0,0-1.48-1.56l-6.14,3.37S201.67,294,201.83,294.49Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M204.36,302l6.34-.11a27,27,0,0,0,0-3.75L204.52,301Z" style="fill:#e0e0e0"></path>
                            <path
                                d="M209.36,294.1a13.53,13.53,0,0,0-18.15-6l-18.34,9.24a13.51,13.51,0,0,0-6,18.15h0a13.51,13.51,0,0,0,18.15,6l18.34-9.24A13.53,13.53,0,0,0,209.36,294.1Zm-8.75,12.48-18.2,9.17a7.2,7.2,0,1,1-6.48-12.87l18.2-9.17a7.2,7.2,0,0,1,6.48,12.87Z"
                                style="fill:none"></path>
                            <path
                                d="M200.61,306.58a8.91,8.91,0,0,0,2.48-2.23,7.19,7.19,0,0,0,1.31-3.61,7,7,0,0,0-10.06-6.88L191,295.55c-4.59,2.33-9.64,4.88-14.94,7.55a7,7,0,0,0-3.79,6.9,7.16,7.16,0,0,0,1.47,3.64,7,7,0,0,0,3.06,2.21,7.1,7.1,0,0,0,3.58.34,11.51,11.51,0,0,0,3.22-1.27l5.7-2.84,8.27-4.07,2.26-1.09a4.8,4.8,0,0,1,.8-.34,7.18,7.18,0,0,1-.76.44l-2.21,1.17-8.2,4.22-5.67,2.89a11.55,11.55,0,0,1-3.34,1.33,7.38,7.38,0,0,1-3.82-.34,7.49,7.49,0,0,1-3.28-2.34,7.62,7.62,0,0,1-1.58-3.9,7.46,7.46,0,0,1,4.06-7.4l15-7.52,3.37-1.68a7.55,7.55,0,0,1,3.54-.72,7.41,7.41,0,0,1,5.59,3,7.22,7.22,0,0,1,1.41,5.05,7.15,7.15,0,0,1-3.29,5.42c-.24.15-.44.24-.57.31Z"
                                style="fill:#263238"></path>
                            <path
                                d="M209.36,294.1s.06.1.15.29.24.5.41.86.32.89.51,1.48a14.24,14.24,0,0,1,.39,2.09,13.59,13.59,0,0,1-.62,5.78,14.41,14.41,0,0,1-1.61,3.28,14.74,14.74,0,0,1-2.77,3,22.39,22.39,0,0,1-3.88,2.29l-4.32,2.19-9.54,4.84a36.17,36.17,0,0,1-5.3,2.41,13.52,13.52,0,0,1-6.08.36,13.78,13.78,0,0,1-5.83-2.43,13.66,13.66,0,0,1-5.68-11.27,13.66,13.66,0,0,1,1.52-6.13,13.34,13.34,0,0,1,3.9-4.67,35.33,35.33,0,0,1,5.09-2.83l9.57-4.79,4.34-2.17a21.39,21.39,0,0,1,4.14-1.75,14.55,14.55,0,0,1,4.08-.43,14.76,14.76,0,0,1,3.6.65,13.83,13.83,0,0,1,5,2.95,14.28,14.28,0,0,1,1.45,1.56c.36.5.66.93.88,1.28l.45.85c.1.19.14.29.14.29a15.75,15.75,0,0,0-3.06-3.83,13.46,13.46,0,0,0-5-2.82,13.47,13.47,0,0,0-7.49-.15,22.5,22.5,0,0,0-4.07,1.75l-4.32,2.2-9.54,4.83a35.73,35.73,0,0,0-5,2.8,12.79,12.79,0,0,0-3.75,4.51,13.1,13.1,0,0,0-1.46,5.9,13.19,13.19,0,0,0,5.47,10.86,13.14,13.14,0,0,0,5.61,2.34,13,13,0,0,0,5.86-.33,35.6,35.6,0,0,0,5.22-2.36l9.57-4.8,4.33-2.16a21.76,21.76,0,0,0,3.83-2.23,14.1,14.1,0,0,0,2.73-2.92,14.42,14.42,0,0,0,1.61-3.18,13.55,13.55,0,0,0,.69-5.67A15.51,15.51,0,0,0,209.36,294.1Z"
                                style="fill:#263238"></path>
                            <path
                                d="M268,265.14a13.5,13.5,0,0,0-18.14-6l-18.34,9.24a13.5,13.5,0,0,0-6,18.14h0a13.5,13.5,0,0,0,18.14,6L262,283.28A13.51,13.51,0,0,0,268,265.14Zm-8.74,12.47L241,286.78a7.21,7.21,0,1,1-6.49-12.87l18.2-9.17a7.21,7.21,0,0,1,6.49,12.87Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M260.44,265.52l6-2.79a13.06,13.06,0,0,0-1.47-1.56l-6.14,3.38S260.28,265.07,260.44,265.52Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M263,273l6.34-.12a25.88,25.88,0,0,0-.06-3.75L263.13,272Z" style="fill:#e0e0e0"></path>
                            <path
                                d="M268,265.14a13.5,13.5,0,0,0-18.14-6l-18.34,9.24a13.5,13.5,0,0,0-6,18.14h0a13.5,13.5,0,0,0,18.14,6L262,283.28A13.51,13.51,0,0,0,268,265.14Zm-8.74,12.47L241,286.78a7.21,7.21,0,1,1-6.49-12.87l18.2-9.17a7.21,7.21,0,0,1,6.49,12.87Z"
                                style="fill:none"></path>
                            <path
                                d="M259.22,277.61a8.59,8.59,0,0,0,2.47-2.22,7.08,7.08,0,0,0,1.31-3.62,7,7,0,0,0-6.73-7.58,7.16,7.16,0,0,0-3.33.7l-3.35,1.7-14.94,7.55a7,7,0,0,0-3.79,6.89,7,7,0,0,0,8.1,6.19,11.57,11.57,0,0,0,3.23-1.27l5.7-2.84,8.26-4.07,2.26-1.08a4.35,4.35,0,0,1,.81-.35,5.83,5.83,0,0,1-.76.44l-2.22,1.17-8.19,4.22-5.67,2.89a11.68,11.68,0,0,1-3.34,1.34,7.43,7.43,0,0,1-8.68-6.59,7.46,7.46,0,0,1,4.06-7.4l15-7.51,3.37-1.68a7.27,7.27,0,0,1,3.54-.72,7.35,7.35,0,0,1,5.58,3,7.25,7.25,0,0,1,1.42,5.05,7.17,7.17,0,0,1-1.44,3.71,6.85,6.85,0,0,1-1.85,1.71,5.11,5.11,0,0,1-.58.31C259.29,277.59,259.22,277.62,259.22,277.61Z"
                                style="fill:#263238"></path>
                            <path
                                d="M268,265.14s.06.09.16.28l.41.87q.23.58.51,1.47a14.24,14.24,0,0,1,.39,2.09,13.58,13.58,0,0,1-.62,5.78,13.53,13.53,0,0,1-4.39,6.3,21.93,21.93,0,0,1-3.87,2.29l-4.33,2.2-9.54,4.83a34.7,34.7,0,0,1-5.3,2.41,13.38,13.38,0,0,1-6.08.36,13.57,13.57,0,0,1-5.82-2.43,14.12,14.12,0,0,1-4.22-4.94,13.92,13.92,0,0,1-1.46-6.33,13.68,13.68,0,0,1,1.51-6.13,13.47,13.47,0,0,1,3.91-4.67,35.76,35.76,0,0,1,5.09-2.83l9.57-4.79,4.33-2.17a22.39,22.39,0,0,1,4.15-1.75,14.93,14.93,0,0,1,4.08-.43,14.67,14.67,0,0,1,3.59.66,13.6,13.6,0,0,1,5,2.94,13.35,13.35,0,0,1,1.45,1.56c.36.5.66.93.88,1.29l.46.84a1.38,1.38,0,0,1,.13.3,14.91,14.91,0,0,0-3-3.84,13.68,13.68,0,0,0-5-2.82,14.38,14.38,0,0,0-3.53-.6,14.22,14.22,0,0,0-4,.46,21.09,21.09,0,0,0-4.06,1.75l-4.32,2.19-9.55,4.84a34.58,34.58,0,0,0-5,2.79,13.27,13.27,0,0,0-5.21,10.41,13.19,13.19,0,0,0,5.47,10.86,13.14,13.14,0,0,0,5.61,2.34,12.85,12.85,0,0,0,5.86-.33,35.6,35.6,0,0,0,5.22-2.36L256,286l4.34-2.17a22.1,22.1,0,0,0,3.83-2.22,14.93,14.93,0,0,0,2.73-2.92,14.49,14.49,0,0,0,1.61-3.19,13.53,13.53,0,0,0,.69-5.67A15.51,15.51,0,0,0,268,265.14Z"
                                style="fill:#263238"></path>
                            <path
                                d="M292.54,258.27l-31.32,14.66a3.51,3.51,0,0,1-4.68-1.69h0a3.52,3.52,0,0,1,1.7-4.68l31.31-14.67a3.52,3.52,0,0,1,4.68,1.7h0A3.51,3.51,0,0,1,292.54,258.27Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M292.54,258.27s.29-.15.74-.55a3.43,3.43,0,0,0-.65-5.62,3.38,3.38,0,0,0-2.44-.26,8.18,8.18,0,0,0-1.29.55l-1.37.65-29.18,13.75a3.27,3.27,0,0,0,1.09,6.21,3.51,3.51,0,0,0,2-.44l2-.92,3.8-1.77,13.16-6.1,8.89-4.07,2.43-1.09.63-.27c.15-.06.22-.08.23-.07l-.21.12-.61.32-2.39,1.17-8.82,4.22-13.11,6.2-3.8,1.79-2,.92a4,4,0,0,1-2.25.49,3.87,3.87,0,0,1-2.17-.94,3.78,3.78,0,0,1,.91-6.24l29.25-13.61,1.37-.64a9.32,9.32,0,0,1,1.35-.55,3.65,3.65,0,0,1,4.54,4,3.52,3.52,0,0,1-1.29,2.31A2.7,2.7,0,0,1,292.54,258.27Z"
                                style="fill:#263238"></path>
                            <path
                                d="M233.93,287.23,202.62,301.9a3.52,3.52,0,0,1-4.68-1.7h0a3.51,3.51,0,0,1,1.69-4.68L231,280.86a3.51,3.51,0,0,1,4.68,1.69h0A3.52,3.52,0,0,1,233.93,287.23Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M233.93,287.23a7.75,7.75,0,0,0,.74-.54,3.43,3.43,0,0,0,1.16-2.26,3.4,3.4,0,0,0-4.25-3.63,9.23,9.23,0,0,0-1.29.55l-1.36.65-29.19,13.76a3.26,3.26,0,0,0,1.09,6.2,3.48,3.48,0,0,0,2-.44l2-.91,3.8-1.77,13.16-6.1,8.89-4.08,2.43-1.08.64-.27.22-.08a.82.82,0,0,1-.2.13l-.62.31-2.38,1.17-8.83,4.23-13.11,6.2L205,301.05l-2,.92a4,4,0,0,1-2.26.49,3.79,3.79,0,0,1-2.17-.93,3.9,3.9,0,0,1-1.19-2.1,3.79,3.79,0,0,1,2.1-4.14l29.25-13.62,1.38-.63a8.88,8.88,0,0,1,1.35-.55,3.7,3.7,0,0,1,2.66.32,3.63,3.63,0,0,1,1.87,3.64,3.48,3.48,0,0,1-1.29,2.32A2.5,2.5,0,0,1,233.93,287.23Z"
                                style="fill:#263238"></path>
                            <path
                                d="M175.48,314.73l-31.31,14.66a3.51,3.51,0,0,1-4.68-1.69h0a3.51,3.51,0,0,1,1.69-4.68l31.32-14.67a3.53,3.53,0,0,1,4.68,1.7h0A3.53,3.53,0,0,1,175.48,314.73Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M175.48,314.73s.29-.15.75-.54a3.5,3.5,0,0,0,1.16-2.26,3.41,3.41,0,0,0-1.82-3.37,3.36,3.36,0,0,0-2.43-.26,7.8,7.8,0,0,0-1.29.55l-1.37.65-29.19,13.75a3.27,3.27,0,0,0,1.09,6.21,3.54,3.54,0,0,0,2-.44l2-.91,3.8-1.77,13.16-6.11,8.89-4.07,2.43-1.09.64-.27.22-.07s-.06,0-.2.12l-.61.32-2.39,1.17-8.82,4.22-13.12,6.2-3.79,1.79-2,.92a4,4,0,0,1-2.25.49,3.77,3.77,0,0,1-1.26-7.17l29.25-13.62,1.37-.63a8,8,0,0,1,1.35-.56,3.7,3.7,0,0,1,2.66.33,3.61,3.61,0,0,1,1.87,3.64,3.45,3.45,0,0,1-1.29,2.32A2.5,2.5,0,0,1,175.48,314.73Z"
                                style="fill:#263238"></path>
                            <path
                                d="M282.94,273.23a13.34,13.34,0,0,0-18.58-3.13l-25.43,18.08-3.32-4.67L261,265.42a19.09,19.09,0,0,1,26.57,4.49"
                                style="fill:currentColor"></path>
                            <g style="opacity:0.4">
                                <path
                                    d="M282.94,273.23a13.34,13.34,0,0,0-18.58-3.13l-25.43,18.08-3.32-4.67L261,265.42a19.09,19.09,0,0,1,26.57,4.49">
                                </path>
                            </g>
                            <rect x="228.06" y="274.86" width="32.95" height="51.36" rx="5.73"
                                transform="translate(-128.91 197.3) rotate(-35.41)" style="fill:currentColor"></rect>
                            <path
                                d="M242.67,326.35a10.53,10.53,0,0,0,1.14,1.12,5.74,5.74,0,0,0,4.29,1.13,6.31,6.31,0,0,0,1.5-.43,8.55,8.55,0,0,0,1.46-.91l3.23-2.32,7.88-5.65,4.58-3.28a12.2,12.2,0,0,0,2.29-1.85,5.45,5.45,0,0,0,1.25-2.68,5.58,5.58,0,0,0-.36-3,18.76,18.76,0,0,0-1.78-2.74c-1.31-1.83-2.66-3.71-4-5.64L246.2,274.89a5.58,5.58,0,0,0-3.17-2.15,5.43,5.43,0,0,0-3.74.42,13.61,13.61,0,0,0-1.64,1.08L236,275.38l-3.19,2.27-12.13,8.63a5.51,5.51,0,0,0-1.71,6,11.75,11.75,0,0,0,1.69,2.78l1.86,2.63c2.44,3.44,4.71,6.66,6.78,9.59l9.79,13.91,2.65,3.8.67,1a1.86,1.86,0,0,1,.22.35,2.77,2.77,0,0,1-.26-.32l-.72-1L239,321.32l-9.92-13.82-6.84-9.56-1.87-2.62c-.32-.44-.63-.89-1-1.34a6.06,6.06,0,0,1-.79-1.54,6,6,0,0,1,1.83-6.53c3.87-2.81,7.93-5.66,12.14-8.67l3.19-2.27,1.61-1.15a13.11,13.11,0,0,1,1.7-1.11,6,6,0,0,1,4.09-.47,6,6,0,0,1,3.46,2.35C253,283.52,259,292,264.5,299.78l4,5.66,1,1.37a7.37,7.37,0,0,1,.86,1.46,6,6,0,0,1-1,6.16,12.33,12.33,0,0,1-2.38,1.9l-4.6,3.25-7.92,5.59-3.25,2.29a9.26,9.26,0,0,1-1.52.91,6.29,6.29,0,0,1-1.56.43,5.83,5.83,0,0,1-4.39-1.25A4.73,4.73,0,0,1,242.67,326.35Z"
                                style="fill:#263238"></path>
                            <g style="opacity:0.5">
                                <path
                                    d="M250.52,301.55a4.29,4.29,0,1,0-6.51-2.07l-5.24,3.72,1.36,1.91,5.23-3.72A4.27,4.27,0,0,0,250.52,301.55Z">
                                </path>
                            </g>
                            <path
                                d="M220.36,289.58c-.07-.1,4.36-3.36,9.88-7.29s10.06-7,10.13-6.93-4.36,3.35-9.88,7.28S220.43,289.68,220.36,289.58Z"
                                style="fill:#fafafa"></path>
                            <path
                                d="M241.6,298.5a1.46,1.46,0,0,1-.06-.57,5.14,5.14,0,0,1,.28-1.56,6,6,0,0,1,8.6-3.49,5.37,5.37,0,0,1,1.28.92c.26.27.38.44.36.46a12.72,12.72,0,0,0-1.78-1.11,6,6,0,0,0-8.18,3.32A13,13,0,0,0,241.6,298.5Z"
                                style="fill:#fafafa"></path>
                            <path
                                d="M308,413.15l6.4,18.73a13.26,13.26,0,0,0,16.82,8.25h0a13.25,13.25,0,0,0,8.25-16.83L333,404.25a13.25,13.25,0,0,0-18.22-7.68A13.46,13.46,0,0,0,308,413.15Zm11.12-11.65a7.22,7.22,0,0,1,8,4.88l6.31,18.44a7.25,7.25,0,0,1-3.5,8.89,7.08,7.08,0,0,1-9.79-4.06l-6.46-18.91A7.07,7.07,0,0,1,319.15,401.5Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M321.17,401.43l-2.27-6.05a12.63,12.63,0,0,1,2.1-.08l2,6.57S321.59,401.22,321.17,401.43Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M314.24,405l-4.36-4.43a27.35,27.35,0,0,1,2.61-2.59l2.33,6.21Z" style="fill:#e0e0e0">
                            </path>
                            <path
                                d="M308,413.15l6.4,18.73a13.26,13.26,0,0,0,16.82,8.25h0a13.25,13.25,0,0,0,8.25-16.83L333,404.25a13.25,13.25,0,0,0-18.22-7.68A13.46,13.46,0,0,0,308,413.15Zm11.12-11.65a7.22,7.22,0,0,1,8,4.88l6.31,18.44a7.25,7.25,0,0,1-3.5,8.89,7.08,7.08,0,0,1-9.79-4.06l-6.46-18.91A7.07,7.07,0,0,1,319.15,401.5Z"
                                style="fill:none"></path>
                            <path
                                d="M319.15,401.5a9,9,0,0,0-2.94,1.41,6.93,6.93,0,0,0-2.23,3,7,7,0,0,0,0,4.92c1.26,3.61,2.74,7.89,4.39,12.65l1.26,3.66a23.64,23.64,0,0,0,1.44,3.7,6.85,6.85,0,0,0,7,3.18,6.6,6.6,0,0,0,3.61-1.89,6.88,6.88,0,0,0,1.83-3.53c.59-2.66-.85-5.12-1.54-7.52-1.61-4.76-3.06-9.06-4.28-12.69-.31-.89-.57-1.78-.88-2.55a7.28,7.28,0,0,0-1.27-2,7.13,7.13,0,0,0-3.15-2.08,6.48,6.48,0,0,0-2.38-.34,7.8,7.8,0,0,1-.86,0,.53.53,0,0,1,.21-.05,4.58,4.58,0,0,1,.64-.1,6.27,6.27,0,0,1,2.45.26,7.14,7.14,0,0,1,3.3,2.08,7.31,7.31,0,0,1,1.36,2.06c.34.81.6,1.66.92,2.57,1.26,3.61,2.74,7.9,4.39,12.65l1.26,3.66a8,8,0,0,1,.32,4.1,7.39,7.39,0,0,1-1.95,3.8,7.07,7.07,0,0,1-3.89,2,7.33,7.33,0,0,1-7.53-3.42,9.37,9.37,0,0,1-.83-1.91c-.22-.64-.43-1.27-.65-1.9-.42-1.24-.83-2.47-1.24-3.66-1.61-4.77-3.06-9.06-4.28-12.69a7.18,7.18,0,0,1,2.46-8.23,7.37,7.37,0,0,1,2.22-1.09c.27-.07.48-.1.63-.13Z"
                                style="fill:#263238"></path>
                            <path
                                d="M308,413.15a1.17,1.17,0,0,1-.12-.3l-.28-.89a14,14,0,0,1-.44-3.58,13.48,13.48,0,0,1,1.24-5.56,12.59,12.59,0,0,1,1.9-3,12.45,12.45,0,0,1,3-2.65,14.64,14.64,0,0,1,4.08-1.71,13.89,13.89,0,0,1,4.79-.22,13.45,13.45,0,0,1,9,5.2l.8,1.18.67,1.26c.18.45.36.9.55,1.35s.31.9.46,1.36l1.92,5.59q2,5.72,4,11.77a13.48,13.48,0,0,1-24.27,11.48,22.16,22.16,0,0,1-1.67-4.09c-1.76-5.27-3.19-9.54-4.2-12.54-.47-1.46-.85-2.6-1.11-3.41l-.28-.9a1.31,1.31,0,0,1-.08-.31,1.79,1.79,0,0,1,.13.3l.32.87c.29.81.7,1.94,1.21,3.39l4.36,12.49a22,22,0,0,0,1.66,4,13,13,0,0,0,23.45-11.11l-4-11.77q-1-2.85-1.91-5.6l-.46-1.36c-.18-.44-.35-.87-.52-1.3s-.44-.82-.65-1.23l-.76-1.13a13.05,13.05,0,0,0-8.67-5.07,13.29,13.29,0,0,0-4.64.19,14,14,0,0,0-4,1.63,12,12,0,0,0-3,2.55,12.2,12.2,0,0,0-1.89,2.94,13.58,13.58,0,0,0-1.3,5.45A16.28,16.28,0,0,0,308,413.15Z"
                                style="fill:#263238"></path>
                            <path
                                d="M325.1,433.81l11.19,32a3.45,3.45,0,0,0,4.39,2.12h0a3.45,3.45,0,0,0,2.12-4.39l-11.19-32a3.45,3.45,0,0,0-4.4-2.12h0A3.46,3.46,0,0,0,325.1,433.81Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M325.1,433.81a2.36,2.36,0,0,1-.24-.88,3.47,3.47,0,0,1,.74-2.5,3.57,3.57,0,0,1,5.89.46,7.27,7.27,0,0,1,.54,1.33c.17.45.33.92.5,1.39,2.7,7.68,6.42,18.21,10.51,29.84a3.7,3.7,0,0,1-5.9,4,3.92,3.92,0,0,1-1.2-1.92c-.24-.67-.47-1.34-.7-2l-1.35-3.89c-1.74-5.05-3.31-9.6-4.64-13.44s-2.34-6.89-3.09-9.08l-.81-2.48-.2-.64a.82.82,0,0,1,0-.23.93.93,0,0,1,.1.21l.25.63.9,2.45c.78,2.17,1.89,5.24,3.24,9s3,8.37,4.75,13.41c.44,1.26.9,2.55,1.37,3.87l.7,2a3.48,3.48,0,0,0,1.06,1.7,3.2,3.2,0,0,0,5.09-3.49l-10.37-29.89c-.17-.48-.33-.94-.48-1.4a9,9,0,0,0-.5-1.28,3.32,3.32,0,0,0-5.45-.49,3.36,3.36,0,0,0-.79,2.36A8.43,8.43,0,0,0,325.1,433.81Z"
                                style="fill:#263238"></path>
                            <path
                                d="M243.66,232.33l6.51,19A13.25,13.25,0,0,0,267,259.63h0a13.26,13.26,0,0,0,8.25-16.82l-6.52-19.05a13.25,13.25,0,0,0-25.07,8.57Zm10.22-11.05a7.05,7.05,0,0,1,9,4.4l6.47,18.9A7.06,7.06,0,1,1,256,249.15l-6.47-18.9A7.07,7.07,0,0,1,253.88,221.28Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M256.91,220.94l-2.26-6.05a12.47,12.47,0,0,1,2.09-.08l2,6.57S257.34,220.73,256.91,220.94Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M250,224.47,245.62,220a25.48,25.48,0,0,1,2.62-2.59l2.32,6.21Z" style="fill:#e0e0e0">
                            </path>
                            <path
                                d="M243.66,232.33l6.51,19A13.25,13.25,0,0,0,267,259.63h0a13.26,13.26,0,0,0,8.25-16.82l-6.52-19.05a13.25,13.25,0,0,0-25.07,8.57Zm10.22-11.05a7.05,7.05,0,0,1,9,4.4l6.47,18.9A7.06,7.06,0,1,1,256,249.15l-6.47-18.9A7.07,7.07,0,0,1,253.88,221.28Z"
                                style="fill:none"></path>
                            <path
                                d="M253.88,221.28a8.43,8.43,0,0,0-2.7,1.83,7,7,0,0,0-1.76,3.33,6.6,6.6,0,0,0-.1,2.36,12.52,12.52,0,0,0,.74,2.58c1.25,3.62,2.74,7.91,4.39,12.66l1.26,3.67c.22.61.42,1.27.67,1.86a6.72,6.72,0,0,0,1,1.67,6.81,6.81,0,0,0,12-4.11,6.38,6.38,0,0,0-.2-1.95c-.16-.62-.41-1.26-.61-1.89-.43-1.25-.84-2.47-1.25-3.67l-4.28-12.7a13.89,13.89,0,0,0-1-2.49,7.17,7.17,0,0,0-1.53-1.8,6.91,6.91,0,0,0-3.44-1.56,8.26,8.26,0,0,0-3.25.21l.2-.09a6.24,6.24,0,0,1,.62-.19,6.92,6.92,0,0,1,2.46-.13,7.09,7.09,0,0,1,3.59,1.54,7.19,7.19,0,0,1,1.63,1.85,14.19,14.19,0,0,1,1.05,2.55c1.25,3.62,2.74,7.9,4.39,12.66l1.26,3.66c.21.64.45,1.24.63,1.92a7.3,7.3,0,0,1-9.11,8.85,7.32,7.32,0,0,1-3.57-2.34,7.42,7.42,0,0,1-1.11-1.79c-.27-.66-.45-1.28-.67-1.91L254,244.2l-4.28-12.7a12.72,12.72,0,0,1-.73-2.66,7.19,7.19,0,0,1,2-5.87,6.85,6.85,0,0,1,2-1.41,5.18,5.18,0,0,1,.6-.23Z"
                                style="fill:#263238"></path>
                            <path
                                d="M243.66,232.33a1.2,1.2,0,0,1-.11-.3c-.08-.23-.17-.52-.29-.89a12.81,12.81,0,0,1-.39-3.59,13.23,13.23,0,0,1,1.37-5.53,14.14,14.14,0,0,1,2-3,14.35,14.35,0,0,1,3.1-2.56,13.45,13.45,0,0,1,17.79,3.68,13.93,13.93,0,0,1,1.4,2.47c.38.9.68,1.8,1,2.72q.93,2.74,1.92,5.59,1.95,5.72,4,11.77a13.89,13.89,0,0,1,.57,6.35A13.47,13.47,0,0,1,254,257.33a13.3,13.3,0,0,1-3-3.73,22.94,22.94,0,0,1-1.62-4.1c-1.77-5.27-3.2-9.55-4.21-12.55-.47-1.46-.85-2.6-1.11-3.42l-.28-.89a1.46,1.46,0,0,1-.08-.31,1.88,1.88,0,0,1,.13.29l.32.88c.29.81.7,1.94,1.21,3.39l4.36,12.49a24.42,24.42,0,0,0,1.62,4,13,13,0,0,0,22.05,1.12,12.89,12.89,0,0,0,2.2-5.53,13.12,13.12,0,0,0-.55-6.11c-1.38-4-2.72-8-4-11.77-.65-1.91-1.28-3.77-1.91-5.6-.31-.92-.61-1.83-1-2.68a13.72,13.72,0,0,0-1.35-2.4,13.09,13.09,0,0,0-8.54-5.27,13.23,13.23,0,0,0-8.68,1.63,13.11,13.11,0,0,0-5,5.35,13.23,13.23,0,0,0-1.43,5.41A15.3,15.3,0,0,0,243.66,232.33Z"
                                style="fill:#263238"></path>
                            <path
                                d="M222.46,171.84l6.51,19a13.24,13.24,0,0,0,16.82,8.25h0A13.24,13.24,0,0,0,254,182.32l-6.51-19a13.25,13.25,0,0,0-25.07,8.57Zm10.22-11.05a7.05,7.05,0,0,1,9,4.4l6.46,18.9a7.06,7.06,0,1,1-13.36,4.57l-6.47-18.9A7.07,7.07,0,0,1,232.68,160.79Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M235.71,160.45l-2.27-6a12.63,12.63,0,0,1,2.1-.08l2,6.57S236.13,160.24,235.71,160.45Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M228.79,164l-4.37-4.43A26.2,26.2,0,0,1,227,157l2.33,6.21Z" style="fill:#e0e0e0"></path>
                            <path
                                d="M222.46,171.84l6.51,19a13.24,13.24,0,0,0,16.82,8.25h0A13.24,13.24,0,0,0,254,182.32l-6.51-19a13.25,13.25,0,0,0-25.07,8.57Zm10.22-11.05a7.05,7.05,0,0,1,9,4.4l6.46,18.9a7.06,7.06,0,1,1-13.36,4.57l-6.47-18.9A7.07,7.07,0,0,1,232.68,160.79Z"
                                style="fill:none"></path>
                            <path
                                d="M232.68,160.79a8.43,8.43,0,0,0-2.7,1.83,7,7,0,0,0-1.87,5.69,13.23,13.23,0,0,0,.75,2.58c1.25,3.62,2.74,7.91,4.39,12.66l1.26,3.67c.22.61.42,1.27.67,1.86a6.72,6.72,0,0,0,1,1.67,6.81,6.81,0,0,0,12-4.11,6.7,6.7,0,0,0-.2-1.95c-.16-.62-.41-1.26-.62-1.89-.42-1.25-.84-2.47-1.24-3.67-1.61-4.77-3.06-9.07-4.29-12.7a12.55,12.55,0,0,0-1-2.49,7,7,0,0,0-5-3.36,8.26,8.26,0,0,0-3.25.21s.06,0,.2-.09.34-.13.61-.19a7,7,0,0,1,2.47-.13,7.09,7.09,0,0,1,3.59,1.54,7.19,7.19,0,0,1,1.63,1.85,14.19,14.19,0,0,1,1,2.55c1.25,3.62,2.74,7.9,4.39,12.66l1.26,3.67c.21.63.45,1.23.63,1.91a7.05,7.05,0,0,1,.22,2.1,7.26,7.26,0,0,1-1.39,4,7.31,7.31,0,0,1-11.52.38,7.7,7.7,0,0,1-1.1-1.79c-.27-.65-.45-1.28-.67-1.9-.43-1.25-.84-2.48-1.25-3.67-1.61-4.77-3.06-9.07-4.29-12.7a13.32,13.32,0,0,1-.72-2.66,7.22,7.22,0,0,1,2-5.87,7,7,0,0,1,2-1.41,5.18,5.18,0,0,1,.6-.23Z"
                                style="fill:#263238"></path>
                            <path
                                d="M222.46,171.84a1.44,1.44,0,0,1-.12-.3c-.07-.23-.16-.52-.28-.89a13.13,13.13,0,0,1-.4-3.59,13.41,13.41,0,0,1,1.38-5.53,14.14,14.14,0,0,1,2-3,14.35,14.35,0,0,1,3.1-2.56,13.45,13.45,0,0,1,17.79,3.68,14.58,14.58,0,0,1,1.4,2.47c.38.9.68,1.8,1,2.72l1.92,5.59q2,5.72,4,11.77a13.9,13.9,0,0,1,.57,6.35,13.46,13.46,0,0,1-25.11,4.53,23.65,23.65,0,0,1-1.61-4.1c-1.77-5.27-3.2-9.55-4.21-12.55-.47-1.46-.85-2.6-1.12-3.42l-.27-.89a1.46,1.46,0,0,1-.08-.31,1.88,1.88,0,0,1,.13.29l.32.88c.29.81.7,1.94,1.21,3.39l4.36,12.49a24.42,24.42,0,0,0,1.62,4,12.87,12.87,0,0,0,3,3.59,13,13,0,0,0,21.29-8,13.27,13.27,0,0,0-.55-6.11c-1.38-4-2.72-8-4-11.77-.65-1.91-1.29-3.77-1.91-5.6-.31-.92-.61-1.83-1-2.68a13.72,13.72,0,0,0-1.35-2.4,13.07,13.07,0,0,0-17.22-3.64,14.44,14.44,0,0,0-3,2.47,14.81,14.81,0,0,0-2,2.88,13.4,13.4,0,0,0-1.43,5.41A15.37,15.37,0,0,0,222.46,171.84Z"
                                style="fill:#263238"></path>
                            <path
                                d="M203.57,117.82l6.51,19.06a13.26,13.26,0,0,0,16.83,8.25h0a13.25,13.25,0,0,0,8.24-16.83l-6.51-19.05a13.25,13.25,0,0,0-25.07,8.57Zm10.22-11a7.07,7.07,0,0,1,9,4.4l6.47,18.91a7.06,7.06,0,1,1-13.37,4.57l-6.47-18.91A7.07,7.07,0,0,1,213.79,106.77Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M216.82,106.43l-2.27-6.05a12.63,12.63,0,0,1,2.1-.08l2,6.58S217.25,106.22,216.82,106.43Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M209.9,110l-4.37-4.42a27.16,27.16,0,0,1,2.61-2.6l2.33,6.22Z" style="fill:#e0e0e0"></path>
                            <path
                                d="M203.57,117.82l6.51,19.06a13.26,13.26,0,0,0,16.83,8.25h0a13.25,13.25,0,0,0,8.24-16.83l-6.51-19.05a13.25,13.25,0,0,0-25.07,8.57Zm10.22-11a7.07,7.07,0,0,1,9,4.4l6.47,18.91a7.06,7.06,0,1,1-13.37,4.57l-6.47-18.91A7.07,7.07,0,0,1,213.79,106.77Z"
                                style="fill:none"></path>
                            <path
                                d="M213.79,106.77a8.43,8.43,0,0,0-2.7,1.83,6.93,6.93,0,0,0-1.76,3.34,6.58,6.58,0,0,0-.1,2.36,12.61,12.61,0,0,0,.74,2.57c1.25,3.62,2.74,7.91,4.39,12.67l1.26,3.66c.22.62.42,1.28.67,1.86a6.72,6.72,0,0,0,1,1.67,6.81,6.81,0,0,0,12-4.11,6.7,6.7,0,0,0-.2-2c-.16-.62-.41-1.26-.61-1.88-.43-1.25-.84-2.48-1.25-3.67-1.61-4.77-3.06-9.07-4.29-12.7a13.29,13.29,0,0,0-1-2.5,7.35,7.35,0,0,0-1.53-1.8,7,7,0,0,0-3.44-1.56,8.77,8.77,0,0,0-3.25.21s.06,0,.2-.08a4.35,4.35,0,0,1,.62-.19,6.69,6.69,0,0,1,2.46-.13,7.07,7.07,0,0,1,3.59,1.53,7.24,7.24,0,0,1,1.63,1.86,13.8,13.8,0,0,1,1.05,2.54c1.25,3.62,2.74,7.91,4.39,12.67l1.26,3.66c.21.63.45,1.23.63,1.92a7.29,7.29,0,0,1,.23,2.09,7.3,7.3,0,0,1-9.34,6.75,7.31,7.31,0,0,1-4.68-4.13c-.27-.65-.45-1.27-.67-1.9-.43-1.25-.84-2.48-1.25-3.67L209.63,117a12.81,12.81,0,0,1-.73-2.65,7.15,7.15,0,0,1,.15-2.47,7.06,7.06,0,0,1,1.9-3.41,6.85,6.85,0,0,1,2-1.41,4.78,4.78,0,0,1,.6-.22Z"
                                style="fill:#263238"></path>
                            <path
                                d="M203.57,117.82s0-.09-.11-.29-.17-.53-.29-.9a12.78,12.78,0,0,1-.39-3.58,13.23,13.23,0,0,1,1.37-5.54,14.09,14.09,0,0,1,2-3,14.38,14.38,0,0,1,3.1-2.57,13.45,13.45,0,0,1,17.79,3.68,14,14,0,0,1,1.4,2.48c.38.89.68,1.8,1,2.71q.93,2.75,1.92,5.6l4,11.77a13.89,13.89,0,0,1,.57,6.35,13.47,13.47,0,0,1-25.11,4.53,24.05,24.05,0,0,1-1.61-4.11c-1.77-5.27-3.2-9.55-4.21-12.54-.47-1.46-.85-2.61-1.12-3.42l-.27-.9a1.31,1.31,0,0,1-.08-.31,1.79,1.79,0,0,1,.13.3l.32.87c.29.81.7,2,1.21,3.39l4.36,12.5a24.78,24.78,0,0,0,1.62,4,13,13,0,0,0,24.25-4.42,13.27,13.27,0,0,0-.55-6.11c-1.38-4-2.72-8-4-11.77q-1-2.85-1.91-5.6c-.31-.92-.61-1.83-1-2.68a13.63,13.63,0,0,0-1.35-2.39,13.07,13.07,0,0,0-8.54-5.28,13.29,13.29,0,0,0-8.68,1.63,13.11,13.11,0,0,0-5,5.35,13.08,13.08,0,0,0-1.43,5.41A15.14,15.14,0,0,0,203.57,117.82Z"
                                style="fill:#263238"></path>
                            <path
                                d="M199.31,79.34l11.88,31.75a3.46,3.46,0,0,0,4.45,2h0a3.45,3.45,0,0,0,2-4.44L205.77,76.92a3.45,3.45,0,0,0-4.44-2h0A3.46,3.46,0,0,0,199.31,79.34Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M199.31,79.34a2.46,2.46,0,0,1-.25-.88,3.41,3.41,0,0,1,.68-2.51,3.57,3.57,0,0,1,5.9.33,8,8,0,0,1,.57,1.31l.53,1.39,11.16,29.6a3.73,3.73,0,0,1-1.37,4.35,3.78,3.78,0,0,1-2.27.65,3.69,3.69,0,0,1-2.17-.84,3.89,3.89,0,0,1-1.25-1.89c-.25-.67-.5-1.33-.74-2-.49-1.31-1-2.59-1.43-3.85-1.86-5-3.53-9.53-4.94-13.34l-3.28-9c-.37-1-.66-1.85-.87-2.45l-.22-.65a.73.73,0,0,1-.05-.22s0,.06.1.2l.27.63.95,2.42,3.44,9,5,13.3c.47,1.26.95,2.54,1.45,3.85.25.66.49,1.32.75,2a3.4,3.4,0,0,0,1.09,1.67,3.2,3.2,0,0,0,5-3.59c-4.3-11.56-8.19-22-11-29.66-.18-.47-.35-.93-.51-1.39a9.32,9.32,0,0,0-.53-1.27,3.33,3.33,0,0,0-5.46-.37,3.4,3.4,0,0,0-.74,2.38C199.21,79,199.34,79.33,199.31,79.34Z"
                                style="fill:#263238"></path>
                            <path
                                d="M239.4,193.84l11.88,31.75a3.47,3.47,0,0,0,4.45,2h0a3.46,3.46,0,0,0,2-4.45l-11.89-31.75a3.45,3.45,0,0,0-4.44-2h0A3.45,3.45,0,0,0,239.4,193.84Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M239.4,193.84a2.46,2.46,0,0,1-.25-.88,3.43,3.43,0,0,1,.68-2.51,3.58,3.58,0,0,1,5.9.33,8.48,8.48,0,0,1,.57,1.32l.53,1.38L258,223.08a3.72,3.72,0,0,1-3.64,5,3.76,3.76,0,0,1-2.17-.84,3.94,3.94,0,0,1-1.25-1.89c-.25-.67-.5-1.33-.74-2-.49-1.31-1-2.6-1.43-3.85l-4.94-13.34-3.28-9-.87-2.46c-.09-.26-.16-.47-.21-.64a.7.7,0,0,1-.06-.23.93.93,0,0,1,.1.21c.08.17.16.37.27.62q.34.9,1,2.43c.82,2.16,2,5.2,3.43,9s3.15,8.3,5,13.3l1.45,3.85.75,2a3.47,3.47,0,0,0,1.09,1.67,3.2,3.2,0,0,0,5-3.6c-4.3-11.56-8.19-22-11-29.65l-.51-1.39a9.32,9.32,0,0,0-.53-1.27,3.28,3.28,0,0,0-1.89-1.49,3.34,3.34,0,0,0-3.57,1.12,3.37,3.37,0,0,0-.74,2.37C239.3,193.54,239.43,193.83,239.4,193.84Z"
                                style="fill:#263238"></path>
                            <path
                                d="M287,351.07l6.4,18.73a13.26,13.26,0,0,0,16.82,8.25h0a13.25,13.25,0,0,0,8.25-16.83l-6.51-19.05a13.25,13.25,0,0,0-18.22-7.68A13.46,13.46,0,0,0,287,351.07Zm11.12-11.65a7.23,7.23,0,0,1,8,4.88l6.31,18.44a7.24,7.24,0,0,1-3.5,8.89,7.08,7.08,0,0,1-9.79-4.06l-6.46-18.91A7.07,7.07,0,0,1,298.09,339.42Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M300.11,339.35l-2.27-6.05a12.63,12.63,0,0,1,2.1-.08l2,6.57S300.53,339.14,300.11,339.35Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M293.19,342.88l-4.37-4.42a27.16,27.16,0,0,1,2.61-2.6l2.33,6.21Z" style="fill:#e0e0e0">
                            </path>
                            <path
                                d="M287,351.07l6.4,18.73a13.26,13.26,0,0,0,16.82,8.25h0a13.25,13.25,0,0,0,8.25-16.83l-6.51-19.05a13.25,13.25,0,0,0-18.22-7.68A13.46,13.46,0,0,0,287,351.07Zm11.12-11.65a7.23,7.23,0,0,1,8,4.88l6.31,18.44a7.24,7.24,0,0,1-3.5,8.89,7.08,7.08,0,0,1-9.79-4.06l-6.46-18.91A7.07,7.07,0,0,1,298.09,339.42Z"
                                style="fill:none"></path>
                            <path
                                d="M298.09,339.42a8.88,8.88,0,0,0-2.93,1.41,7,7,0,0,0-2.24,3,7,7,0,0,0,0,4.92c1.26,3.61,2.74,7.9,4.39,12.65l1.26,3.66a23.64,23.64,0,0,0,1.44,3.7,6.85,6.85,0,0,0,7,3.18,6.54,6.54,0,0,0,3.61-1.89,6.88,6.88,0,0,0,1.83-3.53c.59-2.66-.85-5.12-1.54-7.52-1.61-4.76-3.06-9.06-4.28-12.69-.31-.89-.57-1.78-.88-2.55a7.28,7.28,0,0,0-1.27-2,7.16,7.16,0,0,0-3.14-2.08,6.53,6.53,0,0,0-2.39-.34,7.8,7.8,0,0,1-.86,0l.22-.05a4.16,4.16,0,0,1,.63-.1,6.27,6.27,0,0,1,2.45.26,7.14,7.14,0,0,1,3.3,2.08,7.31,7.31,0,0,1,1.36,2.06c.34.81.6,1.66.92,2.57,1.26,3.61,2.74,7.9,4.39,12.65l1.26,3.66a8,8,0,0,1,.33,4.1,7.49,7.49,0,0,1-2,3.8,7.07,7.07,0,0,1-3.89,2,7.33,7.33,0,0,1-7.53-3.42,9.37,9.37,0,0,1-.83-1.91c-.22-.64-.43-1.27-.65-1.89-.42-1.25-.83-2.48-1.24-3.67-1.61-4.76-3.06-9.06-4.28-12.69a7.22,7.22,0,0,1,.09-5.14,7.13,7.13,0,0,1,2.37-3.09,7.37,7.37,0,0,1,2.22-1.09c.27-.07.49-.1.63-.13Z"
                                style="fill:#263238"></path>
                            <path
                                d="M287,351.07s-.05-.09-.12-.29-.16-.53-.28-.9a14.47,14.47,0,0,1-.44-3.58,13.64,13.64,0,0,1,1.24-5.56,12.59,12.59,0,0,1,1.9-3,12.45,12.45,0,0,1,3-2.65,14.64,14.64,0,0,1,4.08-1.71,13.89,13.89,0,0,1,4.79-.22,13.45,13.45,0,0,1,9,5.2l.8,1.18.67,1.26c.18.45.36.9.55,1.35s.31.9.46,1.36l1.92,5.6c1.31,3.8,2.65,7.73,4,11.76a13.48,13.48,0,0,1-24.27,11.48,21.42,21.42,0,0,1-1.66-4.09l-4.21-12.54c-.47-1.46-.85-2.6-1.11-3.41-.12-.37-.21-.67-.28-.9a1.31,1.31,0,0,1-.08-.31,1.79,1.79,0,0,1,.13.3l.32.87c.29.81.7,1.94,1.21,3.39L293,368.12a22,22,0,0,0,1.66,4A13,13,0,0,0,318.1,361c-1.38-4-2.72-8-4-11.77q-1-2.85-1.91-5.6c-.15-.46-.31-.91-.46-1.36s-.35-.87-.52-1.3-.44-.82-.65-1.23l-.76-1.13a13,13,0,0,0-8.67-5.07,13.54,13.54,0,0,0-4.64.19,14,14,0,0,0-4,1.63,12,12,0,0,0-3,2.55,12.51,12.51,0,0,0-1.89,2.94,13.58,13.58,0,0,0-1.3,5.45A16.28,16.28,0,0,0,287,351.07Z"
                                style="fill:#263238"></path>
                            <path
                                d="M302.83,370.14l11.19,32a3.46,3.46,0,0,0,4.4,2.11h0a3.44,3.44,0,0,0,2.12-4.39l-11.19-32a3.46,3.46,0,0,0-4.4-2.12h0A3.45,3.45,0,0,0,302.83,370.14Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M302.83,370.14a2.51,2.51,0,0,1-.23-.88,3.43,3.43,0,0,1,.74-2.5,3.57,3.57,0,0,1,5.89.46,8.06,8.06,0,0,1,.54,1.33l.5,1.39c2.7,7.68,6.41,18.21,10.51,29.84A3.71,3.71,0,0,1,317,404.7a3.75,3.75,0,0,1-2.15-.88,3.92,3.92,0,0,1-1.2-1.92c-.24-.67-.47-1.34-.7-2L311.63,396c-1.75-5.05-3.32-9.6-4.64-13.44s-2.35-6.89-3.09-9.08c-.34-1-.62-1.87-.82-2.47-.08-.26-.14-.48-.2-.65a.82.82,0,0,1-.05-.23.93.93,0,0,1,.1.21l.25.63.91,2.45,3.24,9c1.36,3.83,3,8.37,4.75,13.41.44,1.26.9,2.55,1.36,3.88.23.66.47,1.32.71,2a3.41,3.41,0,0,0,1.06,1.7A3.2,3.2,0,0,0,320.3,400c-4.05-11.65-7.71-22.2-10.38-29.89l-.48-1.4a8.32,8.32,0,0,0-.49-1.28,3.37,3.37,0,0,0-1.86-1.53,3.33,3.33,0,0,0-3.6,1,3.43,3.43,0,0,0-.79,2.36C302.74,369.84,302.86,370.13,302.83,370.14Z"
                                style="fill:#263238"></path>
                            <path
                                d="M265.65,290.25l6.52,19.06A13.26,13.26,0,0,0,289,317.56h0a13.25,13.25,0,0,0,8.25-16.83l-6.51-19.05a13.25,13.25,0,0,0-25.08,8.57Zm10.23-11.05a7.07,7.07,0,0,1,9,4.4l6.46,18.91a7.06,7.06,0,1,1-13.37,4.57l-6.46-18.91A7.06,7.06,0,0,1,275.88,279.2Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M278.91,278.86l-2.27-6.05a12.63,12.63,0,0,1,2.1-.08l2,6.58S279.33,278.65,278.91,278.86Z"
                                style="fill:#e0e0e0"></path>
                            <path d="M272,282.39,267.62,278a27.16,27.16,0,0,1,2.61-2.6l2.33,6.22Z" style="fill:#e0e0e0"></path>
                            <path
                                d="M265.65,290.25l6.52,19.06A13.26,13.26,0,0,0,289,317.56h0a13.25,13.25,0,0,0,8.25-16.83l-6.51-19.05a13.25,13.25,0,0,0-25.08,8.57Zm10.23-11.05a7.07,7.07,0,0,1,9,4.4l6.46,18.91a7.06,7.06,0,1,1-13.37,4.57l-6.46-18.91A7.06,7.06,0,0,1,275.88,279.2Z"
                                style="fill:none"></path>
                            <path
                                d="M275.88,279.2a8.43,8.43,0,0,0-2.7,1.83,7.07,7.07,0,0,0-1.87,5.7,13.35,13.35,0,0,0,.75,2.57c1.25,3.62,2.74,7.91,4.39,12.67l1.26,3.66c.22.62.41,1.28.67,1.86a6.28,6.28,0,0,0,1,1.67,6.81,6.81,0,0,0,12-4.11,6.71,6.71,0,0,0-.21-1.95c-.15-.62-.41-1.26-.61-1.88l-1.24-3.67c-1.61-4.77-3.06-9.07-4.29-12.7a12.55,12.55,0,0,0-1-2.49,6.83,6.83,0,0,0-1.53-1.81,7.1,7.1,0,0,0-3.43-1.56,8.69,8.69,0,0,0-3.25.21s.06,0,.2-.08a4.58,4.58,0,0,1,.61-.19,6.75,6.75,0,0,1,2.47-.13,7.12,7.12,0,0,1,5.21,3.39,13.16,13.16,0,0,1,1.06,2.54c1.25,3.62,2.74,7.91,4.38,12.67.42,1.19.84,2.41,1.27,3.66.2.63.45,1.23.63,1.92a7.35,7.35,0,0,1-1.18,6.13,7.3,7.3,0,0,1-11.51.37,6.75,6.75,0,0,1-1.1-1.79c-.28-.65-.45-1.27-.68-1.9-.42-1.25-.84-2.47-1.24-3.67-1.61-4.77-3.06-9.07-4.29-12.7a13.42,13.42,0,0,1-.72-2.65,6.91,6.91,0,0,1,.15-2.47,7,7,0,0,1,3.92-4.82,6.31,6.31,0,0,1,.6-.22C275.8,279.21,275.87,279.19,275.88,279.2Z"
                                style="fill:#263238"></path>
                            <path
                                d="M265.65,290.25a2.54,2.54,0,0,1-.11-.29c-.07-.23-.16-.53-.28-.9a13.1,13.1,0,0,1-.4-3.58,13.34,13.34,0,0,1,1.38-5.53,14.21,14.21,0,0,1,2-3,14.45,14.45,0,0,1,3.11-2.57,13.44,13.44,0,0,1,17.78,3.68,14.06,14.06,0,0,1,1.41,2.48c.38.89.68,1.8,1,2.71l1.92,5.6,4,11.77a13.76,13.76,0,0,1,.58,6.35A13.47,13.47,0,0,1,273,311.53a24.12,24.12,0,0,1-1.62-4.11c-1.76-5.27-3.2-9.55-4.2-12.54-.48-1.46-.85-2.61-1.12-3.42l-.28-.9a2.52,2.52,0,0,1-.08-.31,1.13,1.13,0,0,1,.13.3c.09.22.19.51.33.87.29.81.69,1.95,1.21,3.39l4.36,12.5a23.1,23.1,0,0,0,1.62,4A13,13,0,0,0,285.82,318a13,13,0,0,0,11.73-11.05,13.41,13.41,0,0,0-.55-6.11c-1.38-4-2.72-8-4-11.77q-1-2.85-1.91-5.6c-.31-.92-.61-1.83-1-2.68a13.63,13.63,0,0,0-1.35-2.39,13,13,0,0,0-17.22-3.64,13.13,13.13,0,0,0-5,5.34,13.44,13.44,0,0,0-1.43,5.41A15.53,15.53,0,0,0,265.65,290.25Z"
                                style="fill:#263238"></path>
                            <path
                                d="M261.4,251.77l11.88,31.75a3.45,3.45,0,0,0,4.44,2h0a3.44,3.44,0,0,0,2-4.44l-11.88-31.75a3.46,3.46,0,0,0-4.44-2h0A3.45,3.45,0,0,0,261.4,251.77Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M261.4,251.77a2.57,2.57,0,0,1-.26-.88,3.47,3.47,0,0,1,.69-2.51,3.54,3.54,0,0,1,3.81-1.27,3.62,3.62,0,0,1,2.09,1.6,9,9,0,0,1,.57,1.31l.52,1.39L280,281a3.7,3.7,0,0,1-5.81,4.16,3.94,3.94,0,0,1-1.24-1.89c-.25-.67-.5-1.33-.74-2l-1.44-3.85-4.93-13.34c-1.38-3.77-2.49-6.84-3.29-9l-.86-2.45-.22-.65a.73.73,0,0,1-.05-.22.88.88,0,0,1,.1.2l.26.63c.24.59.56,1.4,1,2.42l3.44,9c1.44,3.8,3.14,8.31,5,13.3.47,1.26.95,2.54,1.45,3.85.24.66.49,1.32.74,2a3.48,3.48,0,0,0,1.1,1.67,3.19,3.19,0,0,0,5-3.59c-4.29-11.56-8.18-22-11-29.66l-.51-1.39a8.2,8.2,0,0,0-.52-1.27,3.35,3.35,0,0,0-6.2,2A5.92,5.92,0,0,0,261.4,251.77Z"
                                style="fill:#263238"></path>
                            <path
                                d="M282.6,312.26,294.48,344a3.45,3.45,0,0,0,4.44,2h0a3.46,3.46,0,0,0,2-4.44l-11.89-31.75a3.46,3.46,0,0,0-4.44-2h0A3.45,3.45,0,0,0,282.6,312.26Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M282.6,312.26a2.46,2.46,0,0,1-.25-.88,3.41,3.41,0,0,1,.68-2.51,3.54,3.54,0,0,1,3.81-1.27,3.59,3.59,0,0,1,2.09,1.6,9,9,0,0,1,.57,1.31l.53,1.39c2.87,7.61,6.8,18.06,11.16,29.6a3.7,3.7,0,0,1-5.82,4.16,3.94,3.94,0,0,1-1.24-1.89c-.25-.67-.5-1.33-.74-2L292,337.93,287,324.59l-3.28-9q-.56-1.54-.87-2.46c-.09-.25-.16-.46-.22-.64a.8.8,0,0,1,0-.22s0,.06.1.2l.26.63c.24.59.56,1.4,1,2.42l3.44,8.95,5,13.3c.47,1.26,1,2.54,1.45,3.85.24.66.49,1.32.74,2a3.48,3.48,0,0,0,1.1,1.67,3.19,3.19,0,0,0,5-3.59l-11-29.66c-.18-.47-.35-.94-.52-1.39a8.2,8.2,0,0,0-.52-1.27,3.33,3.33,0,0,0-5.46-.37,3.35,3.35,0,0,0-.74,2.38C282.5,312,282.63,312.25,282.6,312.26Z"
                                style="fill:#263238"></path>
                            <path
                                d="M218.2,133.35l11.88,31.75a3.46,3.46,0,0,0,4.44,2h0a3.46,3.46,0,0,0,2-4.44l-11.89-31.76a3.45,3.45,0,0,0-4.44-2h0A3.44,3.44,0,0,0,218.2,133.35Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M218.2,133.35a2.46,2.46,0,0,1-.25-.88,3.43,3.43,0,0,1,.68-2.51,3.58,3.58,0,0,1,5.9.33,9.56,9.56,0,0,1,.57,1.32l.53,1.38,11.16,29.6a3.72,3.72,0,0,1-3.65,5,3.76,3.76,0,0,1-2.16-.84,3.94,3.94,0,0,1-1.25-1.89c-.25-.67-.5-1.33-.74-2-.49-1.31-1-2.6-1.43-3.85-1.86-5-3.53-9.53-4.94-13.34l-3.28-9-.87-2.46-.22-.64a.76.76,0,0,1-.05-.23.93.93,0,0,1,.1.21c.07.17.16.37.26.63l1,2.42,3.44,8.95c1.44,3.8,3.15,8.3,5,13.3.47,1.25.95,2.54,1.45,3.85.24.65.49,1.32.75,2a3.4,3.4,0,0,0,1.09,1.67,3.2,3.2,0,0,0,5-3.6c-4.3-11.56-8.19-22-11-29.65-.18-.47-.35-.94-.52-1.39a8.2,8.2,0,0,0-.52-1.27,3.31,3.31,0,0,0-5.46-.37,3.37,3.37,0,0,0-.74,2.37C218.1,133.05,218.23,133.34,218.2,133.35Z"
                                style="fill:#263238"></path>
                            <path
                                d="M287.61,269.91l-4.67,3.32a13.34,13.34,0,0,1-3.14,18.58l-14.27,10.06,3.33,4.67,14.26-10.06A19.07,19.07,0,0,0,287.61,269.91Z"
                                style="fill:currentColor"></path>
                            <g style="opacity:0.4">
                                <path
                                    d="M287.61,269.91l-4.67,3.32a13.34,13.34,0,0,1-3.14,18.58l-14.27,10.06,3.33,4.67,14.26-10.06A19.07,19.07,0,0,0,287.61,269.91Z">
                                </path>
                            </g>
                            <path
                                d="M241.82,251.89a7.76,7.76,0,0,1-1.1-.81l-2.89-2.35c-2.44-2-5.8-4.75-9.55-7.74s-7.19-5.67-9.67-7.6l-2.93-2.3a6.83,6.83,0,0,1-1-.9,7.48,7.48,0,0,1,1.16.74c.72.5,1.76,1.24,3,2.17,2.54,1.86,6,4.49,9.77,7.49s7.08,5.79,9.46,7.86c1.19,1,2.14,1.88,2.79,2.47A6.2,6.2,0,0,1,241.82,251.89Z"
                                style="fill:#263238"></path>
                            <path
                                d="M235.18,254.47a16.06,16.06,0,0,1-2.82,0l-6.79-.2-6.8-.06a15.3,15.3,0,0,1-2.82-.11,16.27,16.27,0,0,1,2.82-.26c1.74-.08,4.15-.13,6.81-.08s5.06.19,6.8.34A14,14,0,0,1,235.18,254.47Z"
                                style="fill:#263238"></path>
                            <path
                                d="M285.66,202.4c.14,0-.54,7.79-1.51,17.37s-1.89,17.34-2,17.33.54-7.8,1.51-17.38S285.52,202.39,285.66,202.4Z"
                                style="fill:#263238"></path>
                            <path
                                d="M301.36,217.4a74,74,0,0,1-5.81,6.42,72.35,72.35,0,0,1-6.17,6.07,73,73,0,0,1,5.8-6.42A71.53,71.53,0,0,1,301.36,217.4Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Floor--inject-4">
                            <path
                                d="M484.93,462.57c0,.14-105.19.26-234.92.26s-234.94-.12-234.94-.26,105.17-.26,234.94-.26S484.93,462.42,484.93,462.57Z"
                                style="fill:#263238"></path>
                        </g>
                    </svg>
                @break

                @case('403')
                    <svg id="svg-color" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 500">
                        <g id="freepik--background-simple--inject-2">
                            <path
                                d="M55.48,273.73s2.32,72,62.43,120,143.41,51.43,210.84,56,119.23-33.62,127-91.32-43.72-74.64-71.68-140.33S358.64,130.8,299.49,90.4,147.8,74.81,99.29,144,55.48,273.73,55.48,273.73Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M55.48,273.73s2.32,72,62.43,120,143.41,51.43,210.84,56,119.23-33.62,127-91.32-43.72-74.64-71.68-140.33S358.64,130.8,299.49,90.4,147.8,74.81,99.29,144,55.48,273.73,55.48,273.73Z"
                                style="fill:#fff;opacity:0.7000000000000001"></path>
                        </g>
                        <g id="freepik--Padlock--inject-2">
                            <path
                                d="M83.61,179.69V153.92c0-18.24,15.16-33.08,33.79-33.08s33.79,14.84,33.79,33.08v25.77h13.47V153.92c0-25.51-21.2-46.27-47.26-46.27s-47.26,20.76-47.26,46.27v25.77Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <rect x="65.14" y="179.87" width="103.18" height="85.35"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </rect>
                            <path
                                d="M127.46,215.32a11.24,11.24,0,0,0-22.47,0,11,11,0,0,0,5.9,9.68L109,244.38h14.45L121.56,225A11,11,0,0,0,127.46,215.32Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                        </g>
                        <g id="freepik--Character--inject-2">
                            <polygon
                                points="232.64 267.99 206.95 266.3 206.95 265.88 203.79 266.09 200.64 265.88 200.64 266.3 174.95 267.99 156 423.79 174.95 423.79 203.16 299.57 204.43 299.57 232.64 423.79 251.59 423.79 232.64 267.99"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </polygon>
                            <path
                                d="M156,423.78l-4.63,7.16-14.32,6.32a4.88,4.88,0,0,0-2.52,4.21v5.47h40.84a54.21,54.21,0,0,0,0-8.84c-.42-4.21-.42-14.32-.42-14.32Z"
                                style="fill:#4c4c4c;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <path d="M134.53,442.31v4.63h40.84s.19-2,.19-4.63Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <path
                                d="M251.51,423.78l4.63,7.16,14.32,6.32a4.88,4.88,0,0,1,2.52,4.21v5.47H232.14a54.21,54.21,0,0,1,0-8.84c.42-4.21.42-14.32.42-14.32Z"
                                style="fill:#4c4c4c;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <path d="M273,442.31v4.63H232.14s-.18-2-.19-4.63Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <path
                                d="M164.07,195.51s-30,42.16-30,45.25,4.77,26.95,12.35,29.19,11.79-1.68,13.19-9.54-3.37-19.09-3.37-19.09l14-12.63Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <path
                                d="M158.25,259.29s8.7-1.41,10.95-.85,3.93,5.9,3.93,5.9.84,7.86-.57,9.54-8.14,3.65-10.94,4.21-8.71-5.89-11-9.82S152.35,257.6,158.25,259.29Z"
                                style="fill:#ccc;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <polygon
                                points="170.38 193.6 164.07 195.51 174.01 261.86 233.09 261.86 242.08 195.89 234.05 192.83 204.41 186.33 170.38 193.6"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </polygon>
                            <polygon
                                points="236.34 215.78 235.01 225.34 224.68 227.82 214.16 223.62 214.93 215.01 236.34 215.78"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </polygon>
                            <circle cx="225.35" cy="223.52" r="1.82"
                                style="fill:#4c4c4c;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </circle>
                            <polygon
                                points="198.1 198.57 203.65 205.07 196.57 250.19 204.03 262.05 212.83 249.62 205.37 205.26 211.68 199.14 204.99 190.54 198.1 198.57"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </polygon>
                            <polygon points="192.75 187.29 167.32 193.6 168.09 196.66 192.94 189.77 192.75 187.29"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </polygon>
                            <polygon points="213.59 186.52 239.02 192.83 238.26 195.89 213.4 189.01 213.59 186.52"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </polygon>
                            <path
                                d="M239,192.83s9.62,2.17,15.51,5.54,7.3,10.95,3.93,19.37-13.75,7.3-18.52,5-6.18-10.66-5.34-14.31"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <polygon
                                points="193.9 184.04 191.03 185.95 191.79 205.26 204.22 196.47 217.22 205.45 218.37 186.33 214.93 183.46 193.9 184.04"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </polygon>
                            <path
                                d="M219,161.07s7.06-1.72,8.39-8.78S216,136.64,207.18,135.12s-21.75,7.63-23.85,13.93,6.1,12.59,14.88,13.93S219,161.07,219,161.07Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <path d="M192.68,162.22s-3.82-5.92-4.77-.77,3.05,7.44,4.77,7.25S192.68,162.22,192.68,162.22Z"
                                style="fill:#ccc;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <path d="M217.49,162.22s3.82-5.92,4.77-.77-3,7.44-4.77,7.25S217.49,162.22,217.49,162.22Z"
                                style="fill:#ccc;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <polygon points="193.52 173.9 193.52 186.52 204.22 196.47 216.27 186.14 216.27 174.29 193.52 173.9"
                                style="fill:#ccc;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </polygon>
                            <path
                                d="M191.92,158.4s-.58,11.83.38,15.65,7.25,11.83,12.21,13.55,11.83-8.59,13.36-12,.95-17.94.95-17.94-2.09-5-6.29-6.48S195.35,147,191.92,158.4Z"
                                style="fill:#ccc;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <path
                                d="M199.85,164.68c0,.9-.41,1.63-.92,1.63s-.92-.73-.92-1.63.41-1.63.92-1.63S199.85,163.78,199.85,164.68Z"
                                style="fill:#263238"></path>
                            <path
                                d="M211.56,164.68c0,.9-.41,1.63-.92,1.63s-.92-.73-.92-1.63.41-1.63.92-1.63S211.56,163.78,211.56,164.68Z"
                                style="fill:#263238"></path>
                            <path
                                d="M201.84,169.24a1.28,1.28,0,1,0,0,2.49,1.74,1.74,0,0,0,1.11-.37,3.21,3.21,0,0,0,4.82.08,1.8,1.8,0,0,0,1,.29,1.28,1.28,0,1,0,0-2.49"
                                style="fill:#ccc;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <line x1="203.36" y1="177.07" x2="207.35" y2="177.07"
                                style="fill:#ccc;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </line>
                            <path d="M191.48,161.27s.14,3.84,1.42,2.84,1.7-7.52.57-8.37S191.48,159.29,191.48,161.27Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <path d="M216.11,161.27s.15,3.84,1.42,2.84,1.71-7.52.57-8.37S216.11,159.29,216.11,161.27Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <path
                                d="M191.48,158.15s.43.35.42.52c1.85,1,6.1,2.84,13,3.21a26.56,26.56,0,0,0,14-3.43c0-.51,0-.81,0-.82-.17-4.47-3.49-7.45-7.6-8.59a19.57,19.57,0,0,0-12.24.61,12,12,0,0,0-5.07,3.65C193.48,153.86,190.78,157.59,191.48,158.15Z"
                                style="fill:#4c4c4c;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <path
                                d="M191.92,158.4a45.19,45.19,0,0,0,13,.95c8.21-.38,13.92-.95,13.92-.95a22.64,22.64,0,0,1-13.8,6.06A15.14,15.14,0,0,1,191.92,158.4Z"
                                style="fill:#4c4c4c;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <polygon
                                points="170.96 215.78 172.29 225.34 182.62 227.82 193.13 223.62 192.37 215.01 170.96 215.78"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </polygon>
                            <circle cx="181.95" cy="223.52" r="1.82"
                                style="fill:#4c4c4c;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </circle>
                            <rect x="173.13" y="261.25" width="60.63" height="9.54"
                                style="fill:#4c4c4c;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </rect>
                            <rect x="168.92" y="261.81" width="18.53" height="11.79" rx="2.67"
                                style="fill:#4c4c4c;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </rect>
                            <rect x="217.2" y="261.81" width="18.53" height="11.79" rx="2.67"
                                style="fill:#4c4c4c;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </rect>
                            <rect x="197.83" y="261.81" width="13.19" height="8.42"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </rect>
                            <path d="M156.28,241.32s-8.42-.56-11.51-5.9"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <ellipse cx="249.9" cy="202.02" rx="13.9" ry="14.6"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </ellipse>
                            <ellipse cx="249.9" cy="194.63" rx="10.88" ry="9.75"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </ellipse>
                            <ellipse cx="249.9" cy="187.46" rx="10.88" ry="9.75"
                                style="fill:#ccc;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </ellipse>
                            <path
                                d="M232.42,166.44s.19,14.38.92,18.62,3.69,9.77,7.75,9.77a25.53,25.53,0,0,0,7.93-1.47s4.79,2.58,9.4,1.84,3.87-7.19,3.87-10-.55-23.6-.55-23.6.37-2-1.48-2.39a15.8,15.8,0,0,0-2.76-.37v-4.43a3.36,3.36,0,0,0-3.14-1.47c-2.39,0-2.58.55-2.58.55v-4.06s-2-3.23-4.61-1.66a3.68,3.68,0,0,0-1.84,2.95l-.19,3.88s-4.42-1.66-4.79.92S239.24,174,239.24,174a40.86,40.86,0,0,0-1.47-7.38C236.85,164.22,232.42,164.22,232.42,166.44Z"
                                style="fill:#ccc;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                            <line x1="245.14" y1="154.64" x2="245.51" y2="171.6"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </line>
                            <line x1="251.78" y1="153.53" x2="251.97" y2="171.78"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </line>
                            <line x1="257.5" y1="158.88" x2="257.13" y2="171.6"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </line>
                            <line x1="242.75" y1="171.42" x2="259.53" y2="172.15"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </line>
                            <path d="M239.24,174a4.51,4.51,0,0,0,1.81,3.58c1.82,1.14,5.92,4.1,6.37,8.88"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </path>
                        </g>
                        <g id="freepik--Text--inject-2">
                            <path d="M350,128.81V131h-5.33v7.76h6.55V141h-9v-21.8h9v2.21h-6.55v7.44Z" style="fill:#263238">
                            </path>
                            <path
                                d="M358.3,119.16c3.42,0,4.86,1.74,4.86,5v1.78c0,2.4-.84,3.89-2.71,4.48,2,.59,2.74,2.21,2.74,4.55v3.4a5.49,5.49,0,0,0,.43,2.61h-2.46a5.7,5.7,0,0,1-.4-2.64v-3.43c0-2.46-1.15-3.24-3.18-3.24h-1.71V141h-2.43v-21.8Zm-.63,10.28c1.94,0,3.09-.63,3.09-3v-2.09c0-2-.72-3-2.52-3h-2.37v8.07Z"
                                style="fill:#263238"></path>
                            <path
                                d="M370.57,119.16c3.43,0,4.86,1.74,4.86,5v1.78c0,2.4-.84,3.89-2.71,4.48,2,.59,2.74,2.21,2.74,4.55v3.4a5.37,5.37,0,0,0,.44,2.61h-2.46a5.66,5.66,0,0,1-.41-2.64v-3.43c0-2.46-1.15-3.24-3.18-3.24h-1.71V141h-2.43v-21.8ZM370,129.44c1.93,0,3.08-.63,3.08-3v-2.09c0-2-.71-3-2.52-3h-2.37v8.07Z"
                                style="fill:#263238"></path>
                            <path
                                d="M377.8,124.42c0-3.33,1.65-5.48,5-5.48s5,2.15,5,5.48V135.7c0,3.3-1.65,5.48-5,5.48s-5-2.18-5-5.48Zm2.4,11.4c0,2,.84,3.15,2.58,3.15s2.59-1.15,2.59-3.15V124.3c0-2-.81-3.15-2.59-3.15s-2.58,1.18-2.58,3.15Z"
                                style="fill:#263238"></path>
                            <path
                                d="M395,119.16c3.43,0,4.86,1.74,4.86,5v1.78c0,2.4-.84,3.89-2.71,4.48,2,.59,2.74,2.21,2.74,4.55v3.4a5.37,5.37,0,0,0,.44,2.61h-2.46a5.66,5.66,0,0,1-.41-2.64v-3.43c0-2.46-1.15-3.24-3.18-3.24h-1.71V141H390.1v-21.8Zm-.62,10.28c1.93,0,3.08-.63,3.08-3v-2.09c0-2-.71-3-2.52-3h-2.37v8.07Z"
                                style="fill:#263238"></path>
                            <path d="M329.38,264.88v2.21h-5v9.44h-2.43v-21.8h8.66v2.21h-6.23v7.94Z" style="fill:#263238">
                            </path>
                            <path
                                d="M332.33,260c0-3.33,1.66-5.48,5-5.48s5,2.15,5,5.48v11.28c0,3.3-1.65,5.48-5,5.48s-5-2.18-5-5.48Zm2.4,11.4c0,2,.84,3.15,2.59,3.15s2.58-1.15,2.58-3.15V259.87c0-2-.81-3.15-2.58-3.15s-2.59,1.18-2.59,3.15Z"
                                style="fill:#263238"></path>
                            <path
                                d="M349.5,254.73c3.42,0,4.86,1.74,4.86,5v1.78c0,2.4-.84,3.89-2.71,4.48,2,.59,2.74,2.21,2.74,4.55v3.4a5.37,5.37,0,0,0,.44,2.61h-2.46a5.53,5.53,0,0,1-.41-2.64v-3.43c0-2.46-1.15-3.24-3.18-3.24h-1.71v9.31h-2.43v-21.8ZM348.88,265c1.93,0,3.08-.63,3.08-3v-2.09c0-2-.72-3-2.52-3h-2.37V265Z"
                                style="fill:#263238"></path>
                            <path
                                d="M361.8,254.73c3.4,0,4.74,1.62,4.74,4.83v1c0,2.31-.66,3.74-2.56,4.33,2.12.6,2.93,2.28,2.93,4.68v1.83c0,3.28-1.59,5.11-5,5.11h-5v-21.8Zm-.59,9.25c1.93,0,2.93-.62,2.93-2.9V259.8c0-1.93-.66-2.86-2.4-2.86h-2.4v7Zm.72,10.34c1.77,0,2.58-.93,2.58-3v-1.93c0-2.43-1-3.24-3.05-3.24h-2.12v8.13Z"
                                style="fill:#263238"></path>
                            <path d="M371.55,254.73v21.8h-2.43v-21.8Z" style="fill:#263238"></path>
                            <path
                                d="M379.15,254.73c3.4,0,5,2,5,5.42v11c0,3.34-1.56,5.39-5,5.39h-5.1v-21.8Zm0,19.59c1.75,0,2.59-1.09,2.59-3.08V260c0-2-.84-3.08-2.62-3.08h-2.62v17.38Z"
                                style="fill:#263238"></path>
                            <path
                                d="M391.49,254.73c3.39,0,4.95,2,4.95,5.42v11c0,3.34-1.56,5.39-4.95,5.39h-5.11v-21.8Zm0,19.59c1.74,0,2.58-1.09,2.58-3.08V260c0-2-.84-3.08-2.61-3.08h-2.62v17.38Z"
                                style="fill:#263238"></path>
                            <path d="M406.47,264.38v2.18h-5.33v7.76h6.55v2.21h-9v-21.8h9v2.21h-6.55v7.44Z"
                                style="fill:#263238"></path>
                            <path d="M412.08,276.53H409.9v-21.8H413l5,15.76V254.73h2.15v21.8h-2.53l-5.57-17.63Z"
                                style="fill:#263238"></path>
                            <path
                                d="M306.54,208.26l22.25-52.61h13.35v52.61h5.78v11.12h-5.78V233.5h-12V219.38H306.54Zm23.58,0V179l-12.34,29.25Z"
                                style="fill:#263238"></path>
                            <path
                                d="M352.48,174.33c0-12.45,6.56-19.57,18.57-19.57s18.58,7.12,18.58,19.57v40.49c0,12.46-6.57,19.57-18.58,19.57s-18.57-7.11-18.57-19.57Zm12.23,41.27c0,5.56,2.45,7.67,6.34,7.67s6.34-2.11,6.34-7.67v-42c0-5.57-2.44-7.68-6.34-7.68s-6.34,2.11-6.34,7.68Z"
                                style="fill:#263238"></path>
                            <path
                                d="M421.1,174.78c0-7-2.44-8.9-6.34-8.9s-6.34,2.11-6.34,7.68v5H396.86v-4.23c0-12.45,6.22-19.57,18.24-19.57s18.24,7.12,18.24,19.57v2c0,8.34-2.67,13.57-8.57,16,6.12,2.67,8.57,8.45,8.57,16.35v6.12c0,12.46-6.23,19.57-18.24,19.57s-18.24-7.11-18.24-19.57v-6.45h11.56v7.23c0,5.56,2.45,7.67,6.34,7.67s6.34-1.89,6.34-8.78v-6.12c0-7.23-2.44-9.9-8-9.9H409V187.35h4.78c4.56,0,7.34-2,7.34-8.23Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--security-barrier--inject-2">
                            <polygon points="86.87 446.5 72.61 446.5 91.62 313.99 105.88 313.99 86.87 446.5"
                                style="fill:#263238;stroke:#263238;stroke-miterlimit:10;stroke-width:1.166343341900884px">
                            </polygon>
                            <polygon points="115.39 446.5 129.64 446.5 110.63 313.99 96.38 313.99 115.39 446.5"
                                style="fill:#fff;stroke:#263238;stroke-miterlimit:10;stroke-width:1.166343341900884px">
                            </polygon>
                            <polygon points="289.18 446.5 274.93 446.5 293.93 313.99 308.19 313.99 289.18 446.5"
                                style="fill:#263238;stroke:#263238;stroke-miterlimit:10;stroke-width:1.166343341900884px">
                            </polygon>
                            <polygon points="317.7 446.5 331.95 446.5 312.94 313.99 298.69 313.99 317.7 446.5"
                                style="fill:#fff;stroke:#263238;stroke-miterlimit:10;stroke-width:1.166343341900884px">
                            </polygon>
                            <rect x="55.73" y="293.21" width="271.93" height="26.36"
                                style="fill:currentColor;stroke:#263238;stroke-miterlimit:10;stroke-width:1.166343341900884px">
                            </rect>
                            <rect x="62.36" y="293.21" width="271.93" height="26.36"
                                style="fill:currentColor;stroke:#263238;stroke-miterlimit:10;stroke-width:1.166343341900884px">
                            </rect>
                            <polygon points="66.81 319.57 89.89 319.57 101.82 293.21 78.74 293.21 66.81 319.57"
                                style="fill:#263238"></polygon>
                            <polygon points="158.17 293.21 135.09 293.21 123.16 319.57 146.24 319.57 158.17 293.21"
                                style="fill:#263238"></polygon>
                            <polygon points="327.21 293.21 304.13 293.21 292.21 319.57 315.29 319.57 327.21 293.21"
                                style="fill:#263238"></polygon>
                            <polygon points="270.87 293.21 247.78 293.21 235.86 319.57 258.94 319.57 270.87 293.21"
                                style="fill:#263238"></polygon>
                            <polygon points="214.52 293.21 191.44 293.21 179.51 319.57 202.59 319.57 214.52 293.21"
                                style="fill:#263238"></polygon>
                            <line x1="332.8" y1="304.9" x2="287.8" y2="304.9"
                                style="fill:none;stroke:#263238;stroke-miterlimit:10;stroke-width:1.166343341900884px"></line>
                            <line x1="332.01" y1="309.31" x2="324.91" y2="309.31"
                                style="fill:none;stroke:#263238;stroke-miterlimit:10;stroke-width:1.166343341900884px"></line>
                            <line x1="61.21" y1="308.21" x2="106.21" y2="308.21"
                                style="fill:none;stroke:#263238;stroke-miterlimit:10;stroke-width:1.166343341900884px"></line>
                            <line x1="62" y1="303.25" x2="118.84" y2="303.25"
                                style="fill:none;stroke:#263238;stroke-miterlimit:10;stroke-width:1.166343341900884px"></line>
                            <rect x="331.37" y="440.72" width="77.14" height="5.79"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </rect>
                            <polygon points="395.49 440.56 344.39 440.56 364.42 331.6 375.46 331.6 395.49 440.56"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </polygon>
                            <polygon points="356.98 372.1 382.91 372.1 380.42 358.6 359.46 358.6 356.98 372.1"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </polygon>
                            <line x1="387.81" y1="422.37" x2="389.09" y2="429.82"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </line>
                            <line x1="373.22" y1="337.62" x2="386.2" y2="413"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </line>
                        </g>
                        <g id="freepik--Floor--inject-2">
                            <line x1="450.01" y1="446.5" x2="456.92" y2="446.5"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </line>
                            <line x1="39.37" y1="446.5" x2="440.36" y2="446.5"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.166343341900884px">
                            </line>
                        </g>
                    </svg>
                @break

                @case('404')
                    <svg id="svg-color" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 500">
                        <g id="freepik--background-simple--inject-22">
                            <path
                                d="M451.67,117q-2.52-4.2-5.25-8.22c-24.28-35.67-64.69-60.09-104-71.15a224,224,0,0,0-52.51-8c-115.68-4.2-158.18,91.17-195.45,115.77S0,211.91,7.21,300.15c5.44,67.09,43.61,131.24,113.31,160.43a197.16,197.16,0,0,0,24.19,8.35,230.64,230.64,0,0,0,51.09,7.85c52.7,2.35,95.49-10.35,137.35-42.34,9.73-7.44,19.41-15.83,32-16.75,9.18-.66,17.88,2.63,8.29,11.5-11.28,10.43,1.73,30.93,30.35,16.69,47.81-23.8,67.47-75.13,76.73-127.32C491.93,254.49,486.41,174.81,451.67,117Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M451.67,117q-2.52-4.2-5.25-8.22c-24.28-35.67-64.69-60.09-104-71.15a224,224,0,0,0-52.51-8c-115.68-4.2-158.18,91.17-195.45,115.77S0,211.91,7.21,300.15c5.44,67.09,43.61,131.24,113.31,160.43a197.16,197.16,0,0,0,24.19,8.35,230.64,230.64,0,0,0,51.09,7.85c52.7,2.35,95.49-10.35,137.35-42.34,9.73-7.44,19.41-15.83,32-16.75,9.18-.66,17.88,2.63,8.29,11.5-11.28,10.43,1.73,30.93,30.35,16.69,47.81-23.8,67.47-75.13,76.73-127.32C491.93,254.49,486.41,174.81,451.67,117Z"
                                style="fill:#fff;opacity:0.7000000000000001"></path>
                        </g>
                        <g id="freepik--Space--inject-22">
                            <path
                                d="M206.19,460.54c-3.7,0-7.53-.09-11.38-.26A215.63,215.63,0,0,1,147.29,453a181.09,181.09,0,0,1-22-7.6C66.6,420.84,28.38,366.5,23,300,20.2,265.8,27.78,237,46.15,212c15.51-21.14,36.19-36.28,56.22-49.5,13.07-8.62,24.73-21.68,38.24-36.79,31.75-35.53,71.27-79.75,143.52-79.75,2.21,0,4.48,0,6.73.12a207.59,207.59,0,0,1,48.62,7.42c39.15,11,74.26,34.86,93.93,63.77,1.57,2.31,3.15,4.77,4.68,7.32,34.67,57.73,36.58,137.15,26.8,192.23-9.68,54.57-27.59,89.35-56,108.2a30.43,30.43,0,0,0-1.63-6c-5-12.79-18-20.43-34.68-20.43-1.4,0-2.83.05-4.25.16-19.79,1.44-34.16,12.55-44.65,20.67L321,421.46C285.67,448.49,250.25,460.54,206.19,460.54Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Stars--inject-22">
                            <circle cx="362.53" cy="100.87" r="4.69" style="fill:#b2b2b2"></circle>
                            <circle cx="441.07" cy="180.24" r="4.69" style="fill:#b2b2b2"></circle>
                            <circle cx="116.79" cy="402.6" r="4.69" style="fill:#b2b2b2"></circle>
                            <circle cx="402.48" cy="398.53" r="4.69" style="fill:#b2b2b2"></circle>
                            <path d="M248.49,60a2.68,2.68,0,1,1-2.68-2.68A2.68,2.68,0,0,1,248.49,60Z" style="fill:#b2b2b2">
                            </path>
                            <circle cx="62" cy="221.83" r="4.69" style="fill:#b2b2b2"></circle>
                            <circle cx="400.24" cy="104.37" r="2.33" style="fill:#b2b2b2"></circle>
                            <circle cx="86.94" cy="371.26" r="2.33" style="fill:currentColor"></circle>
                            <circle cx="430.61" cy="352.08" r="2.33" style="fill:currentColor"></circle>
                            <path d="M216.25,416.32a2.33,2.33,0,1,1-2.33-2.32A2.33,2.33,0,0,1,216.25,416.32Z"
                                style="fill:currentColor"></path>
                            <path d="M97,334.17a2.33,2.33,0,1,1-2.33-2.33A2.34,2.34,0,0,1,97,334.17Z" style="fill:#b2b2b2">
                            </path>
                            <path d="M193.36,445.78a2.33,2.33,0,1,1-2.33-2.33A2.32,2.32,0,0,1,193.36,445.78Z"
                                style="fill:#b2b2b2"></path>
                            <path d="M327.41,70.68a2.33,2.33,0,1,1-2.33-2.33A2.33,2.33,0,0,1,327.41,70.68Z"
                                style="fill:currentColor"></path>
                            <path d="M331.43,325.22a2.33,2.33,0,1,1-2.33-2.33A2.32,2.32,0,0,1,331.43,325.22Z"
                                style="fill:#b2b2b2"></path>
                            <path d="M438.32,234.73A2.33,2.33,0,1,1,436,232.4,2.33,2.33,0,0,1,438.32,234.73Z"
                                style="fill:#b2b2b2"></path>
                            <circle cx="57.33" cy="323.94" r="2.33" style="fill:currentColor"></circle>
                            <circle cx="264.74" cy="429.46" r="2.33" style="fill:#b2b2b2"></circle>
                            <circle cx="180.32" cy="338.65" r="2.33" style="fill:currentColor"></circle>
                            <path d="M335.49,150.62a2.33,2.33,0,1,1-2.32-2.33A2.32,2.32,0,0,1,335.49,150.62Z"
                                style="fill:currentColor"></path>
                        </g>
                        <g id="freepik--Text--inject-22">
                            <path d="M137.66,393.7v-40h14.47v2.91H141.46v15h8.7v2.77h-8.7v16.49h10.77v2.82Z"
                                style="fill:#b2b2b2"></path>
                            <path
                                d="M157.37,393.7v-40h9a12,12,0,0,1,5.9,1.21,6.91,6.91,0,0,1,3.08,3.51,14.3,14.3,0,0,1,.94,5.46,17.13,17.13,0,0,1-.49,4.19,8.07,8.07,0,0,1-1.68,3.36,5.82,5.82,0,0,1-3.36,1.83l6.13,20.45h-3.66L167.39,374h-6.27V393.7Zm3.75-22.43h5.09a7.53,7.53,0,0,0,3.9-.84,4.61,4.61,0,0,0,2-2.47,11.93,11.93,0,0,0,.6-4.09,9.66,9.66,0,0,0-1.29-5.54c-.85-1.21-2.55-1.82-5.08-1.82h-5.19Z"
                                style="fill:#b2b2b2"></path>
                            <path
                                d="M182.65,393.7v-40h9a12.11,12.11,0,0,1,5.91,1.21,6.91,6.91,0,0,1,3.08,3.51,14.3,14.3,0,0,1,.94,5.46,17.13,17.13,0,0,1-.49,4.19,8.07,8.07,0,0,1-1.68,3.36,5.82,5.82,0,0,1-3.36,1.83l6.12,20.45h-3.65L192.68,374h-6.27V393.7Zm3.76-22.43h5.09a7.56,7.56,0,0,0,3.9-.84,4.61,4.61,0,0,0,2-2.47,11.93,11.93,0,0,0,.6-4.09,9.66,9.66,0,0,0-1.29-5.54c-.86-1.21-2.55-1.82-5.09-1.82h-5.18Z"
                                style="fill:#b2b2b2"></path>
                            <path
                                d="M217.38,394.19a10.81,10.81,0,0,1-6.2-1.55,8.24,8.24,0,0,1-3.16-4.35,20.5,20.5,0,0,1-.92-6.4V365.3a18.67,18.67,0,0,1,1-6.35,8.11,8.11,0,0,1,3.21-4.17,13.39,13.39,0,0,1,12.24,0,8,8,0,0,1,3.19,4.17,19.22,19.22,0,0,1,.94,6.35v16.64a20.52,20.52,0,0,1-.91,6.37,8.3,8.3,0,0,1-3.14,4.33A10.79,10.79,0,0,1,217.38,394.19Zm0-3a6.58,6.58,0,0,0,4.05-1.06,5.44,5.44,0,0,0,1.9-3,17.08,17.08,0,0,0,.52-4.42V364.61a16.86,16.86,0,0,0-.52-4.4,5.19,5.19,0,0,0-1.9-2.89,8.58,8.58,0,0,0-8.08,0,5.13,5.13,0,0,0-1.93,2.89,16.89,16.89,0,0,0-.51,4.4v18.12a17.1,17.1,0,0,0,.51,4.42,5.37,5.37,0,0,0,1.93,3A6.58,6.58,0,0,0,217.38,391.18Z"
                                style="fill:#b2b2b2"></path>
                            <path
                                d="M233.87,393.7v-40h9a12,12,0,0,1,5.9,1.21,7,7,0,0,1,3.09,3.51,14.5,14.5,0,0,1,.94,5.46,17.63,17.63,0,0,1-.49,4.19,8.19,8.19,0,0,1-1.68,3.36,5.85,5.85,0,0,1-3.36,1.83l6.12,20.45h-3.65L243.9,374h-6.27V393.7Zm3.76-22.43h5.08a7.53,7.53,0,0,0,3.9-.84,4.62,4.62,0,0,0,2-2.47,12,12,0,0,0,.59-4.09,9.67,9.67,0,0,0-1.28-5.54c-.86-1.21-2.55-1.82-5.09-1.82h-5.18Z"
                                style="fill:#b2b2b2"></path>
                            <path
                                d="M269.24,393.7v-40h9.58a10.35,10.35,0,0,1,5.65,1.33,7.38,7.38,0,0,1,2.94,3.71,15.93,15.93,0,0,1,.89,5.58,14.48,14.48,0,0,1-.91,5.21,8,8,0,0,1-3,3.83,9.61,9.61,0,0,1-5.5,1.43H273V393.7ZM273,372h4.79a9.2,9.2,0,0,0,3.93-.72,4.44,4.44,0,0,0,2.2-2.4,12.17,12.17,0,0,0,.69-4.54,15,15,0,0,0-.6-4.77,3.87,3.87,0,0,0-2.05-2.37,10.25,10.25,0,0,0-4.12-.66H273Z"
                                style="fill:#b2b2b2"></path>
                            <path d="M288.89,393.7l8.45-40h4l8.5,40h-3.71l-2-10.72h-9.54l-2,10.72Zm6.23-13.44h8.49l-4.3-21.58Z"
                                style="fill:#b2b2b2"></path>
                            <path
                                d="M323.57,394.24a9.83,9.83,0,0,1-5.91-1.58,8.39,8.39,0,0,1-3-4.47,22.58,22.58,0,0,1-.89-6.69V365.89a23.08,23.08,0,0,1,.86-6.67,8.15,8.15,0,0,1,3.06-4.37,13.05,13.05,0,0,1,11.91-.22,7.54,7.54,0,0,1,3,3.9,18.5,18.5,0,0,1,.93,6.27v1.39H330V364.8a18.39,18.39,0,0,0-.52-4.74,5,5,0,0,0-1.8-2.81,6.41,6.41,0,0,0-3.81-.94,6.17,6.17,0,0,0-4.1,1.18,5.62,5.62,0,0,0-1.8,3.26,24.14,24.14,0,0,0-.42,4.74v16.45a20.55,20.55,0,0,0,.52,5,5.54,5.54,0,0,0,1.93,3.16,6.32,6.32,0,0,0,4,1.09,5.25,5.25,0,0,0,5.73-4.3,20.24,20.24,0,0,0,.54-5v-4.69h-5.92v-2.81h9.38V393.7h-2.42l-.44-4.55a7.64,7.64,0,0,1-2.45,3.71A7.45,7.45,0,0,1,323.57,394.24Z"
                                style="fill:#b2b2b2"></path>
                            <path d="M340.16,393.7v-40h14.47v2.91H344v15h8.7v2.77H344v16.49h10.77v2.82Z" style="fill:#b2b2b2">
                            </path>
                        </g>
                        <g id="freepik--Number--inject-22">
                            <path
                                d="M121.82,338.88V289.81H62.16V260.72l52-121.54h39.69V262.69h20.46v27.12H153.87v49.07ZM90.75,262.69h31.07V175.91Zm153.6,79.14q-17.5,0-29-7.39A45.83,45.83,0,0,1,198.12,314q-5.79-13.08-5.79-30.08V195.39q0-17.5,5.55-30.69a44.17,44.17,0,0,1,17-20.59q11.46-7.4,29.46-7.4t29.46,7.4a44.28,44.28,0,0,1,17,20.59q5.55,13.19,5.55,30.69V283.9q0,17-5.8,30.08a45.81,45.81,0,0,1-17.25,20.46Q261.85,341.84,244.35,341.83Zm0-29.33q7.64,0,11.34-4.69a25.57,25.57,0,0,0,4.93-11.34,71.82,71.82,0,0,0,1.23-13.07V195.88a84.53,84.53,0,0,0-1.11-13.68,24.46,24.46,0,0,0-4.81-11.46q-3.69-4.68-11.58-4.69t-11.59,4.69A24.56,24.56,0,0,0,228,182.2a84.53,84.53,0,0,0-1.11,13.68V283.4a64.93,64.93,0,0,0,1.36,13.07,26.52,26.52,0,0,0,5.05,11.34Q237,312.51,244.35,312.5Zm133.38,26.38V289.81H318.06V260.72l52-121.54h39.69V262.69h20.47v27.12H409.77v49.07Zm-31.07-76.19h31.07V175.91Z"
                                style="fill:currentColor;stroke:#263238;stroke-miterlimit:10"></path>
                        </g>
                        <g id="freepik--Character--inject-22">
                            <g style="opacity:0.30000000000000004">
                                <path
                                    d="M320.7,285.13l.13.12a4.63,4.63,0,0,0,.56.39l.16.08a4,4,0,0,0,.55.27l.2.08a5.5,5.5,0,0,0,.81.26l.14,0c.26.06.53.11.83.15l.28,0c.35,0,.72.08,1.12.09h0a10.18,10.18,0,0,0,4.12-.75,11.87,11.87,0,0,0,2-1,15.15,15.15,0,0,0,1.26-.89c.21-.16.41-.33.61-.51a13.61,13.61,0,0,0,1.15-1.13c3.32-3.64,5.27-9.31,3.65-16-.4-1.66-.83-3.22-1.28-4.72a61.19,61.19,0,0,0-2.51-6.85c-.24-.54-.48-1.07-.74-1.58a34.06,34.06,0,0,0-1.89-3.36c-.44-.69-.9-1.35-1.37-2a18.14,18.14,0,0,0-3.74-3.7c-.33-.24-.67-.46-1-.66a1.74,1.74,0,0,0-.27-.14l-7.42,17.33V280c.71,2,1.19,3.75,2.45,5h0Z">
                                </path>
                                <path
                                    d="M296.37,280V245.67c-1,0-1.88.08-2.67.13a61.77,61.77,0,0,0-1.81-16.1,24.36,24.36,0,0,0-7.45-17.41c-.47-6.64-4.18-14.4-8.33-19.84a1.67,1.67,0,0,0,.31,0c1.66-.18,2.7-2.26,3.43-5.84.1-.49.18-.95.24-1.39a11.55,11.55,0,0,0,3.7-3.66,11.3,11.3,0,0,0,1-3.58,21.59,21.59,0,0,0,4.91-4.06,11.26,11.26,0,0,0,2.54-5.56c-.43-1.25-.9-2.48-1.4-3.68A46.16,46.16,0,0,0,282,151a16.84,16.84,0,0,0-3.4-1.34,13.44,13.44,0,0,0-3.28-.46,105.57,105.57,0,0,0-18.41-2c-3-.07-5.67,0-8.08.09a13,13,0,0,0-6.59-1,12.71,12.71,0,0,0-4,1.1,30.81,30.81,0,0,0-10.81-.92c-.76.09-1.51.18-2.24.29,0-.38-.05-.76-.1-1.14-.08-.73-.19-1.45-.32-2.16a33.5,33.5,0,0,0,0-4,41.89,41.89,0,0,0-10,4.64,44.17,44.17,0,0,0-17,20.59q-5.55,13.19-5.55,30.69v8.78c3.58,4.63,7.9,9.82,10.75,11.81l.62.64c.2,3.45.81,11.22,2.31,13.78,0,0-1.18,4.12.82,6.21-.61,4.62-1.42,16.19,3.38,27.59,3.73,8.85,10.09,13.63,16.63,15.15V195.88A84.53,84.53,0,0,1,228,182.2a24.56,24.56,0,0,1,4.81-11.46q3.7-4.68,11.59-4.69t11.58,4.69a24.46,24.46,0,0,1,4.81,11.46,84.53,84.53,0,0,1,1.11,13.68V283.4c0,1.48-.07,3-.16,4.46.05.28.11.55.18.8h0a6.28,6.28,0,0,0,.3.81,1,1,0,0,0,.07.15,3.72,3.72,0,0,0,.3.52l.09.12a3,3,0,0,0,.44.49h0a3,3,0,0,0,.5.36l.14.08.5.24.1,0c.21.08.43.15.67.22l.16,0c.19.06.4.11.61.16l.23.06.75.17c3.62.84,9.8-4.07,11.38-9a21.88,21.88,0,0,0,.74-3.28l.6-.09A45.25,45.25,0,0,0,296.37,280Zm-22.95-90.67,0,0,.06-.43C273.43,189,273.42,189.18,273.42,189.29Zm.31-2.49c.06-.51.13-1,.19-1.5h0C273.87,185.83,273.79,186.33,273.73,186.8Z">
                                </path>
                                <path
                                    d="M153.87,207.26c-1.29,3.23-2.43,6.14-3,7.76-1.84,5.17-3.77,11-3.73,14.34s2.11,7.62,3.73,7.76,2.77-.93,3-3.18Z">
                                </path>
                            </g>
                            <path
                                d="M269.13,217.18a125.35,125.35,0,0,1,.94,15.09c-.06,7.6,1.72,7.76,5.35,8.6s9.8-4.07,11.38-9,1.43-14.46,1.43-14.46Z"
                                style="fill:#dedede"></path>
                            <path
                                d="M276.29,241.46a4.55,4.55,0,0,1-1-.1l-.34-.08c-3.78-.87-5.45-1.57-5.39-9a126.12,126.12,0,0,0-.93-15l-.08-.57,20.16.23v.49c0,.39.13,9.66-1.46,14.62S280.2,241.46,276.29,241.46Zm-6.59-23.77a126.43,126.43,0,0,1,.87,14.58c-.06,7,1.31,7.27,4.62,8l.34.08c3.35.78,9.3-4,10.79-8.67,1.34-4.17,1.42-11.81,1.41-13.81Z"
                                style="fill:#263238"></path>
                            <path
                                d="M285.67,226.34c-.17,3.37-1.17,8.78-6.18,11.44a8.84,8.84,0,0,1-9-.39c.74,2.64,2.37,2.9,4.89,3.48,3.62.84,9.8-4.07,11.38-9s1.43-14.46,1.43-14.46l-2.23,0C285.92,219.88,285.78,224.07,285.67,226.34Z"
                                style="fill:#dedede"></path>
                            <path
                                d="M276.29,241.46a4.55,4.55,0,0,1-1-.1l-.33-.08c-2.31-.53-4.13-.95-4.92-3.76l-.36-1.26,1.11.71a8.39,8.39,0,0,0,8.46.37c4.56-2.43,5.73-7.34,5.91-11h0c.12-2.43.27-7.07.33-8.95v-.49l3.21,0v.49c0,.39.13,9.66-1.46,14.62S280.2,241.46,276.29,241.46Zm-4.75-3c.72,1.14,1.88,1.41,3.65,1.82l.34.07c3.35.78,9.3-4,10.79-8.67,1.34-4.17,1.42-11.81,1.41-13.81l-1.25,0c-.07,2.11-.2,6.23-.31,8.48-.19,3.95-1.47,9.21-6.44,11.86A9.18,9.18,0,0,1,271.54,238.49Z"
                                style="fill:#263238"></path>
                            <path
                                d="M251.9,224.35A48.06,48.06,0,0,0,266,221.23c8.15-3,17.3-9.83,15.34-16.5s-12.58-8.52-16.77-8.07a76.79,76.79,0,0,0-9,1.69S256.59,217.13,251.9,224.35Z"
                                style="fill:#dedede"></path>
                            <path
                                d="M251,224.87l.51-.79c4.55-7,3.64-25.52,3.63-25.71l0-.41.4-.1a78.69,78.69,0,0,1,9.06-1.7c4.24-.45,15.22,1.32,17.31,8.43,1.95,6.64-6.6,13.77-15.65,17.11a47.66,47.66,0,0,1-14.3,3.15Zm5.16-26.14c.11,2.77.55,17.89-3.32,25.07a51.76,51.76,0,0,0,13.06-3c8.61-3.18,16.81-9.83,15-15.89-1.9-6.45-12.39-8.13-16.24-7.71A73.93,73.93,0,0,0,256.13,198.73Z"
                                style="fill:#263238"></path>
                            <path
                                d="M248,227.08a16.13,16.13,0,0,0,8.6-5.35c3.25-4.24,4.45-11.08,2.71-15.66S248,227.08,248,227.08Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M247.17,227.75l.32-.85c1.92-5.13,8.41-21.87,11.21-21.88h0c.26,0,.75.11,1,.87,1.78,4.7.56,11.79-2.78,16.14a16.51,16.51,0,0,1-8.9,5.54ZM258.67,206c-1.37,0-6.13,10.39-9.9,20.32a15.21,15.21,0,0,0,7.39-4.91c3.15-4.1,4.31-10.77,2.65-15.17A.54.54,0,0,0,258.67,206Z"
                                style="fill:#263238"></path>
                            <path
                                d="M215.83,183.24s-3.14,15,3,29.69,19.64,18.18,29.09,14.15,11.71-17.34,11.81-26.19-.16-12.87-.16-12.87S227.81,191.12,215.83,183.24Z"
                                style="fill:#dedede"></path>
                            <path
                                d="M240.23,229.13a21.69,21.69,0,0,1-8.06-1.57c-4.22-1.71-10-5.61-13.76-14.44-6.17-14.66-3.11-29.83-3.07-30l.15-.72.61.4c11.7,7.7,43.14,4.73,43.46,4.7l.51-.05,0,.52s.26,4.15.16,12.91c-.07,6.49-1.4,22.07-12.12,26.64A20.19,20.19,0,0,1,240.23,229.13Zm-24-45.07c-.51,3.14-2.15,16.1,3.14,28.68,3.59,8.51,9.17,12.25,13.22,13.89a20,20,0,0,0,15.21,0c10.18-4.34,11.44-19.44,11.51-25.73.08-7-.07-11-.13-12.32C254.9,188.94,227.86,191,216.19,184.06Z"
                                style="fill:#263238"></path>
                            <path
                                d="M214.67,179.13s-1.41,4.92,1.44,6.73,17.56,10.45,35,7.14c9.76-1.85,7.61-4.71,7.44-6.28S214.67,179.13,214.67,179.13Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M243.13,194.25a53.88,53.88,0,0,1-27.29-8c-3.12-2-1.71-7.07-1.65-7.29l.12-.42.43.06c.11,0,11.07,1.53,21.9,3.21,22.29,3.46,22.38,4.22,22.44,4.83a5.48,5.48,0,0,0,.12.58,3.41,3.41,0,0,1-.26,2.88c-.95,1.48-3.4,2.55-7.7,3.36A43.29,43.29,0,0,1,243.13,194.25Zm-28.08-14.56c-.24,1.16-.72,4.45,1.33,5.75,2.76,1.75,17.4,10.34,34.67,7.07,3.91-.74,6.28-1.72,7.05-2.92a2.53,2.53,0,0,0,.13-2.11q-.08-.28-.12-.54C256,185.7,230.94,181.88,215.05,179.69Z"
                                style="fill:#263238"></path>
                            <path
                                d="M212.29,163.67s.43,12.14,2.38,15.46,27.77,13.41,40.88,10.57S290,175.18,292.6,166.6s-4.16-22.08-10.52-28.58-9.15-7.78-9.15-7.78S257.35,151,238,157.88,212.29,163.67,212.29,163.67Z"
                                style="fill:#fff"></path>
                            <path
                                d="M250.25,190.7c-13.93,0-34.13-8.12-36-11.32-2-3.39-2.44-15.19-2.45-15.69l0-.61.6.1c.06,0,6.49.95,25.43-5.77s34.58-27.26,34.73-27.47l.25-.32.36.17c.12.05,2.95,1.4,9.3,7.88s13.39,20,10.64,29.08-24.61,20.67-37.42,23.44A26.17,26.17,0,0,1,250.25,190.7Zm-37.44-26.48c.12,2.42.66,11.88,2.29,14.66s27.07,13.2,40.35,10.33c13.62-3,34.24-14.74,36.67-22.75,2.6-8.59-4.49-22.06-10.4-28.09-5-5.06-7.74-6.93-8.65-7.48-2.16,2.75-17,21.1-34.93,27.46C221.9,164.11,214.8,164.32,212.81,164.22Z"
                                style="fill:#263238"></path>
                            <path
                                d="M315.21,194.34s13.72-5.37,19.2-2.08,9.67,11,12.55,22.83-5.54,20.55-12.81,20.28-6-5-8.83-9.81-6.31-7.61-6.54-8.12S322,201.73,315.21,194.34Z"
                                style="fill:#fff"></path>
                            <path
                                d="M334.49,235.88h-.36c-5.53-.2-6.47-3-7.57-6.13a20.72,20.72,0,0,0-1.68-3.93,35.46,35.46,0,0,0-5.63-7.11,4.74,4.74,0,0,1-.92-1c-.1-.21-.07-.41.08-1.6.49-3.8,2-15.36-3.56-21.37l-.5-.54.68-.26c.57-.23,14-5.43,19.64-2S344.53,203,347.44,215a18,18,0,0,1-3.2,15.78A13,13,0,0,1,334.49,235.88Zm-15.22-18.6c.11.13.41.43.69.72a35.91,35.91,0,0,1,5.79,7.31,22.77,22.77,0,0,1,1.76,4.1c1.05,3.07,1.82,5.28,6.66,5.46,3.3.12,6.77-1.65,9.3-4.75a17,17,0,0,0,3-14.92c-2.85-11.74-7-19.32-12.32-22.51-4.53-2.73-15.3.86-18.09,1.87,5.29,6.46,3.83,17.81,3.34,21.62C319.34,216.62,319.29,217.08,319.27,217.28Z"
                                style="fill:#263238"></path>
                            <path
                                d="M334.41,192.26a10.55,10.55,0,0,0-5.74-1c2.78,2.06,8.26,7.08,11.85,16.63,5,13.23,2.72,20.19.18,22.76s-7.92,3.51-10.25,3.23l-1.3-.15c1,1,2.49,1.6,5,1.69,7.27.27,15.69-8.41,12.81-20.28S339.89,195.55,334.41,192.26Z"
                                style="fill:#fff"></path>
                            <path
                                d="M334.49,235.88h-.36c-2.45-.09-4.14-.67-5.33-1.84l-1.05-1,2.76.33c2.12.25,7.36-.59,9.83-3.09,2.83-2.86,4.23-10.19-.29-22.23-3.51-9.35-8.82-14.29-11.68-16.41l-1.13-.84,1.41-.06a10.84,10.84,0,0,1,6,1.12c5.56,3.34,9.86,11.12,12.77,23.14a18,18,0,0,1-3.2,15.78A13,13,0,0,1,334.49,235.88Zm-3.26-1.5a9.63,9.63,0,0,0,2.94.49c3.3.12,6.77-1.65,9.3-4.75a17,17,0,0,0,3-14.92c-2.85-11.74-7-19.32-12.32-22.51h0a8.42,8.42,0,0,0-4-1A37.6,37.6,0,0,1,341,207.66c5.9,15.71,1.54,21.8.06,23.29C338.6,233.43,333.85,234.4,331.23,234.38Z"
                                style="fill:#263238"></path>
                            <path
                                d="M286.21,228s12.94,3.72,25-1.12,19.09-12.84,16.44-22.62-7.64-10.12-18.57-10-13.13,1.07-13.13,1.07S295.54,223,286.21,228Z"
                                style="fill:#fff"></path>
                            <path
                                d="M297.39,229.89a45.4,45.4,0,0,1-11.32-1.37l-1.18-.33,1.08-.59c9-4.88,9.43-31.95,9.43-32.23v-.32l.29-.13c.1,0,2.41-1,13.32-1.11s16.32.26,19.06,10.36c2.56,9.44-3.54,17.9-16.73,23.22A37.61,37.61,0,0,1,297.39,229.89Zm-9.94-2.06c3.36.75,13.82,2.54,23.52-1.37,12.67-5.1,18.56-13.13,16.15-22-2.56-9.43-7.12-9.75-18.08-9.62-8.66.1-11.76.7-12.64.94C296.32,199,295.52,221.74,287.45,227.83Z"
                                style="fill:#263238"></path>
                            <ellipse cx="278.43" cy="179.18" rx="23.96" ry="22.12"
                                transform="translate(73.88 439.54) rotate(-84.61)" style="fill:currentColor"></ellipse>
                            <path
                                d="M278.11,203.63a18.75,18.75,0,0,1-2-.1c-12.42-1.17-21.49-13.05-20.22-26.48s12.4-23.4,24.81-22.23A21.67,21.67,0,0,1,296,163.48a25.36,25.36,0,0,1,5,17.82C299.75,194,289.71,203.63,278.11,203.63Zm.63-47.9c-11.09,0-20.69,9.22-21.84,21.42-1.21,12.88,7.45,24.27,19.32,25.39s22.51-8.45,23.73-21.33h0a24.34,24.34,0,0,0-4.76-17.13,20.68,20.68,0,0,0-14.56-8.26Q279.69,155.73,278.74,155.73Z"
                                style="fill:#263238"></path>
                            <ellipse cx="285.16" cy="207.05" rx="21.74" ry="20.06"
                                transform="translate(52.23 471.5) rotate(-84.61)" style="fill:currentColor"></ellipse>
                            <path
                                d="M284.88,229.28c-.6,0-1.2,0-1.81-.09a19.66,19.66,0,0,1-13.87-7.86,23,23,0,0,1-4.51-16.21c1.15-12.2,11.27-21.28,22.56-20.2s19.54,11.86,18.39,24.07h0C304.55,220.54,295.42,229.28,284.88,229.28Zm.57-43.45c-10,0-18.72,8.35-19.77,19.39a22.06,22.06,0,0,0,4.31,15.5,18.7,18.7,0,0,0,13.18,7.48c10.73,1,20.37-7.65,21.47-19.31s-6.74-22-17.48-23C286.59,185.86,286,185.83,285.45,185.83Z"
                                style="fill:#263238"></path>
                            <path
                                d="M302.36,194.68s.9-19.35-8.55-30-30.94-1.94-34.51,14,4,39.83,13.83,46,18.2.14,23.81-8.42S302.36,194.68,302.36,194.68Z"
                                style="fill:#fff"></path>
                            <path
                                d="M281.19,227.75a15.56,15.56,0,0,1-8.33-2.63c-10.23-6.41-17.58-30.76-14.05-46.53,2.23-10,10.88-16.38,18.47-18.35,6.83-1.77,13-.26,16.9,4.13,9.43,10.6,8.72,29.32,8.68,30.32,0,.73.07,13.35-5.5,21.87C294.27,221.27,288.66,227.75,281.19,227.75Zm1.52-67.23a20.87,20.87,0,0,0-5.18.69c-7.29,1.89-15.61,8.06-17.74,17.6-3.46,15.44,3.66,39.24,13.6,45.46,10.93,6.85,19.18-2.24,23.13-8.26,5.45-8.33,5.34-21.2,5.34-21.32v0c0-.2.78-19.27-8.43-29.62A13.94,13.94,0,0,0,282.71,160.52Z"
                                style="fill:#263238"></path>
                            <path
                                d="M168.85,140.49s-7.48,18.1-9.32,23.26-3.78,11-3.73,14.34,2.11,7.62,3.72,7.76,2.78-.94,3-3.21.13-3.21,1.27-4.46a34.18,34.18,0,0,1,5.18-3.92c.46-.21.81,1.51-.27,3.39s-3.45,3.58-2,5.49,4.44-.32,6-1.93a16.18,16.18,0,0,0,3.87-7.15c.65-2.79.33-8.68.33-8.68l13.22-12.48S172.69,150.8,168.85,140.49Z"
                                style="fill:#dedede"></path>
                            <path
                                d="M159.81,186.37l-.33,0c-2.06-.18-4.14-4.88-4.18-8.25s1.78-9,3.75-14.51c1.83-5.12,9.26-23.11,9.33-23.3l.49-1.17.45,1.19c3.69,9.9,20.78,12.07,21,12.09l1.06.13-13.82,13.05c.05,1.14.23,6-.37,8.6a16.8,16.8,0,0,1-4,7.38c-.87.88-3.12,2.93-5.06,2.82a2.28,2.28,0,0,1-1.73-.93c-1.34-1.72-.13-3.28.94-4.66a14.9,14.9,0,0,0,1-1.39,4.2,4.2,0,0,0,.62-2.52,34.87,34.87,0,0,0-4.73,3.64c-.85.93-.92,1.64-1.05,3.21,0,.3-.06.61-.09,1C162.8,185,161.6,186.37,159.81,186.37Zm9.05-44.6c-1.65,4-7.31,17.79-8.86,22.15-1.86,5.2-3.74,10.94-3.7,14.16,0,3.47,2.13,7.17,3.27,7.27,1.88.17,2.36-1.66,2.47-2.76,0-.34.06-.66.09-.94.14-1.64.23-2.63,1.32-3.81a33.57,33.57,0,0,1,5.33-4,.68.68,0,0,1,.81.18c.53.59.49,2.3-.44,3.92a12.73,12.73,0,0,1-1.06,1.5c-1.12,1.45-1.76,2.38-.94,3.44a1.3,1.3,0,0,0,1,.54c1.25.07,3-1.25,4.28-2.52a15.63,15.63,0,0,0,3.74-6.91c.63-2.69.33-8.48.33-8.54l0-.23,12.64-11.94C185.39,152.63,172.89,150,168.86,141.77Z"
                                style="fill:#263238"></path>
                            <path
                                d="M174.28,179.3c-2.08-.05-3.57-.55-4.41-1.48a2.55,2.55,0,0,1-.7-1.76l1,.08-.5,0,.5,0a1.53,1.53,0,0,0,.46,1c.46.49,1.46,1.08,3.67,1.13Z"
                                style="fill:#263238"></path>
                            <path
                                d="M162.7,178.76a6.55,6.55,0,0,1-6.23-4.67l1-.26a5.51,5.51,0,0,0,6.32,3.86l.13,1A9.88,9.88,0,0,1,162.7,178.76Z"
                                style="fill:#263238"></path>
                            <path
                                d="M159.51,182.47a5.65,5.65,0,0,1-3.3-1.17l.61-.79c.12.09,2.93,2.21,5.07-.15l.74.67A4.1,4.1,0,0,1,159.51,182.47Z"
                                style="fill:#263238"></path>
                            <path
                                d="M175.78,165.91c-4.57,0-8-1.15-10.3-3.42a9.29,9.29,0,0,1-2.69-6.45l1,0a8.42,8.42,0,0,0,2.41,5.72c2.26,2.25,5.88,3.28,10.77,3.08l.05,1Z"
                                style="fill:#263238"></path>
                            <path
                                d="M172.59,135.12s-3.52.06-3.74,5.37,4,13.49,12.18,14.84,13.23-3.51,14.71-7.52S178.17,132,172.59,135.12Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M183.76,156.07a17.3,17.3,0,0,1-2.81-.24c-8.47-1.41-12.83-10-12.6-15.37.21-5.09,3.38-5.75,4.09-5.83,4.25-2.25,14.81,3,20.27,7.64,1.95,1.66,4.14,4,3.5,5.72A13,13,0,0,1,183.76,156.07ZM172.6,135.62c-.14,0-3,.16-3.25,4.89-.22,5,3.85,13,11.76,14.33,8.55,1.42,13-4.09,14.16-7.2.26-.69-.45-2.26-3.2-4.61-5.23-4.44-15.61-9.54-19.24-7.48l-.11.06Z"
                                style="fill:#263238"></path>
                            <path d="M181.75,120.67s-8.64,10.39-10.15,15.67,2.26,15,11.84,16.17,15.28-6.78,15.28-6.78Z"
                                style="fill:#dedede"></path>
                            <path
                                d="M185.37,153.13a17.12,17.12,0,0,1-2-.12,14.09,14.09,0,0,1-10.12-6.27c-2.18-3.31-3-7.44-2.14-10.53,1.52-5.33,9.89-15.43,10.24-15.86l.43-.51,17.54,25.89-.2.29C199.07,146.09,193.94,153.13,185.37,153.13Zm-3.66-31.62c-1.75,2.15-8.36,10.51-9.63,15-.79,2.78,0,6.68,2,9.71a12.88,12.88,0,0,0,9.41,5.82c8.17,1,13.49-4.94,14.59-6.3Z"
                                style="fill:#263238"></path>
                            <path
                                d="M186.69,112.29a20.74,20.74,0,0,0-6.6,13.69c-.43,8.47,7.37,18.24,17.55,17.3S195.07,111.88,186.69,112.29Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M196.29,143.84a15.93,15.93,0,0,1-11.07-4.64A17.83,17.83,0,0,1,179.59,126a21,21,0,0,1,6.78-14l.13-.1h.36c6.49,0,14.4,15.83,15,24.55.32,4.53-1.17,7.17-4.18,7.45C197.22,143.82,196.76,143.84,196.29,143.84Zm-9.4-31.06a20.36,20.36,0,0,0-6.3,13.22,16.82,16.82,0,0,0,5.32,12.48,14.79,14.79,0,0,0,11.69,4.3c3.05-.28,3.47-3.62,3.27-6.38C200.23,127.3,192.38,112.82,186.89,112.78Z"
                                style="fill:#263238"></path>
                            <path
                                d="M191,118.56S186.41,124,189,133.18a29.69,29.69,0,0,0,9.07,14.23s12.53,18,17.79,20.81,14.57,2.9,33.43-4.76,26.3-18.87,29.19-24.62-14.07-32.26-19.93-36.11a30.74,30.74,0,0,0-19.06-4.49,81.86,81.86,0,0,0-10.68,2Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M224,170.47a17.78,17.78,0,0,1-8.4-1.81c-5.21-2.76-17-19.57-17.93-20.9a30.09,30.09,0,0,1-9.18-14.44c-2.64-9.31,1.84-14.85,2-15.08l.17-.13L228.6,99.75a80.17,80.17,0,0,1,10.84-2,31.41,31.41,0,0,1,19.39,4.57c5.88,3.86,23.22,30.57,20.11,36.75-3.73,7.4-11.86,17.73-29.45,24.87C238.69,168.31,230.35,170.47,224,170.47ZM191.27,119c-.52.7-4.1,5.89-1.78,14.09a29.47,29.47,0,0,0,8.9,14l.1.1c.13.18,12.52,17.95,17.62,20.65,6.2,3.29,17,1.73,33-4.77,17.3-7,25.28-17.14,28.93-24.39,2.62-5.22-13.83-31.57-19.77-35.46a30.33,30.33,0,0,0-18.73-4.42,82.23,82.23,0,0,0-10.6,2Z"
                                style="fill:#263238"></path>
                            <path
                                d="M187.59,115.55s-4.53,5.46-1.93,14.62a29.69,29.69,0,0,0,9.07,14.23s12.53,18,17.79,20.8,14.57,2.9,33.43-4.75,26.29-18.87,29.19-24.63-14.07-32.25-19.93-36.1a30.7,30.7,0,0,0-19.07-4.49,81.92,81.92,0,0,0-10.67,2Z"
                                style="fill:#fff"></path>
                            <path
                                d="M220.69,167.46a17.75,17.75,0,0,1-8.4-1.81c-5.21-2.77-17-19.57-17.93-20.91a30,30,0,0,1-9.18-14.43c-2.64-9.31,1.84-14.85,2-15.08l.17-.13,37.87-18.36a80.17,80.17,0,0,1,10.84-2,31.34,31.34,0,0,1,19.39,4.57c5.88,3.86,23.22,30.57,20.11,36.75-3.73,7.4-11.86,17.73-29.45,24.86C235.34,165.3,227,167.46,220.69,167.46ZM187.92,116c-.52.7-4.1,5.89-1.78,14.09a29.28,29.28,0,0,0,8.9,14l.1.11c.13.18,12.52,17.95,17.62,20.65,6.2,3.29,17,1.72,33-4.77,17.31-7,25.29-17.14,28.93-24.39,2.63-5.22-13.82-31.57-19.76-35.46a30.33,30.33,0,0,0-18.73-4.42,82.23,82.23,0,0,0-10.6,2Z"
                                style="fill:#263238"></path>
                            <circle cx="205.49" cy="97.45" r="28.49" transform="translate(55.47 268.38) rotate(-74.1)"
                                style="fill:currentColor"></circle>
                            <path
                                d="M205.43,126.44a29,29,0,1,1,3.19-.17A28.77,28.77,0,0,1,205.43,126.44Zm.11-57a29,29,0,0,0-3.08.17,27.86,27.86,0,1,0,3.08-.17Z"
                                style="fill:#263238"></path>
                            <circle cx="201.39" cy="90.04" r="32.17" transform="translate(5.98 192.41) rotate(-51.74)"
                                style="fill:#ababab"></circle>
                            <path
                                d="M201.33,122.71a32.67,32.67,0,1,1,32.54-36.2h0a32.69,32.69,0,0,1-29,36A33.37,33.37,0,0,1,201.33,122.71Zm.08-64.35a33.5,33.5,0,0,0-3.44.19,31.67,31.67,0,1,0,34.91,28.07h0A31.72,31.72,0,0,0,201.41,58.36Z"
                                style="fill:#263238"></path>
                            <path
                                d="M223.46,94.59a6.53,6.53,0,0,0,.64-3.39c-.2-2.42-2.91-6.88-4-8.09s-2.87.22-2.87.22l-2-3.59a17.95,17.95,0,1,0-31.37,17.45l4.14,7.45-2.32-3.76s-2.12.73-1.69,2.32,2.79,6.25,4.74,7.69a6.28,6.28,0,0,0,3.45,1.26l5.47,9.83a32.51,32.51,0,0,0,7.25,0,32.13,32.13,0,0,0,24.69-16.46Z"
                                style="fill:#263238"></path>
                            <path
                                d="M201.42,122.7a33.3,33.3,0,0,1-3.86-.22l-.25,0-5.46-9.82a7,7,0,0,1-3.45-1.33c-2.12-1.57-4.49-6.36-4.92-8a2.46,2.46,0,0,1,1.65-2.77l-1.74-3.12A18.45,18.45,0,0,1,215.63,79.5l1.74,3.11a2.37,2.37,0,0,1,3,.16c1.14,1.21,4,5.75,4.17,8.38a7,7,0,0,1-.57,3.42l6.11,11-.13.25a32.71,32.71,0,0,1-25.08,16.71A31.44,31.44,0,0,1,201.42,122.7Zm-3.49-1.19a31.62,31.62,0,0,0,31.06-16l-6.1-11,.12-.24a5.92,5.92,0,0,0,.59-3.12c-.19-2.29-2.84-6.64-3.91-7.78-.79-.85-2.12.21-2.18.26l-.46.37L214.76,80a17.45,17.45,0,1,0-30.49,17l4.14,7.45-.86.5-2.1-3.39c-.47.25-1.22.76-1,1.56.41,1.51,2.71,6.06,4.56,7.42a5.82,5.82,0,0,0,3.18,1.16l.28,0Z"
                                style="fill:#263238"></path>
                            <path
                                d="M215,85.59a13.57,13.57,0,0,0-18.45-5.25l-2.45,1.36a13.57,13.57,0,0,0-5.25,18.45l12.27,22a33.26,33.26,0,0,0,3.71-.18,32.08,32.08,0,0,0,22.88-13.58Z"
                                style="fill:#fff"></path>
                            <path
                                d="M201.42,122.7h-.55l-12.42-22.31a14.08,14.08,0,0,1,5.45-19.13l2.45-1.36a14.07,14.07,0,0,1,19.12,5.45l12.87,23.12-.18.26a32.65,32.65,0,0,1-23.24,13.78A31.31,31.31,0,0,1,201.42,122.7Zm1.75-43.57a13,13,0,0,0-6.33,1.64l-2.45,1.37a13.07,13.07,0,0,0-5.07,17.76l12.14,21.8a31.05,31.05,0,0,0,3.35-.18,31.65,31.65,0,0,0,22.35-13.11L214.6,85.84A13.07,13.07,0,0,0,203.17,79.13Z"
                                style="fill:#263238"></path>
                            <path d="M200,99c.46.83.43,1.73-.07,2s-1.28-.16-1.74-1-.43-1.73.07-2S199.49,98.12,200,99Z"
                                style="fill:#263238"></path>
                            <path
                                d="M210.12,93.29c.46.83.43,1.73-.07,2s-1.28-.17-1.75-1-.42-1.72.08-2S209.66,92.47,210.12,93.29Z"
                                style="fill:#263238"></path>
                            <polygon
                                points="205.81 103.78 205.39 102.87 209.56 100.95 204.74 94.95 205.52 94.32 211.14 101.33 205.81 103.78"
                                style="fill:#263238"></polygon>
                            <path d="M212.88,106.5a1.71,1.71,0,1,1-2.32-.66A1.71,1.71,0,0,1,212.88,106.5Z"
                                style="fill:#263238"></path>
                            <path d="M193.36,97.9l-1-.23s.9-3.54,5.42-3.84l.06,1C194.08,95.08,193.37,97.87,193.36,97.9Z"
                                style="fill:#263238"></path>
                            <path d="M204.88,90.61l-.95-.32s1.3-3.78,6.13-2.73l-.21,1C205.92,87.68,204.92,90.49,204.88,90.61Z"
                                style="fill:#263238"></path>
                            <path
                                d="M211.92,118.42a19.54,19.54,0,0,1-4.67-.69l.27-1a15.9,15.9,0,0,0,5.81.53,8.91,8.91,0,0,0,5.13-2.84,24.1,24.1,0,0,0,2.11-5l1,.31c-.06.16-1.3,4-2.28,5.27a9.77,9.77,0,0,1-5.74,3.21A8.18,8.18,0,0,1,211.92,118.42Z"
                                style="fill:#263238"></path>
                            <path
                                d="M177.72,108.62a32.16,32.16,0,0,1,55-26,32.17,32.17,0,1,0-54.3,29.86A33.08,33.08,0,0,1,177.72,108.62Z"
                                style="fill:#fff"></path>
                            <path
                                d="M179.3,114.15,178,112.88a32.66,32.66,0,1,1,55.14-30.34l.41,1.75L232.34,83a31.66,31.66,0,0,0-54.12,25.56h0a31,31,0,0,0,.67,3.84Zm22.11-55.79a33.2,33.2,0,0,0-3.44.19,31.71,31.71,0,0,0-28.06,34.91,31.36,31.36,0,0,0,7.63,17.41c-.13-.74-.24-1.47-.31-2.2h0a32.66,32.66,0,0,1,54.52-27.62A31.69,31.69,0,0,0,201.41,58.36Z"
                                style="fill:#263238"></path>
                            <ellipse cx="252.7" cy="111.31" rx="14.48" ry="16.36"
                                transform="translate(-10.54 27.94) rotate(-6.2)" style="fill:currentColor"></ellipse>
                            <path
                                d="M253.07,128.15c-7.63,0-14.32-6.53-15.26-15.23a17.89,17.89,0,0,1,3.05-12.3A13.84,13.84,0,0,1,262,98.33,18.39,18.39,0,0,1,264.54,122a13.82,13.82,0,0,1-11.47,6.16Zm-.72-32.69a12.26,12.26,0,0,0-1.36.07,13.15,13.15,0,0,0-9.31,5.67,16.83,16.83,0,0,0-2.88,11.61c.94,8.7,8,15.1,15.62,14.27a13.17,13.17,0,0,0,9.31-5.67,17.43,17.43,0,0,0-2.43-22.35A13.27,13.27,0,0,0,252.35,95.46Z"
                                style="fill:#263238"></path>
                            <path
                                d="M286,98.37A95.31,95.31,0,0,0,265.6,96c-12.64-.3-20.07.92-22.47,7.21s-1.85,16.45,5.94,19.81c4.35,1.87,10.73.79,15.38-.27s16-5.81,19.62-11.52S287.72,101,286,98.37Z"
                                style="fill:#fff"></path>
                            <path
                                d="M255,124.5a15.65,15.65,0,0,1-6.1-1.06c-8.21-3.54-8.55-14.29-6.2-20.45,2.55-6.7,10.35-7.83,23-7.53a97.57,97.57,0,0,1,20.55,2.42l.18.06.11.16c2.06,3.2,1.35,8.07-2,13.36-3.74,6-15.61,10.74-19.93,11.73A43.89,43.89,0,0,1,255,124.5Zm7.19-28.08c-10.14,0-16.44,1.38-18.56,6.93-2.21,5.79-1.94,15.89,5.66,19.17,4.29,1.84,10.66.71,15.08-.3,4.2-1,15.72-5.58,19.31-11.3,3-4.77,3.76-9.28,2.07-12.12a99,99,0,0,0-20.13-2.34C264.4,96.44,263.26,96.42,262.16,96.42Z"
                                style="fill:#263238"></path>
                            <path
                                d="M299.27,108s-4.18-7.53-12-9.63-14.94,3-18.18,8-1.8,6.64-1.8,6.64,11.42-5.72,17.33-6.79S299.27,108,299.27,108Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M267.19,113.63l-.25-.29c-.17-.2-1.59-2.1,1.76-7.24,3.53-5.43,10.91-10.31,18.73-8.21s12.1,9.55,12.28,9.86l.62,1.12-1.21-.4c-.09,0-8.67-2.78-14.38-1.75s-17.09,6.68-17.2,6.74Zm16.47-15.24c-6,0-11.32,4-14.12,8.25-2.15,3.29-2.14,5-2,5.69,2.25-1.1,11.7-5.65,17-6.6,4.66-.84,10.89.65,13.56,1.4-1.48-2.13-5.24-6.74-10.95-8.28A13.44,13.44,0,0,0,283.66,98.39Z"
                                style="fill:#263238"></path>
                            <path
                                d="M267,118.08s-1.84-5.26,5.55-12.09,21-4.37,25.37.19,3.9,12.6.39,16.49a19,19,0,0,1-7,5.1S284.46,116.05,267,118.08Z"
                                style="fill:#fff"></path>
                            <path
                                d="M291.11,128.38l-.21-.36c-.06-.11-6.94-11.41-23.81-9.44l-.4,0-.14-.38c-.07-.23-1.85-5.66,5.69-12.62s21.28-4.75,26.07.2c4.64,4.79,4,13.16.41,17.17a19.36,19.36,0,0,1-7.22,5.24Zm-20.15-11c13.06,0,19.31,8,20.57,9.8a19.46,19.46,0,0,0,6.44-4.82c3.33-3.69,3.89-11.4-.37-15.8-4-4.15-17.21-7.08-24.68-.17-5.91,5.46-5.72,9.89-5.51,11.18A34,34,0,0,1,271,117.35Z"
                                style="fill:#263238"></path>
                            <path
                                d="M260.87,128.42S263.7,121,267,118.08s13.28-4.1,20.7-1.54,6.11,11.1,4.72,13.77-5.64,4.82-5.64,4.82Z"
                                style="fill:#fff"></path>
                            <path
                                d="M286.87,135.66l-26.67-6.9.2-.52c.12-.31,2.91-7.6,6.3-10.53s13.42-4.33,21.19-1.65a8.48,8.48,0,0,1,5.4,5,12.59,12.59,0,0,1-.4,9.49c-1.44,2.79-5.68,4.94-5.85,5Zm-25.33-7.58,25.21,6.52c.78-.42,4.11-2.31,5.26-4.52a11.73,11.73,0,0,0,.35-8.66,7.5,7.5,0,0,0-4.79-4.41c-7.35-2.53-17.07-1.27-20.22,1.45C264.66,120.8,262.25,126.35,261.54,128.08Z"
                                style="fill:#263238"></path>
                            <path
                                d="M261.71,127.21a6.44,6.44,0,0,0-3,1.87,16.52,16.52,0,0,1-5,4c-3,1.73-6.25,1.8-5.06,5s5.63,2.75,7.81,2.23,3.08-1.32,4.76-2.62,2.95-10.26,3-10.7S261.71,127.21,261.71,127.21Z"
                                style="fill:#fff"></path>
                            <path
                                d="M253.4,141.26c-2.05,0-4.39-.57-5.25-2.93-1.06-2.85.93-3.69,3-4.58a20.5,20.5,0,0,0,2.24-1.06,14.42,14.42,0,0,0,4.32-3.34l.6-.62a6.9,6.9,0,0,1,3.27-2c2.48-.54,2.79-.23,2.94-.08l.19.19,0,.35s0,.19-.07.42c-1,6.25-2.05,9.71-3.15,10.57l-.38.29a10.45,10.45,0,0,1-4.57,2.42A14.15,14.15,0,0,1,253.4,141.26Zm8.41-13.56a6,6,0,0,0-2.76,1.72l-.58.62a15.77,15.77,0,0,1-4.55,3.52,23.14,23.14,0,0,1-2.35,1.11c-2.28,1-3.18,1.43-2.49,3.31,1.15,3.1,5.82,2.26,7.23,1.92a9.44,9.44,0,0,0,4.19-2.23l.37-.29c.41-.32,1.48-1.91,2.78-9.94v0a14.82,14.82,0,0,0-1.84.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M269.66,124.24s-4.46-1-6.65.72-2,8.63-1.83,12.81,1.66,7.53,3.26,8a4.16,4.16,0,0,0,3.87-.42c.64-.63,0-6.72.42-11.67S269.66,124.24,269.66,124.24Z"
                                style="fill:#fff"></path>
                            <path
                                d="M266.11,146.59a5.83,5.83,0,0,1-1.83-.29c-1.91-.63-3.42-4.21-3.6-8.51-.24-5.81-.16-11.44,2-13.21,2.35-1.92,6.88-.87,7.07-.82l.43.1-.05.44s-.49,4.58-.93,9.47c-.2,2.32-.16,4.93-.13,7,0,3.37,0,4.5-.42,4.95A3.71,3.71,0,0,1,266.11,146.59Zm.66-22.16a5.57,5.57,0,0,0-3.44.92c-2.1,1.7-1.78,9.2-1.65,12.4.17,4.16,1.65,7.18,2.91,7.6a3.77,3.77,0,0,0,3.37-.3,22.62,22.62,0,0,0,.13-4.23c0-2.12-.07-4.77.14-7.13.36-4,.75-7.77.88-9A14.82,14.82,0,0,0,266.77,124.43Z"
                                style="fill:#263238"></path>
                            <path
                                d="M269.66,124.24a42.4,42.4,0,0,0-2.58,9.81c-.58,5,2.11,11.68,3.15,12.26s4,.41,4.65-1.06.18-6.49.26-9.43,1.49-9.25,1.28-11.19S271.85,122.46,269.66,124.24Z"
                                style="fill:#fff"></path>
                            <path
                                d="M271.8,147.13a3.83,3.83,0,0,1-1.81-.38c-1.37-.77-4-7.91-3.41-12.76a43.14,43.14,0,0,1,2.61-9.94l.05-.12.1-.08a6.7,6.7,0,0,1,6.12-1,2.12,2.12,0,0,1,1.46,1.68,32,32,0,0,1-.61,5.85,53.4,53.4,0,0,0-.67,5.42c0,.93,0,2.07.05,3.28.08,2.69.15,5.23-.35,6.34a2.84,2.84,0,0,1-1.8,1.4A5.7,5.7,0,0,1,271.8,147.13Zm-1.73-22.58a42.51,42.51,0,0,0-2.49,9.56c-.58,5,2.16,11.34,2.9,11.77a4.07,4.07,0,0,0,2.75,0,1.91,1.91,0,0,0,1.2-.87c.41-.89.33-3.55.26-5.89,0-1.22-.07-2.38-.05-3.34a51.86,51.86,0,0,1,.68-5.54,33.27,33.27,0,0,0,.61-5.59c-.05-.45-.49-.72-.85-.87A5.79,5.79,0,0,0,270.07,124.55Z"
                                style="fill:#263238"></path>
                            <path
                                d="M276.42,124.63s2.67-1.27,4.6-.22,2.39,3.94,2.13,5.37-1.17,9.93-1.79,12-2.19,3-3.46,2.9-2.15-1.73-2.35-3.53-.41-5.29-.41-5.29Z"
                                style="fill:#fff"></path>
                            <path
                                d="M278.13,145.15h-.29c-1.65-.18-2.58-2.13-2.78-4s-.42-5.28-.42-5.32L276,124.3l.25-.12c.12-.06,2.92-1.37,5.05-.21s2.65,4.44,2.38,5.9c-.08.45-.24,1.7-.42,3.14a88.89,88.89,0,0,1-1.38,8.88A4.17,4.17,0,0,1,278.13,145.15Zm-2.49-9.27s.22,3.43.41,5.18,1,3,1.9,3.08,2.38-.74,2.94-2.54c.4-1.33,1-5.77,1.33-8.71.2-1.52.35-2.72.44-3.2.21-1.17-.12-3.89-1.88-4.84-1.36-.74-3.23-.14-3.89.13l-1.25,10.9Z"
                                style="fill:#263238"></path>
                            <path
                                d="M283.14,127.12a22.38,22.38,0,0,1,4.65,1.6c1.06.72,1.46,3.06.73,6.64s-1.77,5.66-3.43,5.84-3-1.92-3-3.18S283.45,130,283.14,127.12Z"
                                style="fill:#fff"></path>
                            <path
                                d="M284.88,141.71a2.83,2.83,0,0,1-1.88-.79,4.3,4.3,0,0,1-1.42-2.9c0-.45.15-1.43.35-2.79.36-2.46.92-6.17.71-8l-.08-.71.7.17a22.28,22.28,0,0,1,4.82,1.66c1.33.92,1.67,3.53.93,7.16-.84,4.11-2,6-3.87,6.24Zm-1.2-13.93a51.44,51.44,0,0,1-.76,7.6c-.18,1.21-.34,2.26-.34,2.64a3.27,3.27,0,0,0,1.09,2.15,1.81,1.81,0,0,0,1.36.53c1.3-.14,2.28-1.92,3-5.44.76-3.74.2-5.64-.52-6.13A17.2,17.2,0,0,0,283.68,127.78Z"
                                style="fill:#263238"></path>
                            <path
                                d="M235.68,129.83c2.25,3.63,1.45,8.2-1.78,10.2s-7.68.68-9.93-3-1.46-8.2,1.78-10.2S233.42,126.19,235.68,129.83Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M230.59,141.46a8.46,8.46,0,0,1-7.05-4.12,8.72,8.72,0,0,1-1.23-6.07,7,7,0,0,1,3.17-4.83c3.47-2.14,8.23-.74,10.62,3.12a8.78,8.78,0,0,1,1.24,6.07,7,7,0,0,1-3.18,4.83A6.74,6.74,0,0,1,230.59,141.46Zm-1.53-15a5.77,5.77,0,0,0-3.05.85,6,6,0,0,0-2.72,4.15,7.7,7.7,0,0,0,1.11,5.37c2.1,3.4,6.24,4.65,9.23,2.8a6,6,0,0,0,2.72-4.15,7.71,7.71,0,0,0-1.1-5.37h0A7.44,7.44,0,0,0,229.06,126.44Z"
                                style="fill:#263238"></path>
                            <path
                                d="M218,142.07c1.58,2.55,1,5.75-1.24,7.15s-5.38.48-7-2.07-1-5.75,1.24-7.16S216.38,139.52,218,142.07Z"
                                style="fill:#263238"></path>
                            <path
                                d="M232.46,148.16c1.58,2.55,1,5.75-1.24,7.15s-5.38.48-7-2.07-1-5.75,1.24-7.16S230.89,145.61,232.46,148.16Z"
                                style="fill:#ababab"></path>
                            <path
                                d="M228.89,156.47a5.6,5.6,0,0,1-1.55-.23,6.41,6.41,0,0,1-4.39-7.09,5,5,0,0,1,6.43-4,6.25,6.25,0,0,1,3.51,2.74h0c1.72,2.78,1.09,6.29-1.41,7.84A4.92,4.92,0,0,1,228.89,156.47Zm-1.06-10.54a3.82,3.82,0,0,0-2.06.58,4,4,0,0,0-1.84,2.81,5.41,5.41,0,0,0,3.69,6,4.05,4.05,0,0,0,3.33-.39c2-1.26,2.52-4.16,1.09-6.47h0a5.25,5.25,0,0,0-2.94-2.3A4.35,4.35,0,0,0,227.83,145.93Z"
                                style="fill:#263238"></path>
                        </g>
                    </svg>
                @break

                @case('429')
                    <svg id="svg-color" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 500">
                        <g id="freepik--background-complete--inject-23">
                            <path
                                d="M124.74,159a10.46,10.46,0,0,1,1.78,1.54c1.06,1,2.49,2.4,4,4h-.37l.05-.06c1.52-1.63,2.92-3.09,3.95-4.13a10.29,10.29,0,0,1,1.75-1.61,11.43,11.43,0,0,1-1.48,1.86c-1,1.1-2.32,2.6-3.84,4.24l0,.05-.18.2-.2-.19c-1.56-1.58-2.95-3-3.94-4.08A10.85,10.85,0,0,1,124.74,159Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M130.34,164.49s0-.09,0-.27,0-.46,0-.79c0-.72,0-1.76,0-3.09,0-2.73,0-6.68-.07-11.67,0-10,0-24.24-.09-41l.23.23-41.2,0H62.6v-.25c0-20.74.07-38.68.09-51.46,0-6.36.06-11.44.08-15,0-1.73,0-3.07,0-4,0-.44,0-.78,0-1s0-.35,0-.35a1.35,1.35,0,0,1,0,.35c0,.25,0,.59,0,1,0,.93,0,2.27,0,4,0,3.51,0,8.59.07,15,0,12.78.06,30.72.09,51.46l-.25-.25H89.14l41.2,0h.24v.24c0,16.8-.07,31-.09,41,0,5-.05,8.94-.07,11.67,0,1.33,0,2.37,0,3.09,0,.33,0,.6,0,.79A.8.8,0,0,1,130.34,164.49Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M105.73,243.76c0,.14-17.65.26-39.41.26s-39.42-.12-39.42-.26,17.65-.26,39.42-.26S105.73,243.62,105.73,243.76Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M100,249.41a10.63,10.63,0,0,1,1.53-1.78c1-1.06,2.4-2.49,4-4V244l0,0c-1.64-1.52-3.1-2.92-4.14-4a10.29,10.29,0,0,1-1.61-1.75,10.94,10.94,0,0,1,1.86,1.48c1.1,1,2.6,2.32,4.24,3.84l.05,0,.2.18-.19.2c-1.58,1.56-3,3-4.08,3.94A11.08,11.08,0,0,1,100,249.41Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M100,307.69a11.13,11.13,0,0,1,1.53-1.78c1-1.05,2.4-2.49,4-4.05v.38l0-.05c-1.64-1.52-3.1-2.92-4.14-3.95a10.75,10.75,0,0,1-1.61-1.75,10.94,10.94,0,0,1,1.86,1.48c1.1,1,2.6,2.32,4.24,3.84l.05.05.2.18-.19.19c-1.58,1.56-3,2.95-4.08,3.94A10.46,10.46,0,0,1,100,307.69Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M106.63,369.92l-.39,0-1.12,0-4.32,0-15.88.08-52.41.08H26.9l.26-.26c0,19.17-.06,36.29-.08,48.65,0,6.14-.06,11.1-.08,14.56,0,1.69,0,3-.05,3.94,0,.42,0,.76,0,1a1.6,1.6,0,0,1,0,.35,2.37,2.37,0,0,1,0-.35q0-.39,0-1c0-.93,0-2.25,0-3.94,0-3.46,0-8.42-.08-14.56,0-12.36-.05-29.48-.09-48.65v-.26h5.87l52.41.07,15.88.09,4.32.05,1.12,0A1.93,1.93,0,0,1,106.63,369.92Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M100.94,364.27a11.08,11.08,0,0,1,1.79,1.52c1.06,1,2.51,2.38,4.08,3.94l.19.19-.2.19,0,.05c-1.63,1.52-3.14,2.88-4.24,3.84a10.94,10.94,0,0,1-1.86,1.48,10.29,10.29,0,0,1,1.61-1.75c1-1,2.5-2.43,4.14-4l0,0v.37c-1.57-1.56-3-3-4-4.05A10.63,10.63,0,0,1,100.94,364.27Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M99.08,408.83a10.46,10.46,0,0,1,1.79,1.52c1.07,1,2.51,2.38,4.08,3.94l.19.19-.19.19-.06.05c-1.63,1.52-3.13,2.87-4.24,3.83A9.78,9.78,0,0,1,98.79,420a11.66,11.66,0,0,1,1.61-1.74c1-1,2.5-2.43,4.14-4l0,0v.37c-1.58-1.56-3-3-4-4.05A10.46,10.46,0,0,1,99.08,408.83Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M19.29,92.53a.84.84,0,0,1,.28,0l.84,0,3.25,0,12.26-.07h.15v.15c0,16.43.06,43.7.11,74.56,0,7.85,0,15.46,0,22.6l-.25-.25,49.11.09,14.32.07,3.84.05,1,0,.33,0a1.19,1.19,0,0,1-.33,0l-1,0-3.84,0L85,189.85l-49.11.09h-.26V167.09c0-30.86.08-58.13.11-74.56l.15.15-12.26-.07-3.25,0-.84,0Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M19.29,302.09c0-.14,19.35-.26,43.21-.26s43.23.12,43.23.26-19.35.26-43.23.26S19.29,302.24,19.29,302.09Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M62.85,467.36a.67.67,0,0,1,0-.25l0-.71c0-.68,0-1.6,0-2.77,0-2.44,0-5.9-.08-10.16,0-8.62-.05-20.46-.08-33.53v-5.77h.26l29.82.09,8.87.08,2.4,0a5.43,5.43,0,0,1,.83.05,5.43,5.43,0,0,1-.83.05l-2.4,0-8.87.07-29.82.09.26-.26v5.51c0,13.07,0,24.91-.07,33.53,0,4.26-.07,7.72-.09,10.16,0,1.17,0,2.09,0,2.77l0,.71A.79.79,0,0,1,62.85,467.36Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M98.83,195.41a10.63,10.63,0,0,1,1.53-1.78c1-1.06,2.4-2.49,4-4V190l-.06,0c-1.63-1.52-3.09-2.92-4.13-4a10.29,10.29,0,0,1-1.61-1.75,10.94,10.94,0,0,1,1.86,1.48c1.1,1,2.6,2.32,4.24,3.84l0,0,.2.18-.19.2c-1.58,1.56-3,3-4.08,3.94A11.08,11.08,0,0,1,98.83,195.41Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M373,159.06a10.46,10.46,0,0,1-1.52,1.79c-1,1.07-2.38,2.51-3.94,4.08l-.19.19-.19-.19-.05-.06c-1.52-1.63-2.87-3.13-3.84-4.24a9.94,9.94,0,0,1-1.47-1.86,11,11,0,0,1,1.74,1.61c1,1,2.43,2.5,3.95,4.14l.05,0h-.37c1.56-1.58,3-3,4.05-4A10.46,10.46,0,0,1,373,159.06Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M367.35,164.52a1.39,1.39,0,0,1,0-.27c0-.19,0-.45,0-.79,0-.71,0-1.74,0-3.07,0-2.7,0-6.63-.06-11.61,0-10-.06-24.21-.09-41.13v-.23h.23l47.09,0h20.4l-.26.25c0-23.82.07-44.7.09-59.66,0-7.45.06-13.42.08-17.55,0-2,0-3.62,0-4.72,0-.52,0-.92,0-1.22a3.24,3.24,0,0,1,0-.41,3.24,3.24,0,0,1,0,.41c0,.3,0,.7,0,1.22,0,1.1,0,2.68,0,4.72,0,4.13,0,10.1.08,17.55,0,15,.05,35.84.08,59.66v.26H414.44l-47.09,0,.23-.23c0,16.92-.07,31.13-.09,41.13,0,5-.05,8.91-.07,11.61,0,1.33,0,2.36,0,3.07,0,.34,0,.6,0,.79S367.35,164.52,367.35,164.52Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M392,243.79c0-.15,19.15-.26,42.76-.26s42.77.11,42.77.26-19.14.26-42.77.26S392,243.93,392,243.79Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M397.66,249.43a9.34,9.34,0,0,1-1.8-1.52c-1.06-1-2.5-2.38-4.08-3.94l-.19-.19.2-.18,0,0c1.64-1.52,3.14-2.88,4.24-3.84a11.43,11.43,0,0,1,1.86-1.48,10.75,10.75,0,0,1-1.61,1.75c-1,1-2.5,2.43-4.13,4l-.06,0v-.38c1.57,1.56,3,3,4,4.05A10.94,10.94,0,0,1,397.66,249.43Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M397.66,307.72a9.84,9.84,0,0,1-1.8-1.52c-1.06-1-2.5-2.38-4.08-3.94l-.19-.19.2-.19,0-.05c1.64-1.52,3.14-2.87,4.24-3.84a10.33,10.33,0,0,1,1.86-1.47,11,11,0,0,1-1.61,1.74c-1,1-2.5,2.43-4.13,3.95l-.06.05v-.37c1.57,1.56,3,3,4,4.05A10.46,10.46,0,0,1,397.66,307.72Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M391.07,369.94l.35,0,1,0,4,0,14.92-.08,50.37-.08H462v.25c0,3.79,0,7.76,0,11.8,0,22-.06,42-.08,56.72l-.18-.19,18.86.09,5.13.05,1.34,0,.45,0a2.56,2.56,0,0,1-.45,0l-1.34,0-5.13.05-18.86.08h-.19v-.19c0-14.7,0-34.7-.07-56.72v-11.8l.26.26-50.37-.08L396.49,370l-4-.05-1,0Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M396.75,364.3a10.5,10.5,0,0,1-1.53,1.78c-1,1.05-2.4,2.49-4,4.05v-.38l.06.05c1.63,1.52,3.09,2.92,4.13,3.95A11.27,11.27,0,0,1,397,375.5a10.16,10.16,0,0,1-1.86-1.48c-1.1-1-2.6-2.31-4.24-3.84l-.05,0-.2-.19.19-.19c1.58-1.56,3-2.95,4.08-3.94A10.46,10.46,0,0,1,396.75,364.3Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M398.61,408.85a10.42,10.42,0,0,1-1.53,1.79c-1,1.05-2.4,2.48-4,4.05v-.38l0,.05c1.64,1.52,3.1,2.92,4.14,3.95a10.75,10.75,0,0,1,1.61,1.75,10.94,10.94,0,0,1-1.86-1.48c-1.11-1-2.61-2.32-4.24-3.84l-.05-.05-.2-.18.19-.19c1.57-1.56,3-3,4.08-3.94A10.89,10.89,0,0,1,398.61,408.85Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M487.56,92.55l-.45,0-1.32,0-5.09.05-18.92.08.17-.18c0,17.31.05,42.27.09,70,0,9.51,0,18.69,0,27.18V190h-.25l-49.21-.1-14.26-.07-3.82,0-1,0-.33,0a1.19,1.19,0,0,1,.33,0l1,0,3.82,0,14.26-.07,49.21-.09-.25.25c0-8.49,0-17.67,0-27.18,0-27.72.06-52.68.08-70v-.18h.18l18.92.08,5.09,0,1.32,0Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M487.56,302.12c0,.14-21.4.26-47.79.26s-47.8-.12-47.8-.26,21.39-.26,47.8-.26S487.56,302,487.56,302.12Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M434.84,467.39a.87.87,0,0,1,0-.25c0-.19,0-.43,0-.72,0-.67,0-1.59-.05-2.76,0-2.45-.05-5.91-.08-10.16,0-8.62-.05-20.46-.08-33.53v-5.51l.26.26L405,414.63l-8.87-.08-2.4,0a7.83,7.83,0,0,1-.83-.05,4.16,4.16,0,0,1,.83,0l2.4-.05,8.87-.08,29.82-.08h.26V420c0,13.07-.06,24.91-.08,33.53,0,4.25-.06,7.71-.08,10.16,0,1.17,0,2.09-.05,2.76,0,.29,0,.53,0,.72A.87.87,0,0,1,434.84,467.39Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M398.87,195.43a10.25,10.25,0,0,1-1.8-1.52c-1.06-1-2.5-2.38-4.08-3.94l-.19-.19.2-.18.05,0c1.64-1.52,3.14-2.88,4.24-3.84a11.43,11.43,0,0,1,1.86-1.48,10.75,10.75,0,0,1-1.61,1.75c-1,1-2.5,2.43-4.13,4l-.05,0v-.38c1.57,1.56,3,3,4,4.05A10.94,10.94,0,0,1,398.87,195.43Z"
                                style="fill:#e0e0e0"></path>
                        </g>
                        <g id="freepik--Sign--inject-23">
                            <rect x="103.35" y="37.84" width="215.24" height="121.07"
                                transform="translate(-4.89 11.25) rotate(-3.02)" style="fill:#fff"></rect>
                            <path
                                d="M321.63,153.16s-.05-.74-.13-2.17-.2-3.54-.35-6.31c-.31-5.54-.75-13.69-1.33-24.16-1.13-20.93-2.76-51.13-4.76-88.25l.21.18L100.34,43.85h0l.24-.27c2.25,42.76,4.4,83.65,6.36,120.91l-.25-.23,154.62-8,44.4-2.28,11.83-.59,3.06-.15,1,0-1,.07-3,.17-11.78.65-44.34,2.41L106.7,164.74h-.23l0-.24c-2-37.25-4.13-78.14-6.39-120.9v-.25l.25,0h0L315.25,32.06h.19v.2c1.92,37.17,3.48,67.42,4.56,88.38.53,10.45.94,18.59,1.22,24.12.14,2.76.24,4.86.31,6.28S321.63,153.16,321.63,153.16Z"
                                style="fill:#263238"></path>
                            <path d="M307.62,47.75a5,5,0,1,1-4.55-5.47A5,5,0,0,1,307.62,47.75Z" style="fill:#e0e0e0"></path>
                            <path
                                d="M307.62,47.75c-.05,0,0-.45-.15-1.22a5.05,5.05,0,0,0-1.6-2.79,4.78,4.78,0,1,0-.7,7.64,5,5,0,0,0,2.07-2.45c.29-.74.33-1.18.38-1.18s0,.12,0,.33a3.35,3.35,0,0,1-.17.92,5.06,5.06,0,0,1-2.08,2.73,5.18,5.18,0,0,1-5,.35,5.28,5.28,0,0,1,.91-9.91,5.2,5.2,0,0,1,4.88,1.27,5,5,0,0,1,1.54,3.06,4,4,0,0,1,0,.93C307.66,47.65,307.64,47.76,307.62,47.75Z"
                                style="fill:#263238"></path>
                            <path
                                d="M305.3,43.92a5.72,5.72,0,0,1-1.2,3.78,5.66,5.66,0,0,1-3.05,2.53,29,29,0,0,0,2.57-2.85C304.81,45.63,305.12,43.89,305.3,43.92Z"
                                style="fill:#263238"></path>
                            <path
                                d="M305.58,49.34c-.16.06-.64-1.34-2-2.31a11,11,0,0,0-2.87-1.12c0-.07.36-.19,1-.15a4.52,4.52,0,0,1,3.75,2.62C305.63,48.94,305.65,49.32,305.58,49.34Z"
                                style="fill:#263238"></path>
                            <path d="M118.83,59.72a5,5,0,1,1-4.55-5.47A5,5,0,0,1,118.83,59.72Z" style="fill:#e0e0e0"></path>
                            <path
                                d="M118.83,59.72s0-.45-.15-1.22a5.05,5.05,0,0,0-1.6-2.79,4.79,4.79,0,1,0-5.29,7.86,4.86,4.86,0,0,0,4.59-.22,5.07,5.07,0,0,0,2.08-2.46c.28-.73.32-1.18.37-1.17s0,.12,0,.33a3.35,3.35,0,0,1-.17.92,5.08,5.08,0,0,1-2.07,2.73,5.2,5.2,0,0,1-5,.35,5.28,5.28,0,0,1,.91-9.91,5.2,5.2,0,0,1,4.88,1.27,5,5,0,0,1,1.54,3.06,3.15,3.15,0,0,1,0,.93C118.88,59.62,118.85,59.72,118.83,59.72Z"
                                style="fill:#263238"></path>
                            <path
                                d="M116.51,55.89a5.66,5.66,0,0,1-1.2,3.78,5.69,5.69,0,0,1-3,2.53c-.1-.15,1.4-1.09,2.56-2.86A27.34,27.34,0,0,0,116.51,55.89Z"
                                style="fill:#263238"></path>
                            <path
                                d="M116.79,61.31c-.16.06-.64-1.34-2-2.31a10.86,10.86,0,0,0-2.87-1.12c0-.07.36-.19,1-.15a4.33,4.33,0,0,1,2.23.8,4.42,4.42,0,0,1,1.52,1.82C116.84,60.91,116.86,61.29,116.79,61.31Z"
                                style="fill:#263238"></path>
                            <path d="M130.25,135.36l-3.57.22-.08-1.31,8.61-.53.08,1.3-3.57.23.57,9.19-1.47.09Z"
                                style="fill:#263238"></path>
                            <path
                                d="M136.16,139a5.54,5.54,0,1,1,5.87,5A5.31,5.31,0,0,1,136.16,139Zm9.57-.59a4.05,4.05,0,1,0-3.78,4.28A3.94,3.94,0,0,0,145.73,138.36Z"
                                style="fill:#263238"></path>
                            <path
                                d="M148.64,138.18a5.54,5.54,0,1,1,5.88,5A5.32,5.32,0,0,1,148.64,138.18Zm9.57-.6a4,4,0,1,0-3.78,4.29A3.93,3.93,0,0,0,158.21,137.58Z"
                                style="fill:#263238"></path>
                            <path
                                d="M175.94,141.76l-.49-7.65-3.37,6.6-.68,0-4.15-6.1.47,7.61-1.43.08-.65-10.5,1.22-.07,4.8,7.11,3.82-7.65,1.22-.07.66,10.5Z"
                                style="fill:#263238"></path>
                            <path
                                d="M187,138.44l-5.53.34-1,2.7-1.53.09L183,130.78l1.47-.09,5.38,10.2-1.56.1Zm-.6-1.17-2.56-5-1.92,5.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M199.66,129.74l.65,10.5-1.22.08-6.73-7.44.49,7.83-1.49.09-.65-10.5,1.22-.08,6.73,7.45-.49-7.83Z"
                                style="fill:#263238"></path>
                            <path d="M207.18,136.17l.23,3.63-1.47.1-.23-3.66-4.56-6.59,1.6-.1,3.67,5.33,3-5.74,1.47-.09Z"
                                style="fill:#263238"></path>
                            <path
                                d="M224,138.78l-2.44-3.09c-.21,0-.43.06-.65.07l-2.57.16.19,3.2-1.48.09-.65-10.5,4.05-.26c2.71-.16,4.43,1.12,4.57,3.4a3.31,3.31,0,0,1-2.08,3.45l2.68,3.38Zm-.46-6.84c-.1-1.5-1.15-2.29-3.05-2.18l-2.53.16.3,4.72,2.52-.15C222.68,134.37,223.62,133.44,223.53,131.94Z"
                                style="fill:#263238"></path>
                            <path
                                d="M235.31,136.76l.08,1.31-7.55.47-.65-10.5,7.34-.46.08,1.31-5.85.36.2,3.22,5.21-.32.08,1.28-5.21.32.21,3.39Z"
                                style="fill:#263238"></path>
                            <path
                                d="M248.53,138.22a3.32,3.32,0,0,1-2.54,1.39c-1.31.08-2.37-.43-3.92-1.85a5.39,5.39,0,1,1,5.57-5.72,5.22,5.22,0,0,1-3.77,5.46,2.69,2.69,0,0,0,2.06.92,2.46,2.46,0,0,0,1.85-1Zm-6.16-1.8a4,4,0,1,0-4.3-3.79A3.94,3.94,0,0,0,242.37,136.42Z"
                                style="fill:#263238"></path>
                            <path
                                d="M249.86,132.62l-.37-6,1.49-.09.37,5.91c.14,2.33,1.26,3.31,3.13,3.2s2.88-1.24,2.74-3.56l-.37-5.91,1.44-.09.37,6c.19,3-1.36,4.75-4.11,4.92S250.05,135.67,249.86,132.62Z"
                                style="fill:#263238"></path>
                            <path
                                d="M269.46,134.65l.08,1.3-7.55.47-.65-10.5,7.34-.46.08,1.31-5.85.36.2,3.23,5.21-.33.08,1.28-5.22.32.22,3.39Z"
                                style="fill:#263238"></path>
                            <path
                                d="M270.92,134.66l.48-1.2a5.32,5.32,0,0,0,3.51,1c1.79-.11,2.52-.86,2.47-1.78-.16-2.56-6.36-.55-6.61-4.45-.1-1.62,1.07-3.08,3.8-3.25a6,6,0,0,1,3.4.72l-.41,1.23a5.43,5.43,0,0,0-2.91-.68c-1.77.11-2.48.91-2.42,1.83.16,2.56,6.36.56,6.6,4.42.1,1.6-1.1,3.06-3.85,3.23A6.14,6.14,0,0,1,270.92,134.66Z"
                                style="fill:#263238"></path>
                            <path d="M282.52,125.92l-3.57.22-.08-1.31,8.61-.53.08,1.3-3.57.23.57,9.19-1.47.09Z"
                                style="fill:#263238"></path>
                            <path
                                d="M288.59,133.57l.48-1.21a5.26,5.26,0,0,0,3.5,1c1.8-.11,2.53-.86,2.48-1.78-.16-2.56-6.37-.55-6.61-4.45-.1-1.62,1.07-3.08,3.8-3.25a6.1,6.1,0,0,1,3.4.73l-.41,1.23a5.34,5.34,0,0,0-2.91-.68c-1.77.11-2.48.9-2.42,1.82.15,2.57,6.36.57,6.6,4.42.1,1.61-1.1,3.07-3.85,3.24A6.18,6.18,0,0,1,288.59,133.57Z"
                                style="fill:#263238"></path>
                            <path
                                d="M190.68,65.56l.11,2.11-8.73.45-.58-11.37,8.51-.44.11,2.12-5.92.3.13,2.47,5.23-.27.1,2-5.23.26.14,2.64Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M200,67.2l-2.33-3.06h-.13l-2.27.12.16,3.16-2.6.14-.59-11.37,4.88-.25c3-.16,5,1.32,5.1,3.87a3.7,3.7,0,0,1-2.13,3.71l2.71,3.53Zm-2.92-9.1-2.12.11.2,4,2.13-.11c1.59-.08,2.36-.87,2.29-2.1S198.72,58,197.12,58.1Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M211.87,66.59l-2.33-3.05h-.13l-2.27.12.16,3.17-2.6.13-.59-11.37,4.88-.25c3-.15,5,1.32,5.1,3.87A3.7,3.7,0,0,1,212,62.92l2.71,3.53ZM209,57.49l-2.13.11.2,4,2.13-.11c1.59-.08,2.36-.87,2.29-2.1S210.55,57.41,209,57.49Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M215.53,60.7A6.18,6.18,0,1,1,222,66.27,5.86,5.86,0,0,1,215.53,60.7Zm9.69-.49A3.53,3.53,0,1,0,221.88,64,3.46,3.46,0,0,0,225.22,60.21Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M237.29,65.29,235,62.23h-.13l-2.27.12.16,3.16-2.6.14-.59-11.37,4.88-.25c3-.16,5,1.32,5.1,3.87a3.7,3.7,0,0,1-2.13,3.71l2.71,3.53Zm-2.92-9.1-2.12.11.2,4,2.13-.11c1.59-.08,2.36-.87,2.29-2.1S236,56.11,234.37,56.19Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M191.77,110.82l-6.86.43.55,8.84-12.73.8-.55-8.84-24.4,1.53-.54-8.51L166.15,75l13.52-.85-17.11,28.16,9.37-.59-.49-7.85,12.33-.77.49,7.85,6.86-.43Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M229.93,106.91l.65,10.36-36,2.25-.51-8.18L210.39,94.1c3.48-3.66,3.87-5.81,3.75-7.72-.18-3-2.27-4.62-6.23-4.38a9.48,9.48,0,0,0-8,5l-10-4.8c3.14-6,9.43-10.25,18.53-10.82,10.62-.67,18.28,4.35,18.82,12.92.28,4.49-.72,8.66-6.94,15.14l-8.2,8.59Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M271.2,90.29c1,16.1-8.38,25.89-23,26.81-5.14.32-10.23-.56-13.73-2.52l4.16-9.67a14.31,14.31,0,0,0,8.66,1.85c6.53-.41,10.65-4.38,10.94-11.41-2.44,2.33-5.79,3.73-10.15,4-8.7.54-16.25-4.75-16.8-13.59-.61-9.63,7.06-16.26,17.08-16.89C261.34,68.07,270.27,75.32,271.2,90.29Zm-14.59-6.76c-.22-3.43-2.87-5.65-6.83-5.4-3.69.23-6.12,2.63-5.9,6.26s2.94,5.64,6.7,5.41S256.83,87,256.61,83.53Z"
                                style="fill:currentColor"></path>
                        </g>
                        <g id="freepik--Server--inject-23">
                            <path
                                d="M85.53,262a54.26,54.26,0,0,0,2.2,6.49,52.17,52.17,0,0,0,3.44,5.92A6.69,6.69,0,0,1,89.8,273a22.38,22.38,0,0,1-4-8.89A6.44,6.44,0,0,1,85.53,262Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M83.59,262.42a66.61,66.61,0,0,0,2.9,6.52,70.39,70.39,0,0,0,4,5.91A7.64,7.64,0,0,1,89,273.37a25.86,25.86,0,0,1-2.9-4.2,25.07,25.07,0,0,1-2-4.69A7.85,7.85,0,0,1,83.59,262.42Z"
                                style="fill:#455a64"></path>
                            <path d="M88.31,264.31c.15,0,.18,2,.87,4.43s1.71,4.15,1.59,4.22a12.28,12.28,0,0,1-2.46-8.65Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M101,340.16a29.77,29.77,0,0,0,2.2,5,32.6,32.6,0,0,0,3.43,4.21,10.73,10.73,0,0,1-3.84-3.95A10.61,10.61,0,0,1,101,340.16Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M99.86,340.42a43.87,43.87,0,0,1,2,5,48.65,48.65,0,0,1,1.83,5.08,35.21,35.21,0,0,1-3.78-10.11Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M122.85,311.94l-1.17,4.47a9.91,9.91,0,0,0-10.28,3.38A8.51,8.51,0,0,1,118,324.7a7.25,7.25,0,0,1-.38,6.14,6.4,6.4,0,0,1-4.37,3.36,7.26,7.26,0,0,1-7.42-3.58,9.08,9.08,0,0,1-1.15-3.39l-.27.34a12.38,12.38,0,0,0-.37,13.94l-3.82,2.6a16.93,16.93,0,0,1,.52-19.35,13.72,13.72,0,0,1,4.83-4,14.59,14.59,0,0,1,17.3-8.8Zm-13.68,13.77a5,5,0,0,0,.62,2.55,2.71,2.71,0,0,0,2.55,1.41,1.94,1.94,0,0,0,1.19-1,2.7,2.7,0,0,0,.18-2.19,4.16,4.16,0,0,0-4.23-2.14l-.18,0A7.26,7.26,0,0,0,109.17,325.71Z"
                                style="fill:#263238"></path>
                            <path d="M123.62,285.88c-13,1.63-28.11-2.62-35.38-13l2-2.46s7.66,12.86,33.48,11.92"
                                style="fill:#263238"></path>
                            <path d="M93.47,274a13.18,13.18,0,0,1-2.26,2.46A13.18,13.18,0,0,1,93.47,274Z" style="fill:#455a64">
                            </path>
                            <path
                                d="M96.47,276.35a6.9,6.9,0,0,1-1,1.4A7.52,7.52,0,0,1,94.35,279a7,7,0,0,1,1-1.41A6.78,6.78,0,0,1,96.47,276.35Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M100.13,278.21a6.32,6.32,0,0,1-.8,1.62,6,6,0,0,1-1.08,1.44,11.5,11.5,0,0,1,.9-1.55A11.33,11.33,0,0,1,100.13,278.21Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M102,283.19a8.9,8.9,0,0,1,.69-1.77,8.43,8.43,0,0,1,.89-1.69,8.85,8.85,0,0,1-.7,1.77A9,9,0,0,1,102,283.19Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M106,284.37a7.85,7.85,0,0,1,.59-1.77,8.93,8.93,0,0,1,.78-1.7,8,8,0,0,1-.59,1.77A8.24,8.24,0,0,1,106,284.37Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M109.76,285.25a9.12,9.12,0,0,1,.35-1.88,8.4,8.4,0,0,1,.55-1.83,9.35,9.35,0,0,1-.35,1.88A8.21,8.21,0,0,1,109.76,285.25Z"
                                style="fill:#455a64"></path>
                            <path d="M113.58,285.8a8.5,8.5,0,0,1,.21-1.87,9.43,9.43,0,0,1,.42-1.83,16.53,16.53,0,0,1-.63,3.7Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M117.12,286a15.25,15.25,0,0,1,.22-1.8c.13-1,.16-1.79.22-1.79a5,5,0,0,1,0,1.82A5.34,5.34,0,0,1,117.12,286Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M102.8,339.34a13,13,0,0,1-2.07.94,13.87,13.87,0,0,1-2.16.75,11.53,11.53,0,0,1,2.08-.94A12.47,12.47,0,0,1,102.8,339.34Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M102.14,336.53a12.59,12.59,0,0,1-2.25.5,11.66,11.66,0,0,1-2.28.3,13.43,13.43,0,0,1,2.24-.5A12.71,12.71,0,0,1,102.14,336.53Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M102.17,333.47a12.57,12.57,0,0,1-2.3,0,12.42,12.42,0,0,1-2.3-.18,12.77,12.77,0,0,1,2.31,0A13.49,13.49,0,0,1,102.17,333.47Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M102.6,330.82a12,12,0,0,1-2.06-.77,11.81,11.81,0,0,1-2-1,11.94,11.94,0,0,1,2.06.78A11.84,11.84,0,0,1,102.6,330.82Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M104.13,327.4a5.85,5.85,0,0,1-1.74-1.12,6.24,6.24,0,0,1-1.41-1.52s.68.63,1.54,1.36S104.16,327.35,104.13,327.4Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M104.74,327.84a5,5,0,0,1-.09-1,16.88,16.88,0,0,1,.13-2.5,16.22,16.22,0,0,1,.47-2.45,4.57,4.57,0,0,1,.33-1,6.26,6.26,0,0,1-.19,1c-.13.62-.29,1.49-.41,2.45s-.16,1.84-.18,2.47A5.91,5.91,0,0,1,104.74,327.84Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M111.91,319.37a14.75,14.75,0,0,0-1.69,2.48,15.79,15.79,0,0,0-1,2.84,2.61,2.61,0,0,1,.08-.89,8.35,8.35,0,0,1,1.92-3.83A2.75,2.75,0,0,1,111.91,319.37Z"
                                style="fill:#455a64"></path>
                            <path d="M104.89,323.44a2.19,2.19,0,0,1-.51-.78,2,2,0,0,1-.33-.87,4.31,4.31,0,0,1,.84,1.65Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M109.74,328.29c0,.06-1,.26-2.11.77s-1.93,1.1-2,1.05a5.37,5.37,0,0,1,1.89-1.24A5.58,5.58,0,0,1,109.74,328.29Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M108.82,333.54a26.77,26.77,0,0,1,2.28-4.1,13.16,13.16,0,0,1-1,2.1A12.82,12.82,0,0,1,108.82,333.54Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M113.7,334a21.51,21.51,0,0,1-.51-2.24c-.27-1.24-.53-2.23-.48-2.25a8.78,8.78,0,0,1,.68,2.2A9.23,9.23,0,0,1,113.7,334Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M118.07,329.47a11.92,11.92,0,0,1-2.13-.64,11.56,11.56,0,0,1-2.07-.83,12.15,12.15,0,0,1,2.14.64A10.89,10.89,0,0,1,118.07,329.47Z"
                                style="fill:#455a64"></path>
                            <path d="M117.79,324.31c0,.06-1,.34-2.16.81s-2.11.92-2.14.87a11.07,11.07,0,0,1,4.3-1.68Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M113.48,320.32c.06,0-.49.93-1,2.09s-.88,2.16-.94,2.14a7.85,7.85,0,0,1,.75-2.22A7.6,7.6,0,0,1,113.48,320.32Z"
                                style="fill:#455a64"></path>
                            <path d="M109,324.74c0,.06-.91.09-2,.23s-2,.34-2,.28a6.38,6.38,0,0,1,2-.48A6,6,0,0,1,109,324.74Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M110.21,321.28c0,.06-1-.16-2.25-.27s-2.25-.07-2.25-.14a6.85,6.85,0,0,1,2.27-.07A7,7,0,0,1,110.21,321.28Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M113.12,318.24c0,.06-1-.52-2.38-1s-2.5-.62-2.49-.68a2.21,2.21,0,0,1,.76.05,9.64,9.64,0,0,1,1.79.43,10.81,10.81,0,0,1,1.69.75A2.78,2.78,0,0,1,113.12,318.24Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M115.49,316.84c-.06,0-.36-1-1-2.08s-1.31-1.88-1.26-1.92a5.88,5.88,0,0,1,1.44,1.82A5.67,5.67,0,0,1,115.49,316.84Z"
                                style="fill:#455a64"></path>
                            <path d="M118.67,311.51a6.18,6.18,0,0,1,.49,4.59,11.39,11.39,0,0,0-.49-4.59Z" style="fill:#455a64">
                            </path>
                            <path
                                d="M394.6,269.43a31.44,31.44,0,0,0-2.21-5,30.77,30.77,0,0,0-3.43-4.21,12.71,12.71,0,0,1,5.64,9.17Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M395.75,269.18a50.75,50.75,0,0,1-1.95-5,46.27,46.27,0,0,1-1.82-5.08,23.09,23.09,0,0,1,2.27,4.91A22.8,22.8,0,0,1,395.75,269.18Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M372.77,297.65l1.17-4.47a10.2,10.2,0,0,0,7.83-1.2,9.79,9.79,0,0,0,2.45-2.18,8.51,8.51,0,0,1-6.59-4.91,7.25,7.25,0,0,1,.39-6.14,6.4,6.4,0,0,1,4.37-3.36A7.24,7.24,0,0,1,389.8,279a9.27,9.27,0,0,1,1.16,3.39l.26-.34a12.37,12.37,0,0,0,.38-13.94l3.82-2.6a17,17,0,0,1-.53,19.35,13.58,13.58,0,0,1-4.82,4,14.61,14.61,0,0,1-17.3,8.8Zm13.67-13.77a5,5,0,0,0-.62-2.55,2.66,2.66,0,0,0-2.54-1.4,1.87,1.87,0,0,0-1.19,1,2.7,2.7,0,0,0-.19,2.19,4.16,4.16,0,0,0,4.24,2.14l.18,0A8.17,8.17,0,0,0,386.44,283.88Z"
                                style="fill:#263238"></path>
                            <path
                                d="M392.82,270.25a12.53,12.53,0,0,1,2.07-.94,12.19,12.19,0,0,1,2.15-.74,12.54,12.54,0,0,1-2.07.93A12.79,12.79,0,0,1,392.82,270.25Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M393.48,273.06a12.59,12.59,0,0,1,2.25-.5,11.66,11.66,0,0,1,2.28-.3,13.72,13.72,0,0,1-2.25.5A12.65,12.65,0,0,1,393.48,273.06Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M393.45,276.12a12.46,12.46,0,0,1,2.3,0,13.21,13.21,0,0,1,2.29.18,12.57,12.57,0,0,1-2.3,0A12.37,12.37,0,0,1,393.45,276.12Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M393,278.77a22.33,22.33,0,0,1,4,1.74,12.85,12.85,0,0,1-2.05-.77A11.81,11.81,0,0,1,393,278.77Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M391.49,282.19a6.26,6.26,0,0,1,1.74,1.12,6.07,6.07,0,0,1,1.4,1.52s-.67-.63-1.54-1.36S391.46,282.25,391.49,282.19Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M390.87,281.75a3.94,3.94,0,0,1,.1,1,18.37,18.37,0,0,1-.13,2.5,18.05,18.05,0,0,1-.47,2.46,4.25,4.25,0,0,1-.34,1,9.61,9.61,0,0,1,.2-1c.13-.62.29-1.48.4-2.45s.17-1.83.19-2.47A6.79,6.79,0,0,1,390.87,281.75Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M383.7,290.23a14.94,14.94,0,0,0,1.69-2.49,15.13,15.13,0,0,0,1-2.84,2.82,2.82,0,0,1-.09.89,8,8,0,0,1-1.92,3.83A3,3,0,0,1,383.7,290.23Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M390.73,286.15a4.31,4.31,0,0,1,.84,1.65c-.05,0-.28-.32-.52-.78S390.67,286.18,390.73,286.15Z"
                                style="fill:#455a64"></path>
                            <path d="M385.88,281.3c0-.06,1-.26,2.1-.77s1.94-1.1,2-1a6.9,6.9,0,0,1-4.08,1.82Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M386.8,276.05a13.16,13.16,0,0,1-1.05,2.1,14.13,14.13,0,0,1-1.23,2,13.16,13.16,0,0,1,1.05-2.1A12.82,12.82,0,0,1,386.8,276.05Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M381.92,275.6a21.51,21.51,0,0,1,.51,2.24,19.9,19.9,0,0,1,.47,2.25,9.87,9.87,0,0,1-.68-2.2A8.92,8.92,0,0,1,381.92,275.6Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M377.55,280.12a12.19,12.19,0,0,1,2.13.64,11.26,11.26,0,0,1,2.06.83,12.47,12.47,0,0,1-2.13-.64A10.55,10.55,0,0,1,377.55,280.12Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M377.82,285.28c0-.06,1-.34,2.16-.81s2.11-.92,2.14-.87a7.7,7.7,0,0,1-2.06,1.07A7.92,7.92,0,0,1,377.82,285.28Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M382.13,289.27c-.05,0,.49-.93,1-2.09s.88-2.16.94-2.14a8,8,0,0,1-.75,2.23A7.51,7.51,0,0,1,382.13,289.27Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M386.6,284.85c0-.06.91-.09,2-.23s2-.34,2-.28a6.49,6.49,0,0,1-2,.48A6.05,6.05,0,0,1,386.6,284.85Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M385.41,288.31c0-.06,1,.17,2.24.27s2.25.07,2.26.14a7,7,0,0,1-2.28.07A6.76,6.76,0,0,1,385.41,288.31Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M382.5,291.35c0-.06,1,.52,2.38,1s2.49.62,2.48.68a2.33,2.33,0,0,1-.76,0,10.31,10.31,0,0,1-3.47-1.19A2.22,2.22,0,0,1,382.5,291.35Z"
                                style="fill:#455a64"></path>
                            <path d="M380.12,292.75c.07,0,.37,1,1,2.08s1.32,1.88,1.27,1.92a7.37,7.37,0,0,1-2.26-4Z"
                                style="fill:#455a64"></path>
                            <path
                                d="M377,298.08a5,5,0,0,1-.69-2.25,5.18,5.18,0,0,1,.19-2.34,21.66,21.66,0,0,0,0,2.32A20,20,0,0,0,377,298.08Z"
                                style="fill:#455a64"></path>
                            <rect x="389.61" y="219.02" width="12.79" height="5.78"
                                transform="translate(-54.31 279.22) rotate(-36.52)" style="fill:#e0e0e0"></rect>
                            <path
                                d="M389.14,223.39a13.73,13.73,0,0,1,1.06,1.24c.63.79,1.52,1.9,2.57,3.27l-.32,0c2.62-2,6.23-4.73,10.22-7.69.06-.4-.08.55-.06.45h0l0,0,0,0-.05-.07-.12-.15-.22-.31-.45-.6-.87-1.19L399.18,216l.42.07c-3,2.16-5.52,4-7.38,5.29-.87.59-1.6,1.1-2.21,1.53a5.93,5.93,0,0,1-.87.54,4,4,0,0,1,.67-.58l2.05-1.63c1.78-1.39,4.35-3.37,7.38-5.64l.24-.18.19.24c.54.72,1.1,1.47,1.67,2.25.29.39.59.78.88,1.18l.45.6.23.31.11.15.06.07,0,0,0,0h0c0-.1-.12.85-.07.45-4,2.95-7.64,5.61-10.33,7.54l-.19.13-.13-.18c-1.07-1.5-1.9-2.71-2.46-3.53A8.89,8.89,0,0,1,389.14,223.39Z"
                                style="fill:#263238"></path>
                            <path d="M405.31,214.77a5.33,5.33,0,0,0-7.46-1.12l6.35,8.58A5.32,5.32,0,0,0,405.31,214.77Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M405.31,214.77s.18.13.42.47a4.91,4.91,0,0,1,.7,1.62,5.29,5.29,0,0,1-.08,2.72,5.44,5.44,0,0,1-2,2.89l-.23.18-.18-.24-3.19-4.28c-1.12-1.51-2.18-3-3.16-4.3l-.18-.24.24-.17a5.56,5.56,0,0,1,3.34-1.06,5.38,5.38,0,0,1,2.63.73,5.2,5.2,0,0,1,1.35,1.14c.24.33.35.52.32.54a9.86,9.86,0,0,0-1.84-1.36,5.22,5.22,0,0,0-5.45.48l.06-.41,3.2,4.27c1.11,1.52,2.17,3,3.16,4.31L404,222a5.25,5.25,0,0,0,2.06-5.07A9.93,9.93,0,0,0,405.31,214.77Z"
                                style="fill:#263238"></path>
                            <path d="M404,217.51a3.38,3.38,0,0,0,.69-3.52" style="fill:#e0e0e0"></path>
                            <path
                                d="M404.67,214c.14-.1.71.76.48,1.92s-1.07,1.75-1.17,1.6.37-.78.54-1.72S404.5,214.06,404.67,214Z"
                                style="fill:#263238"></path>
                            <path
                                d="M397.73,216.72c.16-.09.91,1,1.93,2.34s1.9,2.33,1.78,2.46-1.24-.71-2.29-2.07S397.58,216.8,397.73,216.72Z"
                                style="fill:#263238"></path>
                            <path
                                d="M396.52,217.61c.16-.08.92,1,1.93,2.34s1.9,2.33,1.78,2.46-1.24-.71-2.28-2.07S396.37,217.69,396.52,217.61Z"
                                style="fill:#263238"></path>
                            <path
                                d="M395.31,218.51c.16-.09.92,1,1.93,2.34s1.91,2.32,1.78,2.46-1.23-.71-2.28-2.07S395.16,218.58,395.31,218.51Z"
                                style="fill:#263238"></path>
                            <path
                                d="M394.11,219.4c.16-.09.91,1,1.93,2.34s1.9,2.33,1.78,2.46-1.24-.71-2.29-2.07S394,219.48,394.11,219.4Z"
                                style="fill:#263238"></path>
                            <path
                                d="M392.9,220.29c.16-.08.92,1,1.93,2.34s1.9,2.33,1.78,2.46-1.24-.71-2.28-2.06S392.75,220.37,392.9,220.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M391.69,221.19c.16-.09.92,1,1.93,2.34s1.91,2.32,1.78,2.46-1.24-.71-2.28-2.07S391.54,221.26,391.69,221.19Z"
                                style="fill:#263238"></path>
                            <path
                                d="M390.49,222.08c.16-.09.91,1,1.93,2.34s1.9,2.33,1.78,2.46-1.24-.71-2.29-2.07S390.33,222.16,390.49,222.08Z"
                                style="fill:#263238"></path>
                            <rect x="65.44" y="314.8" width="12.79" height="5.78"
                                transform="translate(-204.16 144.73) rotate(-45.18)" style="fill:#e0e0e0"></rect>
                            <path
                                d="M78.39,315.2a15,15,0,0,1-1.23-1.07c-.74-.68-1.79-1.65-3-2.85h.33c-2.29,2.39-5.45,5.61-9,9.14V320h0l0,0,0,0,.07.07.14.13.26.27.54.53,1,1,2,2h-.43c2.59-2.59,4.86-4.77,6.51-6.35l2-1.84a5.59,5.59,0,0,1,.77-.67s-.17.23-.57.68L76,317.79c-1.55,1.64-3.79,4-6.45,6.69l-.21.22-.22-.22-2-2-1-1-.54-.53-.26-.26-.14-.14-.07-.06,0,0,0,0h0c0,.1,0-.86,0-.45,3.5-3.53,6.7-6.71,9.07-9l.17-.17.16.16c1.28,1.32,2.29,2.4,3,3.13A7.88,7.88,0,0,1,78.39,315.2Z"
                                style="fill:#263238"></path>
                            <path d="M63.71,326.16a5.33,5.33,0,0,0,7.54,0l-7.57-7.53A5.33,5.33,0,0,0,63.71,326.16Z"
                                style="fill:#e0e0e0"></path>
                            <path
                                d="M63.71,326.16s-.2-.11-.49-.4a5.13,5.13,0,0,1-.93-1.5,5.34,5.34,0,0,1-.34-2.71,5.56,5.56,0,0,1,1.52-3.15l.2-.21.22.21,3.8,3.75,3.77,3.78.21.21-.21.2a5.53,5.53,0,0,1-3.14,1.55,5.35,5.35,0,0,1-2.71-.33,4.94,4.94,0,0,1-1.5-.92c-.29-.28-.43-.46-.4-.48a10.1,10.1,0,0,0,2,1.07,5.26,5.26,0,0,0,2.52.17,5.18,5.18,0,0,0,2.8-1.47v.41l-3.81-3.74-3.77-3.78h.42a5.13,5.13,0,0,0-1.45,2.81,5.34,5.34,0,0,0,.18,2.51A9.46,9.46,0,0,0,63.71,326.16Z"
                                style="fill:#263238"></path>
                            <path d="M64.61,323.24a3.35,3.35,0,0,0-.15,3.59" style="fill:#e0e0e0"></path>
                            <path
                                d="M64.46,326.83c-.12.12-.82-.64-.76-1.83s.79-1.88.91-1.76-.25.83-.28,1.79S64.62,326.73,64.46,326.83Z"
                                style="fill:#263238"></path>
                            <path
                                d="M70.91,323.09c-.15.11-1.06-.89-2.26-2s-2.23-2-2.13-2.16a5.76,5.76,0,0,1,2.57,1.7C70.33,321.78,71.05,323,70.91,323.09Z"
                                style="fill:#263238"></path>
                            <path d="M72,322c-.15.11-1.06-.88-2.26-2s-2.24-2-2.13-2.17,1.33.52,2.57,1.71S72.11,321.92,72,322Z"
                                style="fill:#263238"></path>
                            <path d="M73,321c-.15.11-1.07-.89-2.26-2s-2.24-2-2.13-2.16,1.33.51,2.57,1.7S73.17,320.86,73,321Z"
                                style="fill:#263238"></path>
                            <path
                                d="M74.09,319.89c-.15.11-1.07-.88-2.27-2s-2.23-2-2.13-2.17,1.34.52,2.57,1.71A5.73,5.73,0,0,1,74.09,319.89Z"
                                style="fill:#263238"></path>
                            <path
                                d="M75.14,318.83c-.14.11-1.06-.89-2.26-2s-2.23-2-2.13-2.16,1.33.51,2.57,1.7S75.28,318.73,75.14,318.83Z"
                                style="fill:#263238"></path>
                            <path
                                d="M76.2,317.76c-.14.11-1.06-.89-2.26-2s-2.23-2-2.13-2.17a5.76,5.76,0,0,1,2.57,1.7C75.62,316.46,76.34,317.66,76.2,317.76Z"
                                style="fill:#263238"></path>
                            <path
                                d="M77.26,316.7c-.14.11-1.06-.89-2.26-2s-2.23-2-2.13-2.16,1.33.51,2.57,1.7S77.4,316.6,77.26,316.7Z"
                                style="fill:#263238"></path>
                            <path
                                d="M294.88,149.61a14.21,14.21,0,0,1-8.59-23.05l52.06-63.22a14.08,14.08,0,0,1,13.3-5h.05a14.07,14.07,0,0,1,10.92,9l28.72,76.7a14.21,14.21,0,0,1-15.64,19l-80.78-13.48Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M294.88,149.61a14.21,14.21,0,0,1-8.59-23.05l52.06-63.22a14.08,14.08,0,0,1,13.3-5h.05a14.07,14.07,0,0,1,10.92,9l28.72,76.7a14.21,14.21,0,0,1-15.64,19l-80.78-13.48Z"
                                style="fill:none"></path>
                            <path
                                d="M294.88,149.61l.85.11,2.51.39,9.64,1.56,35.42,5.83,24.46,4,6.71,1.11a20.72,20.72,0,0,0,3.42.4,13.35,13.35,0,0,0,3.44-.38,14.06,14.06,0,0,0,10.05-9.42,13.69,13.69,0,0,0,.25-7.38,31.74,31.74,0,0,0-1.24-3.63c-.46-1.22-.91-2.44-1.37-3.67q-2.77-7.37-5.64-15c-3.83-10.21-7.79-20.78-11.84-31.61q-3-8.12-6-16c-1-2.64-2-5.25-2.94-7.85A13.93,13.93,0,0,0,340,62a26.79,26.79,0,0,0-2.56,2.85q-2.44,3-4.84,5.87l-33.89,41.07c-4.8,5.86-9.23,11.11-13,15.79a13.91,13.91,0,0,0-2.57,7.77,14.34,14.34,0,0,0,1.57,6.75,14.12,14.12,0,0,0,3.43,4.37,14.34,14.34,0,0,0,3.48,2.16,15.58,15.58,0,0,0,2.4.81c.55.12.84.2.84.2s-.29,0-.86-.15a13.9,13.9,0,0,1-9.47-7.3,14.49,14.49,0,0,1-1.64-6.84,14.15,14.15,0,0,1,2.58-7.94c3.75-4.73,8.15-10,12.94-15.85l33.8-41.14,4.84-5.88a25.22,25.22,0,0,1,2.6-2.9A14.39,14.39,0,0,1,343,59.38a14.46,14.46,0,0,1,20.12,8.48c1,2.6,2,5.21,2.94,7.85,2,5.27,4,10.63,6,16,4.06,10.83,8,21.4,11.84,31.62q2.86,7.65,5.62,15l1.37,3.66a33.4,33.4,0,0,1,1.26,3.69,14.24,14.24,0,0,1-.27,7.64,14.57,14.57,0,0,1-10.4,9.73,14.28,14.28,0,0,1-3.56.38,21.07,21.07,0,0,1-3.49-.41l-6.7-1.12-24.45-4.11-35.39-6-9.62-1.65-2.5-.44Z"
                                style="fill:#263238"></path>
                            <path
                                d="M351,62.55h0A9.85,9.85,0,0,0,341.62,66l-52.06,63.22a10,10,0,0,0,6,16.16h0L376.4,158.9a10,10,0,0,0,11-13.33L358.65,68.88A9.87,9.87,0,0,0,351,62.55Z"
                                style="fill:#fff"></path>
                            <path
                                d="M333.3,132.81a5.24,5.24,0,0,1,6.26-4.27,5.25,5.25,0,1,1-1.69,10.37A5.29,5.29,0,0,1,333.3,132.81Zm7.31-42,9.91,1.62-6.77,31.05-6.63-1.08Z"
                                style="fill:currentColor"></path>
                            <polygon points="327.5 155.05 319.05 196.85 337.12 196.85 344.54 157.89 327.5 155.05"
                                style="fill:#455a64"></polygon>
                            <rect x="148.2" y="410.58" width="196.1" height="43.87" style="fill:#e0e0e0"></rect>
                            <rect x="120.17" y="454.45" width="258.95" height="10.34" rx="4.07" style="fill:#e0e0e0">
                            </rect>
                            <rect x="122.3" y="178.07" width="252.26" height="232.51" rx="3.38" style="fill:#e0e0e0">
                            </rect>
                            <rect x="135.46" y="195.14" width="224.13" height="204.37" style="fill:#263238"></rect>
                            <rect x="141.01" y="270.18" width="208.16" height="51.64" style="fill:#455a64"></rect>
                            <rect x="150.26" y="280.82" width="40.99" height="6.31" style="fill:#263238"></rect>
                            <rect x="150.26" y="291.67" width="40.99" height="6.31" style="fill:#263238"></rect>
                            <rect x="150.26" y="302.89" width="40.99" height="6.31" style="fill:#263238"></rect>
                            <path d="M207.45,284.63a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,207.45,284.63Z"
                                style="fill:#263238"></path>
                            <path d="M217.83,284.63a2.36,2.36,0,1,1-2.36-2.35A2.36,2.36,0,0,1,217.83,284.63Z"
                                style="fill:#263238"></path>
                            <path d="M228.2,284.63a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,228.2,284.63Z"
                                style="fill:#263238"></path>
                            <path d="M238.58,284.63a2.36,2.36,0,1,1-2.36-2.35A2.36,2.36,0,0,1,238.58,284.63Z"
                                style="fill:#263238"></path>
                            <path d="M319,284.63a2.36,2.36,0,1,1-2.36-2.35A2.36,2.36,0,0,1,319,284.63Z" style="fill:#263238">
                            </path>
                            <path d="M329.56,284.63a2.36,2.36,0,1,1-2.36-2.35A2.36,2.36,0,0,1,329.56,284.63Z"
                                style="fill:#263238"></path>
                            <path d="M249,284.63a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,249,284.63Z" style="fill:#263238">
                            </path>
                            <path d="M299.9,284.63a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,299.9,284.63Z"
                                style="fill:#263238"></path>
                            <path d="M259.33,284.63a2.36,2.36,0,1,1-2.35-2.35A2.35,2.35,0,0,1,259.33,284.63Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M269.7,284.63a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,269.7,284.63Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M290.75,284.63a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,290.75,284.63Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M338.16,284.63a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,338.16,284.63Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M280.08,284.63a2.36,2.36,0,1,1-2.35-2.35A2.35,2.35,0,0,1,280.08,284.63Z"
                                style="fill:currentColor"></path>
                            <path d="M310.54,284.63a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,310.54,284.63Z"
                                style="fill:currentColor"></path>
                            <path d="M333.46,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,333.46,296Z" style="fill:#263238">
                            </path>
                            <path d="M323.09,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,323.09,296Z" style="fill:#263238">
                            </path>
                            <path d="M312.71,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,312.71,296Z" style="fill:#263238">
                            </path>
                            <path d="M302.34,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,302.34,296Z" style="fill:#263238">
                            </path>
                            <path d="M221.94,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,221.94,296Z" style="fill:#263238">
                            </path>
                            <path d="M211.36,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,211.36,296Z" style="fill:#263238">
                            </path>
                            <path d="M292,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,292,296Z" style="fill:#263238"></path>
                            <path d="M241,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,241,296Z" style="fill:#263238"></path>
                            <path d="M281.59,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,281.59,296Z" style="fill:#f5f5f5">
                            </path>
                            <path d="M271.21,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,271.21,296Z" style="fill:#f5f5f5">
                            </path>
                            <path d="M250.16,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,250.16,296Z" style="fill:#f5f5f5">
                            </path>
                            <path d="M202.75,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,202.75,296Z" style="fill:#f5f5f5">
                            </path>
                            <path d="M260.83,296a2.36,2.36,0,1,1,2.36,2.35A2.36,2.36,0,0,1,260.83,296Z"
                                style="fill:currentColor"></path>
                            <path d="M231.13,296a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,231.13,296Z"
                                style="fill:currentColor"></path>
                            <path d="M207.45,306a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,207.45,306Z" style="fill:#263238">
                            </path>
                            <circle cx="215.47" cy="306.04" r="2.35" style="fill:#263238"></circle>
                            <circle cx="225.85" cy="306.04" r="2.35" style="fill:#263238"></circle>
                            <path d="M238.58,306a2.36,2.36,0,1,1-2.36-2.35A2.36,2.36,0,0,1,238.58,306Z" style="fill:#263238">
                            </path>
                            <circle cx="316.62" cy="306.04" r="2.35" style="fill:#263238"></circle>
                            <circle cx="327.2" cy="306.04" r="2.35" style="fill:#263238"></circle>
                            <path d="M249,306a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,249,306Z" style="fill:#263238"></path>
                            <path d="M299.9,306a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,299.9,306Z" style="fill:#263238">
                            </path>
                            <circle cx="256.98" cy="306.04" r="2.35" style="fill:#f5f5f5"></circle>
                            <path d="M269.7,306a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,269.7,306Z" style="fill:#f5f5f5">
                            </path>
                            <path d="M290.75,306a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,290.75,306Z" style="fill:#f5f5f5">
                            </path>
                            <path d="M338.16,306a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,338.16,306Z" style="fill:#f5f5f5">
                            </path>
                            <path d="M280.08,306a2.36,2.36,0,1,1-2.35-2.35A2.35,2.35,0,0,1,280.08,306Z"
                                style="fill:currentColor"></path>
                            <circle cx="307.43" cy="306.04" r="2.35" style="fill:currentColor"></circle>
                            <rect x="141.01" y="333.91" width="208.16" height="51.64" style="fill:#455a64"></rect>
                            <path d="M206.93,347.85a2.35,2.35,0,1,1-2.35-2.36A2.35,2.35,0,0,1,206.93,347.85Z"
                                style="fill:#263238"></path>
                            <path d="M217.31,347.85a2.35,2.35,0,1,1-2.35-2.36A2.35,2.35,0,0,1,217.31,347.85Z"
                                style="fill:#263238"></path>
                            <path d="M227.68,347.85a2.35,2.35,0,1,1-2.35-2.36A2.35,2.35,0,0,1,227.68,347.85Z"
                                style="fill:#263238"></path>
                            <path d="M238.06,347.85a2.35,2.35,0,1,1-2.35-2.36A2.35,2.35,0,0,1,238.06,347.85Z"
                                style="fill:#263238"></path>
                            <path d="M318.46,347.85a2.35,2.35,0,1,1-2.35-2.36A2.35,2.35,0,0,1,318.46,347.85Z"
                                style="fill:#263238"></path>
                            <path d="M329,347.85a2.35,2.35,0,1,1-2.35-2.36A2.35,2.35,0,0,1,329,347.85Z" style="fill:#263238">
                            </path>
                            <path d="M248.44,347.85a2.36,2.36,0,1,1-2.36-2.36A2.36,2.36,0,0,1,248.44,347.85Z"
                                style="fill:#263238"></path>
                            <path d="M299.39,347.85a2.35,2.35,0,1,1-2.35-2.36A2.35,2.35,0,0,1,299.39,347.85Z"
                                style="fill:#263238"></path>
                            <path d="M258.81,347.85a2.35,2.35,0,1,1-2.35-2.36A2.35,2.35,0,0,1,258.81,347.85Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M269.19,347.85a2.36,2.36,0,1,1-2.35-2.36A2.36,2.36,0,0,1,269.19,347.85Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M290.24,347.85a2.36,2.36,0,1,1-2.35-2.36A2.36,2.36,0,0,1,290.24,347.85Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M337.65,347.85a2.35,2.35,0,1,1-2.35-2.36A2.35,2.35,0,0,1,337.65,347.85Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M279.56,347.85a2.35,2.35,0,1,1-2.35-2.36A2.35,2.35,0,0,1,279.56,347.85Z"
                                style="fill:currentColor"></path>
                            <path d="M309.27,347.85a2.35,2.35,0,1,1-2.35-2.36A2.35,2.35,0,0,1,309.27,347.85Z"
                                style="fill:currentColor"></path>
                            <path d="M333,359.18a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,333,359.18Z" style="fill:#263238">
                            </path>
                            <circle cx="324.92" cy="359.18" r="2.35" style="fill:#263238"></circle>
                            <path d="M312.2,359.18a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,312.2,359.18Z"
                                style="fill:#263238"></path>
                            <path d="M301.82,359.18a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,301.82,359.18Z"
                                style="fill:#263238"></path>
                            <path d="M221.42,359.18a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,221.42,359.18Z"
                                style="fill:#263238"></path>
                            <path d="M210.84,359.18a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,210.84,359.18Z"
                                style="fill:#263238"></path>
                            <circle cx="293.8" cy="359.18" r="2.35" style="fill:#263238"></circle>
                            <path d="M240.49,359.18a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,240.49,359.18Z"
                                style="fill:#263238"></path>
                            <path d="M281.07,359.18a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,281.07,359.18Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M270.69,359.18a2.36,2.36,0,1,1,2.36,2.35A2.36,2.36,0,0,1,270.69,359.18Z"
                                style="fill:#f5f5f5"></path>
                            <circle cx="252" cy="359.18" r="2.35" style="fill:#f5f5f5"></circle>
                            <path d="M202.23,359.18a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,202.23,359.18Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M260.32,359.18a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,260.32,359.18Z"
                                style="fill:currentColor"></path>
                            <path d="M230.61,359.18a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,230.61,359.18Z"
                                style="fill:currentColor"></path>
                            <path d="M206.93,369.26a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,206.93,369.26Z"
                                style="fill:#263238"></path>
                            <path d="M217.31,369.26a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,217.31,369.26Z"
                                style="fill:#263238"></path>
                            <path d="M227.68,369.26a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,227.68,369.26Z"
                                style="fill:#263238"></path>
                            <path d="M238.06,369.26a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,238.06,369.26Z"
                                style="fill:#263238"></path>
                            <path d="M318.46,369.26a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,318.46,369.26Z"
                                style="fill:#263238"></path>
                            <path d="M329,369.26a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,329,369.26Z" style="fill:#263238">
                            </path>
                            <path d="M248.44,369.26a2.36,2.36,0,1,1-2.36-2.35A2.36,2.36,0,0,1,248.44,369.26Z"
                                style="fill:#263238"></path>
                            <path d="M299.39,369.26a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,299.39,369.26Z"
                                style="fill:#263238"></path>
                            <path d="M258.81,369.26a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,258.81,369.26Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M269.19,369.26a2.36,2.36,0,1,1-2.35-2.35A2.35,2.35,0,0,1,269.19,369.26Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M290.24,369.26a2.36,2.36,0,1,1-2.35-2.35A2.35,2.35,0,0,1,290.24,369.26Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M337.65,369.26a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,337.65,369.26Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M279.56,369.26a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,279.56,369.26Z"
                                style="fill:currentColor"></path>
                            <path d="M309.27,369.26a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,309.27,369.26Z"
                                style="fill:currentColor"></path>
                            <rect x="150.26" y="344.55" width="40.99" height="6.31" style="fill:#263238"></rect>
                            <rect x="150.26" y="355.4" width="40.99" height="6.31" style="fill:#263238"></rect>
                            <rect x="150.26" y="366.62" width="40.99" height="6.31" style="fill:#263238"></rect>
                            <rect x="151.76" y="239.62" width="40.99" height="6.31" style="fill:#263238"></rect>
                            <rect x="142.52" y="206.91" width="208.16" height="51.64" style="fill:#455a64"></rect>
                            <rect x="151.76" y="217.55" width="40.99" height="6.31" style="fill:#263238"></rect>
                            <rect x="151.76" y="228.4" width="40.99" height="6.31" style="fill:#263238"></rect>
                            <path d="M209,221.36a2.36,2.36,0,1,1-2.35-2.35A2.35,2.35,0,0,1,209,221.36Z" style="fill:#263238">
                            </path>
                            <path d="M219.33,221.36A2.35,2.35,0,1,1,217,219,2.35,2.35,0,0,1,219.33,221.36Z"
                                style="fill:#263238"></path>
                            <path d="M229.71,221.36a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,229.71,221.36Z"
                                style="fill:#263238"></path>
                            <path d="M240.08,221.36a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,240.08,221.36Z"
                                style="fill:#263238"></path>
                            <path d="M320.48,221.36a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,320.48,221.36Z"
                                style="fill:#263238"></path>
                            <path d="M331.06,221.36a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,331.06,221.36Z"
                                style="fill:#263238"></path>
                            <path d="M250.46,221.36a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,250.46,221.36Z"
                                style="fill:#263238"></path>
                            <path d="M301.41,221.36a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,301.41,221.36Z"
                                style="fill:#263238"></path>
                            <path d="M260.83,221.36a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,260.83,221.36Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M271.21,221.36a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,271.21,221.36Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M292.26,221.36a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,292.26,221.36Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M339.67,221.36a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,339.67,221.36Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M282.34,221.36A2.35,2.35,0,1,1,280,219,2.35,2.35,0,0,1,282.34,221.36Z"
                                style="fill:currentColor"></path>
                            <path d="M312,221.36a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,312,221.36Z"
                                style="fill:currentColor"></path>
                            <path d="M335,232.69a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,335,232.69Z" style="fill:#263238">
                            </path>
                            <path d="M324.59,232.69a2.36,2.36,0,1,1,2.35,2.35A2.35,2.35,0,0,1,324.59,232.69Z"
                                style="fill:#263238"></path>
                            <path d="M314.22,232.69a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,314.22,232.69Z"
                                style="fill:#263238"></path>
                            <path d="M303.84,232.69a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,303.84,232.69Z"
                                style="fill:#263238"></path>
                            <path d="M223.44,232.69a2.36,2.36,0,1,1,2.35,2.35A2.35,2.35,0,0,1,223.44,232.69Z"
                                style="fill:#263238"></path>
                            <path d="M212.86,232.69a2.36,2.36,0,1,1,2.35,2.35A2.35,2.35,0,0,1,212.86,232.69Z"
                                style="fill:#263238"></path>
                            <path d="M293.47,232.69a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,293.47,232.69Z"
                                style="fill:#263238"></path>
                            <circle cx="244.87" cy="232.69" r="2.35" style="fill:#263238"></circle>
                            <path d="M283.09,232.69a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,283.09,232.69Z"
                                style="fill:#f5f5f5"></path>
                            <circle cx="275.07" cy="232.69" r="2.35" style="fill:#f5f5f5"></circle>
                            <path d="M251.67,232.69A2.35,2.35,0,1,1,254,235,2.35,2.35,0,0,1,251.67,232.69Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M204.25,232.69a2.36,2.36,0,1,1,2.36,2.35A2.36,2.36,0,0,1,204.25,232.69Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M263.1,232.69c0-1.3.29-2.35,1.59-2.35a2.35,2.35,0,1,1,0,4.7C263.39,235,263.1,234,263.1,232.69Z"
                                style="fill:currentColor"></path>
                            <path d="M233.39,232.69a2.35,2.35,0,1,1,2.35,2.35A2.35,2.35,0,0,1,233.39,232.69Z"
                                style="fill:currentColor"></path>
                            <path d="M209,242.77a2.36,2.36,0,1,1-2.35-2.35A2.35,2.35,0,0,1,209,242.77Z" style="fill:#263238">
                            </path>
                            <path d="M219.33,242.77a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,219.33,242.77Z"
                                style="fill:#263238"></path>
                            <path d="M229.71,242.77a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,229.71,242.77Z"
                                style="fill:#263238"></path>
                            <circle cx="237.73" cy="242.77" r="2.35" style="fill:#263238"></circle>
                            <path d="M320.48,242.77a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,320.48,242.77Z"
                                style="fill:#263238"></path>
                            <path d="M331.06,242.77a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,331.06,242.77Z"
                                style="fill:#263238"></path>
                            <path d="M250.46,242.77a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,250.46,242.77Z"
                                style="fill:#263238"></path>
                            <path d="M301.41,242.77a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,301.41,242.77Z"
                                style="fill:#263238"></path>
                            <path d="M260.83,242.77a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,260.83,242.77Z"
                                style="fill:#f5f5f5"></path>
                            <path d="M271.21,242.77a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,271.21,242.77Z"
                                style="fill:#f5f5f5"></path>
                            <circle cx="289.91" cy="242.77" r="2.35" style="fill:#f5f5f5"></circle>
                            <path d="M339.67,242.77a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,339.67,242.77Z"
                                style="fill:#f5f5f5"></path>
                            <path
                                d="M281.58,242.77a2.35,2.35,0,0,1-2.35,2.35c-1.3,0-1.59-1.05-1.59-2.35s.29-2.35,1.59-2.35A2.35,2.35,0,0,1,281.58,242.77Z"
                                style="fill:currentColor"></path>
                            <path d="M312,242.77a2.35,2.35,0,1,1-2.35-2.35A2.35,2.35,0,0,1,312,242.77Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M168,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32a98.55,98.55,0,0,1,.27,10.32A98.55,98.55,0,0,1,168,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M173.82,445.29a100.39,100.39,0,0,1-.26-10.32,100.39,100.39,0,0,1,.26-10.32c.14,0,.26,4.62.26,10.32S174,445.29,173.82,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M179.65,445.29a100.39,100.39,0,0,1-.26-10.32,100.39,100.39,0,0,1,.26-10.32c.14,0,.26,4.62.26,10.32S179.79,445.29,179.65,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M185.48,445.29a100.39,100.39,0,0,1-.26-10.32,100.39,100.39,0,0,1,.26-10.32c.14,0,.26,4.62.26,10.32S185.62,445.29,185.48,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M191.31,445.29a100.39,100.39,0,0,1-.26-10.32,100.39,100.39,0,0,1,.26-10.32c.14,0,.26,4.62.26,10.32S191.45,445.29,191.31,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M197.14,445.29a100.39,100.39,0,0,1-.26-10.32,100.39,100.39,0,0,1,.26-10.32c.14,0,.26,4.62.26,10.32S197.28,445.29,197.14,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M203,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32.26,4.62.26,10.32S203.11,445.29,203,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M208.8,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32.26,4.62.26,10.32S208.94,445.29,208.8,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M214.63,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32.26,4.62.26,10.32S214.77,445.29,214.63,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M220.46,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32.26,4.62.26,10.32S220.6,445.29,220.46,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M226.29,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32a100.39,100.39,0,0,1,.26,10.32A100.39,100.39,0,0,1,226.29,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M232.12,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32a100.39,100.39,0,0,1,.26,10.32A100.39,100.39,0,0,1,232.12,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M238,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32a100.39,100.39,0,0,1,.26,10.32A100.39,100.39,0,0,1,238,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M243.78,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32A100.39,100.39,0,0,1,244,435,100.39,100.39,0,0,1,243.78,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M249.61,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32a100.39,100.39,0,0,1,.26,10.32A100.39,100.39,0,0,1,249.61,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M255.44,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32a98.55,98.55,0,0,1,.27,10.32A98.55,98.55,0,0,1,255.44,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M261.28,445.29A100.39,100.39,0,0,1,261,435a100.39,100.39,0,0,1,.26-10.32c.14,0,.26,4.62.26,10.32S261.42,445.29,261.28,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M267.11,445.29a100.39,100.39,0,0,1-.26-10.32,100.39,100.39,0,0,1,.26-10.32c.14,0,.26,4.62.26,10.32S267.25,445.29,267.11,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M272.94,445.29a100.39,100.39,0,0,1-.26-10.32,100.39,100.39,0,0,1,.26-10.32c.14,0,.26,4.62.26,10.32S273.08,445.29,272.94,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M278.77,445.29a100.39,100.39,0,0,1-.26-10.32,100.39,100.39,0,0,1,.26-10.32c.14,0,.26,4.62.26,10.32S278.91,445.29,278.77,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M284.6,445.29a100.39,100.39,0,0,1-.26-10.32,100.39,100.39,0,0,1,.26-10.32c.14,0,.26,4.62.26,10.32S284.74,445.29,284.6,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M290.43,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32.26,4.62.26,10.32S290.57,445.29,290.43,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M296.26,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32.26,4.62.26,10.32S296.4,445.29,296.26,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M302.09,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32.26,4.62.26,10.32S302.23,445.29,302.09,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M307.92,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32.26,4.62.26,10.32S308.06,445.29,307.92,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M313.75,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32A100.39,100.39,0,0,1,314,435,100.39,100.39,0,0,1,313.75,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M319.58,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32a100.39,100.39,0,0,1,.26,10.32A100.39,100.39,0,0,1,319.58,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M325.41,445.29c-.14,0-.26-4.62-.26-10.32s.12-10.32.26-10.32a100.39,100.39,0,0,1,.26,10.32A100.39,100.39,0,0,1,325.41,445.29Z"
                                style="fill:#263238"></path>
                            <path
                                d="M371.18,410.58c0,.14-55.11.26-123.07.26S125,410.72,125,410.58s55.1-.26,123.08-.26S371.18,410.43,371.18,410.58Z"
                                style="fill:#263238"></path>
                            <path
                                d="M374,454.45c0,.14-56.22.26-125.56.26s-125.56-.12-125.56-.26,56.21-.26,125.56-.26S374,454.31,374,454.45Z"
                                style="fill:#263238"></path>
                            <path
                                d="M368.22,407.16c0-1.89-.09-88.78-.22-222.41l.22.22-238.77,0h0l.26-.26c0,81.11,0,157.33,0,222.41l-.23-.23,238.8.23-238.8.22h-.22v-.22c0-65.08,0-141.3,0-222.41v-.26h.29l238.77,0h.23v.23C368.31,318.38,368.22,405.27,368.22,407.16Z"
                                style="fill:#263238"></path>
                            <path
                                d="M293,258.39s-.1.12-.31.33l-.95.94c-.87.83-2.12,2-3.71,3.57l-13.68,13.08c-11.55,11-27.48,26.34-45,43.33s-33.23,32.48-44.6,43.72l-13.47,13.3-3.67,3.6-1,.93a3.3,3.3,0,0,1-.35.3s.1-.12.31-.34l.93-1,3.6-3.68,13.35-13.42c11.3-11.29,27-26.82,44.49-43.82S262.44,287,274.05,276l13.8-13,3.77-3.5,1-.9Z"
                                style="fill:#fff"></path>
                            <path
                                d="M281.23,249.08s-.08.1-.25.27l-.78.77-3,2.9L266.15,263.7c-9.33,9-22.15,21.57-36.27,35.45s-26.9,26.48-36.23,35.5c-4.67,4.51-8.48,8.13-11.17,10.57-1.34,1.22-2.4,2.15-3.15,2.75a9.53,9.53,0,0,1-.89.63.65.65,0,0,1-.27.1c-.08,0-.06-.08-.06-.07,0,.17.44-.13,1.15-.75s1.76-1.56,3.09-2.81c2.64-2.48,6.4-6.14,11-10.68l36.12-35.61c14.12-13.89,27-26.38,36.38-35.34,4.69-4.48,8.52-8.09,11.17-10.56l3.07-2.84.81-.73A1.28,1.28,0,0,1,281.23,249.08Z"
                                style="fill:#fff"></path>
                            <path
                                d="M294.92,215.13a1.7,1.7,0,0,1-.25.28l-.77.76-3,2.91-11.06,10.68c-9.33,9-22.15,21.56-36.27,35.45s-26.9,26.47-36.23,35.5c-4.67,4.51-8.47,8.12-11.16,10.57-1.35,1.22-2.41,2.15-3.16,2.74a7.77,7.77,0,0,1-.89.64.79.79,0,0,1-.26.1c-.09,0-.06-.08-.06-.07,0,.17.44-.13,1.14-.75s1.77-1.57,3.09-2.81c2.64-2.49,6.41-6.15,11-10.69l36.13-35.6c14.12-13.89,27-26.38,36.37-35.35,4.7-4.48,8.52-8.08,11.18-10.56,1.31-1.21,2.34-2.17,3.07-2.83l.8-.73Z"
                                style="fill:#fff"></path>
                            <rect x="127.68" y="212.8" width="3.5" height="30.49" style="fill:#263238"></rect>
                            <rect x="127.68" y="343.93" width="3.5" height="30.49" style="fill:#263238"></rect>
                            <path
                                d="M238.33,142.88s.13,0,.34.13a2,2,0,0,1,.74.77,3.14,3.14,0,0,1,.38,1.66,5,5,0,0,1-.7,2.13c-.4.72-1,1.43-1.44,2.23a4.53,4.53,0,0,0-.8,2.72,5.08,5.08,0,0,0,1.48,2.78,33.47,33.47,0,0,1,2.49,2.63,4.14,4.14,0,0,1,.93,3.59,5.24,5.24,0,0,1-2.19,2.67c-.89.63-1.75,1.16-2.45,1.77a4.69,4.69,0,0,0-1.42,2.06,5.1,5.1,0,0,0,.16,3.64,9.47,9.47,0,0,0,.7,1.2s-.11-.07-.28-.24a4.08,4.08,0,0,1-.6-.87,5.19,5.19,0,0,1-.34-3.84,5.39,5.39,0,0,1,.56-1.2,5.87,5.87,0,0,1,.94-1.07,28.26,28.26,0,0,1,2.44-1.84,4.77,4.77,0,0,0,2-2.42,3.62,3.62,0,0,0-.85-3.13c-.71-1-1.66-1.72-2.45-2.61a5.4,5.4,0,0,1-1.58-3.07,4.88,4.88,0,0,1,.9-3c.52-.82,1.08-1.5,1.49-2.19a4.65,4.65,0,0,0,.73-2,3,3,0,0,0-.27-1.54A2.63,2.63,0,0,0,238.33,142.88Z"
                                style="fill:#263238"></path>
                            <path
                                d="M248.79,142.88s.14,0,.35.13a2,2,0,0,1,.74.77,3.14,3.14,0,0,1,.37,1.66,4.73,4.73,0,0,1-.7,2.13c-.4.72-1,1.43-1.43,2.23a4.47,4.47,0,0,0-.8,2.72,5,5,0,0,0,1.48,2.78,33.47,33.47,0,0,1,2.49,2.63,4.14,4.14,0,0,1,.93,3.59,5.21,5.21,0,0,1-2.2,2.67c-.88.63-1.74,1.16-2.44,1.77a4.71,4.71,0,0,0-1.43,2.06,5.15,5.15,0,0,0,.17,3.64,9.47,9.47,0,0,0,.7,1.2s-.11-.07-.28-.24a3.75,3.75,0,0,1-.6-.87,5.14,5.14,0,0,1-.34-3.84,5.34,5.34,0,0,1,.55-1.2,6.27,6.27,0,0,1,.94-1.07,30.09,30.09,0,0,1,2.45-1.84,4.8,4.8,0,0,0,2-2.42,3.62,3.62,0,0,0-.85-3.13,35.51,35.51,0,0,0-2.45-2.61,5.4,5.4,0,0,1-1.58-3.07,5,5,0,0,1,.91-3c.52-.82,1.08-1.5,1.49-2.19a4.76,4.76,0,0,0,.72-2,3,3,0,0,0-.26-1.54A2.6,2.6,0,0,0,248.79,142.88Z"
                                style="fill:#263238"></path>
                            <path
                                d="M259.26,142.88s.13,0,.35.13a2,2,0,0,1,.73.77,3.14,3.14,0,0,1,.38,1.66,4.86,4.86,0,0,1-.7,2.13c-.4.72-.95,1.43-1.44,2.23a4.46,4.46,0,0,0-.79,2.72,5,5,0,0,0,1.48,2.78,35.43,35.43,0,0,1,2.49,2.63,4.14,4.14,0,0,1,.92,3.59,5.24,5.24,0,0,1-2.19,2.67c-.88.63-1.74,1.16-2.44,1.77a4.63,4.63,0,0,0-1.43,2.06,5.1,5.1,0,0,0,.16,3.64,11.29,11.29,0,0,0,.7,1.2s-.11-.07-.28-.24a4.49,4.49,0,0,1-.6-.87,5.15,5.15,0,0,1-.33-3.84,5.34,5.34,0,0,1,.55-1.2,6.27,6.27,0,0,1,.94-1.07,27,27,0,0,1,2.45-1.84,4.8,4.8,0,0,0,2-2.42,3.62,3.62,0,0,0-.85-3.13c-.71-1-1.66-1.72-2.45-2.61a5.4,5.4,0,0,1-1.58-3.07,4.88,4.88,0,0,1,.91-3c.52-.82,1.08-1.5,1.48-2.19a4.65,4.65,0,0,0,.73-2,3,3,0,0,0-.27-1.54A2.63,2.63,0,0,0,259.26,142.88Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Floor--inject-23">
                            <path
                                d="M408.21,464.79c0,.15-70.84.26-158.2.26s-158.22-.11-158.22-.26,70.82-.26,158.22-.26S408.21,464.65,408.21,464.79Z"
                                style="fill:#263238"></path>
                        </g>
                    </svg>
                @break

                @case('500')
                    <svg id="svg-color" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 500">
                        <g id="freepik--background-simple--inject-2">
                            <path
                                d="M38.89,267.6s3.64,74.59,66.63,122.46,149.19,48.81,219,51.42,122.72-38.6,129.8-98.67-46.49-76-76.53-143.24S350,109.89,288.09,69.86,131,58.46,82,131.74,38.89,267.6,38.89,267.6Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M38.89,267.6s3.64,74.59,66.63,122.46,149.19,48.81,219,51.42,122.72-38.6,129.8-98.67-46.49-76-76.53-143.24S350,109.89,288.09,69.86,131,58.46,82,131.74,38.89,267.6,38.89,267.6Z"
                                style="fill:#fff;opacity:0.7000000000000001"></path>
                        </g>
                        <g id="freepik--Plants--inject-2">
                            <path
                                d="M420.73,372.86s-3.4-14.45-.85-27.21,8.5-4.25,15.31-12.76,3.4-24.66,11.05-31.47,18.71-5.95,21.26-18.71,4.26-23,9.36-21.26-4.25,17-4.25,26.37,5.1,15.3,1.7,24.66-17.86,5.95-17.86,17,5.95,22.11.85,29.77-18.71,9.35-20.41,13.6-6,11.91-10.21,11.91S420.73,372.86,420.73,372.86Z"
                                style="fill:#bfbfbf"></path>
                            <path
                                d="M418,373c.85-2.55-.85-24.66-8.5-28.91s-16.16-2.55-20.41-10.21-4.26-11.05-8.51-11.9-24.66-4.26-22.11,0,17.86-2.56,17.86,5.95-1.7,22.11,3.4,25.51,18.71,2.55,17.86,10.21-3.4,10.2.85,12.76,16.16,13.6,17.86,5.1Z"
                                style="fill:#bfbfbf"></path>
                            <path d="M427.43,391.77s-4-12.39,6.93-35.17,18.82-40.11,23.77-49"
                                style="fill:none;stroke:#263238;stroke-miterlimit:10;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M418.51,393.75s-1.48-5.95-6.44-22.29-10.89-20.8-19.31-26.25-8.91-14.36-10.4-16.84"
                                style="fill:none;stroke:#263238;stroke-miterlimit:10;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M439.31,384.83s1-8.91,8.92-11.39,15.35-1.48,16.84-6.93,1.48-10.9,4.95-13.87,7.92-4.46,8.42-3-5,2.48-5,7.43,7.43,17.33-3.46,22.28-19.81.5-23.77,4-6.44,5.94-6.44,5.94Z"
                                style="fill:#bfbfbf"></path>
                            <path d="M438.32,393.75s3.47-12.88,11.89-15.85S468,381.37,472,375.42s1-11.88.49-15.84"
                                style="fill:none;stroke:#263238;stroke-miterlimit:10;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M443.89,391.77h-30.7a2.47,2.47,0,0,0-2.48,2.47h0a2.48,2.48,0,0,0,2.48,2.48h.25l2.39,6.27a2.57,2.57,0,0,0,2.4,1.65h20.63a2.58,2.58,0,0,0,2.4-1.65l2.39-6.27h.24a2.48,2.48,0,0,0,2.48-2.48h0A2.47,2.47,0,0,0,443.89,391.77Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Text--inject-2">
                            <rect x="302.6" y="250.74" width="156.35" height="28.04" rx="4.73"
                                style="fill:currentColor"></rect>
                            <path d="M314.36,259.68v12.6H313v-12.6Z" style="fill:#263238"></path>
                            <path d="M317.41,272.28h-1.26v-12.6h1.78l2.91,9.11v-9.11h1.25v12.6h-1.46l-3.22-10.19Z"
                                style="fill:#263238"></path>
                            <path d="M325.72,272.28V261H323.4v-1.28h6.05V261h-2.32v11.32Z" style="fill:#263238"></path>
                            <path d="M335.26,265.26v1.26h-3.08V271H336v1.28h-5.18v-12.6H336V261h-3.78v4.3Z"
                                style="fill:#263238"></path>
                            <path
                                d="M340.43,259.68c2,0,2.81,1,2.81,2.88v1c0,1.39-.49,2.25-1.57,2.6,1.15.34,1.58,1.28,1.58,2.63v2a3.07,3.07,0,0,0,.26,1.51h-1.43a3.33,3.33,0,0,1-.23-1.53v-2c0-1.42-.67-1.87-1.84-1.87h-1v5.38h-1.4v-12.6Zm-.36,5.94c1.11,0,1.78-.36,1.78-1.73v-1.21c0-1.13-.41-1.72-1.46-1.72H339v4.66Z"
                                style="fill:#263238"></path>
                            <path d="M346.31,272.28h-1.26v-12.6h1.78l2.92,9.11v-9.11H351v12.6h-1.45l-3.23-10.19Z"
                                style="fill:#263238"></path>
                            <path
                                d="M354.21,269.74l-.48,2.54h-1.3l2.41-12.6h2l2.41,12.6h-1.4l-.49-2.54Zm.18-1.2h2.81l-1.42-7.28Z"
                                style="fill:#263238"></path>
                            <path d="M360.75,272.28v-12.6h1.4V271h3.6v1.28Z" style="fill:#263238"></path>
                            <path
                                d="M375.78,262.7V263h-1.33v-.41c0-1.13-.43-1.8-1.44-1.8s-1.44.67-1.44,1.78c0,2.83,4.23,3.1,4.23,6.64,0,1.91-.92,3.16-2.85,3.16s-2.82-1.25-2.82-3.16v-.71h1.31v.79c0,1.13.47,1.8,1.48,1.8s1.47-.67,1.47-1.8c0-2.81-4.21-3.08-4.21-6.63,0-1.94.9-3.15,2.79-3.15S375.78,260.79,375.78,262.7Z"
                                style="fill:#263238"></path>
                            <path d="M381.86,265.26v1.26h-3.07V271h3.78v1.28h-5.19v-12.6h5.19V261h-3.78v4.3Z"
                                style="fill:#263238"></path>
                            <path
                                d="M387,259.68c2,0,2.81,1,2.81,2.88v1c0,1.39-.49,2.25-1.57,2.6,1.15.34,1.59,1.28,1.59,2.63v2a3.07,3.07,0,0,0,.25,1.51h-1.42a3.17,3.17,0,0,1-.24-1.53v-2c0-1.42-.66-1.87-1.83-1.87h-1v5.38h-1.41v-12.6Zm-.36,5.94c1.12,0,1.78-.36,1.78-1.73v-1.21c0-1.13-.41-1.72-1.46-1.72h-1.36v4.66Z"
                                style="fill:#263238"></path>
                            <path d="M392.7,259.68l2.05,11,2-11h1.29l-2.36,12.6h-2.07l-2.37-12.6Z" style="fill:#263238">
                            </path>
                            <path d="M404,265.26v1.26h-3.08V271h3.79v1.28h-5.19v-12.6h5.19V261h-3.79v4.3Z"
                                style="fill:#263238"></path>
                            <path
                                d="M409.17,259.68c2,0,2.81,1,2.81,2.88v1c0,1.39-.49,2.25-1.57,2.6,1.15.34,1.59,1.28,1.59,2.63v2a3.07,3.07,0,0,0,.25,1.51h-1.42a3.17,3.17,0,0,1-.24-1.53v-2c0-1.42-.67-1.87-1.84-1.87h-1v5.38h-1.4v-12.6Zm-.36,5.94c1.11,0,1.78-.36,1.78-1.73v-1.21c0-1.13-.41-1.72-1.46-1.72h-1.37v4.66Z"
                                style="fill:#263238"></path>
                            <path d="M421.44,265.26v1.26h-3.07V271h3.78v1.28H417v-12.6h5.19V261h-3.78v4.3Z"
                                style="fill:#263238"></path>
                            <path
                                d="M426.61,259.68c2,0,2.81,1,2.81,2.88v1c0,1.39-.49,2.25-1.57,2.6,1.15.34,1.59,1.28,1.59,2.63v2a3.19,3.19,0,0,0,.25,1.51h-1.42a3.17,3.17,0,0,1-.24-1.53v-2c0-1.42-.66-1.87-1.83-1.87h-1v5.38H423.8v-12.6Zm-.36,5.94c1.12,0,1.78-.36,1.78-1.73v-1.21c0-1.13-.41-1.72-1.46-1.72h-1.36v4.66Z"
                                style="fill:#263238"></path>
                            <path
                                d="M434.06,259.68c2,0,2.81,1,2.81,2.88v1c0,1.39-.49,2.25-1.57,2.6,1.16.34,1.59,1.28,1.59,2.63v2a3.19,3.19,0,0,0,.25,1.51h-1.42a3.3,3.3,0,0,1-.24-1.53v-2c0-1.42-.66-1.87-1.83-1.87h-1v5.38h-1.41v-12.6Zm-.36,5.94c1.12,0,1.78-.36,1.78-1.73v-1.21c0-1.13-.41-1.72-1.45-1.72h-1.37v4.66Z"
                                style="fill:#263238"></path>
                            <path
                                d="M438.6,262.72c0-1.93.95-3.17,2.88-3.17s2.9,1.24,2.9,3.17v6.52c0,1.91-1,3.17-2.9,3.17s-2.88-1.26-2.88-3.17Zm1.38,6.59c0,1.15.49,1.82,1.5,1.82s1.49-.67,1.49-1.82v-6.66c0-1.14-.47-1.82-1.49-1.82s-1.5.68-1.5,1.82Z"
                                style="fill:#263238"></path>
                            <path
                                d="M448.88,259.68c2,0,2.8,1,2.8,2.88v1c0,1.39-.48,2.25-1.56,2.6,1.15.34,1.58,1.28,1.58,2.63v2a3.07,3.07,0,0,0,.26,1.51h-1.43a3.33,3.33,0,0,1-.23-1.53v-2c0-1.42-.67-1.87-1.84-1.87h-1v5.38h-1.4v-12.6Zm-.36,5.94c1.11,0,1.78-.36,1.78-1.73v-1.21c0-1.13-.42-1.72-1.46-1.72h-1.37v4.66Z"
                                style="fill:#263238"></path>
                            <path
                                d="M337.12,221v5.85c0,4.5,2,6.12,5.13,6.12s5.13-1.62,5.13-6.12V213c0-4.5-2-6.21-5.13-6.21s-5.13,1.71-5.13,6.21v1.89h-9.36l1.8-36.54h26.1v9H338.47l-.81,15a9.44,9.44,0,0,1,8.64-4.59c7.29,0,11,5.13,11,14.4v14c0,10.08-5,15.84-14.76,15.84s-14.76-5.76-14.76-15.84V221Z"
                                style="fill:#263238"></path>
                            <path
                                d="M364.84,193.48c0-10.08,5.31-15.84,15-15.84s15,5.76,15,15.84v32.76c0,10.08-5.31,15.84-15,15.84s-15-5.76-15-15.84Zm9.9,33.39c0,4.5,2,6.21,5.13,6.21s5.13-1.71,5.13-6.21v-34c0-4.5-2-6.21-5.13-6.21s-5.13,1.71-5.13,6.21Z"
                                style="fill:#263238"></path>
                            <path
                                d="M402.28,193.48c0-10.08,5.31-15.84,15-15.84s15,5.76,15,15.84v32.76c0,10.08-5.31,15.84-15,15.84s-15-5.76-15-15.84Zm9.9,33.39c0,4.5,2,6.21,5.13,6.21s5.13-1.71,5.13-6.21v-34c0-4.5-2-6.21-5.13-6.21s-5.13,1.71-5.13,6.21Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Server--inject-2">
                            <path
                                d="M153,338.54a23.83,23.83,0,0,1,17.68,4.4c8.17,6.28,14.38,22.25,17.59,44.61s5,32,23.87,35.18,64.09,1.89,91.1,1.26,25.76-25.76,3.15-28.27-38.27,3.52-61.86-1.7,21-12.13,54.94-7.1,49,6.28,67.23,4.4"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:2.5130800000000004px">
                            </path>
                            <path
                                d="M153,305.1s18.31.14,23.33,19,6.91,45.24,7.54,66,1.26,38.33,25.13,43.35,88.59,3.14,106.18-.63,37.07-20.73,22.62-24.5-34.56,0-27,5,27.65,3.77,51.52.63"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:2.5130800000000004px">
                            </path>
                            <path
                                d="M156.76,370.69s11.19-1,15.56,11.67-1,15.56,1.46,21.88,17.78.42,17.71,5.66c-.07,4.78-6.13,6.13-41.05,4.07-45.66-2.69-75.87,4.38-73.44,8.76s38.91,1,30.15,7.78-30.15-1-46.69-1.46S41,432.45,41,432.45"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:2.5130800000000004px">
                            </path>
                            <rect x="44.61" y="192.05" width="117.06" height="215.4" rx="3.56"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="47.41" y="224.31" width="111.41" height="82.51" style="fill:#616161"></rect>
                            <rect x="47.41" y="320.23" width="111.41" height="82.51" style="fill:#616161"></rect>
                            <rect x="81.75" y="330.28" width="63.25" height="64.5"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="81.75" y="233.53" width="63.25" height="15.92"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="81.75" y="264.1" width="63.25" height="15.92"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <polygon
                                points="142.88 226.16 141.66 229.51 85.63 229.51 84.41 226.16 72.54 226.16 72.54 240.88 84.41 240.88 85.63 237.53 141.66 237.53 142.88 240.88 156.32 240.88 156.32 226.16 142.88 226.16"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </polygon>
                            <polygon
                                points="142.88 242.22 141.66 245.56 85.63 245.56 84.41 242.22 72.54 242.22 72.54 256.93 84.41 256.93 85.63 253.59 141.66 253.59 142.88 256.93 156.32 256.93 156.32 242.22 142.88 242.22"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </polygon>
                            <polygon
                                points="142.88 258.27 141.66 261.62 85.63 261.62 84.41 258.27 72.54 258.27 72.54 272.99 84.41 272.99 85.63 269.64 141.66 269.64 142.88 272.99 156.32 272.99 156.32 258.27 142.88 258.27"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </polygon>
                            <polygon
                                points="142.88 274.32 141.66 277.67 85.63 277.67 84.41 274.32 72.54 274.32 72.54 289.04 84.41 289.04 85.63 285.7 141.66 285.7 142.88 289.04 156.32 289.04 156.32 274.32 142.88 274.32"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </polygon>
                            <polygon
                                points="142.88 290.38 141.66 293.72 85.63 293.72 84.41 290.38 72.54 290.38 72.54 305.1 84.41 305.1 85.63 301.75 141.66 301.75 142.88 305.1 156.32 305.1 156.32 290.38 142.88 290.38"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </polygon>
                            <polygon
                                points="142.88 322.49 141.66 325.83 85.63 325.83 84.41 322.49 72.54 322.49 72.54 337.2 84.41 337.2 85.63 333.86 141.66 333.86 142.88 337.2 156.32 337.2 156.32 322.49 142.88 322.49"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </polygon>
                            <polygon
                                points="142.88 338.54 141.66 341.89 85.63 341.89 84.41 338.54 72.54 338.54 72.54 353.26 84.41 353.26 85.63 349.92 141.66 349.92 142.88 353.26 156.32 353.26 156.32 338.54 142.88 338.54"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </polygon>
                            <polygon
                                points="142.88 354.6 141.66 357.94 85.63 357.94 84.41 354.6 72.54 354.6 72.54 369.31 84.41 369.31 85.63 365.97 141.66 365.97 142.88 369.31 156.32 369.31 156.32 354.6 142.88 354.6"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </polygon>
                            <polygon
                                points="142.88 370.65 141.66 374 85.63 374 84.41 370.65 72.54 370.65 72.54 385.37 84.41 385.37 85.63 382.02 141.66 382.02 142.88 385.37 156.32 385.37 156.32 370.65 142.88 370.65"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </polygon>
                            <polygon
                                points="142.88 386.71 141.66 390.05 85.63 390.05 84.41 386.71 72.54 386.71 72.54 401.42 84.41 401.42 85.63 398.08 141.66 398.08 142.88 401.42 156.32 401.42 156.32 386.71 142.88 386.71"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </polygon>
                            <rect x="49.65" y="309.39" width="106.65" height="10.05" style="fill:#fff"></rect>
                            <path d="M58.65,314.31a2.81,2.81,0,1,0-2.81,2.81A2.81,2.81,0,0,0,58.65,314.31Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <circle cx="65.2" cy="314.31" r="2.81"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </circle>
                            <path d="M77.37,314.31a2.81,2.81,0,1,0-2.81,2.81A2.81,2.81,0,0,0,77.37,314.31Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <rect x="49.65" y="213.06" width="106.65" height="10.05" style="fill:#fff"></rect>
                            <path d="M58.65,218a2.81,2.81,0,1,0-2.81,2.81A2.81,2.81,0,0,0,58.65,218Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M68,218a2.81,2.81,0,1,0-2.81,2.81A2.81,2.81,0,0,0,68,218Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M77.37,218a2.81,2.81,0,1,0-2.81,2.81A2.81,2.81,0,0,0,77.37,218Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <rect x="49.65" y="200.13" width="106.65" height="10.05" style="fill:#fff"></rect>
                            <path d="M58.65,205.05a2.81,2.81,0,1,0-2.81,2.81A2.81,2.81,0,0,0,58.65,205.05Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M68,205.05a2.81,2.81,0,1,0-2.81,2.81A2.81,2.81,0,0,0,68,205.05Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M77.37,205.05a2.81,2.81,0,1,0-2.81,2.81A2.81,2.81,0,0,0,77.37,205.05Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <rect x="49.92" y="226.41" width="17.59" height="7.54"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="49.92" y="242.74" width="17.59" height="7.54"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="49.92" y="259.08" width="17.59" height="7.54"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="49.92" y="275.41" width="17.59" height="7.54"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="49.92" y="291.75" width="17.59" height="7.54"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="49.92" y="322.32" width="17.59" height="7.54"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="49.92" y="338.66" width="17.59" height="7.54"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="49.92" y="354.99" width="17.59" height="7.54"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="49.92" y="371.33" width="17.59" height="7.54"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="49.92" y="387.66" width="17.59" height="7.54"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                        </g>
                        <g id="freepik--Character--inject-2">
                            <path
                                d="M214.84,146.36s-16.86,4.29-21.54,10.7-23.65,50-23.65,50-6.15,6.9.5,13.55,19.95,9.11,24.88,3.2,12.06-33.75,13.05-36.95,8.37-30.3,9.11-31.77S218.64,147.24,214.84,146.36Z"
                                style="fill:#bdbdbd;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M214.84,146.36s-16.86,4.29-21.54,10.7c-2.83,3.87-10.89,21.37-16.82,34.58,2.88-.58,14.88-2.36,28.93,4.72,1.35-4.72,2.35-8.45,2.67-9.5,1-3.2,8.37-30.3,9.11-31.77S218.64,147.24,214.84,146.36Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M264.24,89.57a16.14,16.14,0,0,1,6.65,7.14c2,4.68,2,11.82,2,11.82s31.53-1,43.6-1.23,20.2,2.71,20.44,8.62-2.46,17.49-9.11,21.92-27.34-2.71-37.93-5.66-14.29-2-21.92-3-9.86-3.94-11.09-8.62,1.23-13.55,1.23-20.69S257.1,88.09,264.24,89.57Z"
                                style="fill:#bdbdbd;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M310.3,119.86s-4.43,11.33-12.56,17.49c-5.83,4.42-13.7,6.94-17.67,8-14.21-4-34.27-5.88-46-3.28,0,0-16.38,3.92-19.23,4.28s-9.62,23.15-11.05,38.82,3.21,54.5,3.21,57.35,1.78,50.23,4.63,63.41,6.06,31,6.41,33.48,2.85,21,2.85,27.07S218,387.15,218,387.15s-12.82,8.55-17.81,13.53,3.67,10.24,10,11.4c10.74,2,23.5-8.55,23.5-8.55L248,397.84c3.79-1.52,4.91-5.59,5-9.24l.66-26.38q3.36,14,5.52,28.29c.58,3.9,1.18,8,3.53,11.15a15.18,15.18,0,0,0,4.94,4.39c1.42.66,2.93.52,4.36,1.34,2.63,1.52,3.71,4.8,6.26,6.45a33.51,33.51,0,0,0,18.17,4.65s14.24.72,15-7.12-18.53-20.66-18.53-20.66-2.85-52-5-69.1-7.84-44.88-7.84-57,5.7-69.11,5.7-69.11.58-1.5,1.47-3.94l.94-.52c8.13-4.68,30.79-22.91,38.18-34.49,7.08-11.08,9.64-31.87,9.84-37.95"
                                style="fill:#bdbdbd;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M311.37,411.37c.71-7.84-18.53-20.66-18.53-20.66s-.22-4-.58-10.15a143.77,143.77,0,0,1-34.08,4q.51,3,1,6c.58,3.9,1.18,8,3.53,11.15a15.18,15.18,0,0,0,4.94,4.39c1.42.66,2.93.52,4.36,1.34,2.63,1.52,3.71,4.8,6.26,6.45a33.51,33.51,0,0,0,18.17,4.65S310.65,419.21,311.37,411.37Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M248,397.84c3.79-1.52,4.91-5.59,5-9.24,0-1.38.07-2.76.1-4.14a157.47,157.47,0,0,1-33.69-4.82c-.68,4.16-1.34,7.51-1.34,7.51s-12.82,8.55-17.81,13.53,3.67,10.24,10,11.4c10.74,2,23.5-8.55,23.5-8.55Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M311.37,411.37c0-.11,0-.23,0-.35a24.49,24.49,0,0,1-10.61,4.3c-11.26,2-21.52-3.75-24.27-6.25s-4.5-4.51-8.76-7.26-8.11-9.52-8.11-9.52l-.16.25c.53,3.25,1.27,6.5,3.22,9.12a15.18,15.18,0,0,0,4.94,4.39c1.42.66,2.93.52,4.36,1.34,2.63,1.52,3.71,4.8,6.26,6.45a33.51,33.51,0,0,0,18.17,4.65S310.65,419.21,311.37,411.37Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M248,397.84c3.31-1.33,4.58-4.59,4.92-7.82-3.28,2-10.86,6.37-15.67,8.29-6.25,2.5-10.51,10-22.76,10-8.74,0-13.53-3.42-15.56-5.39-1.08,4.22,6,8.17,11.32,9.16,10.74,2,23.5-8.55,23.5-8.55Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M294.23,139.67a61.36,61.36,0,0,1-14.16,5.69c-14.21-4-34.27-5.88-46-3.28,0,0-16.38,3.92-19.23,4.28s-9.62,23.15-11.05,38.82c-.88,9.68.55,28.16,1.77,41.57,29.69,10.88,61.35,7.15,76.83,4.19,1.56-17.76,3.33-35.43,3.33-35.43s.58-1.5,1.47-3.94l.94-.52c5.53-3.18,17.75-12.61,27.34-22C296.22,163.5,293.89,148.32,294.23,139.67Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M266.63,156.66a19,19,0,0,0-8.1-15.19c-9.1-.88-18-.82-24.46.61,0,0-4.53,1.09-9.24,2.16a18.35,18.35,0,0,0-5,12.42c0,11.11,10.48,20.12,23.4,20.12S266.63,167.77,266.63,156.66Z"
                                style="fill:#616161;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M259.62,392.29a42.6,42.6,0,0,0,16.66,2.34c12.29-.53,16.56-3.92,16.56-3.92s-2.85-52-5-69.1-7.84-44.88-7.84-57c0-7.14,2-29.87,3.61-47.33l-.77.09a14.35,14.35,0,0,1-16-14.68l.34-11.37a148.24,148.24,0,0,1-27.79-.8c-16.56-1.87-33.66-7.48-33.66-7.48l-1.8.55c0,.53-.11,1.06-.16,1.58-1.42,15.68,3.21,54.5,3.21,57.35s1.78,50.23,4.63,63.41,6.06,31,6.41,33.48,2.85,21,2.85,27.07-2.74,20.12-2.84,20.64c2.14.66,6.62,2,14.69,4.29,12.28,3.48,20.21-.71,20.21-.71,0-4.27.71-28.49.71-28.49S258.16,382.71,259.62,392.29Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <polygon
                                points="218.93 198.05 250.92 203.31 250.92 223.03 232.95 241.01 218.49 223.47 218.93 198.05"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </polygon>
                            <path d="M242,308.94c-2.31-13-4-25.84-4-35.06l-12.82-8.55"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M253.66,362.22s-5.4-20.87-9.86-43.73"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M263.19,251.73a13.31,13.31,0,0,0,1.32,3.3c3.95,7,9.64,7.89,9.64,7.89l.88-18.41"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M264.51,241a15.67,15.67,0,0,0-1.45,4.21"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M280.22,297c.46,2.43.93,4.82,1.39,7.1"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M274.15,262.92s2.26,13.51,4.87,27.67"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M232,134.5,231.8,145s-3.62,2.9-4.34,10.5,6.52,14.67,14.66,14.67,15.21-6.34,16.48-12.13-.37-14.12-.37-14.12l-.54-12.67s-8,5.06-15.57,3.62-9.77-4.17-9.77-4.17Z"
                                style="fill:#bdbdbd;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M226.31,107.1s-.49,6,.81,7.47,3.09,2.6,3.42,1.3.48-8.12.81-9.58S226.47,103,226.31,107.1Z"
                                style="fill:#bdbdbd;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M229.49,107S228,119,228,124.81s-2.25,8,5,11.78,13.53,4.26,18.54,2.5,7.77-6,8-9.52.25-9,.25-9,7-6.26,5.52-11-4.76,1.25-4.76,1.25a38.69,38.69,0,0,0,2-12.78c-.25-6.52-5.26-7.27-7.27-7.27S241,87,235.25,90.72,229.49,107,229.49,107Z"
                                style="fill:#bdbdbd;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M260.57,110.77a38.69,38.69,0,0,0,2-12.78c-.25-6.52-5.26-7.27-7.27-7.27h-.13c-1.06,1.78-2.37,4.52-2.37,4.52l1,.5s-1,5.52,1,6.27,1,2.5,1,5.51,1.76,5.26,2.76,5.26c.79,0,2-2,2.54-2.87C260.77,110.39,260.57,110.77,260.57,110.77Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M240.77,111.49s-2.11,1.94-1.14,3.41,4.55,2.27,5.53.48a3,3,0,0,0-.65-3.73"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M238.5,109.54c0,1-.4,1.78-.9,1.78s-.89-.8-.89-1.78.4-1.79.89-1.79S238.5,108.55,238.5,109.54Z"
                                style="fill:#263238"></path>
                            <path d="M249.3,110c0,1-.4,1.79-.89,1.79s-.9-.8-.9-1.79.4-1.78.9-1.78S249.3,109,249.3,110Z"
                                style="fill:#263238"></path>
                            <path d="M246.62,105.15s3.41-2.28,6.66,1.3"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M241.44,121.14a3.39,3.39,0,0,0-2.78-.12,2.87,2.87,0,0,0-1.62,1.74s-2.08,1.67.11,2.4,7,.68,8.21.63a1.87,1.87,0,0,0,1.6-2.07,1.12,1.12,0,0,0-.51-1A4,4,0,0,0,241.44,121.14Z"
                                style="fill:#666;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:0.922744px">
                            </path>
                            <path d="M236.57,123.39a23.55,23.55,0,0,1,10.09.6"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.0732700000000002px">
                            </path>
                            <path
                                d="M225.23,93.23,252.05,97s11.27-3,12.28-5.26-2.76-13.53-4.77-16.29-21.3,2-27.32,3S221.72,80.94,222,84,225.23,93.23,225.23,93.23Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M225.23,93.23S209.94,105.76,209.69,107s22.3,1.75,29.32.25,13-10.28,13-10.28Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M208.52,259.36l42-24.63a8.28,8.28,0,0,0,12.91-8.95l-8.77,5.13-2-3.45,8.78-5.14a8.28,8.28,0,0,0-14.13,6.88l-42.05,24.63a8.28,8.28,0,0,0-12.91,8.95l8.54-5,2,3.46-8.54,5a8.27,8.27,0,0,0,14.12-6.88Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M244.29,241.05s5.17,3.7,5.17,7.14-6.16,7.15-10.34,7.39-4.93-4.43-4.19-6.89S244.29,241.05,244.29,241.05Z"
                                style="fill:#bdbdbd;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M190.1,210.26s28.57,16,32.51,15.52,9.36-3.94,12.32-3,11.08,13.55,11.82,15.77-5.91,10.1-7.39,11.33-6.16,6.16-7.14,6.65-7.39,6.16-10.59,6.16-8.62-2.47-9.12-3.7.74-2.95.74-2.95l-15-6.9s-28.58-15.52-33.5-23.4,7.39-21.92,7.39-21.92"
                                style="fill:#bdbdbd;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M223.11,248.93a4,4,0,0,1,3.44,3.45c.5,3.2-.74,8.87-.74,8.87"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M228.77,244.25s3.45.25,3.45,3.45v8.87"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path d="M232.47,235.39s6.4,4.68,6.89,7.39a31.36,31.36,0,0,1,0,7.14"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <path
                                d="M261,218.5c1.44,0,5.25-9.54,5.25-13.12s1.67-29.81,5.49-42c2.74-8.73,5.1-15.47,6.22-18.6-2.91-.74-6-1.4-9.22-2-1.91,5.79-7.74,23.86-10.12,35.35-2.86,13.83-2.15,30.29-1.91,31.72S259.59,218.5,261,218.5Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <rect x="256.25" y="189.64" width="10.73" height="9.06" rx="1.23"
                                transform="matrix(0.99, 0.13, -0.13, 0.99, 27.82, -32.73)"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="258.25" y="191.33" width="6.73" height="5.69" rx="1.23"
                                transform="translate(27.82 -32.73) rotate(7.56)"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <path
                                d="M207.59,214.92c1.44,0,5.25-9.54,5.25-13.12s1.67-29.81,5.49-42c2.42-7.72,4.07-12.65,5-15.22-3.73.84-7.27,1.61-8.45,1.76-.88.11-2.12,2.34-3.47,5.82-1.58,4.9-3.51,11.27-5,17.48a128.67,128.67,0,0,0-2.55,15.52,132,132,0,0,0-.07,15.73q0,.27.06.42C204,202.76,206.16,214.92,207.59,214.92Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </path>
                            <rect x="203.06" y="182.25" width="10.73" height="9.06" rx="1.23"
                                transform="translate(21 -21.06) rotate(6.09)"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                            <rect x="205.06" y="183.93" width="6.73" height="5.69" rx="1.23"
                                transform="translate(20.99 -21.06) rotate(6.09)"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.2565400000000002px">
                            </rect>
                        </g>
                    </svg>
                @break

                @case('503')
                    <svg id="svg-color" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                        viewBox="0 0 500 500">
                        <defs>
                            <clipPath id="freepik--clip-path--inject-2">
                                <path d="M261.76,432.31A24.74,24.74,0,1,1,274,399.52,24.73,24.73,0,0,1,261.76,432.31Z"
                                    style="fill:#263238"></path>
                            </clipPath>
                            <clipPath id="freepik--clip-path-2--inject-2">
                                <path
                                    d="M322.16,107.29a39.79,39.79,0,0,0-9.85-9.82,145.36,145.36,0,0,0-15.56-8.06l-3.23-18a61.53,61.53,0,0,0,8.28-9.8c2.92-4.71,2-7.87.13-11.13s-4.46-1.15-4.85.34a33.33,33.33,0,0,0-.52,4.75s-1.74-12-2.75-14.73-4.86-.1-4.52.81c0,0-1.16-3.41-3.55-3.45s-3.07,4-3.07,4-3.07-1.42-4.79.36-.9,6.24-.9,6.24-2.74,1-3.16,4.89-.08,10.7,1,12.57a20.08,20.08,0,0,1,1.45,2.78c-1.36,16.24-1.31,15.17-1.71,21.65-.28,4.56,2.71,15.16,7,19.57s19.64,12.2,19.64,12.2S317.23,118.33,322.16,107.29Z"
                                    style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                                </path>
                            </clipPath>
                            <clipPath id="freepik--clip-path-3--inject-2">
                                <path
                                    d="M282.21,125.93s-4.47.47-5.88,1.68S264.19,138,262.45,143.44s4.87,21.72,12.09,28,16.24,12.93,23.9,11.56,16.46-13.17,17.37-16.38-29.06-40-29.06-40S284.62,124.48,282.21,125.93Z"
                                    style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                                </path>
                            </clipPath>
                            <clipPath id="freepik--clip-path-4--inject-2">
                                <path
                                    d="M320.39,104.12s-4.74-1.6-11.8,1.4-24.72,13.37-27.31,22.4c-1.71,5.93,17,33.62,28.69,38.18,3.14,1.22,6,2.55,12.43-2.69s19.91-19.79,23.44-26.2-2-11.19-3.85-14S325.35,102,320.39,104.12Z"
                                    style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                                </path>
                            </clipPath>
                            <clipPath id="freepik--clip-path-5--inject-2">
                                <circle cx="341.93" cy="103.81" r="26.5"
                                    transform="translate(-15.38 99.53) rotate(-16.2)"
                                    style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                                </circle>
                            </clipPath>
                            <clipPath id="freepik--clip-path-6--inject-2">
                                <path
                                    d="M347.71,134.5s-10.29-2.78-14.34,4.95.52,27,.52,27-7.52,12.22-9.43,13.55-7.29.75-12.59,3.45-3.55,5.47-2.14,6.4,5.73-1.85,7-1.75,1.13,2.39-3.87,7.58S305.57,201,307,203.4a3.69,3.69,0,0,0,4,1.79,2.57,2.57,0,0,0,1.4,3.07c2.06,1,2.94.23,2.94.23s-.2,2.61,1.71,3.41a8.13,8.13,0,0,0,4.59,0s1.81,2.12,3.64,1.77,6-5.45,9.3-9.79,16-19.77,21-29.23,2.63-19,1.61-24.83S351.55,135.78,347.71,134.5Z"
                                    style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                                </path>
                            </clipPath>
                            <clipPath id="freepik--clip-path-7--inject-2">
                                <path
                                    d="M257.06,138.09s4.16,12,9.51,12.89,12.79-8.19,14.3-15-3.8-12.29-11.48-19.13-18.69-10.82-28-5.63-23.07,20-23.07,20-8.61-7.57-13.18-3.66,1.39,15.87,5.6,20.8S222.63,160.52,230,158.8s13.21-15.55,18-19.62S256,136.86,257.06,138.09Z"
                                    style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                                </path>
                            </clipPath>
                            <clipPath id="freepik--clip-path-8--inject-2">
                                <path
                                    d="M281.13,180.59s12.17,3.58,16-.24,4.4-15.43-3.88-20.35c-6-3.54-12.21-4-22.24-1.76s-19.66,8.93-20.83,19.49,2.9,30.42,2.9,30.42-11.15,2.61-10.63,8.61,13.73,8.09,20.18,7.52,16.74-2.63,19.61-9.62-5-19.78-5.54-26S279.52,180.73,281.13,180.59Z"
                                    style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                                </path>
                            </clipPath>
                        </defs>
                        <g id="freepik--background-simple--inject-2">
                            <path
                                d="M58.88,272.43s-.48,70.8,56.64,119.44,138.69,54.06,204.65,60.2S438.39,422,448.25,365.48s-40-74.42-64.93-139.64-21.63-86.38-78.1-127.52S157,79.26,106.81,146.07,58.88,272.43,58.88,272.43Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M58.88,272.43s-.48,70.8,56.64,119.44,138.69,54.06,204.65,60.2S438.39,422,448.25,365.48s-40-74.42-64.93-139.64-21.63-86.38-78.1-127.52S157,79.26,106.81,146.07,58.88,272.43,58.88,272.43Z"
                                style="fill:#fff;opacity:0.7000000000000001"></path>
                        </g>
                        <g id="freepik--planet-3--inject-2">
                            <path d="M396.65,263.73a15.34,15.34,0,1,1,20.65-6.64A15.33,15.33,0,0,1,396.65,263.73Z"
                                style="fill:#263238"></path>
                            <path d="M411.38,241.85l7.44,10.44a15.17,15.17,0,0,0-.34-6.08Z" style="fill:currentColor"></path>
                            <path
                                d="M395.78,236.94l17.68,24.94a15.17,15.17,0,0,0,3.61-4.38l-14.83-22.68A15.32,15.32,0,0,0,395.78,236.94Z"
                                style="fill:currentColor"></path>
                            <path d="M403.09,265.4l-7.68-11,4,10.42A15.58,15.58,0,0,0,403.09,265.4Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M409.33,264.32l-17.56-23.93c-.17.21-.33.44-.49.66L404,265.42A15.47,15.47,0,0,0,409.33,264.32Z"
                                style="fill:currentColor"></path>
                        </g>
                        <g id="freepik--planet-2--inject-2">
                            <path d="M261.76,432.31A24.74,24.74,0,1,1,274,399.52,24.73,24.73,0,0,1,261.76,432.31Z"
                                style="fill:#263238"></path>
                            <g style="clip-path:url(#freepik--clip-path--inject-2)">
                                <path
                                    d="M273.78,420.5,256.9,394l19.17,18.42c.05-.51.09-1,.11-1.54l-22.71-25.74a24.2,24.2,0,0,0-5.82.22l4.56,7.25-7.54-6.6h0l6,10.86-12.13-8.14c-.3.19-.6.38-.89.58l22.51,25-17.86-13.59,6.35,10-9.25-6.4,24.22,27.06a24.58,24.58,0,0,0,7.57-6.57l-4.93-8.23,6.12,6.52A23.74,23.74,0,0,0,273.78,420.5Z"
                                    style="fill:currentColor"></path>
                                <path
                                    d="M258.77,433.45l-19.35-22.32,8.6,13.28-21.2-16.62a24.73,24.73,0,0,0,21.42,26.55l-7.64-6.79,11.86,7A25.24,25.24,0,0,0,258.77,433.45Z"
                                    style="fill:currentColor"></path>
                                <path d="M260.69,386.87l10.85,12.6-2.2-4.81,3.51,2.7A24.63,24.63,0,0,0,260.69,386.87Z"
                                    style="fill:currentColor"></path>
                                <path d="M235.46,406.36l-5.86-8.1a25.21,25.21,0,0,0-2.5,7.31Z" style="fill:currentColor">
                                </path>
                            </g>
                            <path
                                d="M288.23,393.36c-1.8-3.94-9.78-4.49-20.38-2.08a22.7,22.7,0,0,1,1.91,1.89c7.92-1.82,13.57-1.66,14.74.88,2.06,4.51-10.79,14.81-28.71,23s-34.1,11.19-36.17,6.68c-1.06-2.32,1.85-6.18,7.36-10.5a23.69,23.69,0,0,1-.23-2.65c-7.69,6-11.78,11.84-10.09,15.52,2.85,6.24,21.19,4,41-5.07S291.08,399.6,288.23,393.36Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--planet-1--inject-2">
                            <circle cx="133.94" cy="174.23" r="24.43" style="fill:currentColor"></circle>
                            <path
                                d="M139.7,156.16a18.88,18.88,0,0,1,5.59-3.55,23.93,23.93,0,0,0-6.3-2.27,56.64,56.64,0,0,0-6.44,5c-8.74,7.94-6.36,7.15-19.06,11.91a19.87,19.87,0,0,0-3.37,1.62,24.06,24.06,0,0,0-.61,5.33,24.38,24.38,0,0,0,1.73,9c4.54-1.38,10.58-3.62,13.37-6.41C129.37,172.05,130.17,164.9,139.7,156.16Z"
                                style="fill:#263238"></path>
                            <path
                                d="M116.19,191a24.61,24.61,0,0,0,6.39,4.87c4.55-3.18,6.67-6.56,13.15-9.5,5.69-2.59,15.08-3.16,20.94-3.23a24.32,24.32,0,0,0,1.69-8.89c0-.42,0-.83-.06-1.25a70.36,70.36,0,0,0-20.19,4.63C128.87,181.3,124.39,187.85,116.19,191Z"
                                style="fill:#263238"></path>
                            <path
                                d="M140.49,165.69c4.32,2.16,11,1,16.15-.44a24.52,24.52,0,0,0-4.11-6.83C145.65,159.71,134.51,162.7,140.49,165.69Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Text--inject-2">
                            <path
                                d="M145.93,368.3l.51-.84a7.3,7.3,0,0,0,5.07,1.94c3.08,0,4.44-1.34,4.44-3,0-4.61-9.6-1.85-9.6-7.51,0-2.18,1.67-4.09,5.45-4.09a8.2,8.2,0,0,1,4.63,1.39l-.42.9a7.57,7.57,0,0,0-4.21-1.3c-3,0-4.33,1.38-4.33,3.08,0,4.61,9.6,1.88,9.6,7.46,0,2.18-1.74,4.07-5.54,4.07A7.89,7.89,0,0,1,145.93,368.3Z"
                                style="fill:#263238"></path>
                            <path
                                d="M170.2,364.81h-9.86a4.9,4.9,0,0,0,8.52,3l.64.73a5.48,5.48,0,0,1-4.33,1.86,5.62,5.62,0,0,1-5.9-5.82,5.49,5.49,0,1,1,11,0C170.23,364.59,170.2,364.7,170.2,364.81Zm-9.84-.86h8.79a4.4,4.4,0,0,0-8.79,0Z"
                                style="fill:#263238"></path>
                            <path
                                d="M179.06,358.72v1.08l-.27,0c-2.55,0-4.06,1.69-4.06,4.52v6h-1.1V358.81h1.05v2.51A4.37,4.37,0,0,1,179.06,358.72Z"
                                style="fill:#263238"></path>
                            <path d="M191.82,358.81l-5.19,11.47h-1.12l-5.16-11.47h1.17l4.56,10.26,4.62-10.26Z"
                                style="fill:#263238"></path>
                            <path d="M193.86,355.14a.9.9,0,0,1,.9-.9.89.89,0,1,1-.9.9Zm.35,3.67h1.1v11.47h-1.1Z"
                                style="fill:#263238"></path>
                            <path
                                d="M198.69,364.54a5.59,5.59,0,0,1,5.8-5.82,5.06,5.06,0,0,1,4.35,2.11l-.81.6a4.19,4.19,0,0,0-3.54-1.72,4.84,4.84,0,0,0,0,9.67,4.19,4.19,0,0,0,3.54-1.72l.81.6a5.1,5.1,0,0,1-4.35,2.1A5.6,5.6,0,0,1,198.69,364.54Z"
                                style="fill:#263238"></path>
                            <path
                                d="M221.62,364.81h-9.86a4.9,4.9,0,0,0,8.52,3l.64.73a5.48,5.48,0,0,1-4.33,1.86,5.63,5.63,0,0,1-5.91-5.82,5.49,5.49,0,0,1,5.5-5.82,5.43,5.43,0,0,1,5.46,5.78C221.64,364.59,221.62,364.7,221.62,364.81Zm-9.84-.86h8.79a4.4,4.4,0,0,0-8.79,0Z"
                                style="fill:#263238"></path>
                            <path
                                d="M230.91,363.75V354.9H232v8.81c0,3.84,1.85,5.64,5.05,5.64s5-1.8,5-5.64V354.9h1.12v8.85c0,4.4-2.35,6.64-6.17,6.64S230.91,368.15,230.91,363.75Z"
                                style="fill:#263238"></path>
                            <path
                                d="M258.37,363.58v6.7h-1.1v-6.62c0-2.59-1.38-4-3.71-4a4.09,4.09,0,0,0-4.35,4.46v6.11h-1.1V358.81h1.06v2.48a4.72,4.72,0,0,1,4.54-2.57C256.5,358.72,258.37,360.37,258.37,363.58Z"
                                style="fill:#263238"></path>
                            <path
                                d="M271.17,363v7.27h-1.05v-2a4.4,4.4,0,0,1-4.13,2.13c-2.57,0-4.13-1.31-4.13-3.27,0-1.73,1.1-3.21,4.28-3.21h3.94V363c0-2.13-1.17-3.27-3.41-3.27a5.92,5.92,0,0,0-3.95,1.45l-.55-.79a7,7,0,0,1,4.59-1.63C269.59,358.72,271.17,360.17,271.17,363Zm-1.09,3.88v-2.15h-3.91c-2.38,0-3.21,1-3.21,2.31,0,1.49,1.16,2.41,3.18,2.41A3.93,3.93,0,0,0,270.08,366.89Z"
                                style="fill:#263238"></path>
                            <path d="M284.68,358.81l-5.18,11.47h-1.12l-5.16-11.47h1.16L279,369.07l4.61-10.26Z"
                                style="fill:#263238"></path>
                            <path
                                d="M295,363v7.27H294v-2a4.39,4.39,0,0,1-4.13,2.13c-2.57,0-4.13-1.31-4.13-3.27,0-1.73,1.1-3.21,4.28-3.21h3.94V363c0-2.13-1.17-3.27-3.41-3.27a5.92,5.92,0,0,0-3.95,1.45l-.55-.79a7,7,0,0,1,4.59-1.63C293.42,358.72,295,360.17,295,363Zm-1.09,3.88v-2.15H290c-2.37,0-3.21,1-3.21,2.31,0,1.49,1.16,2.41,3.18,2.41A3.93,3.93,0,0,0,293.91,366.89Z"
                                style="fill:#263238"></path>
                            <path
                                d="M299.18,355.14a.9.9,0,0,1,.9-.9.89.89,0,1,1,0,1.78A.88.88,0,0,1,299.18,355.14Zm.35,3.67h1.1v11.47h-1.1Z"
                                style="fill:#263238"></path>
                            <path d="M305.26,354h1.1v16.3h-1.1Z" style="fill:#263238"></path>
                            <path
                                d="M319.27,363v7.27h-1v-2a4.39,4.39,0,0,1-4.13,2.13c-2.57,0-4.13-1.31-4.13-3.27,0-1.73,1.1-3.21,4.29-3.21h3.93V363c0-2.13-1.17-3.27-3.41-3.27a5.92,5.92,0,0,0-3.95,1.45l-.55-.79a7,7,0,0,1,4.59-1.63C317.69,358.72,319.27,360.17,319.27,363Zm-1.09,3.88v-2.15h-3.91c-2.37,0-3.21,1-3.21,2.31,0,1.49,1.16,2.41,3.19,2.41A3.93,3.93,0,0,0,318.18,366.89Z"
                                style="fill:#263238"></path>
                            <path
                                d="M335.22,364.54a5.56,5.56,0,0,1-5.67,5.82,5.12,5.12,0,0,1-4.7-2.79v2.71H323.8V354h1.1v7.45a5.12,5.12,0,0,1,4.65-2.71A5.55,5.55,0,0,1,335.22,364.54Zm-1.1,0a4.63,4.63,0,1,0-4.63,4.84A4.57,4.57,0,0,0,334.12,364.54Z"
                                style="fill:#263238"></path>
                            <path d="M338.63,354h1.09v16.3h-1.09Z" style="fill:#263238"></path>
                            <path
                                d="M354,364.81h-9.86a4.9,4.9,0,0,0,8.52,3l.64.73a5.48,5.48,0,0,1-4.33,1.86,5.62,5.62,0,0,1-5.9-5.82,5.49,5.49,0,1,1,11,0C354.07,364.59,354,364.7,354,364.81ZM344.2,364H353a4.4,4.4,0,0,0-8.79,0Z"
                                style="fill:#263238"></path>
                            <path
                                d="M200.39,297.85c0,17.37-12.75,32.5-40.77,32.5-13.59,0-27.88-3.78-37.41-10.51l9-17.37c7.42,5.6,17.65,8.82,27.88,8.82,11.34,0,18.35-4.76,18.35-12.74,0-7.71-5-12.75-22.84-12.75H129.5l5-55.2h59.82v18.21H153.45l-1.54,18.63h8C188.9,267.44,200.39,280.47,200.39,297.85Zm9.24-18.22c0-32.36,17.93-50.71,42-50.71s42,18.35,42,50.71-17.79,50.72-42,50.72S209.63,312,209.63,279.63Zm61.22,0c0-22.27-7.84-31.52-19.19-31.52s-19,9.25-19,31.52,7.84,31.52,19,31.52S270.85,301.91,270.85,279.63Zm104.94,19.06c0,16.53-12.75,31.66-40.63,31.66-13.73,0-27.88-3.78-37.41-10.51l8.83-17.37c7.43,5.6,17.79,8.82,28,8.82,11.35,0,18.35-4.62,18.35-12.6,0-7.43-5.46-12.05-18.35-12.05H324.23v-15l20.18-22.84H302.66V230.6h68.65v14.71l-22.14,25.21C366.82,273.33,375.79,284.25,375.79,298.69Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Character--inject-2">
                            <path
                                d="M325.24,82.79h0A3.48,3.48,0,0,1,326.33,78L332,74.41a3.48,3.48,0,0,1,4.81,1.09h0a3.48,3.48,0,0,1-1.09,4.81l-5.66,3.57A3.49,3.49,0,0,1,325.24,82.79Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M322.16,107.29a39.79,39.79,0,0,0-9.85-9.82,145.36,145.36,0,0,0-15.56-8.06l-3.23-18a61.53,61.53,0,0,0,8.28-9.8c2.92-4.71,2-7.87.13-11.13s-4.46-1.15-4.85.34a33.33,33.33,0,0,0-.52,4.75s-1.74-12-2.75-14.73-4.86-.1-4.52.81c0,0-1.16-3.41-3.55-3.45s-3.07,4-3.07,4-3.07-1.42-4.79.36-.9,6.24-.9,6.24-2.74,1-3.16,4.89-.08,10.7,1,12.57a20.08,20.08,0,0,1,1.45,2.78c-1.36,16.24-1.31,15.17-1.71,21.65-.28,4.56,2.71,15.16,7,19.57s19.64,12.2,19.64,12.2S317.23,118.33,322.16,107.29Z"
                                style="fill:#fff"></path>
                            <g style="clip-path:url(#freepik--clip-path-2--inject-2)">
                                <path
                                    d="M301.26,122.48s16-4.15,20.9-15.19c0,0-.32-.47-.89-1.22l-4.16-3.47a139.3,139.3,0,0,0-17.57,2.61c-8.78,2-15.61-2.28-18.21-12s-5-24.11-5-24.11h0c-1.36,16.24-1.31,15.17-1.71,21.65-.28,4.56,2.71,15.16,7,19.57S301.26,122.48,301.26,122.48Z"
                                    style="fill:currentColor"></path>
                                <path
                                    d="M301.26,122.48s16-4.15,20.9-15.19c0,0-.32-.47-.89-1.22l-4.16-3.47a139.3,139.3,0,0,0-17.57,2.61c-8.78,2-15.61-2.28-18.21-12s-5-24.11-5-24.11h0c-1.36,16.24-1.31,15.17-1.71,21.65-.28,4.56,2.71,15.16,7,19.57S301.26,122.48,301.26,122.48Z"
                                    style="fill:#fff;opacity:0.5"></path>
                            </g>
                            <path
                                d="M322.16,107.29a39.79,39.79,0,0,0-9.85-9.82,145.36,145.36,0,0,0-15.56-8.06l-3.23-18a61.53,61.53,0,0,0,8.28-9.8c2.92-4.71,2-7.87.13-11.13s-4.46-1.15-4.85.34a33.33,33.33,0,0,0-.52,4.75s-1.74-12-2.75-14.73-4.86-.1-4.52.81c0,0-1.16-3.41-3.55-3.45s-3.07,4-3.07,4-3.07-1.42-4.79.36-.9,6.24-.9,6.24-2.74,1-3.16,4.89-.08,10.7,1,12.57a20.08,20.08,0,0,1,1.45,2.78c-1.36,16.24-1.31,15.17-1.71,21.65-.28,4.56,2.71,15.16,7,19.57s19.64,12.2,19.64,12.2S317.23,118.33,322.16,107.29Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M295.5,82.42l-2-11a61.53,61.53,0,0,0,8.28-9.8c2.92-4.71,2-7.87.13-11.13s-4.46-1.15-4.85.34a33.33,33.33,0,0,0-.52,4.75s-1.74-12-2.75-14.73-4.86-.1-4.52.81c0,0-1.16-3.41-3.55-3.45s-3.07,4-3.07,4-3.07-1.42-4.79.36-.9,6.24-.9,6.24-2.74,1-3.16,4.89-.08,10.7,1,12.57a20.08,20.08,0,0,1,1.45,2.78c-.6,7.18-.93,11-1.14,13.54Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M279.54,107.54a18.33,18.33,0,0,0,1.21,1.74c4.22-3.53,13.72-12,18-19.27-1.2-.38-2-.6-2-.6S287.91,101,279.54,107.54Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path d="M296.56,55.55s-9.45-.35-10.45,7.62"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <line x1="289.29" y1="41.63" x2="289.61" y2="51.68"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </line>
                            <line x1="282.67" y1="42.22" x2="283.32" y2="51.31"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </line>
                            <line x1="276.98" y1="48.82" x2="278" y2="54.49"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </line>
                            <path d="M291.51,51.21S280.84,53,276.73,56.49"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M289,114.24c3.48-3,3.21-9-.62-13.49-3.69-4.32-9.34-5.59-12.86-3,1.19,4.6,3.37,9.76,6.07,12.51A39.12,39.12,0,0,0,288,115,6,6,0,0,0,289,114.24Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M289,114.24c3.48-3,3.21-9-.62-13.49-3.69-4.32-9.34-5.59-12.86-3,1.19,4.6,3.37,9.76,6.07,12.51A39.12,39.12,0,0,0,288,115,6,6,0,0,0,289,114.24Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M282.21,125.93s-4.47.47-5.88,1.68S264.19,138,262.45,143.44s4.87,21.72,12.09,28,16.24,12.93,23.9,11.56,16.46-13.17,17.37-16.38-29.06-40-29.06-40S284.62,124.48,282.21,125.93Z"
                                style="fill:#fff"></path>
                            <g style="clip-path:url(#freepik--clip-path-3--inject-2)">
                                <path
                                    d="M282.21,125.93s-.88.09-2,.3l1,1.69s-.92,9.48,5.58,20.22,17.89,17.56,17.56,21.46,1,9.11-8.78,8.46-20.16-17.24-23.74-25.37c-1.86-4.23-3.46-10.65-5.29-15.62a20.91,20.91,0,0,0-4.16,6.37c-1.74,5.44,4.87,21.72,12.09,28s16.24,12.93,23.9,11.56,16.46-13.17,17.37-16.38-29.06-40-29.06-40S284.62,124.48,282.21,125.93Z"
                                    style="fill:currentColor"></path>
                                <path
                                    d="M282.21,125.93s-.88.09-2,.3l1,1.69s-.92,9.48,5.58,20.22,17.89,17.56,17.56,21.46,1,9.11-8.78,8.46-20.16-17.24-23.74-25.37c-1.86-4.23-3.46-10.65-5.29-15.62a20.91,20.91,0,0,0-4.16,6.37c-1.74,5.44,4.87,21.72,12.09,28s16.24,12.93,23.9,11.56,16.46-13.17,17.37-16.38-29.06-40-29.06-40S284.62,124.48,282.21,125.93Z"
                                    style="fill:#fff;opacity:0.5"></path>
                            </g>
                            <path
                                d="M282.21,125.93s-4.47.47-5.88,1.68S264.19,138,262.45,143.44s4.87,21.72,12.09,28,16.24,12.93,23.9,11.56,16.46-13.17,17.37-16.38-29.06-40-29.06-40S284.62,124.48,282.21,125.93Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M320.39,104.12s-4.74-1.6-11.8,1.4-24.72,13.37-27.31,22.4c-1.71,5.93,17,33.62,28.69,38.18,3.14,1.22,6,2.55,12.43-2.69s19.91-19.79,23.44-26.2-2-11.19-3.85-14S325.35,102,320.39,104.12Z"
                                style="fill:#fff"></path>
                            <g style="clip-path:url(#freepik--clip-path-4--inject-2)">
                                <path
                                    d="M345.88,137.12,333.69,141s-12.68,15-17.23,18.87-18.87-5.53-23.75-10.09l-1.44-1.34c5.83,7.92,13.08,15.48,18.7,17.68,3.14,1.22,6,2.55,12.43-2.69s19.91-19.79,23.44-26.2A.36.36,0,0,0,345.88,137.12Z"
                                    style="fill:currentColor"></path>
                                <path
                                    d="M339.55,135.78l6.56.85c2.91-6.12-2.29-10.7-4.12-13.44s-16.64-21.19-21.6-19.07a11.06,11.06,0,0,0-2.79-.41c-6,4.52-5.32,9.71.16,19.06S339.55,135.78,339.55,135.78Z"
                                    style="fill:currentColor"></path>
                                <g style="opacity:0.5">
                                    <path
                                        d="M345.88,137.12,333.69,141s-12.68,15-17.23,18.87-18.87-5.53-23.75-10.09l-1.44-1.34c5.83,7.92,13.08,15.48,18.7,17.68,3.14,1.22,6,2.55,12.43-2.69s19.91-19.79,23.44-26.2A.36.36,0,0,0,345.88,137.12Z"
                                        style="fill:#fff"></path>
                                    <path
                                        d="M339.55,135.78l6.56.85c2.91-6.12-2.29-10.7-4.12-13.44s-16.64-21.19-21.6-19.07a11.06,11.06,0,0,0-2.79-.41c-6,4.52-5.32,9.71.16,19.06S339.55,135.78,339.55,135.78Z"
                                        style="fill:#fff"></path>
                                </g>
                            </g>
                            <path
                                d="M320.39,104.12s-4.74-1.6-11.8,1.4-24.72,13.37-27.31,22.4c-1.71,5.93,17,33.62,28.69,38.18,3.14,1.22,6,2.55,12.43-2.69s19.91-19.79,23.44-26.2-2-11.19-3.85-14S325.35,102,320.39,104.12Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <rect x="292.3" y="117.55" width="32.36" height="27.62" rx="5.89"
                                transform="translate(232.93 -195.3) rotate(53.91)"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </rect>
                            <path
                                d="M479.52,230.22c-14.95-39-52.35-38.57-85.34-38.16-11.37.14-22.11.28-32-1-33.37-4.22-42.91-38.52-43-39a2.38,2.38,0,0,0-4.61,1.22c.1.38,10.39,37.84,47,42.48,10.23,1.3,21.64,1.15,32.68,1,33-.41,67.06-.84,80.83,35.09a49.43,49.43,0,0,1-8.95,49.48c-10.24,11.79-24.77,16.57-39.85,13.11-14.23-3.27-28.29-7.77-41.89-12.12-22.51-7.2-45.78-14.65-70.48-16.72-42.35-3.56-71.81,17.07-105.89,40.94-6.86,4.81-13.95,9.77-21.38,14.71l-4.23,2.82c-21.09,14.08-42.89,28.64-67.56,31.27-19.18,2-38.68-6.94-48.55-22.35A37.74,37.74,0,0,1,61,304.31,31.75,31.75,0,0,1,76.05,284c12.77-7.61,35.33-10.14,54.57-8l.33-4.75c-20.19-2.15-43.75.61-57.34,8.7a36.91,36.91,0,0,0-17.25,23.35,42.49,42.49,0,0,0,5.92,32.42c9.9,15.47,27.81,24.82,46.82,24.85a59.76,59.76,0,0,0,6.25-.33c25.83-2.75,49.14-18.31,69.69-32l4.22-2.82c7.49-5,14.6-10,21.48-14.77,33.33-23.35,62.11-43.52,102.76-40.1,24.16,2,47.17,9.39,69.42,16.51,13.7,4.38,27.86,8.91,42.28,12.22,16.86,3.87,33.08-1.46,44.52-14.62A54.23,54.23,0,0,0,479.52,230.22Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path d="M313.4,121.06a3.25,3.25,0,1,1-3.25-3.25A3.25,3.25,0,0,1,313.4,121.06Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path d="M304.58,128.48a3.25,3.25,0,1,1-3.24-3.24A3.24,3.24,0,0,1,304.58,128.48Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <circle cx="341.93" cy="103.81" r="26.5"
                                transform="translate(-15.38 99.53) rotate(-16.2)" style="fill:#fff"></circle>
                            <g style="clip-path:url(#freepik--clip-path-5--inject-2)">
                                <path
                                    d="M362.07,86.59a27,27,0,0,0-3-3A26.47,26.47,0,0,1,316.45,111a26.49,26.49,0,1,0,45.62-24.41Z"
                                    style="fill:currentColor"></path>
                                <path
                                    d="M362.07,86.59a27,27,0,0,0-3-3A26.47,26.47,0,0,1,316.45,111a26.49,26.49,0,1,0,45.62-24.41Z"
                                    style="fill:#fff;opacity:0.5"></path>
                            </g>
                            <circle cx="341.93" cy="103.81" r="26.5"
                                transform="translate(-15.38 99.53) rotate(-16.2)"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </circle>
                            <line x1="365.46" y1="122.13" x2="373.18" y2="115.53"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </line>
                            <path d="M375.23,116.36a2,2,0,0,0-2.65-3.1,2,2,0,1,0,2.65,3.1Z" style="fill:#263238"></path>
                            <path
                                d="M356,130.13h0a3.48,3.48,0,0,1,.39-4.91l5.08-4.36a3.5,3.5,0,0,1,4.92.39h0a3.48,3.48,0,0,1-.38,4.91l-5.09,4.36A3.49,3.49,0,0,1,356,130.13Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M347.71,134.5s-10.29-2.78-14.34,4.95.52,27,.52,27-7.52,12.22-9.43,13.55-7.29.75-12.59,3.45-3.55,5.47-2.14,6.4,5.73-1.85,7-1.75,1.13,2.39-3.87,7.58S305.57,201,307,203.4a3.69,3.69,0,0,0,4,1.79,2.57,2.57,0,0,0,1.4,3.07c2.06,1,2.94.23,2.94.23s-.2,2.61,1.71,3.41a8.13,8.13,0,0,0,4.59,0s1.81,2.12,3.64,1.77,6-5.45,9.3-9.79,16-19.77,21-29.23,2.63-19,1.61-24.83S351.55,135.78,347.71,134.5Z"
                                style="fill:#fff"></path>
                            <g style="clip-path:url(#freepik--clip-path-6--inject-2)">
                                <path
                                    d="M357.19,149.85c-1-5.83-5.64-14.07-9.48-15.35l-.24-.06a56.31,56.31,0,0,1,4.11,26.71c-1.3,16.58-16.51,29.66-21.14,34.47-3.71,3.86-8.38,9.27-15.11,13.27a3.25,3.25,0,0,0,1.71,3,8.13,8.13,0,0,0,4.59,0s1.81,2.12,3.64,1.77,6-5.45,9.3-9.79,16-19.77,21-29.23S358.21,155.68,357.19,149.85Z"
                                    style="fill:currentColor"></path>
                                <path
                                    d="M357.19,149.85c-1-5.83-5.64-14.07-9.48-15.35l-.24-.06a56.31,56.31,0,0,1,4.11,26.71c-1.3,16.58-16.51,29.66-21.14,34.47-3.71,3.86-8.38,9.27-15.11,13.27a3.25,3.25,0,0,0,1.71,3,8.13,8.13,0,0,0,4.59,0s1.81,2.12,3.64,1.77,6-5.45,9.3-9.79,16-19.77,21-29.23S358.21,155.68,357.19,149.85Z"
                                    style="fill:#fff;opacity:0.5"></path>
                            </g>
                            <path
                                d="M347.71,134.5s-10.29-2.78-14.34,4.95.52,27,.52,27-7.52,12.22-9.43,13.55-7.29.75-12.59,3.45-3.55,5.47-2.14,6.4,5.73-1.85,7-1.75,1.13,2.39-3.87,7.58S305.57,201,307,203.4a3.69,3.69,0,0,0,4,1.79,2.57,2.57,0,0,0,1.4,3.07c2.06,1,2.94.23,2.94.23s-.2,2.61,1.71,3.41a8.13,8.13,0,0,0,4.59,0s1.81,2.12,3.64,1.77,6-5.45,9.3-9.79,16-19.77,21-29.23,2.63-19,1.61-24.83S351.55,135.78,347.71,134.5Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M325.27,213.7c1.83-.35,6-5.45,9.3-9.79,1.87-2.45,6.75-8.46,11.54-14.93-3.21-11-12.71-14.29-16.94-15.2-1.91,2.86-3.87,5.6-4.71,6.19-1.91,1.33-7.29.75-12.59,3.45s-3.55,5.47-2.14,6.4,5.73-1.85,7-1.75,1.13,2.39-3.87,7.58S305.57,201,307,203.4a3.69,3.69,0,0,0,4,1.79,2.57,2.57,0,0,0,1.4,3.07c2.06,1,2.94.23,2.94.23s-.2,2.61,1.71,3.41a8.13,8.13,0,0,0,4.59,0S323.44,214.05,325.27,213.7Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path d="M311,205.19a33.58,33.58,0,0,0,10-7.92"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path d="M315.33,208.49a32.84,32.84,0,0,0,10.48-8.05"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path d="M321.63,211.93s5.76-4.31,8.5-7.87"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M357.65,169.44c.21-.76.37-1.52.51-2.27-8.38-5.59-18.94-3.76-24.57-2.13.18.87.3,1.38.3,1.38l-.87,1.4C346.48,164.57,353.9,167,357.65,169.44Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M351.81,174.55a10.18,10.18,0,0,0,2.62,2.18c.41-.71.8-1.39,1.15-2a28.72,28.72,0,0,0,2.92-16.28,9.54,9.54,0,0,0-5.77,2.27A9.84,9.84,0,0,0,351.81,174.55Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M257.06,138.09s4.16,12,9.51,12.89,12.79-8.19,14.3-15-3.8-12.29-11.48-19.13-18.69-10.82-28-5.63-23.07,20-23.07,20-8.61-7.57-13.18-3.66,1.39,15.87,5.6,20.8S222.63,160.52,230,158.8s13.21-15.55,18-19.62S256,136.86,257.06,138.09Z"
                                style="fill:#fff"></path>
                            <g style="clip-path:url(#freepik--clip-path-7--inject-2)">
                                <path
                                    d="M269,141c-8.13-3.9-5.85-13.66-14-16.26s-7.48,2.93-14,13.34-18.54,9.75-26.67,7.15a79.89,79.89,0,0,1-7.59-2.89,34.21,34.21,0,0,0,4,6.11c4.21,4.93,11.86,12.09,19.22,10.37s13.21-15.55,18-19.62,8.06-2.32,9.11-1.09c0,0,4.16,12,9.51,12.89s12.79-8.19,14.3-15a10.36,10.36,0,0,0,.19-3.4l-.38-.08S277.1,144.89,269,141Z"
                                    style="fill:currentColor"></path>
                                <path
                                    d="M269,141c-8.13-3.9-5.85-13.66-14-16.26s-7.48,2.93-14,13.34-18.54,9.75-26.67,7.15a79.89,79.89,0,0,1-7.59-2.89,34.21,34.21,0,0,0,4,6.11c4.21,4.93,11.86,12.09,19.22,10.37s13.21-15.55,18-19.62,8.06-2.32,9.11-1.09c0,0,4.16,12,9.51,12.89s12.79-8.19,14.3-15a10.36,10.36,0,0,0,.19-3.4l-.38-.08S277.1,144.89,269,141Z"
                                    style="fill:#fff;opacity:0.5"></path>
                            </g>
                            <path
                                d="M257.06,138.09s4.16,12,9.51,12.89,12.79-8.19,14.3-15-3.8-12.29-11.48-19.13-18.69-10.82-28-5.63-23.07,20-23.07,20-8.61-7.57-13.18-3.66,1.39,15.87,5.6,20.8S222.63,160.52,230,158.8s13.21-15.55,18-19.62S256,136.86,257.06,138.09Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M230.83,119.18c-6.64,5.82-12.48,12.11-12.48,12.11s-8.61-7.57-13.18-3.66,1.39,15.87,5.6,20.8S222.63,160.52,230,158.8c6.64-1.55,12-13,16.52-18.15A88.79,88.79,0,0,1,230.83,119.18Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M253,109a22.56,22.56,0,0,0-2.46-.15,69.54,69.54,0,0,1,1.64,28,5.6,5.6,0,0,1,2.45-.1C255.18,129.66,255.59,117.91,253,109Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path d="M258.61,124.58a8.79,8.79,0,1,1,1-12.4A8.79,8.79,0,0,1,258.61,124.58Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M230,158.8a11,11,0,0,0,4.66-2.68c-4.71.78-13.41.52-21.32-9-7.7-9.24-7.83-16.43-7.07-20.21a4.87,4.87,0,0,0-1.09.69c-4.58,3.91,1.39,15.87,5.6,20.8S222.63,160.52,230,158.8Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M281.13,180.59s12.17,3.58,16-.24,4.4-15.43-3.88-20.35c-6-3.54-12.21-4-22.24-1.76s-19.66,8.93-20.83,19.49,2.9,30.42,2.9,30.42-11.15,2.61-10.63,8.61,13.73,8.09,20.18,7.52,16.74-2.63,19.61-9.62-5-19.78-5.54-26S279.52,180.73,281.13,180.59Z"
                                style="fill:#fff"></path>
                            <g style="clip-path:url(#freepik--clip-path-8--inject-2)">
                                <path
                                    d="M281.13,180.59s12.17,3.58,16-.24c2.5-2.49,3.59-8.26,1.78-13.35h0s1,5.21-6.18,6.51-18.86-1.3-24.06,5.2,2.27,19.84,2.92,28.62S270.27,219,261.49,220s-16.63-5.3-18.44-1.48c2.69,4.63,13.83,6.25,19.6,5.74,6.46-.57,16.74-2.63,19.61-9.62s-5-19.78-5.54-26S279.52,180.73,281.13,180.59Z"
                                    style="fill:currentColor"></path>
                                <path
                                    d="M281.13,180.59s12.17,3.58,16-.24c2.5-2.49,3.59-8.26,1.78-13.35h0s1,5.21-6.18,6.51-18.86-1.3-24.06,5.2,2.27,19.84,2.92,28.62S270.27,219,261.49,220s-16.63-5.3-18.44-1.48c2.69,4.63,13.83,6.25,19.6,5.74,6.46-.57,16.74-2.63,19.61-9.62s-5-19.78-5.54-26S279.52,180.73,281.13,180.59Z"
                                    style="fill:#fff;opacity:0.5"></path>
                            </g>
                            <path
                                d="M281.13,180.59s12.17,3.58,16-.24,4.4-15.43-3.88-20.35c-6-3.54-12.21-4-22.24-1.76s-19.66,8.93-20.83,19.49,2.9,30.42,2.9,30.42-11.15,2.61-10.63,8.61,13.73,8.09,20.18,7.52,16.74-2.63,19.61-9.62-5-19.78-5.54-26S279.52,180.73,281.13,180.59Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M250.5,191c.88,8.79,2.6,17.19,2.6,17.19s-11.15,2.61-10.63,8.61,13.73,8.09,20.18,7.52,16.74-2.63,19.61-9.62c2.59-6.31-3.54-17.32-5.18-24A88.55,88.55,0,0,1,250.5,191Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M255.08,167.06a21.79,21.79,0,0,0-1.54,1.91,69.88,69.88,0,0,1,23.71,14.91,5.57,5.57,0,0,1,1.34-2C273.18,177.23,263.85,170.07,255.08,167.06Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <circle cx="262.27" cy="172.25" r="8.8"
                                transform="translate(-39.6 86.65) rotate(-17.46)"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </circle>
                            <path
                                d="M282.26,214.66a10.89,10.89,0,0,0,.52-5.35c-2.1,4.29-7.36,11.22-19.68,12.14-12,.9-17.93-3.17-20.55-6a4.58,4.58,0,0,0-.08,1.29c.53,6,13.73,8.09,20.18,7.52S279.39,221.65,282.26,214.66Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path
                                d="M350.87,92.66a93.78,93.78,0,0,1-7.17-10.92A22.59,22.59,0,1,0,363.21,106,91.3,91.3,0,0,1,350.87,92.66Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.1914845705032349px">
                            </path>
                            <path d="M353.06,113.17a7.26,7.26,0,1,1,.45-9.91A7,7,0,0,1,353.06,113.17Z" style="fill:#fff">
                            </path>
                            <path d="M345.63,96.42a2.16,2.16,0,1,1,.23-3A2.15,2.15,0,0,1,345.63,96.42Z" style="fill:#fff">
                            </path>
                            <rect x="125.16" y="268.54" width="6.45" height="9.32"
                                transform="translate(27.38 -11.26) rotate(5.62)" style="fill:#263238"></rect>
                        </g>
                    </svg>
                @break

                @default
                    <svg id="svg-color" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 500">
                        <g id="freepik--background-simple--inject-34">
                            <path
                                d="M81.91,305.64s25,57,88.21,75.64,130.71-6.2,185.87-24.87S440.16,290,427.87,241.05s-58.76-45.43-102.1-88.9S277.49,90.54,217.43,77.7,91.63,115.41,75.19,187,81.91,305.64,81.91,305.64Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M81.91,305.64s25,57,88.21,75.64,130.71-6.2,185.87-24.87S440.16,290,427.87,241.05s-58.76-45.43-102.1-88.9S277.49,90.54,217.43,77.7,91.63,115.41,75.19,187,81.91,305.64,81.91,305.64Z"
                                style="fill:#fff;opacity:0.8"></path>
                        </g>
                        <g id="freepik--Trees--inject-34">
                            <path d="M403,228.6s22.92,2.27,34.53,16.48c0,0,12.28-16.46,34.32-16.12a44.55,44.55,0,1,0-68.86-.32Z"
                                style="fill:currentColor"></path>
                            <path d="M403,228.6s22.92,2.27,34.53,16.48c0,0,12.28-16.46,34.32-16.12a44.55,44.55,0,1,0-68.86-.32Z"
                                style="fill:#fff;opacity:0.5"></path>
                            <polygon points="436.76 159.12 435.99 307.66 439.86 307.66 436.76 159.12" style="fill:#b8b8b8">
                            </polygon>
                            <path d="M437.93,240.75s7.73-13.93,21.66-18.19c0,0-14.7,3.49-22,15.48Z" style="fill:#b8b8b8">
                            </path>
                            <path d="M437.93,201.29s7.73-13.93,21.66-18.19c0,0-14.7,3.48-22,15.48Z" style="fill:#b8b8b8">
                            </path>
                            <path d="M437.93,221s7.73-13.93,21.66-18.19c0,0-14.7,3.49-22,15.48Z" style="fill:#b8b8b8"></path>
                            <path d="M436.78,211.34s-7.47-13.92-20.91-18.18c0,0,14.19,3.48,21.28,15.48Z" style="fill:#b8b8b8">
                            </path>
                            <path d="M436.78,230.69s-7.47-13.93-20.91-18.18c0,0,14.19,3.48,21.28,15.47Z" style="fill:#b8b8b8">
                            </path>
                            <path
                                d="M27.87,228.6s22.92,2.27,34.53,16.48c0,0,12.28-16.46,34.32-16.12a44.55,44.55,0,1,0-68.86-.32Z"
                                style="fill:currentColor"></path>
                            <path
                                d="M27.87,228.6s22.92,2.27,34.53,16.48c0,0,12.28-16.46,34.32-16.12a44.55,44.55,0,1,0-68.86-.32Z"
                                style="fill:#fff;opacity:0.5"></path>
                            <polygon points="61.65 159.12 60.87 307.66 64.74 307.66 61.65 159.12" style="fill:#b8b8b8">
                            </polygon>
                            <path d="M62.81,240.75s7.73-13.93,21.66-18.19c0,0-14.7,3.49-22,15.48Z" style="fill:#b8b8b8">
                            </path>
                            <path d="M62.81,201.29s7.73-13.93,21.66-18.19c0,0-14.7,3.48-22,15.48Z" style="fill:#b8b8b8">
                            </path>
                            <path d="M62.81,221s7.73-13.93,21.66-18.19c0,0-14.7,3.49-22,15.48Z" style="fill:#b8b8b8"></path>
                            <path d="M61.66,211.34s-7.47-13.92-20.91-18.18c0,0,14.19,3.48,21.28,15.48Z" style="fill:#b8b8b8">
                            </path>
                            <path d="M61.66,230.69s-7.47-13.93-20.91-18.18c0,0,14.19,3.48,21.28,15.47Z" style="fill:#b8b8b8">
                            </path>
                            <path d="M309.87,243s18.76,1.85,28.26,13.48c0,0,10.05-13.47,28.09-13.2a36.46,36.46,0,1,0-56.36-.25Z"
                                style="fill:currentColor"></path>
                            <path d="M309.87,243s18.76,1.85,28.26,13.48c0,0,10.05-13.47,28.09-13.2a36.46,36.46,0,1,0-56.36-.25Z"
                                style="fill:#fff;opacity:0.5"></path>
                            <polygon points="337.51 186.08 336.88 307.66 340.05 307.66 337.51 186.08" style="fill:#b8b8b8">
                            </polygon>
                            <path d="M338.46,252.9s6.34-11.4,17.73-14.89c0,0-12,2.85-18,12.67Z" style="fill:#b8b8b8"></path>
                            <path d="M338.46,220.6s6.34-11.4,17.73-14.88c0,0-12,2.85-18,12.66Z" style="fill:#b8b8b8"></path>
                            <path d="M338.46,236.75s6.34-11.4,17.73-14.89c0,0-12,2.85-18,12.67Z" style="fill:#b8b8b8"></path>
                            <path d="M337.52,228.83s-6.11-11.4-17.11-14.88c0,0,11.61,2.85,17.42,12.66Z" style="fill:#b8b8b8">
                            </path>
                            <path d="M337.52,244.66s-6.11-11.4-17.11-14.88c0,0,11.61,2.85,17.42,12.67Z" style="fill:#b8b8b8">
                            </path>
                            <path d="M128.36,243s18.76,1.85,28.26,13.48c0,0,10-13.47,28.09-13.2a36.46,36.46,0,1,0-56.36-.25Z"
                                style="fill:currentColor"></path>
                            <path d="M128.36,243s18.76,1.85,28.26,13.48c0,0,10-13.47,28.09-13.2a36.46,36.46,0,1,0-56.36-.25Z"
                                style="fill:#fff;opacity:0.5"></path>
                            <polygon points="156 186.08 155.37 307.66 158.54 307.66 156 186.08" style="fill:#b8b8b8">
                            </polygon>
                            <path d="M157,252.9s6.34-11.4,17.73-14.89c0,0-12,2.85-18,12.67Z" style="fill:#b8b8b8"></path>
                            <path d="M157,220.6s6.34-11.4,17.73-14.88c0,0-12,2.85-18,12.66Z" style="fill:#b8b8b8"></path>
                            <path d="M157,236.75s6.34-11.4,17.73-14.89c0,0-12,2.85-18,12.67Z" style="fill:#b8b8b8"></path>
                            <path d="M156,228.83S149.9,217.43,138.9,214c0,0,11.61,2.85,17.42,12.66Z" style="fill:#b8b8b8">
                            </path>
                            <path d="M156,244.66s-6.11-11.4-17.11-14.88c0,0,11.61,2.85,17.42,12.67Z" style="fill:#b8b8b8">
                            </path>
                            <line x1="34.77" y1="308.19" x2="466.31" y2="308.19"
                                style="fill:none;stroke:#263238;stroke-miterlimit:10;stroke-width:1.04742px"></line>
                        </g>
                        <g id="freepik--Text--inject-34">
                            <path
                                d="M188.51,120.72c0-7.73,4.08-12.15,11.53-12.15s11.54,4.42,11.54,12.15v25.14c0,7.73-4.08,12.15-11.54,12.15s-11.53-4.42-11.53-12.15Zm7.6,25.62c0,3.45,1.52,4.76,3.93,4.76s3.94-1.31,3.94-4.76v-26.1c0-3.45-1.52-4.76-3.94-4.76s-3.93,1.31-3.93,4.76Z"
                                style="fill:#263238"></path>
                            <path
                                d="M217.31,120.72c0-7.73,4.07-12.15,11.53-12.15s11.53,4.42,11.53,12.15v25.14c0,7.73-4.08,12.15-11.53,12.15s-11.53-4.42-11.53-12.15Zm7.59,25.62c0,3.45,1.52,4.76,3.94,4.76s3.93-1.31,3.93-4.76v-26.1c0-3.45-1.52-4.76-3.93-4.76s-3.94,1.31-3.94,4.76Z"
                                style="fill:#263238"></path>
                            <path
                                d="M269.23,121.07v6.28c0,7.74-3.73,12-11.32,12h-3.59v18.16h-7.6V109.13h11.19C265.5,109.13,269.23,113.34,269.23,121.07Zm-14.91-5v16.36h3.59c2.41,0,3.72-1.1,3.72-4.55v-7.25c0-3.46-1.31-4.56-3.72-4.56Z"
                                style="fill:#263238"></path>
                            <path
                                d="M284.77,108.57c7.38,0,11.18,4.42,11.18,12.15v1.52h-7.18v-2c0-3.45-1.38-4.76-3.8-4.76s-3.8,1.31-3.8,4.76c0,9.94,14.85,11.81,14.85,25.62,0,7.73-3.87,12.15-11.32,12.15s-11.33-4.42-11.33-12.15v-3h7.18v3.45c0,3.45,1.52,4.7,3.94,4.7s3.93-1.25,3.93-4.7c0-9.94-14.84-11.81-14.84-25.62C273.58,113,277.38,108.57,284.77,108.57Z"
                                style="fill:#263238"></path>
                            <path d="M302.79,146.75l-1-17.46V109.13h7.6v20.16l-1,17.46Zm6.49,3.39v7.32H302v-7.32Z"
                                style="fill:#263238"></path>
                            <path
                                d="M172.12,412.17c3.56,0,5.08,2.11,5.08,5.54v2.72c0,3.59-1.68,5.47-5.27,5.47h-2.24v8.93h-2.52V412.17Zm-.19,11.46c1.87,0,2.78-.87,2.78-3v-3c0-2.07-.75-3.11-2.59-3.11h-2.43v9.16Z"
                                style="fill:#263238"></path>
                            <path
                                d="M182.06,430.26l-.88,4.57h-2.33l4.34-22.66h3.66l4.34,22.66h-2.53l-.87-4.57Zm.32-2.16h5.05L184.87,415Z"
                                style="fill:#263238"></path>
                            <path
                                d="M203.81,417.64v1.94h-2.4v-2.07c0-2-.81-3.26-2.65-3.26s-2.65,1.22-2.65,3.26v12c0,2,.84,3.27,2.65,3.27s2.65-1.23,2.65-3.27V425h-2.33v-2.27h4.73v6.67c0,3.43-1.62,5.69-5.11,5.69s-5.09-2.26-5.09-5.69V417.64c0-3.43,1.62-5.69,5.09-5.69S203.81,414.21,203.81,417.64Z"
                                style="fill:#263238"></path>
                            <path d="M214.91,422.21v2.26h-5.53v8.06h6.79v2.3h-9.32V412.17h9.32v2.3h-6.79v7.74Z"
                                style="fill:#263238"></path>
                            <path d="M227.05,434.83h-2.26V412.17H228l5.24,16.38V412.17h2.24v22.66h-2.63l-5.79-18.32Z"
                                style="fill:#263238"></path>
                            <path
                                d="M238.51,417.64c0-3.46,1.71-5.69,5.18-5.69s5.21,2.23,5.21,5.69v11.72c0,3.43-1.72,5.69-5.21,5.69s-5.18-2.26-5.18-5.69ZM241,429.49c0,2.07.88,3.27,2.69,3.27s2.68-1.2,2.68-3.27v-12c0-2-.84-3.26-2.68-3.26s-2.69,1.22-2.69,3.26Z"
                                style="fill:#263238"></path>
                            <path d="M255.24,434.83V414.47h-4.17v-2.3h10.87v2.3h-4.17v20.36Z" style="fill:#263238"></path>
                            <path d="M277.74,422.72V425h-5.21v9.81H270V412.17h9v2.3h-6.47v8.25Z" style="fill:#263238"></path>
                            <path
                                d="M281.46,417.64c0-3.46,1.72-5.69,5.18-5.69s5.21,2.23,5.21,5.69v11.72c0,3.43-1.71,5.69-5.21,5.69s-5.18-2.26-5.18-5.69Zm2.5,11.85c0,2.07.87,3.27,2.68,3.27s2.69-1.2,2.69-3.27v-12c0-2-.84-3.26-2.69-3.26s-2.68,1.22-2.68,3.26Z"
                                style="fill:#263238"></path>
                            <path
                                d="M297.29,429.49c0,2,.81,3.27,2.65,3.27s2.63-1.23,2.63-3.27V412.17h2.36v17.19c0,3.43-1.59,5.73-5.08,5.73s-5.05-2.3-5.05-5.73V412.17h2.49Z"
                                style="fill:#263238"></path>
                            <path d="M310.3,434.83H308V412.17h3.2l5.24,16.38V412.17h2.24v22.66H316.1l-5.8-18.32Z"
                                style="fill:#263238"></path>
                            <path
                                d="M327.26,412.17c3.53,0,5.15,2.14,5.15,5.63v11.43c0,3.46-1.62,5.6-5.15,5.6H322V412.17Zm0,20.36c1.81,0,2.69-1.13,2.69-3.2V417.67c0-2.07-.88-3.2-2.72-3.2h-2.72v18.06Z"
                                style="fill:#263238"></path>
                        </g>
                        <g id="freepik--Characters--inject-34">
                            <path
                                d="M152.59,356.45c0,3-18.43,5.39-41.18,5.39s-41.18-2.41-41.18-5.39,18.44-5.39,41.18-5.39S152.59,353.48,152.59,356.45Z"
                                style="opacity:0.30000000000000004"></path>
                            <path
                                d="M238.8,356.45c0,3-18.44,5.39-41.18,5.39s-41.18-2.41-41.18-5.39,18.44-5.39,41.18-5.39S238.8,353.48,238.8,356.45Z"
                                style="opacity:0.30000000000000004"></path>
                            <path
                                d="M353,356.45c0,3-18.43,5.39-41.17,5.39s-41.18-2.41-41.18-5.39,18.43-5.39,41.18-5.39S353,353.48,353,356.45Z"
                                style="opacity:0.30000000000000004"></path>
                            <path
                                d="M448.4,356.45c0,3-18.44,5.39-41.18,5.39S366,359.43,366,356.45s18.44-5.39,41.18-5.39S448.4,353.48,448.4,356.45Z"
                                style="opacity:0.30000000000000004"></path>
                            <path
                                d="M316.28,198.77s-1.69,7-1.69,8.18a10.06,10.06,0,0,1-.24,2.17s-3.61,4.33-3.13,5.53a5.83,5.83,0,0,0,2.41,2.16s1.92,7,3.85,7.46a46.34,46.34,0,0,0,6,.72l.72,5.77,9.62-1.44-2.4-8.66,1-7.46s1.68-3.12,0-8.17-5.29-5.29-7.7-5.29A83.06,83.06,0,0,1,316.28,198.77Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M320.61,195.17s-8.42-.25-8.18,1.92,8.9,5,8.9,5-2.89,1.92-1.45,3.85,4.81,3.61,4.81,3.61-1,4.09.49,4.33,2.4-1.93,2.64-2.65,2.89-.48,3.61,1.44a10,10,0,0,1,.72,3.13s2.89-8.66,3.37-12.51S325.18,195.17,320.61,195.17Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M325.94,214s2.91-6.4,4.65-3.25,1,6.43-.71,6.78-3.14.69-3.14.69"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M314.11,280.79c-.47.55-8.18,17.08-9.14,22.61s-7.21,38.49-7.46,39.93-13.46,4.33-14.43,4.57,1,2.89,3.85,3.61,11.07,4.09,13,2.16,4.57-12.75,5.29-13.95,14.26-33.1,14.26-33.1,6.94-15.31,8.38-16.76-1.71-7.86-2.92-9.79S317.48,276.94,314.11,280.79Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M312.67,281s3.37,16.12,5.05,21.89a46.07,46.07,0,0,0,7,13.47c1.93,2.65,11.31,26,11.31,26l1.44,3.61s-.48,1.44-3.12,3.36-10.11,5.05-8.18,5.78,9.62.72,13.23.48a12.5,12.5,0,0,0,8.17-3.85c1.45-1.69-2.4-6.5-2.4-7.46s-8.42-30.3-8.9-31.75-2.89-11.78-2.89-11.78V289s1.21-2.16,1.21-7-3.61-5.78-3.61-5.78l-19.73,1.93Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M311,279.59s.49,4.09,1.93,4.33,16.35,4.33,22.85-.48c0,0,1.2-3.61.48-4.57s-2.41-.48-11.06-.48S311,278.39,311,279.59Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M333.11,225.71s-8.9,1.2-12.75,5-7.21,10.83-8.89,17.32-2.89,30.31-.49,31.51,22.61,2.41,26,1-.24-12.75-.24-17.08,3.85-19,3.13-27.17S333.11,225.71,333.11,225.71Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M301,250.71c-.11-9.9-4.15-18.35-9.52-22l0-2-14.8.15c-8.33.09-15,11-14.83,24.3s7,24.07,15.34,24l14.8-.15,0-2C297.19,269.14,301.05,260.61,301,250.71Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M307.64,250.64c-.11-10.4-4.12-19.28-9.76-23.14l0-2.13-6.34.07c-8.76.09-15.73,11.52-15.58,25.53s7.36,25.29,16.12,25.2l6.34-.07,0-2.12C303.93,270,307.75,261,307.64,250.64Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M314,250.57c.15,14-6.83,25.44-15.58,25.53s-16-11.19-16.12-25.19,6.83-25.44,15.58-25.54S313.83,236.56,314,250.57Z"
                                style="fill:#737373;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M310.36,250.14c.07,6.63-3.24,12.05-7.39,12.1s-7.57-5.31-7.64-12,3.24-12,7.39-12.1S310.29,243.5,310.36,250.14Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M428.2,300a121.5,121.5,0,0,0,1.05-18.6c-3.25,1.5-22.21,2.05-23.95,2.09s-20.7-.59-23.95-2.09a121.5,121.5,0,0,0,1,18.6c1.31,8.11,12.83,40.58,13.09,42.15a34.94,34.94,0,0,0,1.31,4.46s-6.55,4.71-9.43,6.54-.78,2.62,2.1,2.62,8.9-.79,10.73-.79c1.62,0,4.44-1.41,5.1-1.75.66.34,3.48,1.75,5.09,1.75,1.84,0,7.86.79,10.74.79s5-.79,2.1-2.62-9.43-6.54-9.43-6.54a34.94,34.94,0,0,0,1.31-4.46C415.37,340.55,426.89,308.08,428.2,300Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M401.34,230.49s-10.13,3.31-15.36,6.63-10.48,21.3-10.48,22a22.41,22.41,0,0,1-1.22,3.66s-5.24-1.22-6.28,3.14,5.23,9.95,8.55,10.13,4.36-.87,4.36-.87-2.09,4.19-1.22,5.93,8.21,8.21,22.7,8,25-2.62,26.53-4.71,1.75-6.46,1.75-6.46,5.41-1.4,7.33-4.89,1.57-7.16.52-10.82S432.06,247.94,428.4,242s-11.35-9.25-15-10.3S403.78,230.49,401.34,230.49Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M404.41,245.19c1.45-.48,6-4.52,7.75-8.56a19.47,19.47,0,0,0,1.45-4.85l-.23-.07c-3.66-1.05-9.6-1.22-12-1.22,0,0-2.12.69-4.92,1.76a18,18,0,0,0,1.2,6.32C399.24,242.61,403,245.68,404.41,245.19Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M421.06,253.35S425.25,275.7,430,278"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M380.91,275.18s5.24-19.73,5.59-21.65"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M427.83,263.45s-2.9.65-2.9,2.75"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M378.56,263.77s3.23,2.1,2.91,5.33"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M400.2,355c1.62,0,4.44-1.41,5.1-1.75.66.34,3.48,1.75,5.09,1.75,1.84,0,7.86.79,10.74.79s5-.79,2.1-2.62c-2.51-1.59-7.77-5.35-9.11-6.31-3.09,2.82-9.2,2.12-9.2,2.12a31.37,31.37,0,0,1-3.67-.78c-1.83-.53-4.45-1.57-4.45-1.57s-6.55,4.71-9.43,6.54-.78,2.62,2.1,2.62S398.37,355,400.2,355Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <line x1="404.92" y1="346.67" x2="404.92" y2="301.01"
                                style="fill:none;stroke:#fff;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </line>
                            <polyline points="405.3 353.2 404.92 348.93 404.92 346.67"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </polyline>
                            <line x1="401.25" y1="299.44" x2="408.84" y2="299.44"
                                style="fill:none;stroke:#fff;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </line>
                            <path
                                d="M391.33,204.29s-5.44,3.26-4.63,6.12,3.27,3.41,2.73,5S387,218,389.15,219a18.36,18.36,0,0,0,3.82,1.23s2,6.94,5.44,8.16,9.4.41,13.62-.13a7.05,7.05,0,0,0,6.12-5.18c.41-1.49-1.77.28-2.86-1.36s.55-5.85,1.77-9.53-2.45-10.62-7.21-12.93S396,198.16,391.33,204.29Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M400.47,228a36.87,36.87,0,0,0-1.4,7c-.18,3,2.27,6.29,4.89,6.11s4.88-5.41,5.23-8-.87-9.6-.87-9.6-4,.18-5.59,1.57A9.68,9.68,0,0,0,400.47,228Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M396.92,208.1s.13,4.08,4.22,8a25.29,25.29,0,0,0,8.57,5.45,7.53,7.53,0,0,1-.68,2.58,1.89,1.89,0,0,1-1.9,1h-1.37s-2,4.69-4.42,5.37-8.37.21-9.19-5.78-.95-10.89-.27-12.12S396.92,208.1,396.92,208.1Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M439.71,260.8a11,11,0,0,0,1.11-4c0-1.82-3.38-4.43-4-5.08s-1.24-.58-1.37.33a3.74,3.74,0,0,0,1.17,2.73,3.06,3.06,0,0,1,1.05,1.57c.06.45-1.12,2.66-.53,4.09S439.39,262.3,439.71,260.8Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M304.28,250.59S319,255.3,327.85,266.3s14.66,9.42,25.66,5.76,15.19-16.76,30.38-5.76,18.33,15.18,30.9,8.9,19.37-21.47,30.9-16.24,6.28,32,7.33,45-.53,45.57,2.09,49.76,29.33,1,29.33,1"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:3.1422600000000003px">
                            </path>
                            <path
                                d="M331.85,233.11s-2.93-4.78-7.25-3.53c-4.57,1.32-6.93,7.85-8,11.92s-1.79,8.47-3.75,12.26c0,0-8.66-.15-13.49-1.55a114.2,114.2,0,0,1-10.86-4s-1.71-2.39-2.92-2.86-4.35-1.39-4.58-.67,3.64,3.09,3.64,3.09-7.2,1-7.92,1.77,5.09,3.07,5.09,3.07,2.17.7,7.45-.56c0,0,19.37,12.3,23.23,13.71s6,1.86,8.63-3.22,11.36-17.68,12.75-22.75"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M293.53,250.25c-2.83-1.06-5-2-5-2s-1.71-2.39-2.92-2.86-4.35-1.39-4.58-.67,3.64,3.09,3.64,3.09-7.2,1-7.92,1.77,5.09,3.07,5.09,3.07,2.17.7,7.45-.56l2.71,1.71Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M368.19,262.64a11,11,0,0,1-1.11-4c0-1.82,3.39-4.42,4-5.07s1.23-.58,1.36.33a3.74,3.74,0,0,1-1.17,2.73,3.06,3.06,0,0,0-1.05,1.57c-.06.44,1.12,2.66.53,4.09S368.51,264.13,368.19,262.64Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M370.52,257.15s-2.79,5.15-1.17,7,3.19-4.16,3.49-5.82S371.55,255,370.52,257.15Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M372.82,259s-2.79,5.15-1.17,7,3.19-4.16,3.49-5.82S373.85,256.79,372.82,259Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M375.35,259.43s-2.79,5.15-1.17,7,3.19-4.16,3.49-5.82S376.38,257.27,375.35,259.43Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M378.59,259.47s-2.6,4-1.18,5.51,2.95-3.24,3.25-4.61S379.55,257.67,378.59,259.47Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M437.85,257.35s2.79,5.15,1.17,7-3.19-4.17-3.49-5.83S436.82,255.19,437.85,257.35Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M435.55,259.15s2.79,5.15,1.17,7-3.19-4.17-3.49-5.83S434.52,257,435.55,259.15Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M433,259.63s2.79,5.15,1.17,7-3.19-4.16-3.48-5.83S432,257.47,433,259.63Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M429.78,259.67s2.6,4.05,1.18,5.51-2.95-3.24-3.24-4.61S428.82,257.87,429.78,259.67Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M85.72,316.65v5.68a18,18,0,0,0-4.13,7.58c-1.21,4.64-5,24.61-4,25.13S88,357.71,91,357.26c3.44-.52,6.37-.34,4.64-2.24s-10.82-7.21-10.82-7.21,10-14.46,12.22-19.8,2.58-13.6,2.58-13.6l-13.42-.51Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M91,357.26c3.44-.52,6.37-.34,4.64-2.24s-10.82-7.21-10.82-7.21l-.34,2.06-6.55-.8c-.48,3.34-.69,5.79-.34,6C78.66,355.55,88,357.71,91,357.26Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M118.6,319.59l1.55,2.76a10.07,10.07,0,0,0-.52,8.09c1.55,4.82,5.17,22.55,5.17,23.58s2.23,1.72,4,1.72,6.67.34,7.36.34,5.68.86,7.4-.17-2.19-3.1-4.77-4.3-8.26-4.3-8.26-4.3,1.37-14.12,1.37-20.32,1.38-8.26-.51-12.05-13.77,1.73-13.77,1.73Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M138.74,351.61c-2.58-1.21-8.26-4.3-8.26-4.3l-.69,2.58-5.53,1c.33,1.72.54,2.9.54,3.14,0,1,2.23,1.72,4,1.72s6.67.34,7.36.34,5.68.86,7.4-.17S141.32,352.81,138.74,351.61Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M109.33,205a47.36,47.36,0,0,0-4.61-6.54c-2.37-2.67-9.8-2.52-13.06,1s-2.23,9.8-1,11.58,3.71,10.1,3.71,10.1l.59,5.94,13.81,4.9-2.82-9.65s5.35-1,5.79-2.67-.89-7.28-.89-7.28,1.78-1.19,1.63-2.23S109.33,205,109.33,205Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M93.44,211.4s2.36,2,3.65-.29,2.27-4.53,2.27-6.47-4.85-3.55-1.62-4.85,5.56,1.59,7-1.31.13-3.21-7.63-3.21-11.64,3.88-10,8.73a65.31,65.31,0,0,0,4.85,10.34Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M109.77,208.43a3.71,3.71,0,1,1-3.71-3.71A3.71,3.71,0,0,1,109.77,208.43Z"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M109.23,205.14a3.62,3.62,0,0,1,1.36-.27,3.49,3.49,0,0,1,1.69,6.54"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <line x1="102.35" y1="208.43" x2="93.44" y2="211.4"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </line>
                            <path d="M96,213.33s-1.78-3.71-3.56-3-.89,6.54.89,7.13a3.84,3.84,0,0,0,3.41-.89s1.49,3.12,3.27,4"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M84.32,280l-1.11,14.22-3.32,21.05s7.76,6.09,15,6.09,9.23-.92,9.23-.92l4.06-21.6,4.06,22.71s8-1.29,13.3-2.59a35.08,35.08,0,0,0,10.34-4.8l-10.71-27.88-2.32-14.38s-12,1.11-19.21,1.48-16.8-1.48-16.8-1.48Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M91.93,223.18s17,5.93,22.25,11.69c2.9,3.2,6.15,25.1,7.32,30.45s3.21,16,3.21,16-10.37,4.68-18.39,4.85-23.41-3.51-23.41-3.51,1.83-23.73,1.83-34.76.17-18.23,2-21.74C86.75,226.19,89.76,222.84,91.93,223.18Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M87.46,284.38s.92,15.51,0,21.24a44.06,44.06,0,0,1-3.32,10.71"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M87.83,291.77a8.47,8.47,0,0,0,5.54-6.28"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M80.81,312.27s9.24,7.94,23.64,5"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M111.84,316.88s15.14-1.66,21.79-6.09"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M179.56,216s-1.46,1.08-6.55,4.8-1.08,9.34-1.08,9.34-3.64.57-8.5,5.68,2.17,13.88,8.74,15.25,14.25-6.76,16.55-14.3-.74-18.91-2.27-21.26S179.56,216,179.56,216Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M198.84,215s2.53-3.91.24-9.58-9.13-8.26-15.79-4.15A11.73,11.73,0,0,0,178,214.54c.65,2.62,3.93,6.65,4.62,6.71s6.68,2.24,10.77.33S198.84,215,198.84,215Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M169.41,347s4.75,7.39,13,8.65.83-6.14-.56-7.26S170.53,344.85,169.41,347Z"
                                style="fill:#737373;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M213.36,348.9s9.07,2.23,8.37,4.19-8.09,1.81-12.41.69-8.38-2.79-7.82-4.6S213.36,348.9,213.36,348.9Z"
                                style="fill:#737373;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M187.57,229.7s-12.14,1.78-14.36,6.07.91,27.66.91,27.66-5.18,11.43-5.25,18.79,3.21,20.31,2.95,23.54-3.58,40-3.58,41,7,3.24,17.09,4.44,29.39-2.39,29.39-2.39-.38-21.7.63-34.64-.43-24.57-3-29.4-14.54-22.22-14.54-22.22,5.8-10.52,6.16-15.12-1.51-7-5.89-12.29A15.27,15.27,0,0,0,187.57,229.7Z"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M197.84,262.56s5.8-10.52,6.16-15.12-1.51-7-5.89-12.29c-.21-.26-.43-.49-.65-.73l-.16.15c-4.5,7.35-19.38,19.91-23.81,23.57.34,3.13.63,5.29.63,5.29s-5.18,11.43-5.25,18.79a67.11,67.11,0,0,0,1,10c10.51-6,24.57-17.23,32.18-23.49C199.67,265.21,197.84,262.56,197.84,262.56Z"
                                style="fill:#737373;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M185.33,221.12a75.07,75.07,0,0,1,.55,8.27c-.16,2.05.5,6.73,4,8.2s5.7-.58,5.69-2.64a20.8,20.8,0,0,0-1-5l.1-5.65S188.63,220.52,185.33,221.12Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M182.19,217.45s-2.57-2.26-2.65,1,2.92,4.34,3.58,4.56a2.21,2.21,0,0,0,1.58-.39s4.66,4,8.4,4.26,5.26-1.47,6.14-8.26-6.13-13.68-6.13-13.68S187.11,216,182.19,217.45Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M125,281.18a9,9,0,0,1,.56-3.4c.62-1.36,4-2.14,4.75-2.4s1.13,0,.91.71a3.1,3.1,0,0,1-1.81,1.64,2.54,2.54,0,0,0-1.33.81c-.19.32-.07,2.37-1,3.24S124.69,282.41,125,281.18Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M201.64,251.11s-12-1.57-17.29,6.81-15.18,37.7-33.51,42.42-23.57-33-34.57-31.95c-10.48,1-17.8,0-24.09,11.52-3.36,6.17-20.16,73.54-28.1,74.23-25.29,2.21-41.57.77-41.57.77"
                                style="fill:none;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:3.1422600000000003px">
                            </path>
                            <path
                                d="M92.71,223.66s-2.77-1.11-6.47,1.1-13.66,26.41-12.92,29,11.26,7.39,17.17,9.05,16.62,3.7,16.62,3.7,3.32,5.17,4.43,5.35a24.06,24.06,0,0,0,4.8-.55s2,1.66,2.77-.19-.74-4.24-2.4-6.09-8.68-2.77-8.68-2.77L89,249.14,97,234.37"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M111.54,271.85a24.06,24.06,0,0,0,4.8-.55s2,1.66,2.77-.19-.74-4.24-2.4-6.09-8.68-2.77-8.68-2.77L89,249.14l2.84-5.29c-7.11-4.43-11.83-4.1-14.38-3.21-2.55,6.12-4.49,11.92-4.15,13.11.74,2.59,11.26,7.39,17.17,9.05s16.62,3.7,16.62,3.7S110.43,271.67,111.54,271.85Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M230.49,251.52c-.81-8.73-5-15.9-10-18.75l-.16-1.78-13.06,1.21c-7.35.68-12.42,10.77-11.33,22.53s7.93,20.73,15.28,20l13.06-1.21-.17-1.78C228.51,268.06,231.3,260.25,230.49,251.52Z"
                                style="fill:#263238;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M236.4,251c-.85-9.17-5-16.72-10.29-19.72l-.18-1.87-5.59.52c-7.72.72-13.05,11.31-11.91,23.67s8.34,21.79,16.06,21.07l5.59-.52-.17-1.87C234.53,268.34,237.25,260.14,236.4,251Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M242,250.45c1.15,12.36-4.18,22.95-11.91,23.67S215.17,265.4,214,253.05s4.18-23,11.9-23.67S240.84,238.1,242,250.45Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M248,243.23l-21.69,2a2.32,2.32,0,0,1-2.53-2.1h0a2.32,2.32,0,0,1,2.1-2.53l21.69-2a2.32,2.32,0,0,1,2.53,2.1h0A2.32,2.32,0,0,1,248,243.23Z"
                                style="fill:#737373;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M249.61,260.42l-21.69,2a2.32,2.32,0,0,1-2.53-2.1h0a2.32,2.32,0,0,1,2.1-2.53l21.69-2a2.34,2.34,0,0,1,2.53,2.1h0A2.32,2.32,0,0,1,249.61,260.42Z"
                                style="fill:#737373;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M180.07,231.33s-5.22,1-7.69,4-7.54,26.15-6.37,28.81,19.92,6,25.71,6.48a83.17,83.17,0,0,0,13.94-.62s5-.13,6.37-.36,3.89-1.58,3.93-2.09-.21-1.73-2.08-1.88-5.88-1.49-6.39-1.53a32.6,32.6,0,0,1,3.65-.74s.26-1-1.8-1-3.93-.14-4.71,1a17.2,17.2,0,0,0-1.42,2.8s-11.55.81-17.82-2.25-8.25-4.08-8.25-4.08l4.5-18"
                                style="fill:currentColor;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path
                                d="M212,269.67c1.39-.23,3.89-1.58,3.93-2.09s-.21-1.73-2.08-1.88-5.88-1.49-6.39-1.53a32.6,32.6,0,0,1,3.65-.74s.26-1-1.8-1-3.93-.14-4.71,1a17.2,17.2,0,0,0-1.42,2.8s-11.55.81-17.82-2.25-8.25-4.08-8.25-4.08l2.74-11a39.2,39.2,0,0,0-11.17-2.77c-1.87,7.54-3.4,16.42-2.7,18,1.16,2.66,19.92,6,25.71,6.48a83.17,83.17,0,0,0,13.94-.62S210.64,269.9,212,269.67Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M127.54,279.24s-3.86,2.89-3.27,4.8,3.81-2,4.61-3.15S129.05,278,127.54,279.24Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M128.3,281.83s-3.85,2.89-3.27,4.8,3.82-2,4.61-3.15S129.81,280.57,128.3,281.83Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M130.13,283.51s-3.85,2.89-3.26,4.8,3.81-2,4.61-3.15S131.65,282.25,130.13,283.51Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                            <path d="M131.64,284.87s-3.33,2.14-2.77,3.72,3.31-1.41,4-2.33S133,283.86,131.64,284.87Z"
                                style="fill:#fff;stroke:#263238;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.04742px">
                            </path>
                        </g>
                    </svg>
            @endswitch

        </div>
        <h1 class="error-page-title">
            @yield('title')
        </h1>
        <p class="error-page-text text-muted">
            @yield('message')
        </p>

        @if (in_array($code, [401, 403, 404, 419, 429]))
            <div class="row row-cols-auto align-items-center g-4">
                @if (env('SYSTEM_INSTALLED'))
                    <div class="col">
                        <a href="{{ route('index') }}"
                            class="btn btn-primary btn-md">{{ translate('Go Home') }}</a>
                    </div>
                @else
                    <div class="col">
                        <a href="{{ url('/') }}" class="btn btn-primary btn-md">{{ __('Go Home') }}</a>
                    </div>
                @endif
            </div>
        @endif
    </div>
    <!-- /Error Page -->
    <script src="{{ asset('assets/js/vendor/bootstrap.bundle.min.js') }} "></script>
</body>

</html>
