@extends('install.layout')

@section('title', 'Welcome and Thank You!')
@section('content')
    <div class="steps-content">
        <div class="steps-body">
            <div class="col-lg-9 col-xl-8 col-xxl-6 mx-auto">
                <div class="mb-5">
                    <h2 class="fw-light mb-4">{{ __('Welcome and Thank You!') }}</h2>
                    <p class="fw-light text-muted mx-auto mb-0">
                        {{ __('We appreciate your purchase of our script! You\'re just moments away from getting everything set up.') }}
                    </p>
                </div>
                <div class="text-start">
                    <div class="">
                        <div class="card-body text-center">
                            <h3 class="fw-bold mb-3">{{ __('Thank You for Your Purchase!') }}</h3>
                            <p class="fw-light text-muted mb-4">
                                {{ __('We are thrilled to have you on board. Your support means the world to us, and we are committed to ensuring you have a smooth experience with our product.') }}
                            </p>

                            <div class="text-center d-block m-auto" style="width: 300px">
                                <svg id="svg-color" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 500">
                                    <g id="freepik--background-simple--inject-1">
                                        <path
                                            d="M397,243.55c80.23-77.91-5.9-200.19-101.21-161.68-29.65,12-38.3,50.56-71.95,61.77-34.3,11.43-72.92-8.65-108.26.32C33.21,164.87,27.85,270.43,93.11,322.08,166.41,380.09,339.54,299.34,397,243.55Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M397,243.55c80.23-77.91-5.9-200.19-101.21-161.68-29.65,12-38.3,50.56-71.95,61.77-34.3,11.43-72.92-8.65-108.26.32C33.21,164.87,27.85,270.43,93.11,322.08,166.41,380.09,339.54,299.34,397,243.55Z"
                                            style="fill:#fff;opacity:0.9"></path>
                                    </g>
                                    <g id="freepik--Shadow--inject-1">
                                        <ellipse id="freepik--path--inject-1" cx="250" cy="416.24" rx="193.89"
                                            ry="11.32" style="fill:#f5f5f5"></ellipse>
                                    </g>
                                    <g id="freepik--character-2--inject-1">
                                        <path
                                            d="M364,103c-8.07-3.56-17.41-5.57-22.09,2.08-3.07,5-4.6,15.22-10,20.72a4.42,4.42,0,0,0-1.48,3.22,1.62,1.62,0,0,0,0,.23c.09,3.08,2.56,7.2,8.91,8.72a10.88,10.88,0,0,1-3.18-3.16,21.21,21.21,0,0,0,8.28,1.74c7.48-.08,13.23.49,16.66,2.27s9.67-6,9.39-9.54c1.35,2,3,0,3.53-4.92C375.47,111.71,371.36,101.34,364,103Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M345.63,142.54a6.54,6.54,0,1,1,6.55-6.54A6.55,6.55,0,0,1,345.63,142.54Zm0-12.6a6.06,6.06,0,1,0,6.06,6.06A6.06,6.06,0,0,0,345.63,129.94Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M338.87,165.28a135.16,135.16,0,0,1-8.34,14.19,80.17,80.17,0,0,1-5,6.76,36.44,36.44,0,0,1-6.48,6.4,9.26,9.26,0,0,1-1.47.91,8.08,8.08,0,0,1-2,.69,8,8,0,0,1-4.08-.3,12.46,12.46,0,0,1-4.82-3.29,25.46,25.46,0,0,1-2.87-3.67c-.81-1.24-1.53-2.48-2.19-3.73a81.08,81.08,0,0,1-6-15.43l4.37-1.64a129.06,129.06,0,0,0,7.74,13.41,29.54,29.54,0,0,0,4.49,5.38,4.39,4.39,0,0,0,1.78,1.1c.12,0,0-.07-.14-.05s-.12,0-.13,0-.06,0,.19-.18a32,32,0,0,0,4.53-5.15c1.47-2,2.88-4.13,4.26-6.29s2.68-4.42,4-6.66,2.57-4.56,3.78-6.77Z"
                                            style="fill:#b55b52"></path>
                                        <path
                                            d="M336.1,152.13c-3.92-.14-10.86,14.14-10.86,14.14L332.71,183s14.65-19.28,13-24.11C344,153.84,341.82,152.33,336.1,152.13Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M336.1,152.13c-3.92-.14-10.86,14.14-10.86,14.14L332.71,183s14.65-19.28,13-24.11C344,153.84,341.82,152.33,336.1,152.13Z"
                                            style="fill:#fff;opacity:0.6000000000000001"></path>
                                        <path
                                            d="M299.36,159.46l1.16,10.33-2.72,1.9c-3.73-.86-5.29-6.58-5.29-6.58l-1.68-3.67a4.27,4.27,0,0,1,.87-4.79l.76-.75a3.4,3.4,0,0,1,5.21.43l1.09,1.56A3.39,3.39,0,0,1,299.36,159.46Z"
                                            style="fill:#b55b52"></path>
                                        <polygon points="355.06 408.46 345.84 408.46 345 387.1 354.23 387.1 355.06 408.46"
                                            style="fill:#b55b52"></polygon>
                                        <path
                                            d="M345,407.39h10.37a.66.66,0,0,1,.67.63l.35,8.2a1.66,1.66,0,0,1-1.64,1.64c-3.61-.06-5.33-.27-9.89-.27-2.8,0-9.25.29-13.12.29s-3.7-3.83-2.05-4.18c7.39-1.55,11.07-3.69,13.71-5.74A2.65,2.65,0,0,1,345,407.39Z"
                                            style="fill:#263238"></path>
                                        <g style="opacity:0.2">
                                            <polygon
                                                points="345 387.11 345.43 398.12 354.66 398.12 354.23 387.11 345 387.11">
                                            </polygon>
                                        </g>
                                        <path
                                            d="M332.4,156.7c-.2,5.83.81,19.45,6.94,51.17l37.45-1.12c-1-14.16-1.34-23.28,3.74-49.87a6.07,6.07,0,0,0-5.25-7.18c-2.75-.32-6.1-.62-9.48-.68a118.76,118.76,0,0,0-17,.51c-4.33.52-9,1.42-12.07,2.07A5.41,5.41,0,0,0,332.4,156.7Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M332.4,156.7c-.2,5.83.81,19.45,6.94,51.17l37.45-1.12c-1-14.16-1.34-23.28,3.74-49.87a6.07,6.07,0,0,0-5.25-7.18c-2.75-.32-6.1-.62-9.48-.68a118.76,118.76,0,0,0-17,.51c-4.33.52-9,1.42-12.07,2.07A5.41,5.41,0,0,0,332.4,156.7Z"
                                            style="fill:#fff;opacity:0.7000000000000001"></path>
                                        <path
                                            d="M363.54,129.92c-.91,5.51-1.68,15.56,2.26,19.1a21.2,21.2,0,0,1-13,9.27c-8.63-4.38-4-8.76-4-8.76,6.06-1.64,5.77-6.16,4.58-10.38Z"
                                            style="fill:#b55b52"></path>
                                        <polygon points="352.81 158.29 353.93 156.1 359.92 157.46 352.81 158.29"
                                            style="fill:currentColor"></polygon>
                                        <path
                                            d="M353.93,156.1c1.92-.88,10.83-6.68,11.18-8.49a21.73,21.73,0,0,1,5.06,1.34s-1.6,7.15-10.25,12A9.47,9.47,0,0,0,353.93,156.1Z"
                                            style="fill:#fff"></path>
                                        <polygon points="352.81 158.29 352.31 156.1 348.63 156.36 352.81 158.29"
                                            style="fill:currentColor"></polygon>
                                        <path
                                            d="M352.31,156.1c-3-2-1.88-6.1-1.59-7.91a16,16,0,0,0-4.37,1.08s-4.51,4.14-.14,11.72A14,14,0,0,1,352.31,156.1Z"
                                            style="fill:#fff"></path>
                                        <path
                                            d="M359.4,133.69l-6,5.45a17,17,0,0,1,.62,3c2.32-.4,5.45-3.06,5.62-5.5A8.27,8.27,0,0,0,359.4,133.69Z"
                                            style="opacity:0.2"></path>
                                        <path
                                            d="M366.45,118.24c-.4,9.14-.38,13-4.91,17.79-6.82,7.17-18,4.68-20.31-4.4-2.1-8.18-1.08-21.76,7.8-25.55A12.49,12.49,0,0,1,366.45,118.24Z"
                                            style="fill:#b55b52"></path>
                                        <path
                                            d="M359.92,108.57c-3.07,5.15-7.44-1.4-10.92,2.52-2.79,3.14-7.36-.16-10,8.8.92-7.7,2.21-14.51,10.08-16.77C353.93,101.72,363.21,101.19,359.92,108.57Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M361.49,105c-2.69,1.87-5.45,4.56-5.12,7.85s5.05,1.85,5.68,4.16-2.82,7.17,2.19,7.65c5.72-3.19,7.32-3.89,6.28-8.79S365.86,104.35,361.49,105Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M339.26,207.87S335.64,276,335.45,304c-.19,29.14,8,92,8,92h12.47s-2.37-63.52-.45-92.26c2.09-31.33,9.38-96.68,9.38-96.68Z"
                                            style="fill:currentColor"></path>
                                        <polygon
                                            points="356.97 396.43 342.33 396.43 341.73 391.76 358.18 391.19 356.97 396.43"
                                            style="fill:#263238"></polygon>
                                        <path
                                            d="M362.22,231.52c-1.34-1.68-3.11-.8-5.42,4-7.88,16.35-3.88,42.42-.51,57.44C357.81,274.24,360.31,249.61,362.22,231.52Z"
                                            style="opacity:0.2"></path>
                                        <path
                                            d="M351,121.74c0,.74-.37,1.35-.86,1.36s-.89-.59-.9-1.33.37-1.36.85-1.37S351,121,351,121.74Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M342.62,121.67c0,.74-.38,1.35-.86,1.36s-.89-.59-.91-1.33.38-1.36.86-1.36S342.6,120.92,342.62,121.67Z"
                                            style="fill:#263238"></path>
                                        <path d="M341.93,120.37l-1.8-.48S341.07,121.27,341.93,120.37Z" style="fill:#263238">
                                        </path>
                                        <path d="M345.54,122.35a19.62,19.62,0,0,1-2.57,4.8,3.19,3.19,0,0,0,2.66.45Z"
                                            style="fill:#a02724"></path>
                                        <path
                                            d="M350.1,130.05a6.43,6.43,0,0,1-1.1.1.21.21,0,0,1-.22-.21.22.22,0,0,1,.21-.22,5.9,5.9,0,0,0,4.77-2.39.22.22,0,0,1,.37.23A6.14,6.14,0,0,1,350.1,130.05Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M369.05,126.85a6.67,6.67,0,0,1-3.73,3.49c-2.2.81-3.49-1.11-3-3.29.41-2,2-4.74,4.33-4.61A3,3,0,0,1,369.05,126.85Z"
                                            style="fill:#b55b52"></path>
                                        <path
                                            d="M365.19,142.54a6.54,6.54,0,1,1,6.54-6.54A6.55,6.55,0,0,1,365.19,142.54Zm0-12.6a6.06,6.06,0,1,0,6.05,6.06A6.07,6.07,0,0,0,365.19,129.94Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M354.32,117.72a.44.44,0,0,1-.46-.23c-.94-1.79-3.52-2.14-3.55-2.14a.44.44,0,0,1,.12-.87c.12,0,3.05.42,4.2,2.6a.44.44,0,0,1-.18.6Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M340,117a.43.43,0,0,1-.41-.14.43.43,0,0,1,.05-.62,4.35,4.35,0,0,1,3.86-1,.45.45,0,0,1,.3.55.43.43,0,0,1-.54.29h0a3.44,3.44,0,0,0-3.05.83A.48.48,0,0,1,340,117Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M386.26,160.77c1.68,4.81,3.16,9.61,4.5,14.52.68,2.45,1.33,4.92,1.88,7.45.27,1.27.54,2.55.77,3.88a36,36,0,0,1,.5,4.29v.63l0,.74c0,.44-.06.71-.1,1.08-.06.69-.15,1.32-.24,2-.18,1.29-.39,2.55-.6,3.8-.42,2.51-.92,5-1.42,7.45-1,4.93-2.19,9.82-3.53,14.69l-4.61-.76c.27-5,.65-10,1.05-15l.6-7.41c.09-1.23.17-2.45.24-3.64,0-.6.07-1.2.08-1.76,0-.26,0-.61,0-.79l0-.2,0-.3a30.51,30.51,0,0,0-.6-3.12c-.26-1.13-.56-2.28-.88-3.44-.65-2.32-1.34-4.67-2.05-7l-4.49-14.08Z"
                                            style="fill:#b55b52"></path>
                                        <path
                                            d="M375.28,149.7c12.28,1.52,14.71,16.52,16.46,20.29L379.69,180.1s-7.63-12.83-8.74-17.81C369.8,157.1,370.84,149.15,375.28,149.7Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M375.28,149.7c12.28,1.52,14.71,16.52,16.46,20.29L379.69,180.1s-7.63-12.83-8.74-17.81C369.8,157.1,370.84,149.15,375.28,149.7Z"
                                            style="fill:#fff;opacity:0.7000000000000001"></path>
                                        <path
                                            d="M341.36,409a3.25,3.25,0,0,1-2.18-.57,1.12,1.12,0,0,1-.29-1.07.8.8,0,0,1,.43-.58c1.19-.62,4.68,1.26,5.07,1.48a.2.2,0,0,1,.1.22.27.27,0,0,1-.2.19A16.67,16.67,0,0,1,341.36,409Zm-1.45-1.91a.88.88,0,0,0-.42.08.31.31,0,0,0-.17.23.75.75,0,0,0,.18.7c.51.51,2,.59,4.1.25A11,11,0,0,0,339.91,407.1Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M344.25,408.68l-.09,0c-1.05-.5-3-2.49-2.74-3.53.06-.25.27-.56.88-.62a1.46,1.46,0,0,1,1.17.38c1.06,1,1,3.45,1,3.55a.23.23,0,0,1-.11.2A.2.2,0,0,1,344.25,408.68Zm-1.82-3.74h-.13c-.4,0-.45.2-.46.25-.17.63,1.15,2.19,2.2,2.87a4.6,4.6,0,0,0-.88-2.84A1,1,0,0,0,342.43,404.94Z"
                                            style="fill:currentColor"></path>
                                        <polygon points="411 404.98 401.98 406.92 394.47 386.69 403.49 384.75 411 404.98"
                                            style="fill:#b55b52"></polygon>
                                        <path
                                            d="M401.42,406l10.13-2.19a.74.74,0,0,1,.86.46l3,7.75a1.46,1.46,0,0,1-1.08,1.91c-3.55.7-5.29.86-9.75,1.82-2.74.59-7.59,2.45-11.45,2.18s-3.85-4.11-2.22-4.34c7.3-1.05,7.22-4.2,9.14-6.71A2.42,2.42,0,0,1,401.42,406Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M400.32,407.84a3.57,3.57,0,0,1-2.32-.08,1.23,1.23,0,0,1-.62-.95.68.68,0,0,1,.23-.65c1-.84,5,.21,5.43.34a.21.21,0,0,1,.17.19.23.23,0,0,1-.13.22A15.89,15.89,0,0,1,400.32,407.84Zm-2-1.51a.89.89,0,0,0-.38.16.28.28,0,0,0-.09.26.8.8,0,0,0,.4.63c.66.37,2.17.14,4.09-.62A11.73,11.73,0,0,0,398.28,406.33Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M403,406.92H403c-1.19-.25-3.76-1.73-3.83-2.79,0-.25.09-.58.67-.77a1.59,1.59,0,0,1,1.26.11c1.35.7,2.12,3.07,2.15,3.17a.22.22,0,0,1-.05.21A.19.19,0,0,1,403,406.92Zm-3-3.18-.13,0c-.38.13-.37.29-.37.34,0,.63,1.83,1.85,3.08,2.27a5.14,5.14,0,0,0-1.78-2.52A1.14,1.14,0,0,0,400.06,403.74Z"
                                            style="fill:currentColor"></path>
                                        <g style="opacity:0.2">
                                            <polygon
                                                points="394.47 386.7 398.34 397.13 407.36 395.18 403.49 384.75 394.47 386.7">
                                            </polygon>
                                        </g>
                                        <path
                                            d="M376.79,206.75c9,14.28,6.47,66.8,7.89,94.84,8.44,24.87,23.33,91.27,23.33,91.27l-12.19,2.63s-26.89-65.9-32.47-94.05c-6.16-31.07-13.66-94.69-13.66-94.69Z"
                                            style="fill:currentColor"></path>
                                        <polygon
                                            points="408.92 393.12 394.62 396.21 393.12 391.75 409.08 387.72 408.92 393.12"
                                            style="fill:#263238"></polygon>
                                        <path d="M350.33,120.44l-1.8-.48S349.47,121.34,350.33,120.44Z" style="fill:#263238">
                                        </path>
                                        <path
                                            d="M377.28,204.54l1.06,3.32c.14.26-.16.53-.6.55l-38.54,1.14c-.33,0-.62-.14-.64-.36l-.44-3.34c0-.23.25-.43.62-.45l37.92-1.12A.67.67,0,0,1,377.28,204.54Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M372.31,208.93l1,0c.2,0,.35-.11.34-.24l-.61-4.34c0-.13-.2-.23-.4-.22l-1,0c-.2,0-.35.11-.33.24l.6,4.34C371.93,208.84,372.11,208.94,372.31,208.93Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M342.07,209.83l1,0c.2,0,.35-.11.33-.24l-.6-4.34c0-.13-.2-.23-.4-.22l-1,0c-.2,0-.35.11-.34.24l.61,4.34C341.69,209.74,341.87,209.84,342.07,209.83Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M357.19,209.38l1,0c.2,0,.35-.11.33-.24l-.6-4.34c0-.13-.2-.23-.4-.22l-1,0c-.2,0-.35.11-.33.24l.6,4.34C356.81,209.29,357,209.39,357.19,209.38Z"
                                            style="fill:currentColor"></path>
                                        <path d="M384,219l-6.75,7.33,9.37.41c0,.11,3.05-5,1.14-8.36Z" style="fill:#b55b52">
                                        </path>
                                        <path
                                            d="M379.71,234l2.72,0a2.8,2.8,0,0,0,2.66-2l1.55-5.25-9.37-.41-.38,4.66A2.81,2.81,0,0,0,379.71,234Z"
                                            style="fill:#b55b52"></path>
                                    </g>
                                    <g id="freepik--character-1--inject-1">
                                        <polygon
                                            points="140.33 407.44 131.72 407.31 132.26 387.29 140.87 387.42 140.33 407.44"
                                            style="fill:#ffc3bd"></polygon>
                                        <path
                                            d="M131.62,406.31l9.41.15a.66.66,0,0,1,.67.6l.82,7.7a1.41,1.41,0,0,1-1.42,1.51c-3.39-.11-8.27-.38-12.54-.45-5-.08-4.5.13-10.35,0-3.54-.05-4.11-3.65-2.59-4,6.91-1.37,7.61-1.44,13.85-4.95A4.3,4.3,0,0,1,131.62,406.31Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M129.63,149.6c-2,6.26-4.19,12.44-6.48,18.59-1.14,3.08-2.3,6.15-3.51,9.21s-2.42,6.12-3.7,9.18c-.29.73-.7,1.61-1.06,2.43s-.76,1.61-1.15,2.39-.8,1.55-1.22,2.3-.82,1.51-1.25,2.24c-1.66,3-3.49,5.76-5.3,8.56-3.68,5.57-7.58,10.88-11.78,16.06L88.74,217l8.63-17.44a146.18,146.18,0,0,0,7.46-17.17l6.08-18.51c2-6.18,4.15-12.37,6.32-18.49Z"
                                            style="fill:#ffc3bd"></path>
                                        <path
                                            d="M135.42,145.59c-2.11,6.94-9.4,24.27-9.4,24.27L109.31,158.2s2.94-11.28,9.55-16.59C128.24,134.08,138.14,136.64,135.42,145.59Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M125.48,151.23c-6.15,1.49-10.81,7.69-10.06,11.24l10.6,7.39s2.27-8.71,6.28-14.51C130,153,127.26,150.8,125.48,151.23Z"
                                            style="opacity:0.2"></path>
                                        <path
                                            d="M122.78,167a11.8,11.8,0,0,0,1.66-1.51s-12.41-8.65-15.54-8.74a4,4,0,0,0-.91,2.33S118.83,167.13,122.78,167Z"
                                            style="fill:currentColor"></path>
                                        <path d="M91.79,214.05l-8.31,5.36,6.65,7.23s7-3.27,5.75-9.56Z" style="fill:#ffc3bd">
                                        </path>
                                        <path
                                            d="M80,227.8l4.1,2.08a2,2,0,0,0,2.12-.2l3.95-3-6.65-7.23-4.19,5.4A2,2,0,0,0,80,227.8Z"
                                            style="fill:#ffc3bd"></path>
                                        <polygon
                                            points="132.26 387.29 131.98 397.61 140.6 397.75 140.88 387.43 132.26 387.29"
                                            style="opacity:0.2"></polygon>
                                        <path
                                            d="M171.22,141.31c-8.05,32.79-4.86,67.59-5.43,74.63l-46.18-.75c-3-36.36,0-60.23,1.88-70.79a8.81,8.81,0,0,1,7.73-7.18l.57-.06c1.26-.13,2.62-.24,4-.32.78-.05,1.58-.07,2.38-.09a173,173,0,0,1,19.64,1.46c1.23.15,2.49.34,3.7.54s2.24.39,3.28.6C167.56,140.28,171.22,141.31,171.22,141.31Z"
                                            style="fill:#263238"></path>
                                        <path d="M161.93,155.37c-.71,3.18.79,17.65,4.24,21.22.27-4.63.69-9.47,1.3-14.42Z"
                                            style="opacity:0.2"></path>
                                        <path
                                            d="M154.69,116c-1.46,6.2-3.12,17.65,1.14,22.18-3.55,3.15-8.22,7.22-15.69,6.45-6.09-.62-6-5.34-3.93-7.91,7.1-1.15,7.11-6.38,6.06-11.36Z"
                                            style="fill:#ffc3bd"></path>
                                        <path
                                            d="M153.46,123l-5.12-2.14-1.91,1.44c.2.7-.31,3.24,0,4,.88,2.12,4.41,3.23,6.69,2.87A42.41,42.41,0,0,1,153.46,123Z"
                                            style="opacity:0.2"></path>
                                        <path
                                            d="M150,89.21c-3.59,2.66-3.6,3-7.36,2.27s-14.39-4.61-11.56,4.57c-8.94.52-7.68,9.93-3.68,15.23s8,5.81,8.46,10.16c.58,5.11,9.23,6.1,10.44,3.23l12.35-10.54c4.1.25.14-6.43,2.17-10.27a4.28,4.28,0,0,0,.06-3.88,7,7,0,0,0,2.83-2.48C167.84,91.43,155.83,84.93,150,89.21Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M136,107.82c1.08,8.49,1.28,13.51,5.88,17.57,6.91,6.1,17.19,1.41,18.67-7.25,1.33-7.8-.66-20.37-9.24-23.14A11.79,11.79,0,0,0,136,107.82Z"
                                            style="fill:#ffc3bd"></path>
                                        <path
                                            d="M136.85,97.74c4.47-1,8.57,4.18,6.15,7.78s2.74,8.08-2.67,10.4c-3.78,1.62-5.61-2.31-7.44-5C130.08,106.81,132.09,98.79,136.85,97.74Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M132.48,96.65c5.46,2.94,6.79,5.8,14.9,3,4.79-1.64,6,2.13,12.16.8,1.19-7.27-7.29-8.88-11.57-8.08S132.48,96.65,132.48,96.65Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M132.48,98.11A1.48,1.48,0,0,1,132,98c-5.85-2-5.77-6.41-5.76-6.6a1.49,1.49,0,0,1,1.5-1.41,1.46,1.46,0,0,1,1.41,1.48c0,.15.09,2.52,3.78,3.77a1.46,1.46,0,0,1-.47,2.84Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M134.62,116.07a8.25,8.25,0,0,0,4.46,3.49c2.22.6,2.75-1.83,1.64-4.29-1-2.21-3.35-5.19-5.35-4.7S133.2,113.9,134.62,116.07Z"
                                            style="fill:#ffc3bd"></path>
                                        <path
                                            d="M146.38,300.88c-.35-43.41,9.26-85.1,9.26-85.1l-36-.58s4.14,62.7,5.58,89c1.5,27.3,3.59,91.41,3.59,91.41l14.61.22S148.4,335.14,146.38,300.88Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M147.81,239.66c-10.26,14.05-5.65,40.47-1.44,59.14a400.45,400.45,0,0,1,5.24-61.46Z"
                                            style="opacity:0.2"></path>
                                        <polygon
                                            points="127.9 395.88 145.28 396.15 146.26 390.52 126.89 389.92 127.9 395.88"
                                            style="fill:#263238"></polygon>
                                        <path
                                            d="M150.06,109.89c0,.69.45,1.23.9,1.19s.79-.62.74-1.32-.45-1.23-.9-1.19S150,109.19,150.06,109.89Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M158.22,109.3c.05.7.45,1.23.91,1.2s.78-.63.74-1.32-.45-1.23-.91-1.2S158.18,108.61,158.22,109.3Z"
                                            style="fill:#263238"></path>
                                        <path d="M155.83,109.41a24.63,24.63,0,0,0,3.71,5.7c-1.15,1.23-3.28.86-3.28.86Z"
                                            style="fill:#ed847e"></path>
                                        <path
                                            d="M151.65,118a5.69,5.69,0,0,1-4.07-2,.21.21,0,0,1,.33-.25,5.46,5.46,0,0,0,4.62,1.82.2.2,0,0,1,.22.19.21.21,0,0,1-.19.22A6.9,6.9,0,0,1,151.65,118Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M148.08,107.21a.36.36,0,0,1-.2-.06.4.4,0,0,1-.11-.57,4.09,4.09,0,0,1,3.21-1.93.41.41,0,0,1,0,.82h0a3.26,3.26,0,0,0-2.53,1.56A.41.41,0,0,1,148.08,107.21Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M160.09,105.14a.43.43,0,0,1-.35-.17,3.15,3.15,0,0,0-2.59-1.38.41.41,0,0,1-.43-.39.41.41,0,0,1,.38-.43,4,4,0,0,1,3.3,1.71.41.41,0,0,1-.08.58A.49.49,0,0,1,160.09,105.14Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M130.06,407.08a.2.2,0,0,0,.13-.16.22.22,0,0,0-.1-.22c-.39-.2-3.83-2-4.89-1.45a.69.69,0,0,0-.35.54h0a1.17,1.17,0,0,0,.37,1c.93.85,3.41.55,4.81.3Zm-4.59-1.5c.65-.22,2.52.53,3.88,1.2-1.91.29-3.33.19-3.85-.29a.75.75,0,0,1-.24-.66.24.24,0,0,1,.13-.22Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M130.06,407.08l.05,0a.21.21,0,0,0,.09-.18c0-.1-.21-2.43-1.29-3.35a1.52,1.52,0,0,0-1.13-.37h0c-.56.05-.73.34-.77.56-.17,1,1.86,2.88,2.89,3.36A.29.29,0,0,0,130.06,407.08Zm-2.45-3.48a.87.87,0,0,1,.21,0h0a1.11,1.11,0,0,1,.83.27,4.82,4.82,0,0,1,1.09,2.68c-1.05-.65-2.43-2.14-2.33-2.72C127.42,403.75,127.44,403.66,127.61,403.6Zm.19-.24h0Z"
                                            style="fill:currentColor"></path>
                                        <polygon
                                            points="201.81 407.44 193.16 407.31 187.62 387.29 196.28 387.42 201.81 407.44"
                                            style="fill:#ffc3bd"></polygon>
                                        <path
                                            d="M192.55,406.31l9.44.15a.82.82,0,0,1,.77.6l2.14,7.7a1.16,1.16,0,0,1-1.16,1.51c-3.41-.11-4.52-.38-8.8-.45-5-.08-2.66.13-8.53,0-3.55-.05-4.73-3.63-3.27-4,4.62-1,5.56-2.91,7.37-4.95A2.67,2.67,0,0,1,192.55,406.31Z"
                                            style="fill:#263238"></path>
                                        <polygon
                                            points="187.62 387.29 190.48 397.61 199.14 397.75 196.28 387.43 187.62 387.29"
                                            style="opacity:0.2"></polygon>
                                        <path
                                            d="M180.17,301.49c-4.9-38.8-8.56-76.88-14.38-85.55l-30.51-.49s17.65,63,23.61,88.88C165.07,331.2,186.54,393,186.54,393l13.92.2S189.31,331.5,180.17,301.49Z"
                                            style="fill:currentColor"></path>
                                        <polygon
                                            points="184.62 395.88 201.99 396.15 202.97 390.52 183.61 389.92 184.62 395.88"
                                            style="fill:#263238"></polygon>
                                        <path
                                            d="M193.09,407a.19.19,0,0,0,.19-.1.21.21,0,0,0,0-.24c-.29-.33-2.9-3.21-4.09-3a.64.64,0,0,0-.51.39h0a1.11,1.11,0,0,0,0,1.06c.58,1.12,3,1.69,4.41,1.93Zm-3.79-3c.69,0,2.19,1.37,3.23,2.46-1.89-.38-3.19-1-3.52-1.6a.75.75,0,0,1,0-.7.24.24,0,0,1,.2-.16Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M193.09,407h.06a.21.21,0,0,0,.14-.15c0-.09.65-2.34,0-3.58a1.49,1.49,0,0,0-.94-.73h0c-.54-.15-.8.06-.91.26-.5.85.76,3.33,1.56,4.14A.2.2,0,0,0,193.09,407Zm-1.11-4.1.22,0h0a1.08,1.08,0,0,1,.68.54,4.8,4.8,0,0,1,.11,2.89c-.77-1-1.55-2.84-1.25-3.36A.23.23,0,0,1,192,402.86Zm.27-.17h0Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M174.88,150.66l.35.79.42.9.86,1.84c.61,1.23,1.25,2.45,1.92,3.65,1.33,2.43,2.76,4.8,4.29,7.08a78.2,78.2,0,0,0,4.89,6.6c.85,1.07,1.8,2,2.68,3.07l1.42,1.44.71.73.09.09h0s0,0-.07,0-.25,0-.22,0a.89.89,0,0,0,.53.06,8.77,8.77,0,0,0,2.67-.8A37.92,37.92,0,0,0,202,172a146.69,146.69,0,0,0,13-11.25l5.08,4a85.28,85.28,0,0,1-5.43,7.59,78.07,78.07,0,0,1-6.3,7,43.2,43.2,0,0,1-7.91,6.3A20,20,0,0,1,194.8,188a12.63,12.63,0,0,1-3.93.28,11.17,11.17,0,0,1-4.45-1.38c-.33-.21-.68-.42-1-.65l-.47-.35-.23-.18-.11-.1-.94-.8-1.86-1.6c-1.18-1.13-2.4-2.23-3.48-3.44a71,71,0,0,1-6.22-7.45,77.54,77.54,0,0,1-5.22-8.1c-.78-1.41-1.52-2.83-2.23-4.29-.35-.73-.71-1.46-1-2.21l-.49-1.15-.5-1.28Z"
                                            style="fill:#ffc3bd"></path>
                                        <path
                                            d="M171.22,141.31c8,2.46,11.67,20.3,11.67,20.3l-12.18,10.7a49.94,49.94,0,0,1-10.84-16.87C155.76,144.42,161.57,138.32,171.22,141.31Z"
                                            style="fill:#263238"></path>
                                        <path
                                            d="M183.48,161.94a12.36,12.36,0,0,0-.86-2.08s-12.32,8.79-13.45,11.7a4,4,0,0,0,1.89,1.64S182.24,165.68,183.48,161.94Z"
                                            style="fill:currentColor"></path>
                                        <path d="M213.57,162.65l4.67-7.38,6.93,7.85s-5,6.17-8.74,4Z" style="fill:#ffc3bd">
                                        </path>
                                        <path
                                            d="M227.07,153.2l2,3.16a3,3,0,0,1-.58,3.87l-3.29,2.89-6.93-7.85,4.61-3A3,3,0,0,1,227.07,153.2Z"
                                            style="fill:#ffc3bd"></path>
                                    </g>
                                    <g id="freepik--Heart--inject-1">
                                        <path
                                            d="M328.47,174.44A49.23,49.23,0,0,0,293.55,160H272.43v4.74a49.46,49.46,0,0,0-13.8,9.72A49.24,49.24,0,0,0,223.33,160H202.22v4.92a49.38,49.38,0,0,0-13.43,79.39l48.5,48.5h-.23v21.34h15.32a15.09,15.09,0,0,0,10.67-4.42l65.42-65.42A49.39,49.39,0,0,0,328.47,174.44Z"
                                            style="fill:currentColor"></path>
                                        <path
                                            d="M328.47,174.44A49.23,49.23,0,0,0,293.55,160H272.43v4.74a49.46,49.46,0,0,0-13.8,9.72A49.24,49.24,0,0,0,223.33,160H202.22v4.92a49.38,49.38,0,0,0-13.43,79.39l48.5,48.5h-.23v21.34h15.32a15.09,15.09,0,0,0,10.67-4.42l65.42-65.42A49.39,49.39,0,0,0,328.47,174.44Z"
                                            style="opacity:0.2"></path>
                                        <path
                                            d="M306.9,174.44a49.39,49.39,0,0,0-69.84,0,49.39,49.39,0,0,0-69.84,69.85l69.84,69.84,69.84-69.84A49.39,49.39,0,0,0,306.9,174.44Z"
                                            style="fill:currentColor"></path>
                                        <rect x="210.35" y="284.53" width="1" height="15.27"
                                            transform="translate(-144.83 234.67) rotate(-45)" style="fill:currentColor">
                                        </rect>
                                        <rect x="222.47" y="300.8" width="1" height="6.96"
                                            transform="translate(-149.86 246.8) rotate(-45)" style="fill:currentColor">
                                        </rect>
                                        <path
                                            d="M306.9,174.44a49.39,49.39,0,0,0-69.84,0,49.39,49.39,0,0,0-69.84,69.85l69.84,69.84,69.84-69.84A49.39,49.39,0,0,0,306.9,174.44Z"
                                            style="opacity:0.2"></path>
                                        <path
                                            d="M174.42,237.08a39.19,39.19,0,1,1,55.43-55.43l7.21,7.21,7.21-7.21a39.19,39.19,0,1,1,55.43,55.43l-62.64,62.64Z"
                                            style="fill:currentColor"></path>
                                        <path d="M186.16,202.62h17.22v4.53H197.6V221h-5.67v-13.8h-5.77Z" style="fill:#fff">
                                        </path>
                                        <path d="M206,202.62h5.67V209h6.19v-6.41h5.69V221h-5.69v-7.41h-6.19V221H206Z"
                                            style="fill:#fff"></path>
                                        <path
                                            d="M238.54,217.92h-6.43l-.89,3h-5.79l6.89-18.33h6.18L245.39,221h-5.93Zm-1.17-4-2-6.59-2,6.59Z"
                                            style="fill:#fff"></path>
                                        <path d="M247.23,202.62h5.29l6.9,10.14V202.62h5.34V221h-5.34l-6.86-10.07V221h-5.33Z"
                                            style="fill:#fff"></path>
                                        <path
                                            d="M268.55,202.62h5.67v6.93l5.93-6.93h7.53L281,209.54,288,221h-7l-3.87-7.54-2.92,3.07V221h-5.67Z"
                                            style="fill:#fff"></path>
                                        <path d="M206.28,233.35h6.29l3.69,6.19,3.7-6.19h6.26L219.09,244v7.68h-5.67V244Z"
                                            style="fill:#fff"></path>
                                        <path
                                            d="M225.8,242.53a8.68,8.68,0,0,1,9.46-9.49c3.05,0,5.41.82,7.06,2.46a9.24,9.24,0,0,1,2.47,6.88,11.3,11.3,0,0,1-1.08,5.27,7.66,7.66,0,0,1-3.13,3.2,10.33,10.33,0,0,1-5.09,1.15,11.74,11.74,0,0,1-5.14-1,7.72,7.72,0,0,1-3.29-3.13A10.38,10.38,0,0,1,225.8,242.53Zm5.66,0a6.18,6.18,0,0,0,1,4,3.9,3.9,0,0,0,5.64,0c.66-.79,1-2.21,1-4.27a5.65,5.65,0,0,0-1-3.78,3.58,3.58,0,0,0-2.83-1.19,3.43,3.43,0,0,0-2.75,1.21A6.18,6.18,0,0,0,231.46,242.55Z"
                                            style="fill:#fff"></path>
                                        <path
                                            d="M259.77,233.35h5.66v10.92a9.11,9.11,0,0,1-.51,3.07,6.67,6.67,0,0,1-1.59,2.52,6.34,6.34,0,0,1-2.27,1.52,11.35,11.35,0,0,1-4,.62,25.92,25.92,0,0,1-2.92-.19,7.55,7.55,0,0,1-2.65-.75,6.5,6.5,0,0,1-1.94-1.58,5.76,5.76,0,0,1-1.21-2.11,10.9,10.9,0,0,1-.52-3.1V233.35h5.65v11.18a3.24,3.24,0,0,0,.83,2.35,3.59,3.59,0,0,0,4.6,0,3.18,3.18,0,0,0,.83-2.36Z"
                                            style="fill:#fff"></path>
                                    </g>
                                </svg>
                            </div>
                            <p class="fw-light text-muted">
                                {{ __('If you need any assistance during installation or while using the script, feel free to reach out to our support team. We\'re here to help!') }}
                            </p>
                            <div class="mt-4">
                                <form action="{{ route('install.welcome.post') }}" method="POST">
                                    @csrf
                                    <button class="btn btn-primary btn-md w-100">{{ __('Let\'s Get Started') }} <i
                                            class="fas fa-arrow-right"></i></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
